<?php
add_action( 'admin_menu', 'medical_pharmacy_getting_started' );
function medical_pharmacy_getting_started() {
	add_theme_page( esc_html__('Get Started', 'medical-pharmacy'), esc_html__('Get Started', 'medical-pharmacy'), 'edit_theme_options', 'medical-pharmacy-guide-page', 'medical_pharmacy_test_guide');
}

// Add a Custom CSS file to WP Admin Area
function medical_pharmacy_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/get-started/get-started.css');
}
add_action('admin_enqueue_scripts', 'medical_pharmacy_admin_theme_style');

//guidline for about theme
function medical_pharmacy_test_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'medical-pharmacy' );
?>
	<div class="wrapper-outer">
		<div class="left-main-box">
			<div class="intro"><h3><?php echo esc_html( $theme->Name ); ?></h3></div>
			<div class="left-inner">
				<div class="about-wrapper">
					<div class="col-left">
						<p><?php echo esc_html( $theme->get( 'Description' ) ); ?></p>
					</div>
					<div class="col-right">
						<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/screenshot.png" alt="" />
					</div>
				</div>
				<div class="link-wrapper">
					<h4><?php esc_html_e('Important Links', 'medical-pharmacy'); ?></h4>
					<div class="link-buttons">
						<a href="<?php echo esc_url( MEDICAL_PHARMACY_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Free Setup Guide', 'medical-pharmacy'); ?></a>
						<a href="<?php echo esc_url( MEDICAL_PHARMACY_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'medical-pharmacy'); ?></a>
						<a href="<?php echo esc_url( MEDICAL_PHARMACY_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'medical-pharmacy'); ?></a>
						<a href="<?php echo esc_url( MEDICAL_PHARMACY_PRO_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Setup Guide', 'medical-pharmacy'); ?></a>
					</div>
				</div>
				<div class="support-wrapper">
					<div class="editor-box">
						<i class="dashicons dashicons-admin-appearance"></i>
						<h4><?php esc_html_e('Theme Customization', 'medical-pharmacy'); ?></h4>
						<p><?php esc_html_e('Effortlessly modify & maintain your site using editor.', 'medical-pharmacy'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>" target="_blank"><?php esc_html_e('Site Editor', 'medical-pharmacy'); ?></a>
						</div>
					</div>
					<div class="support-box">
						<i class="dashicons dashicons-microphone"></i>
						<h4><?php esc_html_e('Need Support?', 'medical-pharmacy'); ?></h4>
						<p><?php esc_html_e('Go to our support forum to help you in case of queries.', 'medical-pharmacy'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( MEDICAL_PHARMACY_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Get Support', 'medical-pharmacy'); ?></a>
						</div>
					</div>
					<div class="review-box">
						<i class="dashicons dashicons-star-filled"></i>
						<h4><?php esc_html_e('Leave Us A Review', 'medical-pharmacy'); ?></h4>
						<p><?php esc_html_e('Are you enjoying Our Theme? We would Love to hear your Feedback.', 'medical-pharmacy'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( MEDICAL_PHARMACY_REVIEW ); ?>" target="_blank"><?php esc_html_e('Rate Us', 'medical-pharmacy'); ?></a>
						</div>
					</div>
				</div>
			</div>
			<div class="go-premium-box">
				<h4><?php esc_html_e('Why Go For Premium?', 'medical-pharmacy'); ?></h4>
				<ul class="pro-list">
					<li><?php esc_html_e('Advanced Customization Options', 'medical-pharmacy');?></li>
					<li><?php esc_html_e('One-Click Demo Import', 'medical-pharmacy');?></li>
					<li><?php esc_html_e('WooCommerce Integration & Enhanced Features', 'medical-pharmacy');?></li>
					<li><?php esc_html_e('Performance Optimization & SEO-Ready', 'medical-pharmacy');?></li>
					<li><?php esc_html_e('Premium Support & Regular Updates', 'medical-pharmacy');?></li>
				</ul>
			</div>
		</div>
		<div class="right-main-box">
			<div class="right-inner">
				<div class="pro-boxes">
					<h4><?php esc_html_e('Get Theme Bundle', 'medical-pharmacy'); ?></h4>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/bundle.png" alt="bundle image" />
					<p><?php esc_html_e('SUMMER SALE: ', 'medical-pharmacy'); ?><strong><?php esc_html_e('Extra 20%', 'medical-pharmacy'); ?></strong><?php esc_html_e(' OFF on WordPress Theme Bundle Use Code: ', 'medical-pharmacy'); ?><strong><?php esc_html_e('“HEAT20”', 'medical-pharmacy'); ?></strong></p>
					<a href="<?php echo esc_url( MEDICAL_PHARMACY_PRO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Get Theme Bundle For ', 'medical-pharmacy'); ?><span><?php esc_html_e('$86', 'medical-pharmacy'); ?></span><?php esc_html_e(' $68', 'medical-pharmacy'); ?></a>
				</div>
				<div class="pro-boxes">
					<h4><?php esc_html_e('Medical Pharmacy Pro', 'medical-pharmacy'); ?></h4>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/premium.png" alt="premium image" />
					<p><?php esc_html_e('SUMMER SALE: ', 'medical-pharmacy'); ?><strong><?php esc_html_e('Extra 25%', 'medical-pharmacy'); ?></strong><?php esc_html_e(' OFF on WordPress Block Themes! Use Code: ', 'medical-pharmacy'); ?><strong><?php esc_html_e('“SUMMER25”', 'medical-pharmacy'); ?></strong></p>
					<a href="<?php echo esc_url( MEDICAL_PHARMACY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade To Pro', 'medical-pharmacy'); ?></a>
				</div>
				<div class="pro-boxes last-pro-box">
					<h4><?php esc_html_e('View All Our Themes', 'medical-pharmacy'); ?></h4>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/all-themes.png" alt="all themes image" />
					<a href="<?php echo esc_url( MEDICAL_PHARMACY_PRO_ALL_THEMES ); ?>" target="_blank"><?php esc_html_e('View All Our Premium Themes', 'medical-pharmacy'); ?></a>
				</div>
			</div>
		</div>
	</div>
<?php } ?>