<?php
/**
 * Block Styles
 *
 * @package medical_pharmacy
 * @since 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	function medical_pharmacy_register_block_styles() {

		//Wp Block Padding Zero
		register_block_style(
			'core/group',
			array(
				'name'  => 'medical-pharmacy-padding-0',
				'label' => esc_html__( 'No Padding', 'medical-pharmacy' ),
			)
		);

		//Wp Block Post Author Style
		register_block_style(
			'core/post-author',
			array(
				'name'  => 'medical-pharmacy-post-author-card',
				'label' => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);

		//Wp Block Button Style
		register_block_style(
			'core/button',
			array(
				'name'         => 'medical-pharmacy-button',
				'label'        => esc_html__( 'Plain', 'medical-pharmacy' ),
			)
		);

		//Post Comments Style
		register_block_style(
			'core/post-comments',
			array(
				'name'         => 'medical-pharmacy-post-comments',
				'label'        => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);

		//Latest Comments Style
		register_block_style(
			'core/latest-comments',
			array(
				'name'         => 'medical-pharmacy-latest-comments',
				'label'        => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);


		//Wp Block Table Style
		register_block_style(
			'core/table',
			array(
				'name'         => 'medical-pharmacy-wp-table',
				'label'        => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);


		//Wp Block Pre Style
		register_block_style(
			'core/preformatted',
			array(
				'name'         => 'medical-pharmacy-wp-preformatted',
				'label'        => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);

		//Wp Block Verse Style
		register_block_style(
			'core/verse',
			array(
				'name'         => 'medical-pharmacy-wp-verse',
				'label'        => esc_html__( 'Theme Style', 'medical-pharmacy' ),
			)
		);
	}
	add_action( 'init', 'medical_pharmacy_register_block_styles' );
}
