<?php
/**
 * Block Patterns
 *
 * @package medical_pharmacy
 * @since 1.0
 */

function medical_pharmacy_register_block_patterns() {
	$medical_pharmacy_block_pattern_categories = array(
		'medical-pharmacy' => array( 'label' => esc_html__( 'Medical Pharmacy', 'medical-pharmacy' ) ),
		'pages' => array( 'label' => esc_html__( 'Pages', 'medical-pharmacy' ) ),
	);

	$medical_pharmacy_block_pattern_categories = apply_filters( 'medical_pharmacy_medical_pharmacy_block_pattern_categories', $medical_pharmacy_block_pattern_categories );

	foreach ( $medical_pharmacy_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'medical_pharmacy_register_block_patterns', 9 );