<?php
/**
 * Block Filters
 *
 * @package medical_pharmacy
 * @since 1.0
 */

function medical_pharmacy_block_wrapper( $medical_pharmacy_block_content, $medical_pharmacy_block ) {

	if ( 'core/button' === $medical_pharmacy_block['blockName'] ) {
		
		if( isset( $medical_pharmacy_block['attrs']['className'] ) && strpos( $medical_pharmacy_block['attrs']['className'], 'has-arrow' ) ) {
			$medical_pharmacy_block_content = str_replace( '</a>', medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'caret-circle-right' ) ) ) . '</a>', $medical_pharmacy_block_content );
			return $medical_pharmacy_block_content;
		}
	}

	if( ! is_single() ) {
	
		if ( 'core/post-terms'  === $medical_pharmacy_block['blockName'] ) {
			if( 'post_tag' === $medical_pharmacy_block['attrs']['term'] ) {
				$medical_pharmacy_block_content = str_replace( '<div class="taxonomy-post_tag wp-block-post-terms">', '<div class="taxonomy-post_tag wp-block-post-terms flex">' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'tags' ) ) ), $medical_pharmacy_block_content );
			}

			if( 'category' ===  $medical_pharmacy_block['attrs']['term'] ) {
				$medical_pharmacy_block_content = str_replace( '<div class="taxonomy-category wp-block-post-terms">', '<div class="taxonomy-category wp-block-post-terms flex">' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'category' ) ) ), $medical_pharmacy_block_content );
			}
			return $medical_pharmacy_block_content;
		}
		if ( 'core/post-date' === $medical_pharmacy_block['blockName'] ) {
			$medical_pharmacy_block_content = str_replace( '<div class="wp-block-post-date">', '<div class="wp-block-post-date flex">' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'calendar' ) ) ), $medical_pharmacy_block_content );
			return $medical_pharmacy_block_content;
		}
		if ( 'core/post-author' === $medical_pharmacy_block['blockName'] ) {
			$medical_pharmacy_block_content = str_replace( '<div class="wp-block-post-author">', '<div class="wp-block-post-author flex">' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'user' ) ) ), $medical_pharmacy_block_content );
			return $medical_pharmacy_block_content;
		}
	}
	if( is_single() ){

		// Add chevron icon to the navigations
		if ( 'core/post-navigation-link' === $medical_pharmacy_block['blockName'] ) {
			if( isset( $medical_pharmacy_block['attrs']['type'] ) && 'previous' === $medical_pharmacy_block['attrs']['type'] ) {
				$medical_pharmacy_block_content = str_replace( '<span class="post-navigation-link__label">', '<span class="post-navigation-link__label">' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'prev' ) ) ), $medical_pharmacy_block_content );
			}
			else {
				$medical_pharmacy_block_content = str_replace( '<span class="post-navigation-link__label">Next Post', '<span class="post-navigation-link__label">Next Post' . medical_pharmacy_get_svg( array( 'icon' => esc_attr( 'next' ) ) ), $medical_pharmacy_block_content );
			}
			return $medical_pharmacy_block_content;
		}
		if ( 'core/post-date' === $medical_pharmacy_block['blockName'] ) {
            $medical_pharmacy_block_content = str_replace( '<div class="wp-block-post-date">', '<div class="wp-block-post-date flex">' . medical_pharmacy_get_svg( array( 'icon' => 'calendar' ) ), $medical_pharmacy_block_content );
            return $medical_pharmacy_block_content;
        }
		if ( 'core/post-author' === $medical_pharmacy_block['blockName'] ) {
            $medical_pharmacy_block_content = str_replace( '<div class="wp-block-post-author">', '<div class="wp-block-post-author flex">' . medical_pharmacy_get_svg( array( 'icon' => 'user' ) ), $medical_pharmacy_block_content );
            return $medical_pharmacy_block_content;
        }

	}
    return $medical_pharmacy_block_content;
}
	
add_filter( 'render_block', 'medical_pharmacy_block_wrapper', 10, 2 );
