<?php
/**
 * Medical Pharmacy functions and definitions
 *
 * @package medical_pharmacy
 * @since 1.0
 */

if ( ! function_exists( 'medical_pharmacy_support' ) ) :
	function medical_pharmacy_support() {

		load_theme_textdomain( 'medical-pharmacy', get_template_directory() . '/languages' );

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		add_theme_support('woocommerce');

		// Enqueue editor styles.
		add_editor_style(get_stylesheet_directory_uri() . '/assets/css/editor-style.css');

		/* Theme Credit link */
		define('MEDICAL_PHARMACY_BUY_NOW',__('https://www.cretathemes.com/products/pharmacy-wordpress-theme','medical-pharmacy'));
		define('MEDICAL_PHARMACY_PRO_DEMO',__('https://pattern.cretathemes.com/medical-pharmacy/','medical-pharmacy'));
		define('MEDICAL_PHARMACY_THEME_DOC',__('https://pattern.cretathemes.com/free-guide/medical-pharmacy/','medical-pharmacy'));
		define('MEDICAL_PHARMACY_PRO_THEME_DOC',__('https://pattern.cretathemes.com/pro-guide/medical-pharmacy/','medical-pharmacy'));
		define('MEDICAL_PHARMACY_SUPPORT',__('https://wordpress.org/support/theme/medical-pharmacy','medical-pharmacy'));
		define('MEDICAL_PHARMACY_REVIEW',__('https://wordpress.org/support/theme/medical-pharmacy/reviews/#new-post','medical-pharmacy'));
		define('MEDICAL_PHARMACY_PRO_THEME_BUNDLE',__('https://www.cretathemes.com/products/wordpress-theme-bundle','medical-pharmacy'));
		define('MEDICAL_PHARMACY_PRO_ALL_THEMES',__('https://www.cretathemes.com/collections/wordpress-block-themes','medical-pharmacy'));

	}
endif;

add_action( 'after_setup_theme', 'medical_pharmacy_support' );

if ( ! function_exists( 'medical_pharmacy_styles' ) ) :
	function medical_pharmacy_styles() {
		// Register theme stylesheet.
		$medical_pharmacy_theme_version = wp_get_theme()->get( 'Version' );

		$medical_pharmacy_version_string = is_string( $medical_pharmacy_theme_version ) ? $medical_pharmacy_theme_version : false;
		wp_enqueue_style(
			'medical-pharmacy-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$medical_pharmacy_version_string
		);

		wp_enqueue_style( 'animate-css', esc_url(get_template_directory_uri()).'/assets/css/animate.css' );

		wp_enqueue_script( 'jquery-wow', esc_url(get_template_directory_uri()) . '/assets/js/wow.js', array('jquery') );

		wp_enqueue_script( 'medical-pharmacy-custom-script', get_theme_file_uri( '/assets/js/custom-script.js' ), array( 'jquery' ), true );

		wp_enqueue_style( 'dashicons' );

		wp_style_add_data( 'medical-pharmacy-style', 'rtl', 'replace' );

		//font-awesome
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/inc/fontawesome/css/all.css'
			, array(), '6.7.0' );

		//homepage slider
		wp_enqueue_style('medical-pharmacy-swiper-bundle-style', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), $medical_pharmacy_version_string);

		wp_enqueue_script('medical-pharmacy-swiper-bundle-scripts', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), $medical_pharmacy_version_string, true);
	}
endif;

add_action( 'wp_enqueue_scripts', 'medical_pharmacy_styles' );

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';

// Add block styles
require get_template_directory() . '/inc/block-styles.php';

// Block Filters
require get_template_directory() . '/inc/block-filters.php';

// Svg icons
require get_template_directory() . '/inc/icon-function.php';

// TGM Plugin
require get_template_directory() . '/inc/tgm/tgm.php';

// Customizer
require get_template_directory() . '/inc/customizer.php';

// Get Started.
require get_template_directory() . '/inc/get-started/get-started.php';

// Add Getstart admin notice
function medical_pharmacy_admin_notice() { 
    global $pagenow;
    $theme_args      = wp_get_theme();
    $meta            = get_option( 'medical_pharmacy_admin_notice' );
    $name            = $theme_args->__get( 'Name' );
    $current_screen  = get_current_screen();

    if( !$meta ){
	    if( is_network_admin() ){
	        return;
	    }

	    if( ! current_user_can( 'manage_options' ) ){
	        return;
	    } if($current_screen->base != 'appearance_page_medical-pharmacy-guide-page' ) { ?>

	    <div class="notice notice-success dash-notice">
	        <h1><?php esc_html_e('Hey, Thank you for installing Medical Pharmacy Theme!', 'medical-pharmacy'); ?></h1>
	        <p><a class="button button-primary customize load-customize hide-if-no-customize get-start-btn" href="<?php echo esc_url( admin_url( 'themes.php?page=medical-pharmacy-guide-page' ) ); ?>"><?php esc_html_e('Navigate Getstart', 'medical-pharmacy'); ?></a> 
	        	<a class="button button-primary site-edit" href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>"><?php esc_html_e('Site Editor', 'medical-pharmacy'); ?></a> 
				<a class="button button-primary buy-now-btn" href="<?php echo esc_url( MEDICAL_PHARMACY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'medical-pharmacy'); ?></a>
				<a class="button button-primary bundle-btn" href="<?php echo esc_url( MEDICAL_PHARMACY_PRO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Get Bundle', 'medical-pharmacy'); ?></a>
	        </p>
	        <p class="dismiss-link"><strong><a href="?medical_pharmacy_admin_notice=1"><?php esc_html_e( 'Dismiss', 'medical-pharmacy' ); ?></a></strong></p>
	    </div>
	    <?php }?>
	    <?php
	}
}

add_action( 'admin_notices', 'medical_pharmacy_admin_notice' );

if( ! function_exists( 'medical_pharmacy_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function medical_pharmacy_update_admin_notice(){
    if ( isset( $_GET['medical_pharmacy_admin_notice'] ) && $_GET['medical_pharmacy_admin_notice'] = '1' ) {
        update_option( 'medical_pharmacy_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'medical_pharmacy_update_admin_notice' );

//After Switch theme function
add_action('after_switch_theme', 'medical_pharmacy_getstart_setup_options');
function medical_pharmacy_getstart_setup_options () {
    update_option('medical_pharmacy_admin_notice', FALSE );
}

function medical_pharmacy_google_fonts() {
 
	wp_enqueue_style( 'montserrat', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap', false ); 
}
 
add_action( 'wp_enqueue_scripts', 'medical_pharmacy_google_fonts' );