/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 4306:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.2
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ 6109:
/***/ ((module) => {

// This code has been refactored for 140 bytes
// You can see the original here: https://github.com/twolfson/computedStyle/blob/04cd1da2e30fa45844f95f5cb1ac898e9b9ef050/lib/computedStyle.js
var computedStyle = function (el, prop, getComputedStyle) {
  getComputedStyle = window.getComputedStyle;

  // In one fell swoop
  return (
    // If we have getComputedStyle
    getComputedStyle ?
      // Query it
      // TODO: From CSS-Query notes, we might need (node, null) for FF
      getComputedStyle(el) :

    // Otherwise, we are in IE and use currentStyle
      el.currentStyle
  )[
    // Switch to camelCase for CSSOM
    // DEV: Grabbed from jQuery
    // https://github.com/jquery/jquery/blob/1.9-stable/src/css.js#L191-L194
    // https://github.com/jquery/jquery/blob/1.9-stable/src/core.js#L593-L597
    prop.replace(/-(\w)/gi, function (word, letter) {
      return letter.toUpperCase();
    })
  ];
};

module.exports = computedStyle;


/***/ }),

/***/ 66:
/***/ ((module) => {

"use strict";


var isMergeableObject = function isMergeableObject(value) {
	return isNonNullObject(value)
		&& !isSpecial(value)
};

function isNonNullObject(value) {
	return !!value && typeof value === 'object'
}

function isSpecial(value) {
	var stringValue = Object.prototype.toString.call(value);

	return stringValue === '[object RegExp]'
		|| stringValue === '[object Date]'
		|| isReactElement(value)
}

// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

function isReactElement(value) {
	return value.$$typeof === REACT_ELEMENT_TYPE
}

function emptyTarget(val) {
	return Array.isArray(val) ? [] : {}
}

function cloneUnlessOtherwiseSpecified(value, options) {
	return (options.clone !== false && options.isMergeableObject(value))
		? deepmerge(emptyTarget(value), value, options)
		: value
}

function defaultArrayMerge(target, source, options) {
	return target.concat(source).map(function(element) {
		return cloneUnlessOtherwiseSpecified(element, options)
	})
}

function getMergeFunction(key, options) {
	if (!options.customMerge) {
		return deepmerge
	}
	var customMerge = options.customMerge(key);
	return typeof customMerge === 'function' ? customMerge : deepmerge
}

function getEnumerableOwnPropertySymbols(target) {
	return Object.getOwnPropertySymbols
		? Object.getOwnPropertySymbols(target).filter(function(symbol) {
			return Object.propertyIsEnumerable.call(target, symbol)
		})
		: []
}

function getKeys(target) {
	return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))
}

function propertyIsOnObject(object, property) {
	try {
		return property in object
	} catch(_) {
		return false
	}
}

// Protects from prototype poisoning and unexpected merging up the prototype chain.
function propertyIsUnsafe(target, key) {
	return propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,
		&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,
			&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.
}

function mergeObject(target, source, options) {
	var destination = {};
	if (options.isMergeableObject(target)) {
		getKeys(target).forEach(function(key) {
			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
		});
	}
	getKeys(source).forEach(function(key) {
		if (propertyIsUnsafe(target, key)) {
			return
		}

		if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
			destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
		} else {
			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
		}
	});
	return destination
}

function deepmerge(target, source, options) {
	options = options || {};
	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
	options.isMergeableObject = options.isMergeableObject || isMergeableObject;
	// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()
	// implementations can use it. The caller may not replace it.
	options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;

	var sourceIsArray = Array.isArray(source);
	var targetIsArray = Array.isArray(target);
	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

	if (!sourceAndTargetTypesMatch) {
		return cloneUnlessOtherwiseSpecified(source, options)
	} else if (sourceIsArray) {
		return options.arrayMerge(target, source, options)
	} else {
		return mergeObject(target, source, options)
	}
}

deepmerge.all = function deepmergeAll(array, options) {
	if (!Array.isArray(array)) {
		throw new Error('first argument should be an array')
	}

	return array.reduce(function(prev, next) {
		return deepmerge(prev, next, options)
	}, {})
};

var deepmerge_1 = deepmerge;

module.exports = deepmerge_1;


/***/ }),

/***/ 5215:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 461:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Load in dependencies
var computedStyle = __webpack_require__(6109);

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ 628:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(4067);

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ 5826:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(628)();
}


/***/ }),

/***/ 4067:
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ 4462:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__(1609);
var PropTypes = __webpack_require__(5826);
var autosize = __webpack_require__(4306);
var _getLineHeight = __webpack_require__(461);
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ 4132:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = true;
var TextareaAutosize_1 = __webpack_require__(4462);
exports.A = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ 9681:
/***/ ((module) => {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ả": "A",
	"Ạ": "A",
	"Ẩ": "A",
	"Ẫ": "A",
	"Ậ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ẻ": "E",
	"Ẽ": "E",
	"Ẹ": "E",
	"Ể": "E",
	"Ễ": "E",
	"Ệ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ỉ": "I",
	"Ị": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ỏ": "O",
	"Ọ": "O",
	"Ổ": "O",
	"Ỗ": "O",
	"Ộ": "O",
	"Ờ": "O",
	"Ở": "O",
	"Ỡ": "O",
	"Ớ": "O",
	"Ợ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ủ": "U",
	"Ụ": "U",
	"Ử": "U",
	"Ữ": "U",
	"Ự": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ả": "a",
	"ạ": "a",
	"ẩ": "a",
	"ẫ": "a",
	"ậ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ẻ": "e",
	"ẽ": "e",
	"ẹ": "e",
	"ể": "e",
	"ễ": "e",
	"ệ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ỉ": "i",
	"ị": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ỏ": "o",
	"ọ": "o",
	"ổ": "o",
	"ỗ": "o",
	"ộ": "o",
	"ờ": "o",
	"ở": "o",
	"ỡ": "o",
	"ớ": "o",
	"ợ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ủ": "u",
	"ụ": "u",
	"ử": "u",
	"ữ": "u",
	"ự": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ 1609:
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  AlignmentToolbar: () => (/* reexport */ AlignmentToolbar),
  Autocomplete: () => (/* reexport */ Autocomplete),
  AutosaveMonitor: () => (/* reexport */ autosave_monitor),
  BlockAlignmentToolbar: () => (/* reexport */ BlockAlignmentToolbar),
  BlockControls: () => (/* reexport */ BlockControls),
  BlockEdit: () => (/* reexport */ BlockEdit),
  BlockEditorKeyboardShortcuts: () => (/* reexport */ BlockEditorKeyboardShortcuts),
  BlockFormatControls: () => (/* reexport */ BlockFormatControls),
  BlockIcon: () => (/* reexport */ BlockIcon),
  BlockInspector: () => (/* reexport */ BlockInspector),
  BlockList: () => (/* reexport */ BlockList),
  BlockMover: () => (/* reexport */ BlockMover),
  BlockNavigationDropdown: () => (/* reexport */ BlockNavigationDropdown),
  BlockSelectionClearer: () => (/* reexport */ BlockSelectionClearer),
  BlockSettingsMenu: () => (/* reexport */ BlockSettingsMenu),
  BlockTitle: () => (/* reexport */ BlockTitle),
  BlockToolbar: () => (/* reexport */ BlockToolbar),
  CharacterCount: () => (/* reexport */ CharacterCount),
  ColorPalette: () => (/* reexport */ ColorPalette),
  ContrastChecker: () => (/* reexport */ ContrastChecker),
  CopyHandler: () => (/* reexport */ CopyHandler),
  DefaultBlockAppender: () => (/* reexport */ DefaultBlockAppender),
  DocumentBar: () => (/* reexport */ DocumentBar),
  DocumentOutline: () => (/* reexport */ DocumentOutline),
  DocumentOutlineCheck: () => (/* reexport */ DocumentOutlineCheck),
  EditorHistoryRedo: () => (/* reexport */ editor_history_redo),
  EditorHistoryUndo: () => (/* reexport */ editor_history_undo),
  EditorKeyboardShortcuts: () => (/* reexport */ EditorKeyboardShortcuts),
  EditorKeyboardShortcutsRegister: () => (/* reexport */ register_shortcuts),
  EditorNotices: () => (/* reexport */ editor_notices),
  EditorProvider: () => (/* reexport */ provider),
  EditorSnackbars: () => (/* reexport */ EditorSnackbars),
  EntitiesSavedStates: () => (/* reexport */ EntitiesSavedStates),
  ErrorBoundary: () => (/* reexport */ error_boundary),
  FontSizePicker: () => (/* reexport */ FontSizePicker),
  InnerBlocks: () => (/* reexport */ InnerBlocks),
  Inserter: () => (/* reexport */ Inserter),
  InspectorAdvancedControls: () => (/* reexport */ InspectorAdvancedControls),
  InspectorControls: () => (/* reexport */ InspectorControls),
  LocalAutosaveMonitor: () => (/* reexport */ local_autosave_monitor),
  MediaPlaceholder: () => (/* reexport */ MediaPlaceholder),
  MediaUpload: () => (/* reexport */ MediaUpload),
  MediaUploadCheck: () => (/* reexport */ MediaUploadCheck),
  MultiSelectScrollIntoView: () => (/* reexport */ MultiSelectScrollIntoView),
  NavigableToolbar: () => (/* reexport */ NavigableToolbar),
  ObserveTyping: () => (/* reexport */ ObserveTyping),
  PageAttributesCheck: () => (/* reexport */ page_attributes_check),
  PageAttributesOrder: () => (/* reexport */ PageAttributesOrderWithChecks),
  PageAttributesPanel: () => (/* reexport */ PageAttributesPanel),
  PageAttributesParent: () => (/* reexport */ page_attributes_parent),
  PageTemplate: () => (/* reexport */ classic_theme),
  PanelColorSettings: () => (/* reexport */ PanelColorSettings),
  PlainText: () => (/* reexport */ PlainText),
  PluginBlockSettingsMenuItem: () => (/* reexport */ plugin_block_settings_menu_item),
  PluginDocumentSettingPanel: () => (/* reexport */ plugin_document_setting_panel),
  PluginMoreMenuItem: () => (/* reexport */ PluginMoreMenuItem),
  PluginPostPublishPanel: () => (/* reexport */ plugin_post_publish_panel),
  PluginPostStatusInfo: () => (/* reexport */ plugin_post_status_info),
  PluginPrePublishPanel: () => (/* reexport */ plugin_pre_publish_panel),
  PluginPreviewMenuItem: () => (/* reexport */ PluginPreviewMenuItem),
  PluginSidebar: () => (/* reexport */ PluginSidebar),
  PluginSidebarMoreMenuItem: () => (/* reexport */ PluginSidebarMoreMenuItem),
  PostAuthor: () => (/* reexport */ post_author),
  PostAuthorCheck: () => (/* reexport */ PostAuthorCheck),
  PostAuthorPanel: () => (/* reexport */ panel),
  PostComments: () => (/* reexport */ post_comments),
  PostDiscussionPanel: () => (/* reexport */ PostDiscussionPanel),
  PostExcerpt: () => (/* reexport */ PostExcerpt),
  PostExcerptCheck: () => (/* reexport */ post_excerpt_check),
  PostExcerptPanel: () => (/* reexport */ PostExcerptPanel),
  PostFeaturedImage: () => (/* reexport */ post_featured_image),
  PostFeaturedImageCheck: () => (/* reexport */ post_featured_image_check),
  PostFeaturedImagePanel: () => (/* reexport */ PostFeaturedImagePanel),
  PostFormat: () => (/* reexport */ PostFormat),
  PostFormatCheck: () => (/* reexport */ PostFormatCheck),
  PostLastRevision: () => (/* reexport */ post_last_revision),
  PostLastRevisionCheck: () => (/* reexport */ post_last_revision_check),
  PostLastRevisionPanel: () => (/* reexport */ post_last_revision_panel),
  PostLockedModal: () => (/* reexport */ post_locked_modal),
  PostPendingStatus: () => (/* reexport */ post_pending_status),
  PostPendingStatusCheck: () => (/* reexport */ post_pending_status_check),
  PostPingbacks: () => (/* reexport */ post_pingbacks),
  PostPreviewButton: () => (/* reexport */ PostPreviewButton),
  PostPublishButton: () => (/* reexport */ post_publish_button),
  PostPublishButtonLabel: () => (/* reexport */ PublishButtonLabel),
  PostPublishPanel: () => (/* reexport */ post_publish_panel),
  PostSavedState: () => (/* reexport */ PostSavedState),
  PostSchedule: () => (/* reexport */ PostSchedule),
  PostScheduleCheck: () => (/* reexport */ PostScheduleCheck),
  PostScheduleLabel: () => (/* reexport */ PostScheduleLabel),
  PostSchedulePanel: () => (/* reexport */ PostSchedulePanel),
  PostSticky: () => (/* reexport */ PostSticky),
  PostStickyCheck: () => (/* reexport */ PostStickyCheck),
  PostSwitchToDraftButton: () => (/* reexport */ PostSwitchToDraftButton),
  PostSyncStatus: () => (/* reexport */ PostSyncStatus),
  PostTaxonomies: () => (/* reexport */ post_taxonomies),
  PostTaxonomiesCheck: () => (/* reexport */ PostTaxonomiesCheck),
  PostTaxonomiesFlatTermSelector: () => (/* reexport */ FlatTermSelector),
  PostTaxonomiesHierarchicalTermSelector: () => (/* reexport */ HierarchicalTermSelector),
  PostTaxonomiesPanel: () => (/* reexport */ panel_PostTaxonomies),
  PostTemplatePanel: () => (/* reexport */ PostTemplatePanel),
  PostTextEditor: () => (/* reexport */ PostTextEditor),
  PostTitle: () => (/* reexport */ post_title),
  PostTitleRaw: () => (/* reexport */ post_title_raw),
  PostTrash: () => (/* reexport */ PostTrash),
  PostTrashCheck: () => (/* reexport */ PostTrashCheck),
  PostTypeSupportCheck: () => (/* reexport */ post_type_support_check),
  PostURL: () => (/* reexport */ PostURL),
  PostURLCheck: () => (/* reexport */ PostURLCheck),
  PostURLLabel: () => (/* reexport */ PostURLLabel),
  PostURLPanel: () => (/* reexport */ PostURLPanel),
  PostVisibility: () => (/* reexport */ PostVisibility),
  PostVisibilityCheck: () => (/* reexport */ PostVisibilityCheck),
  PostVisibilityLabel: () => (/* reexport */ PostVisibilityLabel),
  RichText: () => (/* reexport */ RichText),
  RichTextShortcut: () => (/* reexport */ RichTextShortcut),
  RichTextToolbarButton: () => (/* reexport */ RichTextToolbarButton),
  ServerSideRender: () => (/* reexport */ (external_wp_serverSideRender_default())),
  SkipToSelectedBlock: () => (/* reexport */ SkipToSelectedBlock),
  TableOfContents: () => (/* reexport */ table_of_contents),
  TextEditorGlobalKeyboardShortcuts: () => (/* reexport */ TextEditorGlobalKeyboardShortcuts),
  ThemeSupportCheck: () => (/* reexport */ ThemeSupportCheck),
  TimeToRead: () => (/* reexport */ TimeToRead),
  URLInput: () => (/* reexport */ URLInput),
  URLInputButton: () => (/* reexport */ URLInputButton),
  URLPopover: () => (/* reexport */ URLPopover),
  UnsavedChangesWarning: () => (/* reexport */ UnsavedChangesWarning),
  VisualEditorGlobalKeyboardShortcuts: () => (/* reexport */ VisualEditorGlobalKeyboardShortcuts),
  Warning: () => (/* reexport */ Warning),
  WordCount: () => (/* reexport */ WordCount),
  WritingFlow: () => (/* reexport */ WritingFlow),
  __unstableRichTextInputEvent: () => (/* reexport */ __unstableRichTextInputEvent),
  cleanForSlug: () => (/* reexport */ cleanForSlug),
  createCustomColorsHOC: () => (/* reexport */ createCustomColorsHOC),
  getColorClassName: () => (/* reexport */ getColorClassName),
  getColorObjectByAttributeValues: () => (/* reexport */ getColorObjectByAttributeValues),
  getColorObjectByColorValue: () => (/* reexport */ getColorObjectByColorValue),
  getFontSize: () => (/* reexport */ getFontSize),
  getFontSizeClass: () => (/* reexport */ getFontSizeClass),
  getTemplatePartIcon: () => (/* reexport */ getTemplatePartIcon),
  mediaUpload: () => (/* reexport */ mediaUpload),
  privateApis: () => (/* reexport */ privateApis),
  registerEntityAction: () => (/* reexport */ api_registerEntityAction),
  registerEntityField: () => (/* reexport */ api_registerEntityField),
  store: () => (/* reexport */ store_store),
  storeConfig: () => (/* reexport */ storeConfig),
  transformStyles: () => (/* reexport */ external_wp_blockEditor_namespaceObject.transformStyles),
  unregisterEntityAction: () => (/* reexport */ api_unregisterEntityAction),
  unregisterEntityField: () => (/* reexport */ api_unregisterEntityField),
  useEntitiesSavedStatesIsDirty: () => (/* reexport */ useIsDirty),
  usePostScheduleLabel: () => (/* reexport */ usePostScheduleLabel),
  usePostURLLabel: () => (/* reexport */ usePostURLLabel),
  usePostVisibilityLabel: () => (/* reexport */ usePostVisibilityLabel),
  userAutocompleter: () => (/* reexport */ user),
  withColorContext: () => (/* reexport */ withColorContext),
  withColors: () => (/* reexport */ withColors),
  withFontSizes: () => (/* reexport */ withFontSizes)
});

// NAMESPACE OBJECT: ./packages/editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  __experimentalGetDefaultTemplatePartAreas: () => (__experimentalGetDefaultTemplatePartAreas),
  __experimentalGetDefaultTemplateType: () => (__experimentalGetDefaultTemplateType),
  __experimentalGetDefaultTemplateTypes: () => (__experimentalGetDefaultTemplateTypes),
  __experimentalGetTemplateInfo: () => (__experimentalGetTemplateInfo),
  __unstableIsEditorReady: () => (__unstableIsEditorReady),
  canInsertBlockType: () => (canInsertBlockType),
  canUserUseUnfilteredHTML: () => (canUserUseUnfilteredHTML),
  didPostSaveRequestFail: () => (didPostSaveRequestFail),
  didPostSaveRequestSucceed: () => (didPostSaveRequestSucceed),
  getActivePostLock: () => (getActivePostLock),
  getAdjacentBlockClientId: () => (getAdjacentBlockClientId),
  getAutosaveAttribute: () => (getAutosaveAttribute),
  getBlock: () => (getBlock),
  getBlockAttributes: () => (getBlockAttributes),
  getBlockCount: () => (getBlockCount),
  getBlockHierarchyRootClientId: () => (getBlockHierarchyRootClientId),
  getBlockIndex: () => (getBlockIndex),
  getBlockInsertionPoint: () => (getBlockInsertionPoint),
  getBlockListSettings: () => (getBlockListSettings),
  getBlockMode: () => (getBlockMode),
  getBlockName: () => (getBlockName),
  getBlockOrder: () => (getBlockOrder),
  getBlockRootClientId: () => (getBlockRootClientId),
  getBlockSelectionEnd: () => (getBlockSelectionEnd),
  getBlockSelectionStart: () => (getBlockSelectionStart),
  getBlocks: () => (getBlocks),
  getBlocksByClientId: () => (getBlocksByClientId),
  getClientIdsOfDescendants: () => (getClientIdsOfDescendants),
  getClientIdsWithDescendants: () => (getClientIdsWithDescendants),
  getCurrentPost: () => (getCurrentPost),
  getCurrentPostAttribute: () => (getCurrentPostAttribute),
  getCurrentPostId: () => (getCurrentPostId),
  getCurrentPostLastRevisionId: () => (getCurrentPostLastRevisionId),
  getCurrentPostRevisionsCount: () => (getCurrentPostRevisionsCount),
  getCurrentPostType: () => (getCurrentPostType),
  getCurrentTemplateId: () => (getCurrentTemplateId),
  getDeviceType: () => (getDeviceType),
  getEditedPostAttribute: () => (getEditedPostAttribute),
  getEditedPostContent: () => (getEditedPostContent),
  getEditedPostPreviewLink: () => (getEditedPostPreviewLink),
  getEditedPostSlug: () => (getEditedPostSlug),
  getEditedPostVisibility: () => (getEditedPostVisibility),
  getEditorBlocks: () => (getEditorBlocks),
  getEditorMode: () => (getEditorMode),
  getEditorSelection: () => (getEditorSelection),
  getEditorSelectionEnd: () => (getEditorSelectionEnd),
  getEditorSelectionStart: () => (getEditorSelectionStart),
  getEditorSettings: () => (getEditorSettings),
  getFirstMultiSelectedBlockClientId: () => (getFirstMultiSelectedBlockClientId),
  getGlobalBlockCount: () => (getGlobalBlockCount),
  getInserterItems: () => (getInserterItems),
  getLastMultiSelectedBlockClientId: () => (getLastMultiSelectedBlockClientId),
  getMultiSelectedBlockClientIds: () => (getMultiSelectedBlockClientIds),
  getMultiSelectedBlocks: () => (getMultiSelectedBlocks),
  getMultiSelectedBlocksEndClientId: () => (getMultiSelectedBlocksEndClientId),
  getMultiSelectedBlocksStartClientId: () => (getMultiSelectedBlocksStartClientId),
  getNextBlockClientId: () => (getNextBlockClientId),
  getPermalink: () => (getPermalink),
  getPermalinkParts: () => (getPermalinkParts),
  getPostEdits: () => (getPostEdits),
  getPostLockUser: () => (getPostLockUser),
  getPostTypeLabel: () => (getPostTypeLabel),
  getPreviousBlockClientId: () => (getPreviousBlockClientId),
  getRenderingMode: () => (getRenderingMode),
  getSelectedBlock: () => (getSelectedBlock),
  getSelectedBlockClientId: () => (getSelectedBlockClientId),
  getSelectedBlockCount: () => (getSelectedBlockCount),
  getSelectedBlocksInitialCaretPosition: () => (getSelectedBlocksInitialCaretPosition),
  getStateBeforeOptimisticTransaction: () => (getStateBeforeOptimisticTransaction),
  getSuggestedPostFormat: () => (getSuggestedPostFormat),
  getTemplate: () => (getTemplate),
  getTemplateLock: () => (getTemplateLock),
  hasChangedContent: () => (hasChangedContent),
  hasEditorRedo: () => (hasEditorRedo),
  hasEditorUndo: () => (hasEditorUndo),
  hasInserterItems: () => (hasInserterItems),
  hasMultiSelection: () => (hasMultiSelection),
  hasNonPostEntityChanges: () => (hasNonPostEntityChanges),
  hasSelectedBlock: () => (hasSelectedBlock),
  hasSelectedInnerBlock: () => (hasSelectedInnerBlock),
  inSomeHistory: () => (inSomeHistory),
  isAncestorMultiSelected: () => (isAncestorMultiSelected),
  isAutosavingPost: () => (isAutosavingPost),
  isBlockInsertionPointVisible: () => (isBlockInsertionPointVisible),
  isBlockMultiSelected: () => (isBlockMultiSelected),
  isBlockSelected: () => (isBlockSelected),
  isBlockValid: () => (isBlockValid),
  isBlockWithinSelection: () => (isBlockWithinSelection),
  isCaretWithinFormattedText: () => (isCaretWithinFormattedText),
  isCleanNewPost: () => (isCleanNewPost),
  isCurrentPostPending: () => (isCurrentPostPending),
  isCurrentPostPublished: () => (isCurrentPostPublished),
  isCurrentPostScheduled: () => (isCurrentPostScheduled),
  isDeletingPost: () => (isDeletingPost),
  isEditedPostAutosaveable: () => (isEditedPostAutosaveable),
  isEditedPostBeingScheduled: () => (isEditedPostBeingScheduled),
  isEditedPostDateFloating: () => (isEditedPostDateFloating),
  isEditedPostDirty: () => (isEditedPostDirty),
  isEditedPostEmpty: () => (isEditedPostEmpty),
  isEditedPostNew: () => (isEditedPostNew),
  isEditedPostPublishable: () => (isEditedPostPublishable),
  isEditedPostSaveable: () => (isEditedPostSaveable),
  isEditorPanelEnabled: () => (isEditorPanelEnabled),
  isEditorPanelOpened: () => (isEditorPanelOpened),
  isEditorPanelRemoved: () => (isEditorPanelRemoved),
  isFirstMultiSelectedBlock: () => (isFirstMultiSelectedBlock),
  isInserterOpened: () => (isInserterOpened),
  isListViewOpened: () => (isListViewOpened),
  isMultiSelecting: () => (isMultiSelecting),
  isPermalinkEditable: () => (isPermalinkEditable),
  isPostAutosavingLocked: () => (isPostAutosavingLocked),
  isPostLockTakeover: () => (isPostLockTakeover),
  isPostLocked: () => (isPostLocked),
  isPostSavingLocked: () => (isPostSavingLocked),
  isPreviewingPost: () => (isPreviewingPost),
  isPublishSidebarEnabled: () => (isPublishSidebarEnabled),
  isPublishSidebarOpened: () => (isPublishSidebarOpened),
  isPublishingPost: () => (isPublishingPost),
  isSavingNonPostEntityChanges: () => (isSavingNonPostEntityChanges),
  isSavingPost: () => (isSavingPost),
  isSelectionEnabled: () => (isSelectionEnabled),
  isTyping: () => (isTyping),
  isValidTemplate: () => (isValidTemplate)
});

// NAMESPACE OBJECT: ./packages/editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  __experimentalTearDownEditor: () => (__experimentalTearDownEditor),
  __unstableSaveForPreview: () => (__unstableSaveForPreview),
  autosave: () => (autosave),
  clearSelectedBlock: () => (clearSelectedBlock),
  closePublishSidebar: () => (closePublishSidebar),
  createUndoLevel: () => (createUndoLevel),
  disablePublishSidebar: () => (disablePublishSidebar),
  editPost: () => (editPost),
  enablePublishSidebar: () => (enablePublishSidebar),
  enterFormattedText: () => (enterFormattedText),
  exitFormattedText: () => (exitFormattedText),
  hideInsertionPoint: () => (hideInsertionPoint),
  insertBlock: () => (insertBlock),
  insertBlocks: () => (insertBlocks),
  insertDefaultBlock: () => (insertDefaultBlock),
  lockPostAutosaving: () => (lockPostAutosaving),
  lockPostSaving: () => (lockPostSaving),
  mergeBlocks: () => (mergeBlocks),
  moveBlockToPosition: () => (moveBlockToPosition),
  moveBlocksDown: () => (moveBlocksDown),
  moveBlocksUp: () => (moveBlocksUp),
  multiSelect: () => (multiSelect),
  openPublishSidebar: () => (openPublishSidebar),
  receiveBlocks: () => (receiveBlocks),
  redo: () => (redo),
  refreshPost: () => (refreshPost),
  removeBlock: () => (removeBlock),
  removeBlocks: () => (removeBlocks),
  removeEditorPanel: () => (removeEditorPanel),
  replaceBlock: () => (replaceBlock),
  replaceBlocks: () => (replaceBlocks),
  resetBlocks: () => (resetBlocks),
  resetEditorBlocks: () => (resetEditorBlocks),
  resetPost: () => (resetPost),
  savePost: () => (savePost),
  selectBlock: () => (selectBlock),
  setDeviceType: () => (setDeviceType),
  setEditedPost: () => (setEditedPost),
  setIsInserterOpened: () => (setIsInserterOpened),
  setIsListViewOpened: () => (setIsListViewOpened),
  setRenderingMode: () => (setRenderingMode),
  setTemplateValidity: () => (setTemplateValidity),
  setupEditor: () => (setupEditor),
  setupEditorState: () => (setupEditorState),
  showInsertionPoint: () => (showInsertionPoint),
  startMultiSelect: () => (startMultiSelect),
  startTyping: () => (startTyping),
  stopMultiSelect: () => (stopMultiSelect),
  stopTyping: () => (stopTyping),
  switchEditorMode: () => (switchEditorMode),
  synchronizeTemplate: () => (synchronizeTemplate),
  toggleBlockMode: () => (toggleBlockMode),
  toggleDistractionFree: () => (toggleDistractionFree),
  toggleEditorPanelEnabled: () => (toggleEditorPanelEnabled),
  toggleEditorPanelOpened: () => (toggleEditorPanelOpened),
  togglePublishSidebar: () => (togglePublishSidebar),
  toggleSelection: () => (toggleSelection),
  toggleSpotlightMode: () => (toggleSpotlightMode),
  toggleTopToolbar: () => (toggleTopToolbar),
  trashPost: () => (trashPost),
  undo: () => (undo),
  unlockPostAutosaving: () => (unlockPostAutosaving),
  unlockPostSaving: () => (unlockPostSaving),
  updateBlock: () => (updateBlock),
  updateBlockAttributes: () => (updateBlockAttributes),
  updateBlockListSettings: () => (updateBlockListSettings),
  updateEditorSettings: () => (updateEditorSettings),
  updatePost: () => (updatePost),
  updatePostLock: () => (updatePostLock)
});

// NAMESPACE OBJECT: ./packages/interface/build-module/store/actions.js
var store_actions_namespaceObject = {};
__webpack_require__.r(store_actions_namespaceObject);
__webpack_require__.d(store_actions_namespaceObject, {
  closeModal: () => (closeModal),
  disableComplementaryArea: () => (disableComplementaryArea),
  enableComplementaryArea: () => (enableComplementaryArea),
  openModal: () => (openModal),
  pinItem: () => (pinItem),
  setDefaultComplementaryArea: () => (setDefaultComplementaryArea),
  setFeatureDefaults: () => (setFeatureDefaults),
  setFeatureValue: () => (setFeatureValue),
  toggleFeature: () => (toggleFeature),
  unpinItem: () => (unpinItem)
});

// NAMESPACE OBJECT: ./packages/interface/build-module/store/selectors.js
var store_selectors_namespaceObject = {};
__webpack_require__.r(store_selectors_namespaceObject);
__webpack_require__.d(store_selectors_namespaceObject, {
  getActiveComplementaryArea: () => (getActiveComplementaryArea),
  isComplementaryAreaLoading: () => (isComplementaryAreaLoading),
  isFeatureActive: () => (isFeatureActive),
  isItemPinned: () => (isItemPinned),
  isModalActive: () => (isModalActive)
});

// NAMESPACE OBJECT: ./packages/interface/build-module/index.js
var build_module_namespaceObject = {};
__webpack_require__.r(build_module_namespaceObject);
__webpack_require__.d(build_module_namespaceObject, {
  ActionItem: () => (action_item),
  ComplementaryArea: () => (complementary_area),
  ComplementaryAreaMoreMenuItem: () => (ComplementaryAreaMoreMenuItem),
  FullscreenMode: () => (fullscreen_mode),
  InterfaceSkeleton: () => (interface_skeleton),
  NavigableRegion: () => (navigable_region),
  PinnedItems: () => (pinned_items),
  store: () => (store)
});

// NAMESPACE OBJECT: ./packages/editor/build-module/store/private-actions.js
var store_private_actions_namespaceObject = {};
__webpack_require__.r(store_private_actions_namespaceObject);
__webpack_require__.d(store_private_actions_namespaceObject, {
  createTemplate: () => (createTemplate),
  hideBlockTypes: () => (hideBlockTypes),
  registerEntityAction: () => (registerEntityAction),
  registerEntityField: () => (registerEntityField),
  registerPostTypeSchema: () => (registerPostTypeSchema),
  removeTemplates: () => (removeTemplates),
  revertTemplate: () => (private_actions_revertTemplate),
  saveDirtyEntities: () => (saveDirtyEntities),
  setCurrentTemplateId: () => (setCurrentTemplateId),
  setDefaultRenderingMode: () => (setDefaultRenderingMode),
  setIsReady: () => (setIsReady),
  showBlockTypes: () => (showBlockTypes),
  unregisterEntityAction: () => (unregisterEntityAction),
  unregisterEntityField: () => (unregisterEntityField)
});

// NAMESPACE OBJECT: ./packages/editor/build-module/store/private-selectors.js
var store_private_selectors_namespaceObject = {};
__webpack_require__.r(store_private_selectors_namespaceObject);
__webpack_require__.d(store_private_selectors_namespaceObject, {
  getDefaultRenderingMode: () => (getDefaultRenderingMode),
  getEntityActions: () => (private_selectors_getEntityActions),
  getEntityFields: () => (private_selectors_getEntityFields),
  getInserter: () => (getInserter),
  getInserterSidebarToggleRef: () => (getInserterSidebarToggleRef),
  getListViewToggleRef: () => (getListViewToggleRef),
  getPostBlocksByName: () => (getPostBlocksByName),
  getPostIcon: () => (getPostIcon),
  hasPostMetaChanges: () => (hasPostMetaChanges),
  isEntityReady: () => (private_selectors_isEntityReady)
});

;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// external ["wp","coreData"]
const external_wp_coreData_namespaceObject = window["wp"]["coreData"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// external ["wp","hooks"]
const external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// external ["wp","blockEditor"]
const external_wp_blockEditor_namespaceObject = window["wp"]["blockEditor"];
;// ./packages/editor/build-module/store/defaults.js
/**
 * WordPress dependencies
 */


/**
 * The default post editor settings.
 *
 * @property {boolean|Array} allowedBlockTypes     Allowed block types
 * @property {boolean}       richEditingEnabled    Whether rich editing is enabled or not
 * @property {boolean}       codeEditingEnabled    Whether code editing is enabled or not
 * @property {boolean}       fontLibraryEnabled    Whether the font library is enabled or not.
 * @property {boolean}       enableCustomFields    Whether the WordPress custom fields are enabled or not.
 *                                                 true  = the user has opted to show the Custom Fields panel at the bottom of the editor.
 *                                                 false = the user has opted to hide the Custom Fields panel at the bottom of the editor.
 *                                                 undefined = the current environment does not support Custom Fields, so the option toggle in Preferences -> Panels to enable the Custom Fields panel is not displayed.
 * @property {number}        autosaveInterval      How often in seconds the post will be auto-saved via the REST API.
 * @property {number}        localAutosaveInterval How often in seconds the post will be backed up to sessionStorage.
 * @property {Array?}        availableTemplates    The available post templates
 * @property {boolean}       disablePostFormats    Whether or not the post formats are disabled
 * @property {Array?}        allowedMimeTypes      List of allowed mime types and file extensions
 * @property {number}        maxUploadFileSize     Maximum upload file size
 * @property {boolean}       supportsLayout        Whether the editor supports layouts.
 */
const EDITOR_SETTINGS_DEFAULTS = {
  ...external_wp_blockEditor_namespaceObject.SETTINGS_DEFAULTS,
  richEditingEnabled: true,
  codeEditingEnabled: true,
  fontLibraryEnabled: true,
  enableCustomFields: undefined,
  defaultRenderingMode: 'post-only'
};

;// ./packages/editor/build-module/dataviews/store/reducer.js
/**
 * WordPress dependencies
 */

function isReady(state = {}, action) {
  switch (action.type) {
    case 'SET_IS_READY':
      return {
        ...state,
        [action.kind]: {
          ...state[action.kind],
          [action.name]: true
        }
      };
  }
  return state;
}
function actions(state = {}, action) {
  var _state$action$kind$ac;
  switch (action.type) {
    case 'REGISTER_ENTITY_ACTION':
      return {
        ...state,
        [action.kind]: {
          ...state[action.kind],
          [action.name]: [...((_state$action$kind$ac = state[action.kind]?.[action.name]) !== null && _state$action$kind$ac !== void 0 ? _state$action$kind$ac : []).filter(_action => _action.id !== action.config.id), action.config]
        }
      };
    case 'UNREGISTER_ENTITY_ACTION':
      {
        var _state$action$kind$ac2;
        return {
          ...state,
          [action.kind]: {
            ...state[action.kind],
            [action.name]: ((_state$action$kind$ac2 = state[action.kind]?.[action.name]) !== null && _state$action$kind$ac2 !== void 0 ? _state$action$kind$ac2 : []).filter(_action => _action.id !== action.actionId)
          }
        };
      }
  }
  return state;
}
function fields(state = {}, action) {
  var _state$action$kind$ac3, _state$action$kind$ac4;
  switch (action.type) {
    case 'REGISTER_ENTITY_FIELD':
      return {
        ...state,
        [action.kind]: {
          ...state[action.kind],
          [action.name]: [...((_state$action$kind$ac3 = state[action.kind]?.[action.name]) !== null && _state$action$kind$ac3 !== void 0 ? _state$action$kind$ac3 : []).filter(_field => _field.id !== action.config.id), action.config]
        }
      };
    case 'UNREGISTER_ENTITY_FIELD':
      return {
        ...state,
        [action.kind]: {
          ...state[action.kind],
          [action.name]: ((_state$action$kind$ac4 = state[action.kind]?.[action.name]) !== null && _state$action$kind$ac4 !== void 0 ? _state$action$kind$ac4 : []).filter(_field => _field.id !== action.fieldId)
        }
      };
  }
  return state;
}
/* harmony default export */ const reducer = ((0,external_wp_data_namespaceObject.combineReducers)({
  actions,
  fields,
  isReady
}));

;// ./packages/editor/build-module/store/reducer.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns a post attribute value, flattening nested rendered content using its
 * raw value in place of its original object form.
 *
 * @param {*} value Original value.
 *
 * @return {*} Raw value.
 */
function getPostRawValue(value) {
  if (value && 'object' === typeof value && 'raw' in value) {
    return value.raw;
  }
  return value;
}

/**
 * Returns true if the two object arguments have the same keys, or false
 * otherwise.
 *
 * @param {Object} a First object.
 * @param {Object} b Second object.
 *
 * @return {boolean} Whether the two objects have the same keys.
 */
function hasSameKeys(a, b) {
  const keysA = Object.keys(a).sort();
  const keysB = Object.keys(b).sort();
  return keysA.length === keysB.length && keysA.every((key, index) => keysB[index] === key);
}

/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are editing the same post property, or
 * false otherwise.
 *
 * @param {Object} action         Currently dispatching action.
 * @param {Object} previousAction Previously dispatched action.
 *
 * @return {boolean} Whether actions are updating the same post property.
 */
function isUpdatingSamePostProperty(action, previousAction) {
  return action.type === 'EDIT_POST' && hasSameKeys(action.edits, previousAction.edits);
}

/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are modifying the same property such that
 * undo history should be batched.
 *
 * @param {Object} action         Currently dispatching action.
 * @param {Object} previousAction Previously dispatched action.
 *
 * @return {boolean} Whether to overwrite present state.
 */
function shouldOverwriteState(action, previousAction) {
  if (action.type === 'RESET_EDITOR_BLOCKS') {
    return !action.shouldCreateUndoLevel;
  }
  if (!previousAction || action.type !== previousAction.type) {
    return false;
  }
  return isUpdatingSamePostProperty(action, previousAction);
}
function postId(state = null, action) {
  switch (action.type) {
    case 'SET_EDITED_POST':
      return action.postId;
  }
  return state;
}
function templateId(state = null, action) {
  switch (action.type) {
    case 'SET_CURRENT_TEMPLATE_ID':
      return action.id;
  }
  return state;
}
function postType(state = null, action) {
  switch (action.type) {
    case 'SET_EDITED_POST':
      return action.postType;
  }
  return state;
}

/**
 * Reducer returning whether the post blocks match the defined template or not.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function template(state = {
  isValid: true
}, action) {
  switch (action.type) {
    case 'SET_TEMPLATE_VALIDITY':
      return {
        ...state,
        isValid: action.isValid
      };
  }
  return state;
}

/**
 * Reducer returning current network request state (whether a request to
 * the WP REST API is in progress, successful, or failed).
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function saving(state = {}, action) {
  switch (action.type) {
    case 'REQUEST_POST_UPDATE_START':
    case 'REQUEST_POST_UPDATE_FINISH':
      return {
        pending: action.type === 'REQUEST_POST_UPDATE_START',
        options: action.options || {}
      };
  }
  return state;
}

/**
 * Reducer returning deleting post request state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function deleting(state = {}, action) {
  switch (action.type) {
    case 'REQUEST_POST_DELETE_START':
    case 'REQUEST_POST_DELETE_FINISH':
      return {
        pending: action.type === 'REQUEST_POST_DELETE_START'
      };
  }
  return state;
}

/**
 * Post Lock State.
 *
 * @typedef {Object} PostLockState
 *
 * @property {boolean}  isLocked       Whether the post is locked.
 * @property {?boolean} isTakeover     Whether the post editing has been taken over.
 * @property {?boolean} activePostLock Active post lock value.
 * @property {?Object}  user           User that took over the post.
 */

/**
 * Reducer returning the post lock status.
 *
 * @param {PostLockState} state  Current state.
 * @param {Object}        action Dispatched action.
 *
 * @return {PostLockState} Updated state.
 */
function postLock(state = {
  isLocked: false
}, action) {
  switch (action.type) {
    case 'UPDATE_POST_LOCK':
      return action.lock;
  }
  return state;
}

/**
 * Post saving lock.
 *
 * When post saving is locked, the post cannot be published or updated.
 *
 * @param {PostLockState} state  Current state.
 * @param {Object}        action Dispatched action.
 *
 * @return {PostLockState} Updated state.
 */
function postSavingLock(state = {}, action) {
  switch (action.type) {
    case 'LOCK_POST_SAVING':
      return {
        ...state,
        [action.lockName]: true
      };
    case 'UNLOCK_POST_SAVING':
      {
        const {
          [action.lockName]: removedLockName,
          ...restState
        } = state;
        return restState;
      }
  }
  return state;
}

/**
 * Post autosaving lock.
 *
 * When post autosaving is locked, the post will not autosave.
 *
 * @param {PostLockState} state  Current state.
 * @param {Object}        action Dispatched action.
 *
 * @return {PostLockState} Updated state.
 */
function postAutosavingLock(state = {}, action) {
  switch (action.type) {
    case 'LOCK_POST_AUTOSAVING':
      return {
        ...state,
        [action.lockName]: true
      };
    case 'UNLOCK_POST_AUTOSAVING':
      {
        const {
          [action.lockName]: removedLockName,
          ...restState
        } = state;
        return restState;
      }
  }
  return state;
}

/**
 * Reducer returning the post editor setting.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function editorSettings(state = EDITOR_SETTINGS_DEFAULTS, action) {
  switch (action.type) {
    case 'UPDATE_EDITOR_SETTINGS':
      return {
        ...state,
        ...action.settings
      };
  }
  return state;
}
function renderingMode(state = 'post-only', action) {
  switch (action.type) {
    case 'SET_RENDERING_MODE':
      return action.mode;
  }
  return state;
}

/**
 * Reducer returning the editing canvas device type.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function deviceType(state = 'Desktop', action) {
  switch (action.type) {
    case 'SET_DEVICE_TYPE':
      return action.deviceType;
  }
  return state;
}

/**
 * Reducer storing the list of all programmatically removed panels.
 *
 * @param {Array}  state  Current state.
 * @param {Object} action Action object.
 *
 * @return {Array} Updated state.
 */
function removedPanels(state = [], action) {
  switch (action.type) {
    case 'REMOVE_PANEL':
      if (!state.includes(action.panelName)) {
        return [...state, action.panelName];
      }
  }
  return state;
}

/**
 * Reducer to set the block inserter panel open or closed.
 *
 * Note: this reducer interacts with the list view panel reducer
 * to make sure that only one of the two panels is open at the same time.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 */
function blockInserterPanel(state = false, action) {
  switch (action.type) {
    case 'SET_IS_LIST_VIEW_OPENED':
      return action.isOpen ? false : state;
    case 'SET_IS_INSERTER_OPENED':
      return action.value;
  }
  return state;
}

/**
 * Reducer to set the list view panel open or closed.
 *
 * Note: this reducer interacts with the inserter panel reducer
 * to make sure that only one of the two panels is open at the same time.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 */
function listViewPanel(state = false, action) {
  switch (action.type) {
    case 'SET_IS_INSERTER_OPENED':
      return action.value ? false : state;
    case 'SET_IS_LIST_VIEW_OPENED':
      return action.isOpen;
  }
  return state;
}

/**
 * This reducer does nothing aside initializing a ref to the list view toggle.
 * We will have a unique ref per "editor" instance.
 *
 * @param {Object} state
 * @return {Object} Reference to the list view toggle button.
 */
function listViewToggleRef(state = {
  current: null
}) {
  return state;
}

/**
 * This reducer does nothing aside initializing a ref to the inserter sidebar toggle.
 * We will have a unique ref per "editor" instance.
 *
 * @param {Object} state
 * @return {Object} Reference to the inserter sidebar toggle button.
 */
function inserterSidebarToggleRef(state = {
  current: null
}) {
  return state;
}
function publishSidebarActive(state = false, action) {
  switch (action.type) {
    case 'OPEN_PUBLISH_SIDEBAR':
      return true;
    case 'CLOSE_PUBLISH_SIDEBAR':
      return false;
    case 'TOGGLE_PUBLISH_SIDEBAR':
      return !state;
  }
  return state;
}
/* harmony default export */ const store_reducer = ((0,external_wp_data_namespaceObject.combineReducers)({
  postId,
  postType,
  templateId,
  saving,
  deleting,
  postLock,
  template,
  postSavingLock,
  editorSettings,
  postAutosavingLock,
  renderingMode,
  deviceType,
  removedPanels,
  blockInserterPanel,
  inserterSidebarToggleRef,
  listViewPanel,
  listViewToggleRef,
  publishSidebarActive,
  dataviews: reducer
}));

;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// external ["wp","date"]
const external_wp_date_namespaceObject = window["wp"]["date"];
;// external ["wp","url"]
const external_wp_url_namespaceObject = window["wp"]["url"];
;// external ["wp","deprecated"]
const external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
;// external ["wp","preferences"]
const external_wp_preferences_namespaceObject = window["wp"]["preferences"];
;// ./packages/editor/build-module/store/constants.js
/**
 * Set of post properties for which edits should assume a merging behavior,
 * assuming an object value.
 *
 * @type {Set}
 */
const EDIT_MERGE_PROPERTIES = new Set(['meta']);

/**
 * Constant for the store module (or reducer) key.
 */
const STORE_NAME = 'core/editor';
const PERMALINK_POSTNAME_REGEX = /%(?:postname|pagename)%/;
const ONE_MINUTE_IN_MS = 60 * 1000;
const AUTOSAVE_PROPERTIES = ['title', 'excerpt', 'content'];
const TEMPLATE_PART_AREA_DEFAULT_CATEGORY = 'uncategorized';
const TEMPLATE_POST_TYPE = 'wp_template';
const TEMPLATE_PART_POST_TYPE = 'wp_template_part';
const PATTERN_POST_TYPE = 'wp_block';
const NAVIGATION_POST_TYPE = 'wp_navigation';
const TEMPLATE_ORIGINS = {
  custom: 'custom',
  theme: 'theme',
  plugin: 'plugin'
};
const TEMPLATE_POST_TYPES = ['wp_template', 'wp_template_part'];
const GLOBAL_POST_TYPES = [...TEMPLATE_POST_TYPES, 'wp_block', 'wp_navigation'];

;// external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// ./packages/icons/build-module/library/header.js
/**
 * WordPress dependencies
 */


const header = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18.5 10.5H10v8h8a.5.5 0 00.5-.5v-7.5zm-10 0h-3V18a.5.5 0 00.5.5h2.5v-8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
  })
});
/* harmony default export */ const library_header = (header);

;// ./packages/icons/build-module/library/footer.js
/**
 * WordPress dependencies
 */


const footer = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    d: "M18 5.5h-8v8h8.5V6a.5.5 0 00-.5-.5zm-9.5 8h-3V6a.5.5 0 01.5-.5h2.5v8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
  })
});
/* harmony default export */ const library_footer = (footer);

;// ./packages/icons/build-module/library/sidebar.js
/**
 * WordPress dependencies
 */


const sidebar = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18 5.5H6a.5.5 0 00-.5.5v3h13V6a.5.5 0 00-.5-.5zm.5 5H10v8h8a.5.5 0 00.5-.5v-7.5zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
  })
});
/* harmony default export */ const library_sidebar = (sidebar);

;// ./packages/icons/build-module/library/symbol-filled.js
/**
 * WordPress dependencies
 */


const symbolFilled = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-17.6 1L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
  })
});
/* harmony default export */ const symbol_filled = (symbolFilled);

;// ./packages/editor/build-module/utils/get-template-part-icon.js
/**
 * WordPress dependencies
 */

/**
 * Helper function to retrieve the corresponding icon by name.
 *
 * @param {string} iconName The name of the icon.
 *
 * @return {Object} The corresponding icon.
 */
function getTemplatePartIcon(iconName) {
  if ('header' === iconName) {
    return library_header;
  } else if ('footer' === iconName) {
    return library_footer;
  } else if ('sidebar' === iconName) {
    return library_sidebar;
  }
  return symbol_filled;
}

;// external ["wp","privateApis"]
const external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// ./packages/editor/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock,
  unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I acknowledge private features are not for use in themes or plugins and doing so will break in the next version of WordPress.', '@wordpress/editor');

;// ./packages/icons/build-module/library/layout.js
/**
 * WordPress dependencies
 */


const layout = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18 5.5H6a.5.5 0 00-.5.5v3h13V6a.5.5 0 00-.5-.5zm.5 5H10v8h8a.5.5 0 00.5-.5v-7.5zm-10 0h-3V18a.5.5 0 00.5.5h2.5v-8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
  })
});
/* harmony default export */ const library_layout = (layout);

;// ./packages/editor/build-module/utils/get-template-info.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const EMPTY_OBJECT = {};

/**
 * Helper function to retrieve the corresponding template info for a given template.
 * @param {Object} params
 * @param {Array}  params.templateTypes
 * @param {Array}  [params.templateAreas]
 * @param {Object} params.template
 */
const getTemplateInfo = params => {
  var _Object$values$find;
  if (!params) {
    return EMPTY_OBJECT;
  }
  const {
    templateTypes,
    templateAreas,
    template
  } = params;
  const {
    description,
    slug,
    title,
    area
  } = template;
  const {
    title: defaultTitle,
    description: defaultDescription
  } = (_Object$values$find = Object.values(templateTypes).find(type => type.slug === slug)) !== null && _Object$values$find !== void 0 ? _Object$values$find : EMPTY_OBJECT;
  const templateTitle = typeof title === 'string' ? title : title?.rendered;
  const templateDescription = typeof description === 'string' ? description : description?.raw;
  const templateAreasWithIcon = templateAreas?.map(item => ({
    ...item,
    icon: getTemplatePartIcon(item.icon)
  }));
  const templateIcon = templateAreasWithIcon?.find(item => area === item.area)?.icon || library_layout;
  return {
    title: templateTitle && templateTitle !== slug ? templateTitle : defaultTitle || slug,
    description: templateDescription || defaultDescription,
    icon: templateIcon
  };
};

;// ./packages/editor/build-module/store/selectors.js
/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */






/**
 * Shared reference to an empty object for cases where it is important to avoid
 * returning a new object reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 */
const selectors_EMPTY_OBJECT = {};

/**
 * Returns true if any past editor history snapshots exist, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether undo history exists.
 */
const hasEditorUndo = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => {
  return select(external_wp_coreData_namespaceObject.store).hasUndo();
});

/**
 * Returns true if any future editor history snapshots exist, or false
 * otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether redo history exists.
 */
const hasEditorRedo = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => {
  return select(external_wp_coreData_namespaceObject.store).hasRedo();
});

/**
 * Returns true if the currently edited post is yet to be saved, or false if
 * the post has been saved.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post is new.
 */
function isEditedPostNew(state) {
  return getCurrentPost(state).status === 'auto-draft';
}

/**
 * Returns true if content includes unsaved changes, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether content includes unsaved changes.
 */
function hasChangedContent(state) {
  const edits = getPostEdits(state);
  return 'content' in edits;
}

/**
 * Returns true if there are unsaved values for the current edit session, or
 * false if the editing state matches the saved or new post.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether unsaved values exist.
 */
const isEditedPostDirty = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  // Edits should contain only fields which differ from the saved post (reset
  // at initial load and save complete). Thus, a non-empty edits state can be
  // inferred to contain unsaved values.
  const postType = getCurrentPostType(state);
  const postId = getCurrentPostId(state);
  return select(external_wp_coreData_namespaceObject.store).hasEditsForEntityRecord('postType', postType, postId);
});

/**
 * Returns true if there are unsaved edits for entities other than
 * the editor's post, and false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether there are edits or not.
 */
const hasNonPostEntityChanges = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const dirtyEntityRecords = select(external_wp_coreData_namespaceObject.store).__experimentalGetDirtyEntityRecords();
  const {
    type,
    id
  } = getCurrentPost(state);
  return dirtyEntityRecords.some(entityRecord => entityRecord.kind !== 'postType' || entityRecord.name !== type || entityRecord.key !== id);
});

/**
 * Returns true if there are no unsaved values for the current edit session and
 * if the currently edited post is new (has never been saved before).
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether new post and unsaved values exist.
 */
function isCleanNewPost(state) {
  return !isEditedPostDirty(state) && isEditedPostNew(state);
}

/**
 * Returns the post currently being edited in its last known saved state, not
 * including unsaved edits. Returns an object containing relevant default post
 * values if the post has not yet been saved.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} Post object.
 */
const getCurrentPost = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const postId = getCurrentPostId(state);
  const postType = getCurrentPostType(state);
  const post = select(external_wp_coreData_namespaceObject.store).getRawEntityRecord('postType', postType, postId);
  if (post) {
    return post;
  }

  // This exists for compatibility with the previous selector behavior
  // which would guarantee an object return based on the editor reducer's
  // default empty object state.
  return selectors_EMPTY_OBJECT;
});

/**
 * Returns the post type of the post currently being edited.
 *
 * @param {Object} state Global application state.
 *
 * @example
 *
 *```js
 * const currentPostType = wp.data.select( 'core/editor' ).getCurrentPostType();
 *```
 * @return {string} Post type.
 */
function getCurrentPostType(state) {
  return state.postType;
}

/**
 * Returns the ID of the post currently being edited, or null if the post has
 * not yet been saved.
 *
 * @param {Object} state Global application state.
 *
 * @return {?(number|string)} The current post ID (number) or template slug (string).
 */
function getCurrentPostId(state) {
  return state.postId;
}

/**
 * Returns the template ID currently being rendered/edited
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Template ID.
 */
function getCurrentTemplateId(state) {
  return state.templateId;
}

/**
 * Returns the number of revisions of the post currently being edited.
 *
 * @param {Object} state Global application state.
 *
 * @return {number} Number of revisions.
 */
function getCurrentPostRevisionsCount(state) {
  var _getCurrentPost$_link;
  return (_getCurrentPost$_link = getCurrentPost(state)._links?.['version-history']?.[0]?.count) !== null && _getCurrentPost$_link !== void 0 ? _getCurrentPost$_link : 0;
}

/**
 * Returns the last revision ID of the post currently being edited,
 * or null if the post has no revisions.
 *
 * @param {Object} state Global application state.
 *
 * @return {?number} ID of the last revision.
 */
function getCurrentPostLastRevisionId(state) {
  var _getCurrentPost$_link2;
  return (_getCurrentPost$_link2 = getCurrentPost(state)._links?.['predecessor-version']?.[0]?.id) !== null && _getCurrentPost$_link2 !== void 0 ? _getCurrentPost$_link2 : null;
}

/**
 * Returns any post values which have been changed in the editor but not yet
 * been saved.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} Object of key value pairs comprising unsaved edits.
 */
const getPostEdits = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const postType = getCurrentPostType(state);
  const postId = getCurrentPostId(state);
  return select(external_wp_coreData_namespaceObject.store).getEntityRecordEdits('postType', postType, postId) || selectors_EMPTY_OBJECT;
});

/**
 * Returns an attribute value of the saved post.
 *
 * @param {Object} state         Global application state.
 * @param {string} attributeName Post attribute name.
 *
 * @return {*} Post attribute value.
 */
function getCurrentPostAttribute(state, attributeName) {
  switch (attributeName) {
    case 'type':
      return getCurrentPostType(state);
    case 'id':
      return getCurrentPostId(state);
    default:
      const post = getCurrentPost(state);
      if (!post.hasOwnProperty(attributeName)) {
        break;
      }
      return getPostRawValue(post[attributeName]);
  }
}

/**
 * Returns a single attribute of the post being edited, preferring the unsaved
 * edit if one exists, but merging with the attribute value for the last known
 * saved state of the post (this is needed for some nested attributes like meta).
 *
 * @param {Object} state         Global application state.
 * @param {string} attributeName Post attribute name.
 *
 * @return {*} Post attribute value.
 */
const getNestedEditedPostProperty = (0,external_wp_data_namespaceObject.createSelector)((state, attributeName) => {
  const edits = getPostEdits(state);
  if (!edits.hasOwnProperty(attributeName)) {
    return getCurrentPostAttribute(state, attributeName);
  }
  return {
    ...getCurrentPostAttribute(state, attributeName),
    ...edits[attributeName]
  };
}, (state, attributeName) => [getCurrentPostAttribute(state, attributeName), getPostEdits(state)[attributeName]]);

/**
 * Returns a single attribute of the post being edited, preferring the unsaved
 * edit if one exists, but falling back to the attribute for the last known
 * saved state of the post.
 *
 * @param {Object} state         Global application state.
 * @param {string} attributeName Post attribute name.
 *
 * @example
 *
 *```js
 * 	// Get specific media size based on the featured media ID
 * 	// Note: change sizes?.large for any registered size
 * 	const getFeaturedMediaUrl = useSelect( ( select ) => {
 * 		const getFeaturedMediaId =
 * 			select( 'core/editor' ).getEditedPostAttribute( 'featured_media' );
 * 		const media = select( 'core' ).getEntityRecord(
 * 			'postType',
 * 			'attachment',
 * 			getFeaturedMediaId
 * 		);
 *
 * 		return (
 * 			media?.media_details?.sizes?.large?.source_url || media?.source_url || ''
 * 		);
 * }, [] );
 *```
 *
 * @return {*} Post attribute value.
 */
function getEditedPostAttribute(state, attributeName) {
  // Special cases.
  switch (attributeName) {
    case 'content':
      return getEditedPostContent(state);
  }

  // Fall back to saved post value if not edited.
  const edits = getPostEdits(state);
  if (!edits.hasOwnProperty(attributeName)) {
    return getCurrentPostAttribute(state, attributeName);
  }

  // Merge properties are objects which contain only the patch edit in state,
  // and thus must be merged with the current post attribute.
  if (EDIT_MERGE_PROPERTIES.has(attributeName)) {
    return getNestedEditedPostProperty(state, attributeName);
  }
  return edits[attributeName];
}

/**
 * Returns an attribute value of the current autosave revision for a post, or
 * null if there is no autosave for the post.
 *
 * @deprecated since 5.6. Callers should use the `getAutosave( postType, postId, userId )` selector
 * 			   from the '@wordpress/core-data' package and access properties on the returned
 * 			   autosave object using getPostRawValue.
 *
 * @param {Object} state         Global application state.
 * @param {string} attributeName Autosave attribute name.
 *
 * @return {*} Autosave attribute value.
 */
const getAutosaveAttribute = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, attributeName) => {
  if (!AUTOSAVE_PROPERTIES.includes(attributeName) && attributeName !== 'preview_link') {
    return;
  }
  const postType = getCurrentPostType(state);

  // Currently template autosaving is not supported.
  if (postType === 'wp_template') {
    return false;
  }
  const postId = getCurrentPostId(state);
  const currentUserId = select(external_wp_coreData_namespaceObject.store).getCurrentUser()?.id;
  const autosave = select(external_wp_coreData_namespaceObject.store).getAutosave(postType, postId, currentUserId);
  if (autosave) {
    return getPostRawValue(autosave[attributeName]);
  }
});

/**
 * Returns the current visibility of the post being edited, preferring the
 * unsaved value if different than the saved post. The return value is one of
 * "private", "password", or "public".
 *
 * @param {Object} state Global application state.
 *
 * @return {string} Post visibility.
 */
function getEditedPostVisibility(state) {
  const status = getEditedPostAttribute(state, 'status');
  if (status === 'private') {
    return 'private';
  }
  const password = getEditedPostAttribute(state, 'password');
  if (password) {
    return 'password';
  }
  return 'public';
}

/**
 * Returns true if post is pending review.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether current post is pending review.
 */
function isCurrentPostPending(state) {
  return getCurrentPost(state).status === 'pending';
}

/**
 * Return true if the current post has already been published.
 *
 * @param {Object} state         Global application state.
 * @param {Object} [currentPost] Explicit current post for bypassing registry selector.
 *
 * @return {boolean} Whether the post has been published.
 */
function isCurrentPostPublished(state, currentPost) {
  const post = currentPost || getCurrentPost(state);
  return ['publish', 'private'].indexOf(post.status) !== -1 || post.status === 'future' && !(0,external_wp_date_namespaceObject.isInTheFuture)(new Date(Number((0,external_wp_date_namespaceObject.getDate)(post.date)) - ONE_MINUTE_IN_MS));
}

/**
 * Returns true if post is already scheduled.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether current post is scheduled to be posted.
 */
function isCurrentPostScheduled(state) {
  return getCurrentPost(state).status === 'future' && !isCurrentPostPublished(state);
}

/**
 * Return true if the post being edited can be published.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post can been published.
 */
function isEditedPostPublishable(state) {
  const post = getCurrentPost(state);

  // TODO: Post being publishable should be superset of condition of post
  // being saveable. Currently this restriction is imposed at UI.
  //
  //  See: <PostPublishButton /> (`isButtonEnabled` assigned by `isSaveable`).

  return isEditedPostDirty(state) || ['publish', 'private', 'future'].indexOf(post.status) === -1;
}

/**
 * Returns true if the post can be saved, or false otherwise. A post must
 * contain a title, an excerpt, or non-empty content to be valid for save.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post can be saved.
 */
function isEditedPostSaveable(state) {
  if (isSavingPost(state)) {
    return false;
  }

  // TODO: Post should not be saveable if not dirty. Cannot be added here at
  // this time since posts where meta boxes are present can be saved even if
  // the post is not dirty. Currently this restriction is imposed at UI, but
  // should be moved here.
  //
  //  See: `isEditedPostPublishable` (includes `isEditedPostDirty` condition)
  //  See: <PostSavedState /> (`forceIsDirty` prop)
  //  See: <PostPublishButton /> (`forceIsDirty` prop)
  //  See: https://github.com/WordPress/gutenberg/pull/4184.

  return !!getEditedPostAttribute(state, 'title') || !!getEditedPostAttribute(state, 'excerpt') || !isEditedPostEmpty(state) || external_wp_element_namespaceObject.Platform.OS === 'native';
}

/**
 * Returns true if the edited post has content. A post has content if it has at
 * least one saveable block or otherwise has a non-empty content property
 * assigned.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether post has content.
 */
const isEditedPostEmpty = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  // While the condition of truthy content string is sufficient to determine
  // emptiness, testing saveable blocks length is a trivial operation. Since
  // this function can be called frequently, optimize for the fast case as a
  // condition of the mere existence of blocks. Note that the value of edited
  // content takes precedent over block content, and must fall through to the
  // default logic.
  const postId = getCurrentPostId(state);
  const postType = getCurrentPostType(state);
  const record = select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', postType, postId);
  if (typeof record.content !== 'function') {
    return !record.content;
  }
  const blocks = getEditedPostAttribute(state, 'blocks');
  if (blocks.length === 0) {
    return true;
  }

  // Pierce the abstraction of the serializer in knowing that blocks are
  // joined with newlines such that even if every individual block
  // produces an empty save result, the serialized content is non-empty.
  if (blocks.length > 1) {
    return false;
  }

  // There are two conditions under which the optimization cannot be
  // assumed, and a fallthrough to getEditedPostContent must occur:
  //
  // 1. getBlocksForSerialization has special treatment in omitting a
  //    single unmodified default block.
  // 2. Comment delimiters are omitted for a freeform or unregistered
  //    block in its serialization. The freeform block specifically may
  //    produce an empty string in its saved output.
  //
  // For all other content, the single block is assumed to make a post
  // non-empty, if only by virtue of its own comment delimiters.
  const blockName = blocks[0].name;
  if (blockName !== (0,external_wp_blocks_namespaceObject.getDefaultBlockName)() && blockName !== (0,external_wp_blocks_namespaceObject.getFreeformContentHandlerName)()) {
    return false;
  }
  return !getEditedPostContent(state);
});

/**
 * Returns true if the post can be autosaved, or false otherwise.
 *
 * @param {Object} state    Global application state.
 * @param {Object} autosave A raw autosave object from the REST API.
 *
 * @return {boolean} Whether the post can be autosaved.
 */
const isEditedPostAutosaveable = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  // A post must contain a title, an excerpt, or non-empty content to be valid for autosaving.
  if (!isEditedPostSaveable(state)) {
    return false;
  }

  // A post is not autosavable when there is a post autosave lock.
  if (isPostAutosavingLocked(state)) {
    return false;
  }
  const postType = getCurrentPostType(state);
  const postTypeObject = select(external_wp_coreData_namespaceObject.store).getPostType(postType);

  // Currently template autosaving is not supported.
  // @todo: Remove hardcode check for template after bumping required WP version to 6.8.
  if (postType === 'wp_template' || !postTypeObject?.supports?.autosave) {
    return false;
  }
  const postId = getCurrentPostId(state);
  const hasFetchedAutosave = select(external_wp_coreData_namespaceObject.store).hasFetchedAutosaves(postType, postId);
  const currentUserId = select(external_wp_coreData_namespaceObject.store).getCurrentUser()?.id;

  // Disable reason - this line causes the side-effect of fetching the autosave
  // via a resolver, moving below the return would result in the autosave never
  // being fetched.
  // eslint-disable-next-line @wordpress/no-unused-vars-before-return
  const autosave = select(external_wp_coreData_namespaceObject.store).getAutosave(postType, postId, currentUserId);

  // If any existing autosaves have not yet been fetched, this function is
  // unable to determine if the post is autosaveable, so return false.
  if (!hasFetchedAutosave) {
    return false;
  }

  // If we don't already have an autosave, the post is autosaveable.
  if (!autosave) {
    return true;
  }

  // To avoid an expensive content serialization, use the content dirtiness
  // flag in place of content field comparison against the known autosave.
  // This is not strictly accurate, and relies on a tolerance toward autosave
  // request failures for unnecessary saves.
  if (hasChangedContent(state)) {
    return true;
  }

  // If title, excerpt, or meta have changed, the post is autosaveable.
  return ['title', 'excerpt', 'meta'].some(field => getPostRawValue(autosave[field]) !== getEditedPostAttribute(state, field));
});

/**
 * Return true if the post being edited is being scheduled. Preferring the
 * unsaved status values.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post has been published.
 */
function isEditedPostBeingScheduled(state) {
  const date = getEditedPostAttribute(state, 'date');
  // Offset the date by one minute (network latency).
  const checkedDate = new Date(Number((0,external_wp_date_namespaceObject.getDate)(date)) - ONE_MINUTE_IN_MS);
  return (0,external_wp_date_namespaceObject.isInTheFuture)(checkedDate);
}

/**
 * Returns whether the current post should be considered to have a "floating"
 * date (i.e. that it would publish "Immediately" rather than at a set time).
 *
 * Unlike in the PHP backend, the REST API returns a full date string for posts
 * where the 0000-00-00T00:00:00 placeholder is present in the database. To
 * infer that a post is set to publish "Immediately" we check whether the date
 * and modified date are the same.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the edited post has a floating date value.
 */
function isEditedPostDateFloating(state) {
  const date = getEditedPostAttribute(state, 'date');
  const modified = getEditedPostAttribute(state, 'modified');

  // This should be the status of the persisted post
  // It shouldn't use the "edited" status otherwise it breaks the
  // inferred post data floating status
  // See https://github.com/WordPress/gutenberg/issues/28083.
  const status = getCurrentPost(state).status;
  if (status === 'draft' || status === 'auto-draft' || status === 'pending') {
    return date === modified || date === null;
  }
  return false;
}

/**
 * Returns true if the post is currently being deleted, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether post is being deleted.
 */
function isDeletingPost(state) {
  return !!state.deleting.pending;
}

/**
 * Returns true if the post is currently being saved, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether post is being saved.
 */
function isSavingPost(state) {
  return !!state.saving.pending;
}

/**
 * Returns true if non-post entities are currently being saved, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether non-post entities are being saved.
 */
const isSavingNonPostEntityChanges = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const entitiesBeingSaved = select(external_wp_coreData_namespaceObject.store).__experimentalGetEntitiesBeingSaved();
  const {
    type,
    id
  } = getCurrentPost(state);
  return entitiesBeingSaved.some(entityRecord => entityRecord.kind !== 'postType' || entityRecord.name !== type || entityRecord.key !== id);
});

/**
 * Returns true if a previous post save was attempted successfully, or false
 * otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post was saved successfully.
 */
const didPostSaveRequestSucceed = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const postType = getCurrentPostType(state);
  const postId = getCurrentPostId(state);
  return !select(external_wp_coreData_namespaceObject.store).getLastEntitySaveError('postType', postType, postId);
});

/**
 * Returns true if a previous post save was attempted but failed, or false
 * otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post save failed.
 */
const didPostSaveRequestFail = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const postType = getCurrentPostType(state);
  const postId = getCurrentPostId(state);
  return !!select(external_wp_coreData_namespaceObject.store).getLastEntitySaveError('postType', postType, postId);
});

/**
 * Returns true if the post is autosaving, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post is autosaving.
 */
function isAutosavingPost(state) {
  return isSavingPost(state) && Boolean(state.saving.options?.isAutosave);
}

/**
 * Returns true if the post is being previewed, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the post is being previewed.
 */
function isPreviewingPost(state) {
  return isSavingPost(state) && Boolean(state.saving.options?.isPreview);
}

/**
 * Returns the post preview link
 *
 * @param {Object} state Global application state.
 *
 * @return {string | undefined} Preview Link.
 */
function getEditedPostPreviewLink(state) {
  if (state.saving.pending || isSavingPost(state)) {
    return;
  }
  let previewLink = getAutosaveAttribute(state, 'preview_link');
  // Fix for issue: https://github.com/WordPress/gutenberg/issues/33616
  // If the post is draft, ignore the preview link from the autosave record,
  // because the preview could be a stale autosave if the post was switched from
  // published to draft.
  // See: https://github.com/WordPress/gutenberg/pull/37952.
  if (!previewLink || 'draft' === getCurrentPost(state).status) {
    previewLink = getEditedPostAttribute(state, 'link');
    if (previewLink) {
      previewLink = (0,external_wp_url_namespaceObject.addQueryArgs)(previewLink, {
        preview: true
      });
    }
  }
  const featuredImageId = getEditedPostAttribute(state, 'featured_media');
  if (previewLink && featuredImageId) {
    return (0,external_wp_url_namespaceObject.addQueryArgs)(previewLink, {
      _thumbnail_id: featuredImageId
    });
  }
  return previewLink;
}

/**
 * Returns a suggested post format for the current post, inferred only if there
 * is a single block within the post and it is of a type known to match a
 * default post format. Returns null if the format cannot be determined.
 *
 * @return {?string} Suggested post format.
 */
const getSuggestedPostFormat = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => {
  const blocks = select(external_wp_blockEditor_namespaceObject.store).getBlocks();
  if (blocks.length > 2) {
    return null;
  }
  let name;
  // If there is only one block in the content of the post grab its name
  // so we can derive a suitable post format from it.
  if (blocks.length === 1) {
    name = blocks[0].name;
    // Check for core/embed `video` and `audio` eligible suggestions.
    if (name === 'core/embed') {
      const provider = blocks[0].attributes?.providerNameSlug;
      if (['youtube', 'vimeo'].includes(provider)) {
        name = 'core/video';
      } else if (['spotify', 'soundcloud'].includes(provider)) {
        name = 'core/audio';
      }
    }
  }

  // If there are two blocks in the content and the last one is a text blocks
  // grab the name of the first one to also suggest a post format from it.
  if (blocks.length === 2 && blocks[1].name === 'core/paragraph') {
    name = blocks[0].name;
  }

  // We only convert to default post formats in core.
  switch (name) {
    case 'core/image':
      return 'image';
    case 'core/quote':
    case 'core/pullquote':
      return 'quote';
    case 'core/gallery':
      return 'gallery';
    case 'core/video':
      return 'video';
    case 'core/audio':
      return 'audio';
    default:
      return null;
  }
});

/**
 * Returns the content of the post being edited.
 *
 * @param {Object} state Global application state.
 *
 * @return {string} Post content.
 */
const getEditedPostContent = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const postId = getCurrentPostId(state);
  const postType = getCurrentPostType(state);
  const record = select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', postType, postId);
  if (record) {
    if (typeof record.content === 'function') {
      return record.content(record);
    } else if (record.blocks) {
      return (0,external_wp_blocks_namespaceObject.__unstableSerializeAndClean)(record.blocks);
    } else if (record.content) {
      return record.content;
    }
  }
  return '';
});

/**
 * Returns true if the post is being published, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether post is being published.
 */
function isPublishingPost(state) {
  return isSavingPost(state) && !isCurrentPostPublished(state) && getEditedPostAttribute(state, 'status') === 'publish';
}

/**
 * Returns whether the permalink is editable or not.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether or not the permalink is editable.
 */
function isPermalinkEditable(state) {
  const permalinkTemplate = getEditedPostAttribute(state, 'permalink_template');
  return PERMALINK_POSTNAME_REGEX.test(permalinkTemplate);
}

/**
 * Returns the permalink for the post.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} The permalink, or null if the post is not viewable.
 */
function getPermalink(state) {
  const permalinkParts = getPermalinkParts(state);
  if (!permalinkParts) {
    return null;
  }
  const {
    prefix,
    postName,
    suffix
  } = permalinkParts;
  if (isPermalinkEditable(state)) {
    return prefix + postName + suffix;
  }
  return prefix;
}

/**
 * Returns the slug for the post being edited, preferring a manually edited
 * value if one exists, then a sanitized version of the current post title, and
 * finally the post ID.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} The current slug to be displayed in the editor
 */
function getEditedPostSlug(state) {
  return getEditedPostAttribute(state, 'slug') || (0,external_wp_url_namespaceObject.cleanForSlug)(getEditedPostAttribute(state, 'title')) || getCurrentPostId(state);
}

/**
 * Returns the permalink for a post, split into its three parts: the prefix,
 * the postName, and the suffix.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} An object containing the prefix, postName, and suffix for
 *                  the permalink, or null if the post is not viewable.
 */
function getPermalinkParts(state) {
  const permalinkTemplate = getEditedPostAttribute(state, 'permalink_template');
  if (!permalinkTemplate) {
    return null;
  }
  const postName = getEditedPostAttribute(state, 'slug') || getEditedPostAttribute(state, 'generated_slug');
  const [prefix, suffix] = permalinkTemplate.split(PERMALINK_POSTNAME_REGEX);
  return {
    prefix,
    postName,
    suffix
  };
}

/**
 * Returns whether the post is locked.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Is locked.
 */
function isPostLocked(state) {
  return state.postLock.isLocked;
}

/**
 * Returns whether post saving is locked.
 *
 * @param {Object} state Global application state.
 *
 * @example
 * ```jsx
 * import { __ } from '@wordpress/i18n';
 * import { store as editorStore } from '@wordpress/editor';
 * import { useSelect } from '@wordpress/data';
 *
 * const ExampleComponent = () => {
 * 	const isSavingLocked = useSelect(
 * 		( select ) => select( editorStore ).isPostSavingLocked(),
 * 		[]
 * 	);
 *
 * 	return isSavingLocked ? (
 * 		<p>{ __( 'Post saving is locked' ) }</p>
 * 	) : (
 * 		<p>{ __( 'Post saving is not locked' ) }</p>
 * 	);
 * };
 * ```
 *
 * @return {boolean} Is locked.
 */
function isPostSavingLocked(state) {
  return Object.keys(state.postSavingLock).length > 0;
}

/**
 * Returns whether post autosaving is locked.
 *
 * @param {Object} state Global application state.
 *
 * @example
 * ```jsx
 * import { __ } from '@wordpress/i18n';
 * import { store as editorStore } from '@wordpress/editor';
 * import { useSelect } from '@wordpress/data';
 *
 * const ExampleComponent = () => {
 * 	const isAutoSavingLocked = useSelect(
 * 		( select ) => select( editorStore ).isPostAutosavingLocked(),
 * 		[]
 * 	);
 *
 * 	return isAutoSavingLocked ? (
 * 		<p>{ __( 'Post auto saving is locked' ) }</p>
 * 	) : (
 * 		<p>{ __( 'Post auto saving is not locked' ) }</p>
 * 	);
 * };
 * ```
 *
 * @return {boolean} Is locked.
 */
function isPostAutosavingLocked(state) {
  return Object.keys(state.postAutosavingLock).length > 0;
}

/**
 * Returns whether the edition of the post has been taken over.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Is post lock takeover.
 */
function isPostLockTakeover(state) {
  return state.postLock.isTakeover;
}

/**
 * Returns details about the post lock user.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} A user object.
 */
function getPostLockUser(state) {
  return state.postLock.user;
}

/**
 * Returns the active post lock.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} The lock object.
 */
function getActivePostLock(state) {
  return state.postLock.activePostLock;
}

/**
 * Returns whether or not the user has the unfiltered_html capability.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the user can or can't post unfiltered HTML.
 */
function canUserUseUnfilteredHTML(state) {
  return Boolean(getCurrentPost(state)._links?.hasOwnProperty('wp:action-unfiltered-html'));
}

/**
 * Returns whether the pre-publish panel should be shown
 * or skipped when the user clicks the "publish" button.
 *
 * @return {boolean} Whether the pre-publish panel should be shown or not.
 */
const isPublishSidebarEnabled = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => !!select(external_wp_preferences_namespaceObject.store).get('core', 'isPublishSidebarEnabled'));

/**
 * Return the current block list.
 *
 * @param {Object} state
 * @return {Array} Block list.
 */
const getEditorBlocks = (0,external_wp_data_namespaceObject.createSelector)(state => {
  return getEditedPostAttribute(state, 'blocks') || (0,external_wp_blocks_namespaceObject.parse)(getEditedPostContent(state));
}, state => [getEditedPostAttribute(state, 'blocks'), getEditedPostContent(state)]);

/**
 * Returns true if the given panel was programmatically removed, or false otherwise.
 * All panels are not removed by default.
 *
 * @param {Object} state     Global application state.
 * @param {string} panelName A string that identifies the panel.
 *
 * @return {boolean} Whether or not the panel is removed.
 */
function isEditorPanelRemoved(state, panelName) {
  return state.removedPanels.includes(panelName);
}

/**
 * Returns true if the given panel is enabled, or false otherwise. Panels are
 * enabled by default.
 *
 * @param {Object} state     Global application state.
 * @param {string} panelName A string that identifies the panel.
 *
 * @return {boolean} Whether or not the panel is enabled.
 */
const isEditorPanelEnabled = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, panelName) => {
  // For backward compatibility, we check edit-post
  // even though now this is in "editor" package.
  const inactivePanels = select(external_wp_preferences_namespaceObject.store).get('core', 'inactivePanels');
  return !isEditorPanelRemoved(state, panelName) && !inactivePanels?.includes(panelName);
});

/**
 * Returns true if the given panel is open, or false otherwise. Panels are
 * closed by default.
 *
 * @param {Object} state     Global application state.
 * @param {string} panelName A string that identifies the panel.
 *
 * @return {boolean} Whether or not the panel is open.
 */
const isEditorPanelOpened = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, panelName) => {
  // For backward compatibility, we check edit-post
  // even though now this is in "editor" package.
  const openPanels = select(external_wp_preferences_namespaceObject.store).get('core', 'openPanels');
  return !!openPanels?.includes(panelName);
});

/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

/**
 * Returns the current selection start.
 *
 * @deprecated since Gutenberg 10.0.0.
 *
 * @param {Object} state
 * @return {WPBlockSelection} The selection start.
 */
function getEditorSelectionStart(state) {
  external_wp_deprecated_default()("select('core/editor').getEditorSelectionStart", {
    since: '5.8',
    alternative: "select('core/editor').getEditorSelection"
  });
  return getEditedPostAttribute(state, 'selection')?.selectionStart;
}

/**
 * Returns the current selection end.
 *
 * @deprecated since Gutenberg 10.0.0.
 *
 * @param {Object} state
 * @return {WPBlockSelection} The selection end.
 */
function getEditorSelectionEnd(state) {
  external_wp_deprecated_default()("select('core/editor').getEditorSelectionStart", {
    since: '5.8',
    alternative: "select('core/editor').getEditorSelection"
  });
  return getEditedPostAttribute(state, 'selection')?.selectionEnd;
}

/**
 * Returns the current selection.
 *
 * @param {Object} state
 * @return {WPBlockSelection} The selection end.
 */
function getEditorSelection(state) {
  return getEditedPostAttribute(state, 'selection');
}

/**
 * Is the editor ready
 *
 * @param {Object} state
 * @return {boolean} is Ready.
 */
function __unstableIsEditorReady(state) {
  return !!state.postId;
}

/**
 * Returns the post editor settings.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} The editor settings object.
 */
function getEditorSettings(state) {
  return state.editorSettings;
}

/**
 * Returns the post editor's rendering mode.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} Rendering mode.
 */
function getRenderingMode(state) {
  return state.renderingMode;
}

/**
 * Returns the current editing canvas device type.
 *
 * @param {Object} state Global application state.
 *
 * @return {string} Device type.
 */
const getDeviceType = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const isZoomOut = unlock(select(external_wp_blockEditor_namespaceObject.store)).isZoomOut();
  if (isZoomOut) {
    return 'Desktop';
  }
  return state.deviceType;
});

/**
 * Returns true if the list view is opened.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the list view is opened.
 */
function isListViewOpened(state) {
  return state.listViewPanel;
}

/**
 * Returns true if the inserter is opened.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the inserter is opened.
 */
function isInserterOpened(state) {
  return !!state.blockInserterPanel;
}

/**
 * Returns the current editing mode.
 *
 * @param {Object} state Global application state.
 *
 * @return {string} Editing mode.
 */
const getEditorMode = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => {
  var _select$get;
  return (_select$get = select(external_wp_preferences_namespaceObject.store).get('core', 'editorMode')) !== null && _select$get !== void 0 ? _select$get : 'visual';
});

/*
 * Backward compatibility
 */

/**
 * Returns state object prior to a specified optimist transaction ID, or `null`
 * if the transaction corresponding to the given ID cannot be found.
 *
 * @deprecated since Gutenberg 9.7.0.
 */
function getStateBeforeOptimisticTransaction() {
  external_wp_deprecated_default()("select('core/editor').getStateBeforeOptimisticTransaction", {
    since: '5.7',
    hint: 'No state history is kept on this store anymore'
  });
  return null;
}
/**
 * Returns true if an optimistic transaction is pending commit, for which the
 * before state satisfies the given predicate function.
 *
 * @deprecated since Gutenberg 9.7.0.
 */
function inSomeHistory() {
  external_wp_deprecated_default()("select('core/editor').inSomeHistory", {
    since: '5.7',
    hint: 'No state history is kept on this store anymore'
  });
  return false;
}
function getBlockEditorSelector(name) {
  return (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, ...args) => {
    external_wp_deprecated_default()("`wp.data.select( 'core/editor' )." + name + '`', {
      since: '5.3',
      alternative: "`wp.data.select( 'core/block-editor' )." + name + '`',
      version: '6.2'
    });
    return select(external_wp_blockEditor_namespaceObject.store)[name](...args);
  });
}

/**
 * @see getBlockName in core/block-editor store.
 */
const getBlockName = getBlockEditorSelector('getBlockName');

/**
 * @see isBlockValid in core/block-editor store.
 */
const isBlockValid = getBlockEditorSelector('isBlockValid');

/**
 * @see getBlockAttributes in core/block-editor store.
 */
const getBlockAttributes = getBlockEditorSelector('getBlockAttributes');

/**
 * @see getBlock in core/block-editor store.
 */
const getBlock = getBlockEditorSelector('getBlock');

/**
 * @see getBlocks in core/block-editor store.
 */
const getBlocks = getBlockEditorSelector('getBlocks');

/**
 * @see getClientIdsOfDescendants in core/block-editor store.
 */
const getClientIdsOfDescendants = getBlockEditorSelector('getClientIdsOfDescendants');

/**
 * @see getClientIdsWithDescendants in core/block-editor store.
 */
const getClientIdsWithDescendants = getBlockEditorSelector('getClientIdsWithDescendants');

/**
 * @see getGlobalBlockCount in core/block-editor store.
 */
const getGlobalBlockCount = getBlockEditorSelector('getGlobalBlockCount');

/**
 * @see getBlocksByClientId in core/block-editor store.
 */
const getBlocksByClientId = getBlockEditorSelector('getBlocksByClientId');

/**
 * @see getBlockCount in core/block-editor store.
 */
const getBlockCount = getBlockEditorSelector('getBlockCount');

/**
 * @see getBlockSelectionStart in core/block-editor store.
 */
const getBlockSelectionStart = getBlockEditorSelector('getBlockSelectionStart');

/**
 * @see getBlockSelectionEnd in core/block-editor store.
 */
const getBlockSelectionEnd = getBlockEditorSelector('getBlockSelectionEnd');

/**
 * @see getSelectedBlockCount in core/block-editor store.
 */
const getSelectedBlockCount = getBlockEditorSelector('getSelectedBlockCount');

/**
 * @see hasSelectedBlock in core/block-editor store.
 */
const hasSelectedBlock = getBlockEditorSelector('hasSelectedBlock');

/**
 * @see getSelectedBlockClientId in core/block-editor store.
 */
const getSelectedBlockClientId = getBlockEditorSelector('getSelectedBlockClientId');

/**
 * @see getSelectedBlock in core/block-editor store.
 */
const getSelectedBlock = getBlockEditorSelector('getSelectedBlock');

/**
 * @see getBlockRootClientId in core/block-editor store.
 */
const getBlockRootClientId = getBlockEditorSelector('getBlockRootClientId');

/**
 * @see getBlockHierarchyRootClientId in core/block-editor store.
 */
const getBlockHierarchyRootClientId = getBlockEditorSelector('getBlockHierarchyRootClientId');

/**
 * @see getAdjacentBlockClientId in core/block-editor store.
 */
const getAdjacentBlockClientId = getBlockEditorSelector('getAdjacentBlockClientId');

/**
 * @see getPreviousBlockClientId in core/block-editor store.
 */
const getPreviousBlockClientId = getBlockEditorSelector('getPreviousBlockClientId');

/**
 * @see getNextBlockClientId in core/block-editor store.
 */
const getNextBlockClientId = getBlockEditorSelector('getNextBlockClientId');

/**
 * @see getSelectedBlocksInitialCaretPosition in core/block-editor store.
 */
const getSelectedBlocksInitialCaretPosition = getBlockEditorSelector('getSelectedBlocksInitialCaretPosition');

/**
 * @see getMultiSelectedBlockClientIds in core/block-editor store.
 */
const getMultiSelectedBlockClientIds = getBlockEditorSelector('getMultiSelectedBlockClientIds');

/**
 * @see getMultiSelectedBlocks in core/block-editor store.
 */
const getMultiSelectedBlocks = getBlockEditorSelector('getMultiSelectedBlocks');

/**
 * @see getFirstMultiSelectedBlockClientId in core/block-editor store.
 */
const getFirstMultiSelectedBlockClientId = getBlockEditorSelector('getFirstMultiSelectedBlockClientId');

/**
 * @see getLastMultiSelectedBlockClientId in core/block-editor store.
 */
const getLastMultiSelectedBlockClientId = getBlockEditorSelector('getLastMultiSelectedBlockClientId');

/**
 * @see isFirstMultiSelectedBlock in core/block-editor store.
 */
const isFirstMultiSelectedBlock = getBlockEditorSelector('isFirstMultiSelectedBlock');

/**
 * @see isBlockMultiSelected in core/block-editor store.
 */
const isBlockMultiSelected = getBlockEditorSelector('isBlockMultiSelected');

/**
 * @see isAncestorMultiSelected in core/block-editor store.
 */
const isAncestorMultiSelected = getBlockEditorSelector('isAncestorMultiSelected');

/**
 * @see getMultiSelectedBlocksStartClientId in core/block-editor store.
 */
const getMultiSelectedBlocksStartClientId = getBlockEditorSelector('getMultiSelectedBlocksStartClientId');

/**
 * @see getMultiSelectedBlocksEndClientId in core/block-editor store.
 */
const getMultiSelectedBlocksEndClientId = getBlockEditorSelector('getMultiSelectedBlocksEndClientId');

/**
 * @see getBlockOrder in core/block-editor store.
 */
const getBlockOrder = getBlockEditorSelector('getBlockOrder');

/**
 * @see getBlockIndex in core/block-editor store.
 */
const getBlockIndex = getBlockEditorSelector('getBlockIndex');

/**
 * @see isBlockSelected in core/block-editor store.
 */
const isBlockSelected = getBlockEditorSelector('isBlockSelected');

/**
 * @see hasSelectedInnerBlock in core/block-editor store.
 */
const hasSelectedInnerBlock = getBlockEditorSelector('hasSelectedInnerBlock');

/**
 * @see isBlockWithinSelection in core/block-editor store.
 */
const isBlockWithinSelection = getBlockEditorSelector('isBlockWithinSelection');

/**
 * @see hasMultiSelection in core/block-editor store.
 */
const hasMultiSelection = getBlockEditorSelector('hasMultiSelection');

/**
 * @see isMultiSelecting in core/block-editor store.
 */
const isMultiSelecting = getBlockEditorSelector('isMultiSelecting');

/**
 * @see isSelectionEnabled in core/block-editor store.
 */
const isSelectionEnabled = getBlockEditorSelector('isSelectionEnabled');

/**
 * @see getBlockMode in core/block-editor store.
 */
const getBlockMode = getBlockEditorSelector('getBlockMode');

/**
 * @see isTyping in core/block-editor store.
 */
const isTyping = getBlockEditorSelector('isTyping');

/**
 * @see isCaretWithinFormattedText in core/block-editor store.
 */
const isCaretWithinFormattedText = getBlockEditorSelector('isCaretWithinFormattedText');

/**
 * @see getBlockInsertionPoint in core/block-editor store.
 */
const getBlockInsertionPoint = getBlockEditorSelector('getBlockInsertionPoint');

/**
 * @see isBlockInsertionPointVisible in core/block-editor store.
 */
const isBlockInsertionPointVisible = getBlockEditorSelector('isBlockInsertionPointVisible');

/**
 * @see isValidTemplate in core/block-editor store.
 */
const isValidTemplate = getBlockEditorSelector('isValidTemplate');

/**
 * @see getTemplate in core/block-editor store.
 */
const getTemplate = getBlockEditorSelector('getTemplate');

/**
 * @see getTemplateLock in core/block-editor store.
 */
const getTemplateLock = getBlockEditorSelector('getTemplateLock');

/**
 * @see canInsertBlockType in core/block-editor store.
 */
const canInsertBlockType = getBlockEditorSelector('canInsertBlockType');

/**
 * @see getInserterItems in core/block-editor store.
 */
const getInserterItems = getBlockEditorSelector('getInserterItems');

/**
 * @see hasInserterItems in core/block-editor store.
 */
const hasInserterItems = getBlockEditorSelector('hasInserterItems');

/**
 * @see getBlockListSettings in core/block-editor store.
 */
const getBlockListSettings = getBlockEditorSelector('getBlockListSettings');
const __experimentalGetDefaultTemplateTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => () => {
  external_wp_deprecated_default()("select('core/editor').__experimentalGetDefaultTemplateTypes", {
    since: '6.8',
    alternative: "select('core/core-data').getCurrentTheme()?.default_template_types"
  });
  return select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.default_template_types;
});

/**
 * Returns the default template part areas.
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} The template part areas.
 */
const __experimentalGetDefaultTemplatePartAreas = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)(() => {
  external_wp_deprecated_default()("select('core/editor').__experimentalGetDefaultTemplatePartAreas", {
    since: '6.8',
    alternative: "select('core/core-data').getCurrentTheme()?.default_template_part_areas"
  });
  const areas = select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.default_template_part_areas || [];
  return areas.map(item => {
    return {
      ...item,
      icon: getTemplatePartIcon(item.icon)
    };
  });
}));

/**
 * Returns a default template type searched by slug.
 *
 * @param {Object} state Global application state.
 * @param {string} slug  The template type slug.
 *
 * @return {Object} The template type.
 */
const __experimentalGetDefaultTemplateType = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, slug) => {
  var _Object$values$find;
  external_wp_deprecated_default()("select('core/editor').__experimentalGetDefaultTemplateType", {
    since: '6.8'
  });
  const templateTypes = select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.default_template_types;
  if (!templateTypes) {
    return selectors_EMPTY_OBJECT;
  }
  return (_Object$values$find = Object.values(templateTypes).find(type => type.slug === slug)) !== null && _Object$values$find !== void 0 ? _Object$values$find : selectors_EMPTY_OBJECT;
}));

/**
 * Given a template entity, return information about it which is ready to be
 * rendered, such as the title, description, and icon.
 *
 * @param {Object} state    Global application state.
 * @param {Object} template The template for which we need information.
 * @return {Object} Information about the template, including title, description, and icon.
 */
const __experimentalGetTemplateInfo = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, template) => {
  external_wp_deprecated_default()("select('core/editor').__experimentalGetTemplateInfo", {
    since: '6.8'
  });
  if (!template) {
    return selectors_EMPTY_OBJECT;
  }
  const currentTheme = select(external_wp_coreData_namespaceObject.store).getCurrentTheme();
  const templateTypes = currentTheme?.default_template_types || [];
  const templateAreas = currentTheme?.default_template_part_areas || [];
  return getTemplateInfo({
    template,
    templateAreas,
    templateTypes
  });
}));

/**
 * Returns a post type label depending on the current post.
 *
 * @param {Object} state Global application state.
 *
 * @return {string|undefined} The post type label if available, otherwise undefined.
 */
const getPostTypeLabel = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  const currentPostType = getCurrentPostType(state);
  const postType = select(external_wp_coreData_namespaceObject.store).getPostType(currentPostType);
  // Disable reason: Post type labels object is shaped like this.
  // eslint-disable-next-line camelcase
  return postType?.labels?.singular_name;
});

/**
 * Returns true if the publish sidebar is opened.
 *
 * @param {Object} state Global application state
 *
 * @return {boolean} Whether the publish sidebar is open.
 */
function isPublishSidebarOpened(state) {
  return state.publishSidebarActive;
}

;// external ["wp","a11y"]
const external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// external ["wp","apiFetch"]
const external_wp_apiFetch_namespaceObject = window["wp"]["apiFetch"];
var external_wp_apiFetch_default = /*#__PURE__*/__webpack_require__.n(external_wp_apiFetch_namespaceObject);
;// external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// ./packages/editor/build-module/store/local-autosave.js
/**
 * Function returning a sessionStorage key to set or retrieve a given post's
 * automatic session backup.
 *
 * Keys are crucially prefixed with 'wp-autosave-' so that wp-login.php's
 * `loggedout` handler can clear sessionStorage of any user-private content.
 *
 * @see https://github.com/WordPress/wordpress-develop/blob/6dad32d2aed47e6c0cf2aee8410645f6d7aba6bd/src/wp-login.php#L103
 *
 * @param {string}  postId    Post ID.
 * @param {boolean} isPostNew Whether post new.
 *
 * @return {string} sessionStorage key
 */
function postKey(postId, isPostNew) {
  return `wp-autosave-block-editor-post-${isPostNew ? 'auto-draft' : postId}`;
}
function localAutosaveGet(postId, isPostNew) {
  return window.sessionStorage.getItem(postKey(postId, isPostNew));
}
function localAutosaveSet(postId, isPostNew, title, content, excerpt) {
  window.sessionStorage.setItem(postKey(postId, isPostNew), JSON.stringify({
    post_title: title,
    content,
    excerpt
  }));
}
function localAutosaveClear(postId, isPostNew) {
  window.sessionStorage.removeItem(postKey(postId, isPostNew));
}

;// ./packages/editor/build-module/store/utils/notice-builder.js
/**
 * WordPress dependencies
 */


/**
 * Builds the arguments for a success notification dispatch.
 *
 * @param {Object} data Incoming data to build the arguments from.
 *
 * @return {Array} Arguments for dispatch. An empty array signals no
 *                 notification should be sent.
 */
function getNotificationArgumentsForSaveSuccess(data) {
  var _postType$viewable;
  const {
    previousPost,
    post,
    postType
  } = data;
  // Autosaves are neither shown a notice nor redirected.
  if (data.options?.isAutosave) {
    return [];
  }
  const publishStatus = ['publish', 'private', 'future'];
  const isPublished = publishStatus.includes(previousPost.status);
  const willPublish = publishStatus.includes(post.status);
  const willTrash = post.status === 'trash' && previousPost.status !== 'trash';
  let noticeMessage;
  let shouldShowLink = (_postType$viewable = postType?.viewable) !== null && _postType$viewable !== void 0 ? _postType$viewable : false;
  let isDraft;

  // Always should a notice, which will be spoken for accessibility.
  if (willTrash) {
    noticeMessage = postType.labels.item_trashed;
    shouldShowLink = false;
  } else if (!isPublished && !willPublish) {
    // If saving a non-published post, don't show notice.
    noticeMessage = (0,external_wp_i18n_namespaceObject.__)('Draft saved.');
    isDraft = true;
  } else if (isPublished && !willPublish) {
    // If undoing publish status, show specific notice.
    noticeMessage = postType.labels.item_reverted_to_draft;
    shouldShowLink = false;
  } else if (!isPublished && willPublish) {
    // If publishing or scheduling a post, show the corresponding
    // publish message.
    noticeMessage = {
      publish: postType.labels.item_published,
      private: postType.labels.item_published_privately,
      future: postType.labels.item_scheduled
    }[post.status];
  } else {
    // Generic fallback notice.
    noticeMessage = postType.labels.item_updated;
  }
  const actions = [];
  if (shouldShowLink) {
    actions.push({
      label: isDraft ? (0,external_wp_i18n_namespaceObject.__)('View Preview') : postType.labels.view_item,
      url: post.link,
      openInNewTab: true
    });
  }
  return [noticeMessage, {
    id: 'editor-save',
    type: 'snackbar',
    actions
  }];
}

/**
 * Builds the fail notification arguments for dispatch.
 *
 * @param {Object} data Incoming data to build the arguments with.
 *
 * @return {Array} Arguments for dispatch. An empty array signals no
 *                 notification should be sent.
 */
function getNotificationArgumentsForSaveFail(data) {
  const {
    post,
    edits,
    error
  } = data;
  if (error && 'rest_autosave_no_changes' === error.code) {
    // Autosave requested a new autosave, but there were no changes. This shouldn't
    // result in an error notice for the user.
    return [];
  }
  const publishStatus = ['publish', 'private', 'future'];
  const isPublished = publishStatus.indexOf(post.status) !== -1;
  if (error.code === 'offline_error') {
    const messages = {
      publish: (0,external_wp_i18n_namespaceObject.__)('Publishing failed because you were offline.'),
      private: (0,external_wp_i18n_namespaceObject.__)('Publishing failed because you were offline.'),
      future: (0,external_wp_i18n_namespaceObject.__)('Scheduling failed because you were offline.'),
      default: (0,external_wp_i18n_namespaceObject.__)('Updating failed because you were offline.')
    };
    const noticeMessage = !isPublished && edits.status in messages ? messages[edits.status] : messages.default;
    return [noticeMessage, {
      id: 'editor-save'
    }];
  }
  const messages = {
    publish: (0,external_wp_i18n_namespaceObject.__)('Publishing failed.'),
    private: (0,external_wp_i18n_namespaceObject.__)('Publishing failed.'),
    future: (0,external_wp_i18n_namespaceObject.__)('Scheduling failed.'),
    default: (0,external_wp_i18n_namespaceObject.__)('Updating failed.')
  };
  let noticeMessage = !isPublished && edits.status in messages ? messages[edits.status] : messages.default;

  // Check if message string contains HTML. Notice text is currently only
  // supported as plaintext, and stripping the tags may muddle the meaning.
  if (error.message && !/<\/?[^>]*>/.test(error.message)) {
    noticeMessage = [noticeMessage, error.message].join(' ');
  }
  return [noticeMessage, {
    id: 'editor-save'
  }];
}

/**
 * Builds the trash fail notification arguments for dispatch.
 *
 * @param {Object} data
 *
 * @return {Array} Arguments for dispatch.
 */
function getNotificationArgumentsForTrashFail(data) {
  return [data.error.message && data.error.code !== 'unknown_error' ? data.error.message : (0,external_wp_i18n_namespaceObject.__)('Trashing failed'), {
    id: 'editor-trash-fail'
  }];
}

;// ./packages/editor/build-module/store/actions.js
/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */



/**
 * Returns an action generator used in signalling that editor has initialized with
 * the specified post object and editor settings.
 *
 * @param {Object} post       Post object.
 * @param {Object} edits      Initial edited attributes object.
 * @param {Array}  [template] Block Template.
 */
const setupEditor = (post, edits, template) => ({
  dispatch
}) => {
  dispatch.setEditedPost(post.type, post.id);
  // Apply a template for new posts only, if exists.
  const isNewPost = post.status === 'auto-draft';
  if (isNewPost && template) {
    // In order to ensure maximum of a single parse during setup, edits are
    // included as part of editor setup action. Assume edited content as
    // canonical if provided, falling back to post.
    let content;
    if ('content' in edits) {
      content = edits.content;
    } else {
      content = post.content.raw;
    }
    let blocks = (0,external_wp_blocks_namespaceObject.parse)(content);
    blocks = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(blocks, template);
    dispatch.resetEditorBlocks(blocks, {
      __unstableShouldCreateUndoLevel: false
    });
  }
  if (edits && Object.values(edits).some(([key, edit]) => {
    var _post$key$raw;
    return edit !== ((_post$key$raw = post[key]?.raw) !== null && _post$key$raw !== void 0 ? _post$key$raw : post[key]);
  })) {
    dispatch.editPost(edits);
  }
};

/**
 * Returns an action object signalling that the editor is being destroyed and
 * that any necessary state or side-effect cleanup should occur.
 *
 * @deprecated
 *
 * @return {Object} Action object.
 */
function __experimentalTearDownEditor() {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).__experimentalTearDownEditor", {
    since: '6.5'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Returns an action object used in signalling that the latest version of the
 * post has been received, either by initialization or save.
 *
 * @deprecated Since WordPress 6.0.
 */
function resetPost() {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).resetPost", {
    since: '6.0',
    version: '6.3',
    alternative: 'Initialize the editor with the setupEditorState action'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Returns an action object used in signalling that a patch of updates for the
 * latest version of the post have been received.
 *
 * @return {Object} Action object.
 * @deprecated since Gutenberg 9.7.0.
 */
function updatePost() {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).updatePost", {
    since: '5.7',
    alternative: 'Use the core entities store instead'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Setup the editor state.
 *
 * @deprecated
 *
 * @param {Object} post Post object.
 */
function setupEditorState(post) {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).setupEditorState", {
    since: '6.5',
    alternative: "wp.data.dispatch( 'core/editor' ).setEditedPost"
  });
  return setEditedPost(post.type, post.id);
}

/**
 * Returns an action that sets the current post Type and post ID.
 *
 * @param {string} postType Post Type.
 * @param {string} postId   Post ID.
 *
 * @return {Object} Action object.
 */
function setEditedPost(postType, postId) {
  return {
    type: 'SET_EDITED_POST',
    postType,
    postId
  };
}

/**
 * Returns an action object used in signalling that attributes of the post have
 * been edited.
 *
 * @param {Object} edits     Post attributes to edit.
 * @param {Object} [options] Options for the edit.
 *
 * @example
 * ```js
 * // Update the post title
 * wp.data.dispatch( 'core/editor' ).editPost( { title: `${ newTitle }` } );
 * ```
 *
 * @return {Object} Action object
 */
const editPost = (edits, options) => ({
  select,
  registry
}) => {
  const {
    id,
    type
  } = select.getCurrentPost();
  registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', type, id, edits, options);
};

/**
 * Action for saving the current post in the editor.
 *
 * @param {Object} [options]
 */
const savePost = (options = {}) => async ({
  select,
  dispatch,
  registry
}) => {
  if (!select.isEditedPostSaveable()) {
    return;
  }
  const content = select.getEditedPostContent();
  if (!options.isAutosave) {
    dispatch.editPost({
      content
    }, {
      undoIgnore: true
    });
  }
  const previousRecord = select.getCurrentPost();
  let edits = {
    id: previousRecord.id,
    ...registry.select(external_wp_coreData_namespaceObject.store).getEntityRecordNonTransientEdits('postType', previousRecord.type, previousRecord.id),
    content
  };
  dispatch({
    type: 'REQUEST_POST_UPDATE_START',
    options
  });
  let error = false;
  try {
    edits = await (0,external_wp_hooks_namespaceObject.applyFiltersAsync)('editor.preSavePost', edits, options);
  } catch (err) {
    error = err;
  }
  if (!error) {
    try {
      await registry.dispatch(external_wp_coreData_namespaceObject.store).saveEntityRecord('postType', previousRecord.type, edits, options);
    } catch (err) {
      error = err.message && err.code !== 'unknown_error' ? err.message : (0,external_wp_i18n_namespaceObject.__)('An error occurred while updating.');
    }
  }
  if (!error) {
    error = registry.select(external_wp_coreData_namespaceObject.store).getLastEntitySaveError('postType', previousRecord.type, previousRecord.id);
  }

  // Run the hook with legacy unstable name for backward compatibility
  if (!error) {
    try {
      await (0,external_wp_hooks_namespaceObject.applyFilters)('editor.__unstableSavePost', Promise.resolve(), options);
    } catch (err) {
      error = err;
    }
  }
  if (!error) {
    try {
      await (0,external_wp_hooks_namespaceObject.doActionAsync)('editor.savePost', {
        id: previousRecord.id
      }, options);
    } catch (err) {
      error = err;
    }
  }
  dispatch({
    type: 'REQUEST_POST_UPDATE_FINISH',
    options
  });
  if (error) {
    const args = getNotificationArgumentsForSaveFail({
      post: previousRecord,
      edits,
      error
    });
    if (args.length) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(...args);
    }
  } else {
    const updatedRecord = select.getCurrentPost();
    const args = getNotificationArgumentsForSaveSuccess({
      previousPost: previousRecord,
      post: updatedRecord,
      postType: await registry.resolveSelect(external_wp_coreData_namespaceObject.store).getPostType(updatedRecord.type),
      options
    });
    if (args.length) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createSuccessNotice(...args);
    }
    // Make sure that any edits after saving create an undo level and are
    // considered for change detection.
    if (!options.isAutosave) {
      registry.dispatch(external_wp_blockEditor_namespaceObject.store).__unstableMarkLastChangeAsPersistent();
    }
  }
};

/**
 * Action for refreshing the current post.
 *
 * @deprecated Since WordPress 6.0.
 */
function refreshPost() {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).refreshPost", {
    since: '6.0',
    version: '6.3',
    alternative: 'Use the core entities store instead'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Action for trashing the current post in the editor.
 */
const trashPost = () => async ({
  select,
  dispatch,
  registry
}) => {
  const postTypeSlug = select.getCurrentPostType();
  const postType = await registry.resolveSelect(external_wp_coreData_namespaceObject.store).getPostType(postTypeSlug);
  const {
    rest_base: restBase,
    rest_namespace: restNamespace = 'wp/v2'
  } = postType;
  dispatch({
    type: 'REQUEST_POST_DELETE_START'
  });
  try {
    const post = select.getCurrentPost();
    await external_wp_apiFetch_default()({
      path: `/${restNamespace}/${restBase}/${post.id}`,
      method: 'DELETE'
    });
    await dispatch.savePost();
  } catch (error) {
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(...getNotificationArgumentsForTrashFail({
      error
    }));
  }
  dispatch({
    type: 'REQUEST_POST_DELETE_FINISH'
  });
};

/**
 * Action that autosaves the current post.  This
 * includes server-side autosaving (default) and client-side (a.k.a. local)
 * autosaving (e.g. on the Web, the post might be committed to Session
 * Storage).
 *
 * @param {Object}  [options]       Extra flags to identify the autosave.
 * @param {boolean} [options.local] Whether to perform a local autosave.
 */
const autosave = ({
  local = false,
  ...options
} = {}) => async ({
  select,
  dispatch
}) => {
  const post = select.getCurrentPost();

  // Currently template autosaving is not supported.
  if (post.type === 'wp_template') {
    return;
  }
  if (local) {
    const isPostNew = select.isEditedPostNew();
    const title = select.getEditedPostAttribute('title');
    const content = select.getEditedPostAttribute('content');
    const excerpt = select.getEditedPostAttribute('excerpt');
    localAutosaveSet(post.id, isPostNew, title, content, excerpt);
  } else {
    await dispatch.savePost({
      isAutosave: true,
      ...options
    });
  }
};
const __unstableSaveForPreview = ({
  forceIsAutosaveable
} = {}) => async ({
  select,
  dispatch
}) => {
  if ((forceIsAutosaveable || select.isEditedPostAutosaveable()) && !select.isPostLocked()) {
    const isDraft = ['draft', 'auto-draft'].includes(select.getEditedPostAttribute('status'));
    if (isDraft) {
      await dispatch.savePost({
        isPreview: true
      });
    } else {
      await dispatch.autosave({
        isPreview: true
      });
    }
  }
  return select.getEditedPostPreviewLink();
};

/**
 * Action that restores last popped state in undo history.
 */
const redo = () => ({
  registry
}) => {
  registry.dispatch(external_wp_coreData_namespaceObject.store).redo();
};

/**
 * Action that pops a record from undo history and undoes the edit.
 */
const undo = () => ({
  registry
}) => {
  registry.dispatch(external_wp_coreData_namespaceObject.store).undo();
};

/**
 * Action that creates an undo history record.
 *
 * @deprecated Since WordPress 6.0
 */
function createUndoLevel() {
  external_wp_deprecated_default()("wp.data.dispatch( 'core/editor' ).createUndoLevel", {
    since: '6.0',
    version: '6.3',
    alternative: 'Use the core entities store instead'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Action that locks the editor.
 *
 * @param {Object} lock Details about the post lock status, user, and nonce.
 * @return {Object} Action object.
 */
function updatePostLock(lock) {
  return {
    type: 'UPDATE_POST_LOCK',
    lock
  };
}

/**
 * Enable the publish sidebar.
 */
const enablePublishSidebar = () => ({
  registry
}) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'isPublishSidebarEnabled', true);
};

/**
 * Disables the publish sidebar.
 */
const disablePublishSidebar = () => ({
  registry
}) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'isPublishSidebarEnabled', false);
};

/**
 * Action that locks post saving.
 *
 * @param {string} lockName The lock name.
 *
 * @example
 * ```
 * const { subscribe } = wp.data;
 *
 * const initialPostStatus = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'status' );
 *
 * // Only allow publishing posts that are set to a future date.
 * if ( 'publish' !== initialPostStatus ) {
 *
 * 	// Track locking.
 * 	let locked = false;
 *
 * 	// Watch for the publish event.
 * 	let unssubscribe = subscribe( () => {
 * 		const currentPostStatus = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'status' );
 * 		if ( 'publish' !== currentPostStatus ) {
 *
 * 			// Compare the post date to the current date, lock the post if the date isn't in the future.
 * 			const postDate = new Date( wp.data.select( 'core/editor' ).getEditedPostAttribute( 'date' ) );
 * 			const currentDate = new Date();
 * 			if ( postDate.getTime() <= currentDate.getTime() ) {
 * 				if ( ! locked ) {
 * 					locked = true;
 * 					wp.data.dispatch( 'core/editor' ).lockPostSaving( 'futurelock' );
 * 				}
 * 			} else {
 * 				if ( locked ) {
 * 					locked = false;
 * 					wp.data.dispatch( 'core/editor' ).unlockPostSaving( 'futurelock' );
 * 				}
 * 			}
 * 		}
 * 	} );
 * }
 * ```
 *
 * @return {Object} Action object
 */
function lockPostSaving(lockName) {
  return {
    type: 'LOCK_POST_SAVING',
    lockName
  };
}

/**
 * Action that unlocks post saving.
 *
 * @param {string} lockName The lock name.
 *
 * @example
 * ```
 * // Unlock post saving with the lock key `mylock`:
 * wp.data.dispatch( 'core/editor' ).unlockPostSaving( 'mylock' );
 * ```
 *
 * @return {Object} Action object
 */
function unlockPostSaving(lockName) {
  return {
    type: 'UNLOCK_POST_SAVING',
    lockName
  };
}

/**
 * Action that locks post autosaving.
 *
 * @param {string} lockName The lock name.
 *
 * @example
 * ```
 * // Lock post autosaving with the lock key `mylock`:
 * wp.data.dispatch( 'core/editor' ).lockPostAutosaving( 'mylock' );
 * ```
 *
 * @return {Object} Action object
 */
function lockPostAutosaving(lockName) {
  return {
    type: 'LOCK_POST_AUTOSAVING',
    lockName
  };
}

/**
 * Action that unlocks post autosaving.
 *
 * @param {string} lockName The lock name.
 *
 * @example
 * ```
 * // Unlock post saving with the lock key `mylock`:
 * wp.data.dispatch( 'core/editor' ).unlockPostAutosaving( 'mylock' );
 * ```
 *
 * @return {Object} Action object
 */
function unlockPostAutosaving(lockName) {
  return {
    type: 'UNLOCK_POST_AUTOSAVING',
    lockName
  };
}

/**
 * Returns an action object used to signal that the blocks have been updated.
 *
 * @param {Array}  blocks    Block Array.
 * @param {Object} [options] Optional options.
 */
const resetEditorBlocks = (blocks, options = {}) => ({
  select,
  dispatch,
  registry
}) => {
  const {
    __unstableShouldCreateUndoLevel,
    selection
  } = options;
  const edits = {
    blocks,
    selection
  };
  if (__unstableShouldCreateUndoLevel !== false) {
    const {
      id,
      type
    } = select.getCurrentPost();
    const noChange = registry.select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', type, id).blocks === edits.blocks;
    if (noChange) {
      registry.dispatch(external_wp_coreData_namespaceObject.store).__unstableCreateUndoLevel('postType', type, id);
      return;
    }

    // We create a new function here on every persistent edit
    // to make sure the edit makes the post dirty and creates
    // a new undo level.
    edits.content = ({
      blocks: blocksForSerialization = []
    }) => (0,external_wp_blocks_namespaceObject.__unstableSerializeAndClean)(blocksForSerialization);
  }
  dispatch.editPost(edits);
};

/*
 * Returns an action object used in signalling that the post editor settings have been updated.
 *
 * @param {Object} settings Updated settings
 *
 * @return {Object} Action object
 */
function updateEditorSettings(settings) {
  return {
    type: 'UPDATE_EDITOR_SETTINGS',
    settings
  };
}

/**
 * Returns an action used to set the rendering mode of the post editor. We support multiple rendering modes:
 *
 * -   `post-only`: This mode extracts the post blocks from the template and renders only those. The idea is to allow the user to edit the post/page in isolation without the wrapping template.
 * -   `template-locked`: This mode renders both the template and the post blocks but the template blocks are locked and can't be edited. The post blocks are editable.
 *
 * @param {string} mode Mode (one of 'post-only' or 'template-locked').
 */
const setRenderingMode = mode => ({
  dispatch,
  registry,
  select
}) => {
  if (select.__unstableIsEditorReady()) {
    // We clear the block selection but we also need to clear the selection from the core store.
    registry.dispatch(external_wp_blockEditor_namespaceObject.store).clearSelectedBlock();
    dispatch.editPost({
      selection: undefined
    }, {
      undoIgnore: true
    });
  }
  dispatch({
    type: 'SET_RENDERING_MODE',
    mode
  });
};

/**
 * Action that changes the width of the editing canvas.
 *
 * @param {string} deviceType
 *
 * @return {Object} Action object.
 */
function setDeviceType(deviceType) {
  return {
    type: 'SET_DEVICE_TYPE',
    deviceType
  };
}

/**
 * Returns an action object used to enable or disable a panel in the editor.
 *
 * @param {string} panelName A string that identifies the panel to enable or disable.
 *
 * @return {Object} Action object.
 */
const toggleEditorPanelEnabled = panelName => ({
  registry
}) => {
  var _registry$select$get;
  const inactivePanels = (_registry$select$get = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'inactivePanels')) !== null && _registry$select$get !== void 0 ? _registry$select$get : [];
  const isPanelInactive = !!inactivePanels?.includes(panelName);

  // If the panel is inactive, remove it to enable it, else add it to
  // make it inactive.
  let updatedInactivePanels;
  if (isPanelInactive) {
    updatedInactivePanels = inactivePanels.filter(invactivePanelName => invactivePanelName !== panelName);
  } else {
    updatedInactivePanels = [...inactivePanels, panelName];
  }
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'inactivePanels', updatedInactivePanels);
};

/**
 * Opens a closed panel and closes an open panel.
 *
 * @param {string} panelName A string that identifies the panel to open or close.
 */
const toggleEditorPanelOpened = panelName => ({
  registry
}) => {
  var _registry$select$get2;
  const openPanels = (_registry$select$get2 = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'openPanels')) !== null && _registry$select$get2 !== void 0 ? _registry$select$get2 : [];
  const isPanelOpen = !!openPanels?.includes(panelName);

  // If the panel is open, remove it to close it, else add it to
  // make it open.
  let updatedOpenPanels;
  if (isPanelOpen) {
    updatedOpenPanels = openPanels.filter(openPanelName => openPanelName !== panelName);
  } else {
    updatedOpenPanels = [...openPanels, panelName];
  }
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'openPanels', updatedOpenPanels);
};

/**
 * Returns an action object used to remove a panel from the editor.
 *
 * @param {string} panelName A string that identifies the panel to remove.
 *
 * @return {Object} Action object.
 */
function removeEditorPanel(panelName) {
  return {
    type: 'REMOVE_PANEL',
    panelName
  };
}

/**
 * Returns an action object used to open/close the inserter.
 *
 * @param {boolean|Object} value                Whether the inserter should be
 *                                              opened (true) or closed (false).
 *                                              To specify an insertion point,
 *                                              use an object.
 * @param {string}         value.rootClientId   The root client ID to insert at.
 * @param {number}         value.insertionIndex The index to insert at.
 * @param {string}         value.filterValue    A query to filter the inserter results.
 * @param {Function}       value.onSelect       A callback when an item is selected.
 * @param {string}         value.tab            The tab to open in the inserter.
 * @param {string}         value.category       The category to initialize in the inserter.
 *
 * @return {Object} Action object.
 */
const setIsInserterOpened = value => ({
  dispatch,
  registry
}) => {
  if (typeof value === 'object' && value.hasOwnProperty('rootClientId') && value.hasOwnProperty('insertionIndex')) {
    unlock(registry.dispatch(external_wp_blockEditor_namespaceObject.store)).setInsertionPoint({
      rootClientId: value.rootClientId,
      index: value.insertionIndex
    });
  }
  dispatch({
    type: 'SET_IS_INSERTER_OPENED',
    value
  });
};

/**
 * Returns an action object used to open/close the list view.
 *
 * @param {boolean} isOpen A boolean representing whether the list view should be opened or closed.
 * @return {Object} Action object.
 */
function setIsListViewOpened(isOpen) {
  return {
    type: 'SET_IS_LIST_VIEW_OPENED',
    isOpen
  };
}

/**
 * Action that toggles Distraction free mode.
 * Distraction free mode expects there are no sidebars, as due to the
 * z-index values set, you can't close sidebars.
 *
 * @param {Object}  [options={}]                Optional configuration object
 * @param {boolean} [options.createNotice=true] Whether to create a notice
 */
const toggleDistractionFree = ({
  createNotice = true
} = {}) => ({
  dispatch,
  registry
}) => {
  const isDistractionFree = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'distractionFree');
  if (isDistractionFree) {
    registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'fixedToolbar', false);
  }
  if (!isDistractionFree) {
    registry.batch(() => {
      registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'fixedToolbar', true);
      dispatch.setIsInserterOpened(false);
      dispatch.setIsListViewOpened(false);
      unlock(registry.dispatch(external_wp_blockEditor_namespaceObject.store)).resetZoomLevel();
    });
  }
  registry.batch(() => {
    registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'distractionFree', !isDistractionFree);
    if (createNotice) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createInfoNotice(isDistractionFree ? (0,external_wp_i18n_namespaceObject.__)('Distraction free mode deactivated.') : (0,external_wp_i18n_namespaceObject.__)('Distraction free mode activated.'), {
        id: 'core/editor/distraction-free-mode/notice',
        type: 'snackbar',
        actions: [{
          label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
          onClick: () => {
            registry.batch(() => {
              registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'fixedToolbar', isDistractionFree);
              registry.dispatch(external_wp_preferences_namespaceObject.store).toggle('core', 'distractionFree');
            });
          }
        }]
      });
    }
  });
};

/**
 * Action that toggles the Spotlight Mode view option.
 */
const toggleSpotlightMode = () => ({
  registry
}) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).toggle('core', 'focusMode');
  const isFocusMode = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'focusMode');
  registry.dispatch(external_wp_notices_namespaceObject.store).createInfoNotice(isFocusMode ? (0,external_wp_i18n_namespaceObject.__)('Spotlight mode activated.') : (0,external_wp_i18n_namespaceObject.__)('Spotlight mode deactivated.'), {
    id: 'core/editor/toggle-spotlight-mode/notice',
    type: 'snackbar',
    actions: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
      onClick: () => {
        registry.dispatch(external_wp_preferences_namespaceObject.store).toggle('core', 'focusMode');
      }
    }]
  });
};

/**
 * Action that toggles the Top Toolbar view option.
 */
const toggleTopToolbar = () => ({
  registry
}) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).toggle('core', 'fixedToolbar');
  const isTopToolbar = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'fixedToolbar');
  registry.dispatch(external_wp_notices_namespaceObject.store).createInfoNotice(isTopToolbar ? (0,external_wp_i18n_namespaceObject.__)('Top toolbar activated.') : (0,external_wp_i18n_namespaceObject.__)('Top toolbar deactivated.'), {
    id: 'core/editor/toggle-top-toolbar/notice',
    type: 'snackbar',
    actions: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
      onClick: () => {
        registry.dispatch(external_wp_preferences_namespaceObject.store).toggle('core', 'fixedToolbar');
      }
    }]
  });
};

/**
 * Triggers an action used to switch editor mode.
 *
 * @param {string} mode The editor mode.
 */
const switchEditorMode = mode => ({
  dispatch,
  registry
}) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'editorMode', mode);
  if (mode !== 'visual') {
    // Unselect blocks when we switch to a non visual mode.
    registry.dispatch(external_wp_blockEditor_namespaceObject.store).clearSelectedBlock();
    // Exit zoom out state when switching to a non visual mode.
    unlock(registry.dispatch(external_wp_blockEditor_namespaceObject.store)).resetZoomLevel();
  }
  if (mode === 'visual') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Visual editor selected'), 'assertive');
  } else if (mode === 'text') {
    const isDistractionFree = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'distractionFree');
    if (isDistractionFree) {
      dispatch.toggleDistractionFree();
    }
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Code editor selected'), 'assertive');
  }
};

/**
 * Returns an action object used in signalling that the user opened the publish
 * sidebar.
 *
 * @return {Object} Action object
 */
function openPublishSidebar() {
  return {
    type: 'OPEN_PUBLISH_SIDEBAR'
  };
}

/**
 * Returns an action object used in signalling that the user closed the
 * publish sidebar.
 *
 * @return {Object} Action object.
 */
function closePublishSidebar() {
  return {
    type: 'CLOSE_PUBLISH_SIDEBAR'
  };
}

/**
 * Returns an action object used in signalling that the user toggles the publish sidebar.
 *
 * @return {Object} Action object
 */
function togglePublishSidebar() {
  return {
    type: 'TOGGLE_PUBLISH_SIDEBAR'
  };
}

/**
 * Backward compatibility
 */

const getBlockEditorAction = name => (...args) => ({
  registry
}) => {
  external_wp_deprecated_default()("`wp.data.dispatch( 'core/editor' )." + name + '`', {
    since: '5.3',
    alternative: "`wp.data.dispatch( 'core/block-editor' )." + name + '`',
    version: '6.2'
  });
  registry.dispatch(external_wp_blockEditor_namespaceObject.store)[name](...args);
};

/**
 * @see resetBlocks in core/block-editor store.
 */
const resetBlocks = getBlockEditorAction('resetBlocks');

/**
 * @see receiveBlocks in core/block-editor store.
 */
const receiveBlocks = getBlockEditorAction('receiveBlocks');

/**
 * @see updateBlock in core/block-editor store.
 */
const updateBlock = getBlockEditorAction('updateBlock');

/**
 * @see updateBlockAttributes in core/block-editor store.
 */
const updateBlockAttributes = getBlockEditorAction('updateBlockAttributes');

/**
 * @see selectBlock in core/block-editor store.
 */
const selectBlock = getBlockEditorAction('selectBlock');

/**
 * @see startMultiSelect in core/block-editor store.
 */
const startMultiSelect = getBlockEditorAction('startMultiSelect');

/**
 * @see stopMultiSelect in core/block-editor store.
 */
const stopMultiSelect = getBlockEditorAction('stopMultiSelect');

/**
 * @see multiSelect in core/block-editor store.
 */
const multiSelect = getBlockEditorAction('multiSelect');

/**
 * @see clearSelectedBlock in core/block-editor store.
 */
const clearSelectedBlock = getBlockEditorAction('clearSelectedBlock');

/**
 * @see toggleSelection in core/block-editor store.
 */
const toggleSelection = getBlockEditorAction('toggleSelection');

/**
 * @see replaceBlocks in core/block-editor store.
 */
const replaceBlocks = getBlockEditorAction('replaceBlocks');

/**
 * @see replaceBlock in core/block-editor store.
 */
const replaceBlock = getBlockEditorAction('replaceBlock');

/**
 * @see moveBlocksDown in core/block-editor store.
 */
const moveBlocksDown = getBlockEditorAction('moveBlocksDown');

/**
 * @see moveBlocksUp in core/block-editor store.
 */
const moveBlocksUp = getBlockEditorAction('moveBlocksUp');

/**
 * @see moveBlockToPosition in core/block-editor store.
 */
const moveBlockToPosition = getBlockEditorAction('moveBlockToPosition');

/**
 * @see insertBlock in core/block-editor store.
 */
const insertBlock = getBlockEditorAction('insertBlock');

/**
 * @see insertBlocks in core/block-editor store.
 */
const insertBlocks = getBlockEditorAction('insertBlocks');

/**
 * @see showInsertionPoint in core/block-editor store.
 */
const showInsertionPoint = getBlockEditorAction('showInsertionPoint');

/**
 * @see hideInsertionPoint in core/block-editor store.
 */
const hideInsertionPoint = getBlockEditorAction('hideInsertionPoint');

/**
 * @see setTemplateValidity in core/block-editor store.
 */
const setTemplateValidity = getBlockEditorAction('setTemplateValidity');

/**
 * @see synchronizeTemplate in core/block-editor store.
 */
const synchronizeTemplate = getBlockEditorAction('synchronizeTemplate');

/**
 * @see mergeBlocks in core/block-editor store.
 */
const mergeBlocks = getBlockEditorAction('mergeBlocks');

/**
 * @see removeBlocks in core/block-editor store.
 */
const removeBlocks = getBlockEditorAction('removeBlocks');

/**
 * @see removeBlock in core/block-editor store.
 */
const removeBlock = getBlockEditorAction('removeBlock');

/**
 * @see toggleBlockMode in core/block-editor store.
 */
const toggleBlockMode = getBlockEditorAction('toggleBlockMode');

/**
 * @see startTyping in core/block-editor store.
 */
const startTyping = getBlockEditorAction('startTyping');

/**
 * @see stopTyping in core/block-editor store.
 */
const stopTyping = getBlockEditorAction('stopTyping');

/**
 * @see enterFormattedText in core/block-editor store.
 */
const enterFormattedText = getBlockEditorAction('enterFormattedText');

/**
 * @see exitFormattedText in core/block-editor store.
 */
const exitFormattedText = getBlockEditorAction('exitFormattedText');

/**
 * @see insertDefaultBlock in core/block-editor store.
 */
const insertDefaultBlock = getBlockEditorAction('insertDefaultBlock');

/**
 * @see updateBlockListSettings in core/block-editor store.
 */
const updateBlockListSettings = getBlockEditorAction('updateBlockListSettings');

;// external ["wp","htmlEntities"]
const external_wp_htmlEntities_namespaceObject = window["wp"]["htmlEntities"];
;// ./packages/editor/build-module/store/utils/is-template-revertable.js
/**
 * Internal dependencies
 */


// Copy of the function from packages/edit-site/src/utils/is-template-revertable.js

/**
 * Check if a template or template part is revertable to its original theme-provided file.
 *
 * @param {Object} templateOrTemplatePart The entity to check.
 * @return {boolean} Whether the entity is revertable.
 */
function isTemplateRevertable(templateOrTemplatePart) {
  if (!templateOrTemplatePart) {
    return false;
  }
  return templateOrTemplatePart.source === TEMPLATE_ORIGINS.custom && (Boolean(templateOrTemplatePart?.plugin) || templateOrTemplatePart?.has_theme_file);
}

;// ./packages/icons/build-module/library/external.js
/**
 * WordPress dependencies
 */


const external = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19.5 4.5h-7V6h4.44l-5.97 5.97 1.06 1.06L18 7.06v4.44h1.5v-7Zm-13 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3H17v3a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h3V5.5h-3Z"
  })
});
/* harmony default export */ const library_external = (external);

;// ./packages/fields/build-module/actions/view-post.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const viewPost = {
  id: 'view-post',
  label: (0,external_wp_i18n_namespaceObject._x)('View', 'verb'),
  isPrimary: true,
  icon: library_external,
  isEligible(post) {
    return post.status !== 'trash';
  },
  callback(posts, {
    onActionPerformed
  }) {
    const post = posts[0];
    window.open(post?.link, '_blank');
    if (onActionPerformed) {
      onActionPerformed(posts);
    }
  }
};

/**
 * View post action for BasePost.
 */
/* harmony default export */ const view_post = (viewPost);

;// ./packages/fields/build-module/actions/view-post-revisions.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const viewPostRevisions = {
  id: 'view-post-revisions',
  context: 'list',
  label(items) {
    var _items$0$_links$versi;
    const revisionsCount = (_items$0$_links$versi = items[0]._links?.['version-history']?.[0]?.count) !== null && _items$0$_links$versi !== void 0 ? _items$0$_links$versi : 0;
    return (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: number of revisions. */
    (0,external_wp_i18n_namespaceObject.__)('View revisions (%d)'), revisionsCount);
  },
  isEligible(post) {
    var _post$_links$predeces, _post$_links$version;
    if (post.status === 'trash') {
      return false;
    }
    const lastRevisionId = (_post$_links$predeces = post?._links?.['predecessor-version']?.[0]?.id) !== null && _post$_links$predeces !== void 0 ? _post$_links$predeces : null;
    const revisionsCount = (_post$_links$version = post?._links?.['version-history']?.[0]?.count) !== null && _post$_links$version !== void 0 ? _post$_links$version : 0;
    return !!lastRevisionId && revisionsCount > 1;
  },
  callback(posts, {
    onActionPerformed
  }) {
    const post = posts[0];
    const href = (0,external_wp_url_namespaceObject.addQueryArgs)('revision.php', {
      revision: post?._links?.['predecessor-version']?.[0]?.id
    });
    document.location.href = href;
    if (onActionPerformed) {
      onActionPerformed(posts);
    }
  }
};

/**
 * View post revisions action for Post.
 */
/* harmony default export */ const view_post_revisions = (viewPostRevisions);

;// ./packages/dataviews/build-module/components/dataform-context/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const DataFormContext = (0,external_wp_element_namespaceObject.createContext)({
  fields: []
});
DataFormContext.displayName = 'DataFormContext';
function DataFormProvider({
  fields,
  children
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormContext.Provider, {
    value: {
      fields
    },
    children: children
  });
}
/* harmony default export */ const dataform_context = (DataFormContext);

;// ./packages/dataviews/build-module/utils.js
/**
 * Internal dependencies
 */

function renderFromElements({
  item,
  field
}) {
  const value = field.getValue({
    item
  });
  return field?.elements?.find(element => element.value === value)?.label || field.getValue({
    item
  });
}

;// ./packages/icons/build-module/library/arrow-up.js
/**
 * WordPress dependencies
 */


const arrowUp = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 3.9 6.5 9.5l1 1 3.8-3.7V20h1.5V6.8l3.7 3.7 1-1z"
  })
});
/* harmony default export */ const arrow_up = (arrowUp);

;// ./packages/icons/build-module/library/arrow-down.js
/**
 * WordPress dependencies
 */


const arrowDown = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m16.5 13.5-3.7 3.7V4h-1.5v13.2l-3.8-3.7-1 1 5.5 5.6 5.5-5.6z"
  })
});
/* harmony default export */ const arrow_down = (arrowDown);

;// ./packages/dataviews/build-module/constants.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

// Filter operators.
const OPERATOR_IS = 'is';
const OPERATOR_IS_NOT = 'isNot';
const OPERATOR_IS_ANY = 'isAny';
const OPERATOR_IS_NONE = 'isNone';
const OPERATOR_IS_ALL = 'isAll';
const OPERATOR_IS_NOT_ALL = 'isNotAll';
const OPERATOR_LESS_THAN = 'lessThan';
const OPERATOR_GREATER_THAN = 'greaterThan';
const OPERATOR_LESS_THAN_OR_EQUAL = 'lessThanOrEqual';
const OPERATOR_GREATER_THAN_OR_EQUAL = 'greaterThanOrEqual';
const OPERATOR_BEFORE = 'before';
const OPERATOR_AFTER = 'after';
const OPERATOR_BEFORE_INC = 'beforeInc';
const OPERATOR_AFTER_INC = 'afterInc';
const OPERATOR_CONTAINS = 'contains';
const OPERATOR_NOT_CONTAINS = 'notContains';
const OPERATOR_STARTS_WITH = 'startsWith';
const OPERATOR_BETWEEN = 'between';
const OPERATOR_ON = 'on';
const OPERATOR_NOT_ON = 'notOn';
const OPERATOR_IN_THE_PAST = 'inThePast';
const OPERATOR_OVER = 'over';
const ALL_OPERATORS = [OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_IS_ANY, OPERATOR_IS_NONE, OPERATOR_IS_ALL, OPERATOR_IS_NOT_ALL, OPERATOR_LESS_THAN, OPERATOR_GREATER_THAN, OPERATOR_LESS_THAN_OR_EQUAL, OPERATOR_GREATER_THAN_OR_EQUAL, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_CONTAINS, OPERATOR_NOT_CONTAINS, OPERATOR_STARTS_WITH, OPERATOR_BETWEEN, OPERATOR_ON, OPERATOR_NOT_ON, OPERATOR_IN_THE_PAST, OPERATOR_OVER];
const SINGLE_SELECTION_OPERATORS = [OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_LESS_THAN, OPERATOR_GREATER_THAN, OPERATOR_LESS_THAN_OR_EQUAL, OPERATOR_GREATER_THAN_OR_EQUAL, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_CONTAINS, OPERATOR_NOT_CONTAINS, OPERATOR_STARTS_WITH, OPERATOR_ON, OPERATOR_NOT_ON];
const OPERATORS = {
  [OPERATOR_IS]: {
    key: 'is-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is')
  },
  [OPERATOR_IS_NOT]: {
    key: 'is-not-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is not')
  },
  [OPERATOR_IS_ANY]: {
    key: 'is-any-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is any')
  },
  [OPERATOR_IS_NONE]: {
    key: 'is-none-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is none')
  },
  [OPERATOR_IS_ALL]: {
    key: 'is-all-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is all')
  },
  [OPERATOR_IS_NOT_ALL]: {
    key: 'is-not-all-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Is not all')
  },
  [OPERATOR_LESS_THAN]: {
    key: 'less-than-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Less than')
  },
  [OPERATOR_GREATER_THAN]: {
    key: 'greater-than-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Greater than')
  },
  [OPERATOR_LESS_THAN_OR_EQUAL]: {
    key: 'less-than-or-equal-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Less than or equal')
  },
  [OPERATOR_GREATER_THAN_OR_EQUAL]: {
    key: 'greater-than-or-equal-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Greater than or equal')
  },
  [OPERATOR_BEFORE]: {
    key: 'before-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Before')
  },
  [OPERATOR_AFTER]: {
    key: 'after-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('After')
  },
  [OPERATOR_BEFORE_INC]: {
    key: 'before-inc-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Before (inc)')
  },
  [OPERATOR_AFTER_INC]: {
    key: 'after-inc-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('After (inc)')
  },
  [OPERATOR_CONTAINS]: {
    key: 'contains-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Contains')
  },
  [OPERATOR_NOT_CONTAINS]: {
    key: 'not-contains-filter',
    label: (0,external_wp_i18n_namespaceObject.__)("Doesn't contain")
  },
  [OPERATOR_STARTS_WITH]: {
    key: 'starts-with-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Starts with')
  },
  [OPERATOR_BETWEEN]: {
    key: 'between-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Between (inc)')
  },
  [OPERATOR_ON]: {
    key: 'on-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('On')
  },
  [OPERATOR_NOT_ON]: {
    key: 'not-on-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Not on')
  },
  [OPERATOR_IN_THE_PAST]: {
    key: 'in-the-past-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('In the past')
  },
  [OPERATOR_OVER]: {
    key: 'over-filter',
    label: (0,external_wp_i18n_namespaceObject.__)('Over')
  }
};
const SORTING_DIRECTIONS = (/* unused pure expression or super */ null && (['asc', 'desc']));
const sortArrows = {
  asc: '↑',
  desc: '↓'
};
const sortValues = {
  asc: 'ascending',
  desc: 'descending'
};
const sortLabels = {
  asc: (0,external_wp_i18n_namespaceObject.__)('Sort ascending'),
  desc: (0,external_wp_i18n_namespaceObject.__)('Sort descending')
};
const sortIcons = {
  asc: arrow_up,
  desc: arrow_down
};

// View layouts.
const LAYOUT_TABLE = 'table';
const LAYOUT_GRID = 'grid';
const LAYOUT_LIST = 'list';

;// ./packages/dataviews/build-module/field-types/email.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function sort(valueA, valueB, direction) {
  return direction === 'asc' ? valueA.localeCompare(valueB) : valueB.localeCompare(valueA);
}

// Email validation regex based on HTML5 spec
// https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address
const emailRegex = /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;
/* harmony default export */ const email = ({
  sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (![undefined, '', null].includes(value) && !emailRegex.test(value)) {
        return (0,external_wp_i18n_namespaceObject.__)('Value must be a valid email address.');
      }
      if (field.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(value)) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: 'email',
  render: ({
    item,
    field
  }) => {
    return field.elements ? renderFromElements({
      item,
      field
    }) : field.getValue({
      item
    });
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_IS_ANY, OPERATOR_IS_NONE],
    validOperators: [OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_CONTAINS, OPERATOR_NOT_CONTAINS, OPERATOR_STARTS_WITH,
    // Multiple selection
    OPERATOR_IS_ANY, OPERATOR_IS_NONE, OPERATOR_IS_ALL, OPERATOR_IS_NOT_ALL]
  }
});

;// ./packages/dataviews/build-module/field-types/integer.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function integer_sort(a, b, direction) {
  return direction === 'asc' ? a - b : b - a;
}
/* harmony default export */ const integer = ({
  sort: integer_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (![undefined, '', null].includes(value) && !Number.isInteger(value)) {
        return (0,external_wp_i18n_namespaceObject.__)('Value must be an integer.');
      }
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(Number(value))) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: 'integer',
  render: ({
    item,
    field
  }) => {
    return field.elements ? renderFromElements({
      item,
      field
    }) : field.getValue({
      item
    });
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_LESS_THAN, OPERATOR_GREATER_THAN, OPERATOR_LESS_THAN_OR_EQUAL, OPERATOR_GREATER_THAN_OR_EQUAL, OPERATOR_BETWEEN],
    validOperators: [
    // Single-selection
    OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_LESS_THAN, OPERATOR_GREATER_THAN, OPERATOR_LESS_THAN_OR_EQUAL, OPERATOR_GREATER_THAN_OR_EQUAL, OPERATOR_BETWEEN,
    // Multiple-selection
    OPERATOR_IS_ANY, OPERATOR_IS_NONE, OPERATOR_IS_ALL, OPERATOR_IS_NOT_ALL]
  }
});

;// ./packages/dataviews/build-module/field-types/text.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function text_sort(valueA, valueB, direction) {
  return direction === 'asc' ? valueA.localeCompare(valueB) : valueB.localeCompare(valueA);
}
/* harmony default export */ const field_types_text = ({
  sort: text_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(value)) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: 'text',
  render: ({
    item,
    field
  }) => {
    return field.elements ? renderFromElements({
      item,
      field
    }) : field.getValue({
      item
    });
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_IS_ANY, OPERATOR_IS_NONE],
    validOperators: [
    // Single selection
    OPERATOR_IS, OPERATOR_IS_NOT, OPERATOR_CONTAINS, OPERATOR_NOT_CONTAINS, OPERATOR_STARTS_WITH,
    // Multiple selection
    OPERATOR_IS_ANY, OPERATOR_IS_NONE, OPERATOR_IS_ALL, OPERATOR_IS_NOT_ALL]
  }
});

;// ./packages/dataviews/build-module/field-types/datetime.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function datetime_sort(a, b, direction) {
  const timeA = new Date(a).getTime();
  const timeB = new Date(b).getTime();
  return direction === 'asc' ? timeA - timeB : timeB - timeA;
}
/* harmony default export */ const datetime = ({
  sort: datetime_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(value)) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: 'datetime',
  render: ({
    item,
    field
  }) => {
    return field.elements ? renderFromElements({
      item,
      field
    }) : field.getValue({
      item
    });
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_ON, OPERATOR_NOT_ON, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_IN_THE_PAST, OPERATOR_OVER],
    validOperators: [OPERATOR_ON, OPERATOR_NOT_ON, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_IN_THE_PAST, OPERATOR_OVER]
  }
});

;// ./packages/dataviews/build-module/field-types/date.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const getFormattedDate = dateToDisplay => (0,external_wp_date_namespaceObject.dateI18n)((0,external_wp_date_namespaceObject.getSettings)().formats.date, (0,external_wp_date_namespaceObject.getDate)(dateToDisplay));
function date_sort(a, b, direction) {
  const timeA = new Date(a).getTime();
  const timeB = new Date(b).getTime();
  return direction === 'asc' ? timeA - timeB : timeB - timeA;
}
/* harmony default export */ const date = ({
  sort: date_sort,
  Edit: 'date',
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(value)) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  render: ({
    item,
    field
  }) => {
    if (field.elements) {
      return renderFromElements({
        item,
        field
      });
    }
    const value = field.getValue({
      item
    });
    if (!value) {
      return '';
    }
    return getFormattedDate(value);
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_ON, OPERATOR_NOT_ON, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_IN_THE_PAST, OPERATOR_OVER, OPERATOR_BETWEEN],
    validOperators: [OPERATOR_ON, OPERATOR_NOT_ON, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_BEFORE_INC, OPERATOR_AFTER_INC, OPERATOR_IN_THE_PAST, OPERATOR_OVER, OPERATOR_BETWEEN]
  }
});

;// ./packages/dataviews/build-module/field-types/boolean.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function boolean_sort(a, b, direction) {
  const boolA = Boolean(a);
  const boolB = Boolean(b);
  if (boolA === boolB) {
    return 0;
  }

  // In ascending order, false comes before true
  if (direction === 'asc') {
    return boolA ? 1 : -1;
  }

  // In descending order, true comes before false
  return boolA ? -1 : 1;
}
/* harmony default export */ const field_types_boolean = ({
  sort: boolean_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (![undefined, '', null].includes(value) && ![true, false].includes(value)) {
        return (0,external_wp_i18n_namespaceObject.__)('Value must be true, false, or undefined');
      }
      return null;
    }
  },
  Edit: 'boolean',
  render: ({
    item,
    field
  }) => {
    if (field.elements) {
      return renderFromElements({
        item,
        field
      });
    }
    if (field.getValue({
      item
    }) === true) {
      return (0,external_wp_i18n_namespaceObject.__)('True');
    }
    if (field.getValue({
      item
    }) === false) {
      return (0,external_wp_i18n_namespaceObject.__)('False');
    }
    return null;
  },
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_IS, OPERATOR_IS_NOT],
    validOperators: [OPERATOR_IS, OPERATOR_IS_NOT]
  }
});

;// ./packages/dataviews/build-module/field-types/media.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

function media_sort() {
  return 0;
}
/* harmony default export */ const media = ({
  sort: media_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!validValues.includes(value)) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: null,
  render: () => null,
  enableSorting: false,
  filterBy: false
});

;// ./packages/dataviews/build-module/field-types/array.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



// Sort arrays by length, then alphabetically by joined string
function array_sort(valueA, valueB, direction) {
  const arrA = Array.isArray(valueA) ? valueA : [];
  const arrB = Array.isArray(valueB) ? valueB : [];
  if (arrA.length !== arrB.length) {
    return direction === 'asc' ? arrA.length - arrB.length : arrB.length - arrA.length;
  }
  const joinedA = arrA.join(',');
  const joinedB = arrB.join(',');
  return direction === 'asc' ? joinedA.localeCompare(joinedB) : joinedB.localeCompare(joinedA);
}
function render({
  item,
  field
}) {
  const value = field.getValue({
    item
  }) || [];
  return value.join(', ');
}
const arrayFieldType = {
  sort: array_sort,
  isValid: {
    custom: (item, field) => {
      const value = field.getValue({
        item
      });
      if (![undefined, '', null].includes(value) && !Array.isArray(value)) {
        return (0,external_wp_i18n_namespaceObject.__)('Value must be an array.');
      }

      // Only allow strings for now. Can be extended to other types in the future.
      if (!value.every(v => typeof v === 'string')) {
        return (0,external_wp_i18n_namespaceObject.__)('Every value must be a string.');
      }
      if (field?.elements) {
        const validValues = field.elements.map(f => f.value);
        if (!value.every(v => validValues.includes(v))) {
          return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
        }
      }
      return null;
    }
  },
  Edit: 'array',
  // Use array control
  render,
  enableSorting: true,
  filterBy: {
    defaultOperators: [OPERATOR_IS_ANY, OPERATOR_IS_NONE],
    validOperators: [OPERATOR_IS_ANY, OPERATOR_IS_NONE, OPERATOR_IS_ALL, OPERATOR_IS_NOT_ALL]
  }
};
/* harmony default export */ const array = (arrayFieldType);

;// ./packages/dataviews/build-module/field-types/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */












/**
 *
 * @param {FieldType} type The field type definition to get.
 *
 * @return A field type definition.
 */
function getFieldTypeDefinition(type) {
  if ('email' === type) {
    return email;
  }
  if ('integer' === type) {
    return integer;
  }
  if ('text' === type) {
    return field_types_text;
  }
  if ('datetime' === type) {
    return datetime;
  }
  if ('date' === type) {
    return date;
  }
  if ('boolean' === type) {
    return field_types_boolean;
  }
  if ('media' === type) {
    return media;
  }
  if ('array' === type) {
    return array;
  }

  // This is a fallback for fields that don't provide a type.
  // It can be removed when the field.type is mandatory.
  return {
    sort: (a, b, direction) => {
      if (typeof a === 'number' && typeof b === 'number') {
        return direction === 'asc' ? a - b : b - a;
      }
      return direction === 'asc' ? a.localeCompare(b) : b.localeCompare(a);
    },
    isValid: {
      custom: (item, field) => {
        if (field?.elements) {
          const value = field.getValue({
            item
          });
          const validValues = field?.elements?.map(f => f.value);
          if (!validValues.includes(value)) {
            return (0,external_wp_i18n_namespaceObject.__)('Value must be one of the elements.');
          }
        }
        return null;
      }
    },
    Edit: null,
    render: ({
      item,
      field
    }) => {
      return field.elements ? renderFromElements({
        item,
        field
      }) : field.getValue({
        item
      });
    },
    enableSorting: true,
    filterBy: {
      defaultOperators: [OPERATOR_IS, OPERATOR_IS_NOT],
      validOperators: ALL_OPERATORS
    }
  };
}

;// external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// ./packages/dataviews/build-module/dataform-controls/checkbox.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

function Checkbox({
  field,
  onChange,
  data,
  hideLabelFromVision
}) {
  const {
    id,
    getValue,
    label,
    description
  } = field;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
    __nextHasNoMarginBottom: true,
    hidden: hideLabelFromVision,
    label: label,
    help: description,
    checked: getValue({
      item: data
    }),
    onChange: () => onChange({
      [id]: !getValue({
        item: data
      })
    })
  });
}

;// ./node_modules/clsx/dist/clsx.mjs
function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f)}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}/* harmony default export */ const dist_clsx = (clsx);
;// ./packages/dataviews/build-module/dataform-controls/relative-date-control.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const TIME_UNITS_OPTIONS = {
  [OPERATOR_IN_THE_PAST]: [{
    value: 'days',
    label: (0,external_wp_i18n_namespaceObject.__)('Days')
  }, {
    value: 'weeks',
    label: (0,external_wp_i18n_namespaceObject.__)('Weeks')
  }, {
    value: 'months',
    label: (0,external_wp_i18n_namespaceObject.__)('Months')
  }, {
    value: 'years',
    label: (0,external_wp_i18n_namespaceObject.__)('Years')
  }],
  [OPERATOR_OVER]: [{
    value: 'days',
    label: (0,external_wp_i18n_namespaceObject.__)('Days ago')
  }, {
    value: 'weeks',
    label: (0,external_wp_i18n_namespaceObject.__)('Weeks ago')
  }, {
    value: 'months',
    label: (0,external_wp_i18n_namespaceObject.__)('Months ago')
  }, {
    value: 'years',
    label: (0,external_wp_i18n_namespaceObject.__)('Years ago')
  }]
};
function RelativeDateControl({
  id,
  value,
  onChange,
  label,
  hideLabelFromVision,
  options,
  className
}) {
  const {
    value: relValue = '',
    unit = options[0].value
  } = value;
  const onChangeValue = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: {
      value: Number(newValue),
      unit
    }
  }), [id, onChange, unit]);
  const onChangeUnit = (0,external_wp_element_namespaceObject.useCallback)(newUnit => onChange({
    [id]: {
      value: relValue,
      unit: newUnit
    }
  }), [id, onChange, relValue]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl, {
    id: id,
    __nextHasNoMarginBottom: true,
    className: dist_clsx(className, 'dataviews-controls__relative-date'),
    label: label,
    hideLabelFromVision: hideLabelFromVision,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      spacing: 2.5,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
        __next40pxDefaultSize: true,
        className: "dataviews-controls__relative-date-number",
        spinControls: "none",
        min: 1,
        step: 1,
        value: relValue,
        onChange: onChangeValue
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SelectControl, {
        className: "dataviews-controls__relative-date-unit",
        __next40pxDefaultSize: true,
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)('Unit'),
        value: unit,
        options: options,
        onChange: onChangeUnit,
        hideLabelFromVision: true
      })]
    })
  });
}

;// ./packages/dataviews/build-module/dataform-controls/datetime.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function DateTime({
  data,
  field,
  onChange,
  hideLabelFromVision,
  operator
}) {
  const {
    id,
    label
  } = field;
  const value = field.getValue({
    item: data
  });
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  if (operator === OPERATOR_IN_THE_PAST || operator === OPERATOR_OVER) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(RelativeDateControl, {
      id: id,
      value: value && typeof value === 'object' ? value : {},
      onChange: onChange,
      label: label,
      hideLabelFromVision: hideLabelFromVision,
      options: TIME_UNITS_OPTIONS[operator]
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "dataviews-controls__datetime",
    children: [!hideLabelFromVision && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
      as: "legend",
      children: label
    }), hideLabelFromVision && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, {
      as: "legend",
      children: label
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TimePicker, {
      currentTime: typeof value === 'string' ? value : undefined,
      onChange: onChangeControl,
      hideLabelFromVision: true
    })]
  });
}

;// ./packages/dataviews/node_modules/date-fns/constants.js
/**
 * @module constants
 * @summary Useful constants
 * @description
 * Collection of useful date constants.
 *
 * The constants could be imported from `date-fns/constants`:
 *
 * ```ts
 * import { maxTime, minTime } from "./constants/date-fns/constants";
 *
 * function isAllowedTime(time) {
 *   return time <= maxTime && time >= minTime;
 * }
 * ```
 */

/**
 * @constant
 * @name daysInWeek
 * @summary Days in 1 week.
 */
const daysInWeek = 7;

/**
 * @constant
 * @name daysInYear
 * @summary Days in 1 year.
 *
 * @description
 * How many days in a year.
 *
 * One years equals 365.2425 days according to the formula:
 *
 * > Leap year occurs every 4 years, except for years that are divisible by 100 and not divisible by 400.
 * > 1 mean year = (365+1/4-1/100+1/400) days = 365.2425 days
 */
const daysInYear = 365.2425;

/**
 * @constant
 * @name maxTime
 * @summary Maximum allowed time.
 *
 * @example
 * import { maxTime } from "./constants/date-fns/constants";
 *
 * const isValid = 8640000000000001 <= maxTime;
 * //=> false
 *
 * new Date(8640000000000001);
 * //=> Invalid Date
 */
const maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1000;

/**
 * @constant
 * @name minTime
 * @summary Minimum allowed time.
 *
 * @example
 * import { minTime } from "./constants/date-fns/constants";
 *
 * const isValid = -8640000000000001 >= minTime;
 * //=> false
 *
 * new Date(-8640000000000001)
 * //=> Invalid Date
 */
const minTime = -maxTime;

/**
 * @constant
 * @name millisecondsInWeek
 * @summary Milliseconds in 1 week.
 */
const millisecondsInWeek = 604800000;

/**
 * @constant
 * @name millisecondsInDay
 * @summary Milliseconds in 1 day.
 */
const millisecondsInDay = 86400000;

/**
 * @constant
 * @name millisecondsInMinute
 * @summary Milliseconds in 1 minute
 */
const millisecondsInMinute = 60000;

/**
 * @constant
 * @name millisecondsInHour
 * @summary Milliseconds in 1 hour
 */
const millisecondsInHour = 3600000;

/**
 * @constant
 * @name millisecondsInSecond
 * @summary Milliseconds in 1 second
 */
const millisecondsInSecond = 1000;

/**
 * @constant
 * @name minutesInYear
 * @summary Minutes in 1 year.
 */
const minutesInYear = 525600;

/**
 * @constant
 * @name minutesInMonth
 * @summary Minutes in 1 month.
 */
const minutesInMonth = 43200;

/**
 * @constant
 * @name minutesInDay
 * @summary Minutes in 1 day.
 */
const minutesInDay = 1440;

/**
 * @constant
 * @name minutesInHour
 * @summary Minutes in 1 hour.
 */
const minutesInHour = 60;

/**
 * @constant
 * @name monthsInQuarter
 * @summary Months in 1 quarter.
 */
const monthsInQuarter = 3;

/**
 * @constant
 * @name monthsInYear
 * @summary Months in 1 year.
 */
const monthsInYear = 12;

/**
 * @constant
 * @name quartersInYear
 * @summary Quarters in 1 year
 */
const quartersInYear = 4;

/**
 * @constant
 * @name secondsInHour
 * @summary Seconds in 1 hour.
 */
const secondsInHour = 3600;

/**
 * @constant
 * @name secondsInMinute
 * @summary Seconds in 1 minute.
 */
const secondsInMinute = 60;

/**
 * @constant
 * @name secondsInDay
 * @summary Seconds in 1 day.
 */
const secondsInDay = secondsInHour * 24;

/**
 * @constant
 * @name secondsInWeek
 * @summary Seconds in 1 week.
 */
const secondsInWeek = secondsInDay * 7;

/**
 * @constant
 * @name secondsInYear
 * @summary Seconds in 1 year.
 */
const secondsInYear = secondsInDay * daysInYear;

/**
 * @constant
 * @name secondsInMonth
 * @summary Seconds in 1 month
 */
const secondsInMonth = secondsInYear / 12;

/**
 * @constant
 * @name secondsInQuarter
 * @summary Seconds in 1 quarter.
 */
const secondsInQuarter = secondsInMonth * 3;

/**
 * @constant
 * @name constructFromSymbol
 * @summary Symbol enabling Date extensions to inherit properties from the reference date.
 *
 * The symbol is used to enable the `constructFrom` function to construct a date
 * using a reference date and a value. It allows to transfer extra properties
 * from the reference date to the new date. It's useful for extensions like
 * [`TZDate`](https://github.com/date-fns/tz) that accept a time zone as
 * a constructor argument.
 */
const constructFromSymbol = Symbol.for("constructDateFrom");

;// ./packages/dataviews/node_modules/date-fns/constructFrom.js


/**
 * @name constructFrom
 * @category Generic Helpers
 * @summary Constructs a date using the reference date and the value
 *
 * @description
 * The function constructs a new date using the constructor from the reference
 * date and the given value. It helps to build generic functions that accept
 * date extensions.
 *
 * It defaults to `Date` if the passed reference date is a number or a string.
 *
 * Starting from v3.7.0, it allows to construct a date using `[Symbol.for("constructDateFrom")]`
 * enabling to transfer extra properties from the reference date to the new date.
 * It's useful for extensions like [`TZDate`](https://github.com/date-fns/tz)
 * that accept a time zone as a constructor argument.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 *
 * @param date - The reference date to take constructor from
 * @param value - The value to create the date
 *
 * @returns Date initialized using the given date and value
 *
 * @example
 * import { constructFrom } from "./constructFrom/date-fns";
 *
 * // A function that clones a date preserving the original type
 * function cloneDate<DateType extends Date>(date: DateType): DateType {
 *   return constructFrom(
 *     date, // Use constructor from the given date
 *     date.getTime() // Use the date value to create a new date
 *   );
 * }
 */
function constructFrom(date, value) {
  if (typeof date === "function") return date(value);

  if (date && typeof date === "object" && constructFromSymbol in date)
    return date[constructFromSymbol](value);

  if (date instanceof Date) return new date.constructor(value);

  return new Date(value);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_constructFrom = ((/* unused pure expression or super */ null && (constructFrom)));

;// ./packages/dataviews/node_modules/date-fns/toDate.js


/**
 * @name toDate
 * @category Common Helpers
 * @summary Convert the given argument to an instance of Date.
 *
 * @description
 * Convert the given argument to an instance of Date.
 *
 * If the argument is an instance of Date, the function returns its clone.
 *
 * If the argument is a number, it is treated as a timestamp.
 *
 * If the argument is none of the above, the function returns Invalid Date.
 *
 * Starting from v3.7.0, it clones a date using `[Symbol.for("constructDateFrom")]`
 * enabling to transfer extra properties from the reference date to the new date.
 * It's useful for extensions like [`TZDate`](https://github.com/date-fns/tz)
 * that accept a time zone as a constructor argument.
 *
 * **Note**: *all* Date arguments passed to any *date-fns* function is processed by `toDate`.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param argument - The value to convert
 *
 * @returns The parsed date in the local time zone
 *
 * @example
 * // Clone the date:
 * const result = toDate(new Date(2014, 1, 11, 11, 30, 30))
 * //=> Tue Feb 11 2014 11:30:30
 *
 * @example
 * // Convert the timestamp to date:
 * const result = toDate(1392098430000)
 * //=> Tue Feb 11 2014 11:30:30
 */
function toDate(argument, context) {
  // [TODO] Get rid of `toDate` or `constructFrom`?
  return constructFrom(context || argument, argument);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_toDate = ((/* unused pure expression or super */ null && (toDate)));

;// ./packages/dataviews/node_modules/date-fns/addDays.js



/**
 * The {@link addDays} function options.
 */

/**
 * @name addDays
 * @category Day Helpers
 * @summary Add the specified number of days to the given date.
 *
 * @description
 * Add the specified number of days to the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The date to be changed
 * @param amount - The amount of days to be added.
 * @param options - An object with options
 *
 * @returns The new date with the days added
 *
 * @example
 * // Add 10 days to 1 September 2014:
 * const result = addDays(new Date(2014, 8, 1), 10)
 * //=> Thu Sep 11 2014 00:00:00
 */
function addDays(date, amount, options) {
  const _date = toDate(date, options?.in);
  if (isNaN(amount)) return constructFrom(options?.in || date, NaN);

  // If 0 days, no-op to avoid changing times in the hour before end of DST
  if (!amount) return _date;

  _date.setDate(_date.getDate() + amount);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_addDays = ((/* unused pure expression or super */ null && (addDays)));

;// ./packages/dataviews/node_modules/date-fns/subDays.js


/**
 * The {@link subDays} function options.
 */

/**
 * @name subDays
 * @category Day Helpers
 * @summary Subtract the specified number of days from the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The date to be changed
 * @param amount - The amount of days to be subtracted.
 * @param options - An object with options
 *
 * @returns The new date with the days subtracted
 *
 * @example
 * // Subtract 10 days from 1 September 2014:
 * const result = subDays(new Date(2014, 8, 1), 10)
 * //=> Fri Aug 22 2014 00:00:00
 */
function subDays(date, amount, options) {
  return addDays(date, -amount, options);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_subDays = ((/* unused pure expression or super */ null && (subDays)));

;// ./packages/dataviews/node_modules/date-fns/addMonths.js



/**
 * The {@link addMonths} function options.
 */

/**
 * @name addMonths
 * @category Month Helpers
 * @summary Add the specified number of months to the given date.
 *
 * @description
 * Add the specified number of months to the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The date to be changed
 * @param amount - The amount of months to be added.
 * @param options - The options object
 *
 * @returns The new date with the months added
 *
 * @example
 * // Add 5 months to 1 September 2014:
 * const result = addMonths(new Date(2014, 8, 1), 5)
 * //=> Sun Feb 01 2015 00:00:00
 *
 * // Add one month to 30 January 2023:
 * const result = addMonths(new Date(2023, 0, 30), 1)
 * //=> Tue Feb 28 2023 00:00:00
 */
function addMonths(date, amount, options) {
  const _date = toDate(date, options?.in);
  if (isNaN(amount)) return constructFrom(options?.in || date, NaN);
  if (!amount) {
    // If 0 months, no-op to avoid changing times in the hour before end of DST
    return _date;
  }
  const dayOfMonth = _date.getDate();

  // The JS Date object supports date math by accepting out-of-bounds values for
  // month, day, etc. For example, new Date(2020, 0, 0) returns 31 Dec 2019 and
  // new Date(2020, 13, 1) returns 1 Feb 2021.  This is *almost* the behavior we
  // want except that dates will wrap around the end of a month, meaning that
  // new Date(2020, 13, 31) will return 3 Mar 2021 not 28 Feb 2021 as desired. So
  // we'll default to the end of the desired month by adding 1 to the desired
  // month and using a date of 0 to back up one day to the end of the desired
  // month.
  const endOfDesiredMonth = constructFrom(options?.in || date, _date.getTime());
  endOfDesiredMonth.setMonth(_date.getMonth() + amount + 1, 0);
  const daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    // If we're already at the end of the month, then this is the correct date
    // and we're done.
    return endOfDesiredMonth;
  } else {
    // Otherwise, we now know that setting the original day-of-month value won't
    // cause an overflow, so set the desired day-of-month. Note that we can't
    // just set the date of `endOfDesiredMonth` because that object may have had
    // its time changed in the unusual case where where a DST transition was on
    // the last day of the month and its local time was in the hour skipped or
    // repeated next to a DST transition.  So we use `date` instead which is
    // guaranteed to still have the original time.
    _date.setFullYear(
      endOfDesiredMonth.getFullYear(),
      endOfDesiredMonth.getMonth(),
      dayOfMonth,
    );
    return _date;
  }
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_addMonths = ((/* unused pure expression or super */ null && (addMonths)));

;// ./packages/dataviews/node_modules/date-fns/subMonths.js


/**
 * The subMonths function options.
 */

/**
 * @name subMonths
 * @category Month Helpers
 * @summary Subtract the specified number of months from the given date.
 *
 * @description
 * Subtract the specified number of months from the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The date to be changed
 * @param amount - The amount of months to be subtracted.
 * @param options - An object with options
 *
 * @returns The new date with the months subtracted
 *
 * @example
 * // Subtract 5 months from 1 February 2015:
 * const result = subMonths(new Date(2015, 1, 1), 5)
 * //=> Mon Sep 01 2014 00:00:00
 */
function subMonths(date, amount, options) {
  return addMonths(date, -amount, options);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_subMonths = ((/* unused pure expression or super */ null && (subMonths)));

;// ./packages/dataviews/node_modules/date-fns/startOfMonth.js


/**
 * The {@link startOfMonth} function options.
 */

/**
 * @name startOfMonth
 * @category Month Helpers
 * @summary Return the start of a month for the given date.
 *
 * @description
 * Return the start of a month for the given date. The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments.
 * Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed,
 * or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The start of a month
 *
 * @example
 * // The start of a month for 2 September 2014 11:55:00:
 * const result = startOfMonth(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Mon Sep 01 2014 00:00:00
 */
function startOfMonth(date, options) {
  const _date = toDate(date, options?.in);
  _date.setDate(1);
  _date.setHours(0, 0, 0, 0);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfMonth = ((/* unused pure expression or super */ null && (startOfMonth)));

;// ./packages/dataviews/node_modules/date-fns/addYears.js


/**
 * The {@link addYears} function options.
 */

/**
 * @name addYears
 * @category Year Helpers
 * @summary Add the specified number of years to the given date.
 *
 * @description
 * Add the specified number of years to the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type.
 *
 * @param date - The date to be changed
 * @param amount - The amount of years to be added.
 * @param options - The options
 *
 * @returns The new date with the years added
 *
 * @example
 * // Add 5 years to 1 September 2014:
 * const result = addYears(new Date(2014, 8, 1), 5)
 * //=> Sun Sep 01 2019 00:00:00
 */
function addYears(date, amount, options) {
  return addMonths(date, amount * 12, options);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_addYears = ((/* unused pure expression or super */ null && (addYears)));

;// ./packages/dataviews/node_modules/date-fns/subYears.js


/**
 * The {@link subYears} function options.
 */

/**
 * @name subYears
 * @category Year Helpers
 * @summary Subtract the specified number of years from the given date.
 *
 * @description
 * Subtract the specified number of years from the given date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The date to be changed
 * @param amount - The amount of years to be subtracted.
 * @param options - An object with options
 *
 * @returns The new date with the years subtracted
 *
 * @example
 * // Subtract 5 years from 1 September 2014:
 * const result = subYears(new Date(2014, 8, 1), 5)
 * //=> Tue Sep 01 2009 00:00:00
 */
function subYears(date, amount, options) {
  return addYears(date, -amount, options);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_subYears = ((/* unused pure expression or super */ null && (subYears)));

;// ./packages/dataviews/node_modules/date-fns/startOfYear.js


/**
 * The {@link startOfYear} function options.
 */

/**
 * @name startOfYear
 * @category Year Helpers
 * @summary Return the start of a year for the given date.
 *
 * @description
 * Return the start of a year for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - The options
 *
 * @returns The start of a year
 *
 * @example
 * // The start of a year for 2 September 2014 11:55:00:
 * const result = startOfYear(new Date(2014, 8, 2, 11, 55, 00))
 * //=> Wed Jan 01 2014 00:00:00
 */
function startOfYear(date, options) {
  const date_ = toDate(date, options?.in);
  date_.setFullYear(date_.getFullYear(), 0, 1);
  date_.setHours(0, 0, 0, 0);
  return date_;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfYear = ((/* unused pure expression or super */ null && (startOfYear)));

;// ./packages/dataviews/node_modules/date-fns/isDate.js
/**
 * @name isDate
 * @category Common Helpers
 * @summary Is the given value a date?
 *
 * @description
 * Returns true if the given value is an instance of Date. The function works for dates transferred across iframes.
 *
 * @param value - The value to check
 *
 * @returns True if the given value is a date
 *
 * @example
 * // For a valid date:
 * const result = isDate(new Date())
 * //=> true
 *
 * @example
 * // For an invalid date:
 * const result = isDate(new Date(NaN))
 * //=> true
 *
 * @example
 * // For some value:
 * const result = isDate('2014-02-31')
 * //=> false
 *
 * @example
 * // For an object:
 * const result = isDate({})
 * //=> false
 */
function isDate(value) {
  return (
    value instanceof Date ||
    (typeof value === "object" &&
      Object.prototype.toString.call(value) === "[object Date]")
  );
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_isDate = ((/* unused pure expression or super */ null && (isDate)));

;// ./packages/dataviews/node_modules/date-fns/isValid.js



/**
 * @name isValid
 * @category Common Helpers
 * @summary Is the given date valid?
 *
 * @description
 * Returns false if argument is Invalid Date and true otherwise.
 * Argument is converted to Date using `toDate`. See [toDate](https://date-fns.org/docs/toDate)
 * Invalid Date is a Date, whose time value is NaN.
 *
 * Time value of Date: http://es5.github.io/#x15.9.1.1
 *
 * @param date - The date to check
 *
 * @returns The date is valid
 *
 * @example
 * // For the valid date:
 * const result = isValid(new Date(2014, 1, 31))
 * //=> true
 *
 * @example
 * // For the value, convertible into a date:
 * const result = isValid(1393804800000)
 * //=> true
 *
 * @example
 * // For the invalid date:
 * const result = isValid(new Date(''))
 * //=> false
 */
function isValid(date) {
  return !((!isDate(date) && typeof date !== "number") || isNaN(+toDate(date)));
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_isValid = ((/* unused pure expression or super */ null && (isValid)));

;// ./packages/dataviews/node_modules/date-fns/locale/en-US/_lib/formatDistance.js
const formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds",
  },

  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds",
  },

  halfAMinute: "half a minute",

  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes",
  },

  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes",
  },

  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours",
  },

  xHours: {
    one: "1 hour",
    other: "{{count}} hours",
  },

  xDays: {
    one: "1 day",
    other: "{{count}} days",
  },

  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks",
  },

  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks",
  },

  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months",
  },

  xMonths: {
    one: "1 month",
    other: "{{count}} months",
  },

  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years",
  },

  xYears: {
    one: "1 year",
    other: "{{count}} years",
  },

  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years",
  },

  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years",
  },
};

const formatDistance = (token, count, options) => {
  let result;

  const tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }

  if (options?.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }

  return result;
};

;// ./packages/dataviews/node_modules/date-fns/locale/_lib/buildFormatLongFn.js
function buildFormatLongFn(args) {
  return (options = {}) => {
    // TODO: Remove String()
    const width = options.width ? String(options.width) : args.defaultWidth;
    const format = args.formats[width] || args.formats[args.defaultWidth];
    return format;
  };
}

;// ./packages/dataviews/node_modules/date-fns/locale/en-US/_lib/formatLong.js


const dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy",
};

const timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a",
};

const dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}",
};

const formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full",
  }),

  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full",
  }),

  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full",
  }),
};

;// ./packages/dataviews/node_modules/date-fns/locale/en-US/_lib/formatRelative.js
const formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P",
};

const formatRelative = (token, _date, _baseDate, _options) =>
  formatRelativeLocale[token];

;// ./packages/dataviews/node_modules/date-fns/locale/_lib/buildLocalizeFn.js
/**
 * The localize function argument callback which allows to convert raw value to
 * the actual type.
 *
 * @param value - The value to convert
 *
 * @returns The converted value
 */

/**
 * The map of localized values for each width.
 */

/**
 * The index type of the locale unit value. It types conversion of units of
 * values that don't start at 0 (i.e. quarters).
 */

/**
 * Converts the unit value to the tuple of values.
 */

/**
 * The tuple of localized era values. The first element represents BC,
 * the second element represents AD.
 */

/**
 * The tuple of localized quarter values. The first element represents Q1.
 */

/**
 * The tuple of localized day values. The first element represents Sunday.
 */

/**
 * The tuple of localized month values. The first element represents January.
 */

function buildLocalizeFn(args) {
  return (value, options) => {
    const context = options?.context ? String(options.context) : "standalone";

    let valuesArray;
    if (context === "formatting" && args.formattingValues) {
      const defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      const width = options?.width ? String(options.width) : defaultWidth;

      valuesArray =
        args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      const defaultWidth = args.defaultWidth;
      const width = options?.width ? String(options.width) : args.defaultWidth;

      valuesArray = args.values[width] || args.values[defaultWidth];
    }
    const index = args.argumentCallback ? args.argumentCallback(value) : value;

    // @ts-expect-error - For some reason TypeScript just don't want to match it, no matter how hard we try. I challenge you to try to remove it!
    return valuesArray[index];
  };
}

;// ./packages/dataviews/node_modules/date-fns/locale/en-US/_lib/localize.js


const eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"],
};

const quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"],
};

// Note: in English, the names of days of the week and months are capitalized.
// If you are making a new locale based on this one, check if the same is true for the language you're working on.
// Generally, formatted dates should look like they are in the middle of a sentence,
// e.g. in Spanish language the weekdays and months should be in the lowercase.
const monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
  ],

  wide: [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
  ],
};

const dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
  ],
};

const dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night",
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night",
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night",
  },
};

const formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night",
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night",
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night",
  },
};

const ordinalNumber = (dirtyNumber, _options) => {
  const number = Number(dirtyNumber);

  // If ordinal numbers depend on context, for example,
  // if they are different for different grammatical genders,
  // use `options.unit`.
  //
  // `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
  // 'day', 'hour', 'minute', 'second'.

  const rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};

const localize = {
  ordinalNumber,

  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide",
  }),

  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: (quarter) => quarter - 1,
  }),

  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide",
  }),

  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide",
  }),

  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide",
  }),
};

;// ./packages/dataviews/node_modules/date-fns/locale/_lib/buildMatchFn.js
function buildMatchFn(args) {
  return (string, options = {}) => {
    const width = options.width;

    const matchPattern =
      (width && args.matchPatterns[width]) ||
      args.matchPatterns[args.defaultMatchWidth];
    const matchResult = string.match(matchPattern);

    if (!matchResult) {
      return null;
    }
    const matchedString = matchResult[0];

    const parsePatterns =
      (width && args.parsePatterns[width]) ||
      args.parsePatterns[args.defaultParseWidth];

    const key = Array.isArray(parsePatterns)
      ? findIndex(parsePatterns, (pattern) => pattern.test(matchedString))
      : // [TODO] -- I challenge you to fix the type
        findKey(parsePatterns, (pattern) => pattern.test(matchedString));

    let value;

    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback
      ? // [TODO] -- I challenge you to fix the type
        options.valueCallback(value)
      : value;

    const rest = string.slice(matchedString.length);

    return { value, rest };
  };
}

function findKey(object, predicate) {
  for (const key in object) {
    if (
      Object.prototype.hasOwnProperty.call(object, key) &&
      predicate(object[key])
    ) {
      return key;
    }
  }
  return undefined;
}

function findIndex(array, predicate) {
  for (let key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return undefined;
}

;// ./packages/dataviews/node_modules/date-fns/locale/_lib/buildMatchPatternFn.js
function buildMatchPatternFn(args) {
  return (string, options = {}) => {
    const matchResult = string.match(args.matchPattern);
    if (!matchResult) return null;
    const matchedString = matchResult[0];

    const parseResult = string.match(args.parsePattern);
    if (!parseResult) return null;
    let value = args.valueCallback
      ? args.valueCallback(parseResult[0])
      : parseResult[0];

    // [TODO] I challenge you to fix the type
    value = options.valueCallback ? options.valueCallback(value) : value;

    const rest = string.slice(matchedString.length);

    return { value, rest };
  };
}

;// ./packages/dataviews/node_modules/date-fns/locale/en-US/_lib/match.js



const matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
const parseOrdinalNumberPattern = /\d+/i;

const matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i,
};
const parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i],
};

const matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i,
};
const parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i],
};

const matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i,
};
const parseMonthPatterns = {
  narrow: [
    /^j/i,
    /^f/i,
    /^m/i,
    /^a/i,
    /^m/i,
    /^j/i,
    /^j/i,
    /^a/i,
    /^s/i,
    /^o/i,
    /^n/i,
    /^d/i,
  ],

  any: [
    /^ja/i,
    /^f/i,
    /^mar/i,
    /^ap/i,
    /^may/i,
    /^jun/i,
    /^jul/i,
    /^au/i,
    /^s/i,
    /^o/i,
    /^n/i,
    /^d/i,
  ],
};

const matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i,
};
const parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i],
};

const matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i,
};
const parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i,
  },
};

const match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: (value) => parseInt(value, 10),
  }),

  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any",
  }),

  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: (index) => index + 1,
  }),

  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any",
  }),

  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any",
  }),

  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any",
  }),
};

;// ./packages/dataviews/node_modules/date-fns/locale/en-US.js






/**
 * @category Locales
 * @summary English locale (United States).
 * @language English
 * @iso-639-2 eng
 * @author Sasha Koss [@kossnocorp](https://github.com/kossnocorp)
 * @author Lesha Koss [@leshakoss](https://github.com/leshakoss)
 */
const enUS = {
  code: "en-US",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 0 /* Sunday */,
    firstWeekContainsDate: 1,
  },
};

// Fallback for modularized imports:
/* harmony default export */ const en_US = ((/* unused pure expression or super */ null && (enUS)));

;// ./packages/dataviews/node_modules/date-fns/_lib/defaultOptions.js
let defaultOptions = {};

function getDefaultOptions() {
  return defaultOptions;
}

function setDefaultOptions(newOptions) {
  defaultOptions = newOptions;
}

;// ./packages/dataviews/node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds.js


/**
 * Google Chrome as of 67.0.3396.87 introduced timezones with offset that includes seconds.
 * They usually appear for dates that denote time before the timezones were introduced
 * (e.g. for 'Europe/Prague' timezone the offset is GMT+00:57:44 before 1 October 1891
 * and GMT+01:00:00 after that date)
 *
 * Date#getTimezoneOffset returns the offset in minutes and would return 57 for the example above,
 * which would lead to incorrect calculations.
 *
 * This function returns the timezone offset in milliseconds that takes seconds in account.
 */
function getTimezoneOffsetInMilliseconds(date) {
  const _date = toDate(date);
  const utcDate = new Date(
    Date.UTC(
      _date.getFullYear(),
      _date.getMonth(),
      _date.getDate(),
      _date.getHours(),
      _date.getMinutes(),
      _date.getSeconds(),
      _date.getMilliseconds(),
    ),
  );
  utcDate.setUTCFullYear(_date.getFullYear());
  return +date - +utcDate;
}

;// ./packages/dataviews/node_modules/date-fns/_lib/normalizeDates.js


function normalizeDates(context, ...dates) {
  const normalize = constructFrom.bind(
    null,
    context || dates.find((date) => typeof date === "object"),
  );
  return dates.map(normalize);
}

;// ./packages/dataviews/node_modules/date-fns/startOfDay.js


/**
 * The {@link startOfDay} function options.
 */

/**
 * @name startOfDay
 * @category Day Helpers
 * @summary Return the start of a day for the given date.
 *
 * @description
 * Return the start of a day for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - The options
 *
 * @returns The start of a day
 *
 * @example
 * // The start of a day for 2 September 2014 11:55:00:
 * const result = startOfDay(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Tue Sep 02 2014 00:00:00
 */
function startOfDay(date, options) {
  const _date = toDate(date, options?.in);
  _date.setHours(0, 0, 0, 0);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfDay = ((/* unused pure expression or super */ null && (startOfDay)));

;// ./packages/dataviews/node_modules/date-fns/differenceInCalendarDays.js





/**
 * The {@link differenceInCalendarDays} function options.
 */

/**
 * @name differenceInCalendarDays
 * @category Day Helpers
 * @summary Get the number of calendar days between the given dates.
 *
 * @description
 * Get the number of calendar days between the given dates. This means that the times are removed
 * from the dates and then the difference in days is calculated.
 *
 * @param laterDate - The later date
 * @param earlierDate - The earlier date
 * @param options - The options object
 *
 * @returns The number of calendar days
 *
 * @example
 * // How many calendar days are between
 * // 2 July 2011 23:00:00 and 2 July 2012 00:00:00?
 * const result = differenceInCalendarDays(
 *   new Date(2012, 6, 2, 0, 0),
 *   new Date(2011, 6, 2, 23, 0)
 * )
 * //=> 366
 * // How many calendar days are between
 * // 2 July 2011 23:59:00 and 3 July 2011 00:01:00?
 * const result = differenceInCalendarDays(
 *   new Date(2011, 6, 3, 0, 1),
 *   new Date(2011, 6, 2, 23, 59)
 * )
 * //=> 1
 */
function differenceInCalendarDays(laterDate, earlierDate, options) {
  const [laterDate_, earlierDate_] = normalizeDates(
    options?.in,
    laterDate,
    earlierDate,
  );

  const laterStartOfDay = startOfDay(laterDate_);
  const earlierStartOfDay = startOfDay(earlierDate_);

  const laterTimestamp =
    +laterStartOfDay - getTimezoneOffsetInMilliseconds(laterStartOfDay);
  const earlierTimestamp =
    +earlierStartOfDay - getTimezoneOffsetInMilliseconds(earlierStartOfDay);

  // Round the number of days to the nearest integer because the number of
  // milliseconds in a day is not constant (e.g. it's different in the week of
  // the daylight saving time clock shift).
  return Math.round((laterTimestamp - earlierTimestamp) / millisecondsInDay);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_differenceInCalendarDays = ((/* unused pure expression or super */ null && (differenceInCalendarDays)));

;// ./packages/dataviews/node_modules/date-fns/getDayOfYear.js




/**
 * The {@link getDayOfYear} function options.
 */

/**
 * @name getDayOfYear
 * @category Day Helpers
 * @summary Get the day of the year of the given date.
 *
 * @description
 * Get the day of the year of the given date.
 *
 * @param date - The given date
 * @param options - The options
 *
 * @returns The day of year
 *
 * @example
 * // Which day of the year is 2 July 2014?
 * const result = getDayOfYear(new Date(2014, 6, 2))
 * //=> 183
 */
function getDayOfYear(date, options) {
  const _date = toDate(date, options?.in);
  const diff = differenceInCalendarDays(_date, startOfYear(_date));
  const dayOfYear = diff + 1;
  return dayOfYear;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_getDayOfYear = ((/* unused pure expression or super */ null && (getDayOfYear)));

;// ./packages/dataviews/node_modules/date-fns/startOfWeek.js



/**
 * The {@link startOfWeek} function options.
 */

/**
 * @name startOfWeek
 * @category Week Helpers
 * @summary Return the start of a week for the given date.
 *
 * @description
 * Return the start of a week for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The start of a week
 *
 * @example
 * // The start of a week for 2 September 2014 11:55:00:
 * const result = startOfWeek(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Sun Aug 31 2014 00:00:00
 *
 * @example
 * // If the week starts on Monday, the start of the week for 2 September 2014 11:55:00:
 * const result = startOfWeek(new Date(2014, 8, 2, 11, 55, 0), { weekStartsOn: 1 })
 * //=> Mon Sep 01 2014 00:00:00
 */
function startOfWeek(date, options) {
  const defaultOptions = getDefaultOptions();
  const weekStartsOn =
    options?.weekStartsOn ??
    options?.locale?.options?.weekStartsOn ??
    defaultOptions.weekStartsOn ??
    defaultOptions.locale?.options?.weekStartsOn ??
    0;

  const _date = toDate(date, options?.in);
  const day = _date.getDay();
  const diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;

  _date.setDate(_date.getDate() - diff);
  _date.setHours(0, 0, 0, 0);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfWeek = ((/* unused pure expression or super */ null && (startOfWeek)));

;// ./packages/dataviews/node_modules/date-fns/startOfISOWeek.js


/**
 * The {@link startOfISOWeek} function options.
 */

/**
 * @name startOfISOWeek
 * @category ISO Week Helpers
 * @summary Return the start of an ISO week for the given date.
 *
 * @description
 * Return the start of an ISO week for the given date.
 * The result will be in the local timezone.
 *
 * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The start of an ISO week
 *
 * @example
 * // The start of an ISO week for 2 September 2014 11:55:00:
 * const result = startOfISOWeek(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Mon Sep 01 2014 00:00:00
 */
function startOfISOWeek(date, options) {
  return startOfWeek(date, { ...options, weekStartsOn: 1 });
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfISOWeek = ((/* unused pure expression or super */ null && (startOfISOWeek)));

;// ./packages/dataviews/node_modules/date-fns/getISOWeekYear.js




/**
 * The {@link getISOWeekYear} function options.
 */

/**
 * @name getISOWeekYear
 * @category ISO Week-Numbering Year Helpers
 * @summary Get the ISO week-numbering year of the given date.
 *
 * @description
 * Get the ISO week-numbering year of the given date,
 * which always starts 3 days before the year's first Thursday.
 *
 * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
 *
 * @param date - The given date
 *
 * @returns The ISO week-numbering year
 *
 * @example
 * // Which ISO-week numbering year is 2 January 2005?
 * const result = getISOWeekYear(new Date(2005, 0, 2))
 * //=> 2004
 */
function getISOWeekYear(date, options) {
  const _date = toDate(date, options?.in);
  const year = _date.getFullYear();

  const fourthOfJanuaryOfNextYear = constructFrom(_date, 0);
  fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
  const startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);

  const fourthOfJanuaryOfThisYear = constructFrom(_date, 0);
  fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
  const startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);

  if (_date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (_date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_getISOWeekYear = ((/* unused pure expression or super */ null && (getISOWeekYear)));

;// ./packages/dataviews/node_modules/date-fns/startOfISOWeekYear.js




/**
 * The {@link startOfISOWeekYear} function options.
 */

/**
 * @name startOfISOWeekYear
 * @category ISO Week-Numbering Year Helpers
 * @summary Return the start of an ISO week-numbering year for the given date.
 *
 * @description
 * Return the start of an ISO week-numbering year,
 * which always starts 3 days before the year's first Thursday.
 * The result will be in the local timezone.
 *
 * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The start of an ISO week-numbering year
 *
 * @example
 * // The start of an ISO week-numbering year for 2 July 2005:
 * const result = startOfISOWeekYear(new Date(2005, 6, 2))
 * //=> Mon Jan 03 2005 00:00:00
 */
function startOfISOWeekYear(date, options) {
  const year = getISOWeekYear(date, options);
  const fourthOfJanuary = constructFrom(options?.in || date, 0);
  fourthOfJanuary.setFullYear(year, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  return startOfISOWeek(fourthOfJanuary);
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfISOWeekYear = ((/* unused pure expression or super */ null && (startOfISOWeekYear)));

;// ./packages/dataviews/node_modules/date-fns/getISOWeek.js





/**
 * The {@link getISOWeek} function options.
 */

/**
 * @name getISOWeek
 * @category ISO Week Helpers
 * @summary Get the ISO week of the given date.
 *
 * @description
 * Get the ISO week of the given date.
 *
 * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
 *
 * @param date - The given date
 * @param options - The options
 *
 * @returns The ISO week
 *
 * @example
 * // Which week of the ISO-week numbering year is 2 January 2005?
 * const result = getISOWeek(new Date(2005, 0, 2))
 * //=> 53
 */
function getISOWeek(date, options) {
  const _date = toDate(date, options?.in);
  const diff = +startOfISOWeek(_date) - +startOfISOWeekYear(_date);

  // Round the number of weeks to the nearest integer because the number of
  // milliseconds in a week is not constant (e.g. it's different in the week of
  // the daylight saving time clock shift).
  return Math.round(diff / millisecondsInWeek) + 1;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_getISOWeek = ((/* unused pure expression or super */ null && (getISOWeek)));

;// ./packages/dataviews/node_modules/date-fns/getWeekYear.js





/**
 * The {@link getWeekYear} function options.
 */

/**
 * @name getWeekYear
 * @category Week-Numbering Year Helpers
 * @summary Get the local week-numbering year of the given date.
 *
 * @description
 * Get the local week-numbering year of the given date.
 * The exact calculation depends on the values of
 * `options.weekStartsOn` (which is the index of the first day of the week)
 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
 * the first week of the week-numbering year)
 *
 * Week numbering: https://en.wikipedia.org/wiki/Week#The_ISO_week_date_system
 *
 * @param date - The given date
 * @param options - An object with options.
 *
 * @returns The local week-numbering year
 *
 * @example
 * // Which week numbering year is 26 December 2004 with the default settings?
 * const result = getWeekYear(new Date(2004, 11, 26))
 * //=> 2005
 *
 * @example
 * // Which week numbering year is 26 December 2004 if week starts on Saturday?
 * const result = getWeekYear(new Date(2004, 11, 26), { weekStartsOn: 6 })
 * //=> 2004
 *
 * @example
 * // Which week numbering year is 26 December 2004 if the first week contains 4 January?
 * const result = getWeekYear(new Date(2004, 11, 26), { firstWeekContainsDate: 4 })
 * //=> 2004
 */
function getWeekYear(date, options) {
  const _date = toDate(date, options?.in);
  const year = _date.getFullYear();

  const defaultOptions = getDefaultOptions();
  const firstWeekContainsDate =
    options?.firstWeekContainsDate ??
    options?.locale?.options?.firstWeekContainsDate ??
    defaultOptions.firstWeekContainsDate ??
    defaultOptions.locale?.options?.firstWeekContainsDate ??
    1;

  const firstWeekOfNextYear = constructFrom(options?.in || date, 0);
  firstWeekOfNextYear.setFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setHours(0, 0, 0, 0);
  const startOfNextYear = startOfWeek(firstWeekOfNextYear, options);

  const firstWeekOfThisYear = constructFrom(options?.in || date, 0);
  firstWeekOfThisYear.setFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setHours(0, 0, 0, 0);
  const startOfThisYear = startOfWeek(firstWeekOfThisYear, options);

  if (+_date >= +startOfNextYear) {
    return year + 1;
  } else if (+_date >= +startOfThisYear) {
    return year;
  } else {
    return year - 1;
  }
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_getWeekYear = ((/* unused pure expression or super */ null && (getWeekYear)));

;// ./packages/dataviews/node_modules/date-fns/startOfWeekYear.js





/**
 * The {@link startOfWeekYear} function options.
 */

/**
 * @name startOfWeekYear
 * @category Week-Numbering Year Helpers
 * @summary Return the start of a local week-numbering year for the given date.
 *
 * @description
 * Return the start of a local week-numbering year.
 * The exact calculation depends on the values of
 * `options.weekStartsOn` (which is the index of the first day of the week)
 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
 * the first week of the week-numbering year)
 *
 * Week numbering: https://en.wikipedia.org/wiki/Week#The_ISO_week_date_system
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The start of a week-numbering year
 *
 * @example
 * // The start of an a week-numbering year for 2 July 2005 with default settings:
 * const result = startOfWeekYear(new Date(2005, 6, 2))
 * //=> Sun Dec 26 2004 00:00:00
 *
 * @example
 * // The start of a week-numbering year for 2 July 2005
 * // if Monday is the first day of week
 * // and 4 January is always in the first week of the year:
 * const result = startOfWeekYear(new Date(2005, 6, 2), {
 *   weekStartsOn: 1,
 *   firstWeekContainsDate: 4
 * })
 * //=> Mon Jan 03 2005 00:00:00
 */
function startOfWeekYear(date, options) {
  const defaultOptions = getDefaultOptions();
  const firstWeekContainsDate =
    options?.firstWeekContainsDate ??
    options?.locale?.options?.firstWeekContainsDate ??
    defaultOptions.firstWeekContainsDate ??
    defaultOptions.locale?.options?.firstWeekContainsDate ??
    1;

  const year = getWeekYear(date, options);
  const firstWeek = constructFrom(options?.in || date, 0);
  firstWeek.setFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setHours(0, 0, 0, 0);
  const _date = startOfWeek(firstWeek, options);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_startOfWeekYear = ((/* unused pure expression or super */ null && (startOfWeekYear)));

;// ./packages/dataviews/node_modules/date-fns/getWeek.js





/**
 * The {@link getWeek} function options.
 */

/**
 * @name getWeek
 * @category Week Helpers
 * @summary Get the local week index of the given date.
 *
 * @description
 * Get the local week index of the given date.
 * The exact calculation depends on the values of
 * `options.weekStartsOn` (which is the index of the first day of the week)
 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
 * the first week of the week-numbering year)
 *
 * Week numbering: https://en.wikipedia.org/wiki/Week#The_ISO_week_date_system
 *
 * @param date - The given date
 * @param options - An object with options
 *
 * @returns The week
 *
 * @example
 * // Which week of the local week numbering year is 2 January 2005 with default options?
 * const result = getWeek(new Date(2005, 0, 2))
 * //=> 2
 *
 * @example
 * // Which week of the local week numbering year is 2 January 2005,
 * // if Monday is the first day of the week,
 * // and the first week of the year always contains 4 January?
 * const result = getWeek(new Date(2005, 0, 2), {
 *   weekStartsOn: 1,
 *   firstWeekContainsDate: 4
 * })
 * //=> 53
 */
function getWeek(date, options) {
  const _date = toDate(date, options?.in);
  const diff = +startOfWeek(_date, options) - +startOfWeekYear(_date, options);

  // Round the number of weeks to the nearest integer because the number of
  // milliseconds in a week is not constant (e.g. it's different in the week of
  // the daylight saving time clock shift).
  return Math.round(diff / millisecondsInWeek) + 1;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_getWeek = ((/* unused pure expression or super */ null && (getWeek)));

;// ./packages/dataviews/node_modules/date-fns/_lib/addLeadingZeros.js
function addLeadingZeros(number, targetLength) {
  const sign = number < 0 ? "-" : "";
  const output = Math.abs(number).toString().padStart(targetLength, "0");
  return sign + output;
}

;// ./packages/dataviews/node_modules/date-fns/_lib/format/lightFormatters.js


/*
 * |     | Unit                           |     | Unit                           |
 * |-----|--------------------------------|-----|--------------------------------|
 * |  a  | AM, PM                         |  A* |                                |
 * |  d  | Day of month                   |  D  |                                |
 * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
 * |  m  | Minute                         |  M  | Month                          |
 * |  s  | Second                         |  S  | Fraction of second             |
 * |  y  | Year (abs)                     |  Y  |                                |
 *
 * Letters marked by * are not implemented but reserved by Unicode standard.
 */

const lightFormatters = {
  // Year
  y(date, token) {
    // From http://www.unicode.org/reports/tr35/tr35-31/tr35-dates.html#Date_Format_tokens
    // | Year     |     y | yy |   yyy |  yyyy | yyyyy |
    // |----------|-------|----|-------|-------|-------|
    // | AD 1     |     1 | 01 |   001 |  0001 | 00001 |
    // | AD 12    |    12 | 12 |   012 |  0012 | 00012 |
    // | AD 123   |   123 | 23 |   123 |  0123 | 00123 |
    // | AD 1234  |  1234 | 34 |  1234 |  1234 | 01234 |
    // | AD 12345 | 12345 | 45 | 12345 | 12345 | 12345 |

    const signedYear = date.getFullYear();
    // Returns 1 for 1 BC (which is year 0 in JavaScript)
    const year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },

  // Month
  M(date, token) {
    const month = date.getMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },

  // Day of the month
  d(date, token) {
    return addLeadingZeros(date.getDate(), token.length);
  },

  // AM or PM
  a(date, token) {
    const dayPeriodEnumValue = date.getHours() / 12 >= 1 ? "pm" : "am";

    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },

  // Hour [1-12]
  h(date, token) {
    return addLeadingZeros(date.getHours() % 12 || 12, token.length);
  },

  // Hour [0-23]
  H(date, token) {
    return addLeadingZeros(date.getHours(), token.length);
  },

  // Minute
  m(date, token) {
    return addLeadingZeros(date.getMinutes(), token.length);
  },

  // Second
  s(date, token) {
    return addLeadingZeros(date.getSeconds(), token.length);
  },

  // Fraction of second
  S(date, token) {
    const numberOfDigits = token.length;
    const milliseconds = date.getMilliseconds();
    const fractionalSeconds = Math.trunc(
      milliseconds * Math.pow(10, numberOfDigits - 3),
    );
    return addLeadingZeros(fractionalSeconds, token.length);
  },
};

;// ./packages/dataviews/node_modules/date-fns/_lib/format/formatters.js









const dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night",
};

/*
 * |     | Unit                           |     | Unit                           |
 * |-----|--------------------------------|-----|--------------------------------|
 * |  a  | AM, PM                         |  A* | Milliseconds in day            |
 * |  b  | AM, PM, noon, midnight         |  B  | Flexible day period            |
 * |  c  | Stand-alone local day of week  |  C* | Localized hour w/ day period   |
 * |  d  | Day of month                   |  D  | Day of year                    |
 * |  e  | Local day of week              |  E  | Day of week                    |
 * |  f  |                                |  F* | Day of week in month           |
 * |  g* | Modified Julian day            |  G  | Era                            |
 * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
 * |  i! | ISO day of week                |  I! | ISO week of year               |
 * |  j* | Localized hour w/ day period   |  J* | Localized hour w/o day period  |
 * |  k  | Hour [1-24]                    |  K  | Hour [0-11]                    |
 * |  l* | (deprecated)                   |  L  | Stand-alone month              |
 * |  m  | Minute                         |  M  | Month                          |
 * |  n  |                                |  N  |                                |
 * |  o! | Ordinal number modifier        |  O  | Timezone (GMT)                 |
 * |  p! | Long localized time            |  P! | Long localized date            |
 * |  q  | Stand-alone quarter            |  Q  | Quarter                        |
 * |  r* | Related Gregorian year         |  R! | ISO week-numbering year        |
 * |  s  | Second                         |  S  | Fraction of second             |
 * |  t! | Seconds timestamp              |  T! | Milliseconds timestamp         |
 * |  u  | Extended year                  |  U* | Cyclic year                    |
 * |  v* | Timezone (generic non-locat.)  |  V* | Timezone (location)            |
 * |  w  | Local week of year             |  W* | Week of month                  |
 * |  x  | Timezone (ISO-8601 w/o Z)      |  X  | Timezone (ISO-8601)            |
 * |  y  | Year (abs)                     |  Y  | Local week-numbering year      |
 * |  z  | Timezone (specific non-locat.) |  Z* | Timezone (aliases)             |
 *
 * Letters marked by * are not implemented but reserved by Unicode standard.
 *
 * Letters marked by ! are non-standard, but implemented by date-fns:
 * - `o` modifies the previous token to turn it into an ordinal (see `format` docs)
 * - `i` is ISO day of week. For `i` and `ii` is returns numeric ISO week days,
 *   i.e. 7 for Sunday, 1 for Monday, etc.
 * - `I` is ISO week of year, as opposed to `w` which is local week of year.
 * - `R` is ISO week-numbering year, as opposed to `Y` which is local week-numbering year.
 *   `R` is supposed to be used in conjunction with `I` and `i`
 *   for universal ISO week-numbering date, whereas
 *   `Y` is supposed to be used in conjunction with `w` and `e`
 *   for week-numbering date specific to the locale.
 * - `P` is long localized date format
 * - `p` is long localized time format
 */

const formatters = {
  // Era
  G: function (date, token, localize) {
    const era = date.getFullYear() > 0 ? 1 : 0;
    switch (token) {
      // AD, BC
      case "G":
      case "GG":
      case "GGG":
        return localize.era(era, { width: "abbreviated" });
      // A, B
      case "GGGGG":
        return localize.era(era, { width: "narrow" });
      // Anno Domini, Before Christ
      case "GGGG":
      default:
        return localize.era(era, { width: "wide" });
    }
  },

  // Year
  y: function (date, token, localize) {
    // Ordinal number
    if (token === "yo") {
      const signedYear = date.getFullYear();
      // Returns 1 for 1 BC (which is year 0 in JavaScript)
      const year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize.ordinalNumber(year, { unit: "year" });
    }

    return lightFormatters.y(date, token);
  },

  // Local week-numbering year
  Y: function (date, token, localize, options) {
    const signedWeekYear = getWeekYear(date, options);
    // Returns 1 for 1 BC (which is year 0 in JavaScript)
    const weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;

    // Two digit year
    if (token === "YY") {
      const twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }

    // Ordinal number
    if (token === "Yo") {
      return localize.ordinalNumber(weekYear, { unit: "year" });
    }

    // Padding
    return addLeadingZeros(weekYear, token.length);
  },

  // ISO week-numbering year
  R: function (date, token) {
    const isoWeekYear = getISOWeekYear(date);

    // Padding
    return addLeadingZeros(isoWeekYear, token.length);
  },

  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function (date, token) {
    const year = date.getFullYear();
    return addLeadingZeros(year, token.length);
  },

  // Quarter
  Q: function (date, token, localize) {
    const quarter = Math.ceil((date.getMonth() + 1) / 3);
    switch (token) {
      // 1, 2, 3, 4
      case "Q":
        return String(quarter);
      // 01, 02, 03, 04
      case "QQ":
        return addLeadingZeros(quarter, 2);
      // 1st, 2nd, 3rd, 4th
      case "Qo":
        return localize.ordinalNumber(quarter, { unit: "quarter" });
      // Q1, Q2, Q3, Q4
      case "QQQ":
        return localize.quarter(quarter, {
          width: "abbreviated",
          context: "formatting",
        });
      // 1, 2, 3, 4 (narrow quarter; could be not numerical)
      case "QQQQQ":
        return localize.quarter(quarter, {
          width: "narrow",
          context: "formatting",
        });
      // 1st quarter, 2nd quarter, ...
      case "QQQQ":
      default:
        return localize.quarter(quarter, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // Stand-alone quarter
  q: function (date, token, localize) {
    const quarter = Math.ceil((date.getMonth() + 1) / 3);
    switch (token) {
      // 1, 2, 3, 4
      case "q":
        return String(quarter);
      // 01, 02, 03, 04
      case "qq":
        return addLeadingZeros(quarter, 2);
      // 1st, 2nd, 3rd, 4th
      case "qo":
        return localize.ordinalNumber(quarter, { unit: "quarter" });
      // Q1, Q2, Q3, Q4
      case "qqq":
        return localize.quarter(quarter, {
          width: "abbreviated",
          context: "standalone",
        });
      // 1, 2, 3, 4 (narrow quarter; could be not numerical)
      case "qqqqq":
        return localize.quarter(quarter, {
          width: "narrow",
          context: "standalone",
        });
      // 1st quarter, 2nd quarter, ...
      case "qqqq":
      default:
        return localize.quarter(quarter, {
          width: "wide",
          context: "standalone",
        });
    }
  },

  // Month
  M: function (date, token, localize) {
    const month = date.getMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters.M(date, token);
      // 1st, 2nd, ..., 12th
      case "Mo":
        return localize.ordinalNumber(month + 1, { unit: "month" });
      // Jan, Feb, ..., Dec
      case "MMM":
        return localize.month(month, {
          width: "abbreviated",
          context: "formatting",
        });
      // J, F, ..., D
      case "MMMMM":
        return localize.month(month, {
          width: "narrow",
          context: "formatting",
        });
      // January, February, ..., December
      case "MMMM":
      default:
        return localize.month(month, { width: "wide", context: "formatting" });
    }
  },

  // Stand-alone month
  L: function (date, token, localize) {
    const month = date.getMonth();
    switch (token) {
      // 1, 2, ..., 12
      case "L":
        return String(month + 1);
      // 01, 02, ..., 12
      case "LL":
        return addLeadingZeros(month + 1, 2);
      // 1st, 2nd, ..., 12th
      case "Lo":
        return localize.ordinalNumber(month + 1, { unit: "month" });
      // Jan, Feb, ..., Dec
      case "LLL":
        return localize.month(month, {
          width: "abbreviated",
          context: "standalone",
        });
      // J, F, ..., D
      case "LLLLL":
        return localize.month(month, {
          width: "narrow",
          context: "standalone",
        });
      // January, February, ..., December
      case "LLLL":
      default:
        return localize.month(month, { width: "wide", context: "standalone" });
    }
  },

  // Local week of year
  w: function (date, token, localize, options) {
    const week = getWeek(date, options);

    if (token === "wo") {
      return localize.ordinalNumber(week, { unit: "week" });
    }

    return addLeadingZeros(week, token.length);
  },

  // ISO week of year
  I: function (date, token, localize) {
    const isoWeek = getISOWeek(date);

    if (token === "Io") {
      return localize.ordinalNumber(isoWeek, { unit: "week" });
    }

    return addLeadingZeros(isoWeek, token.length);
  },

  // Day of the month
  d: function (date, token, localize) {
    if (token === "do") {
      return localize.ordinalNumber(date.getDate(), { unit: "date" });
    }

    return lightFormatters.d(date, token);
  },

  // Day of year
  D: function (date, token, localize) {
    const dayOfYear = getDayOfYear(date);

    if (token === "Do") {
      return localize.ordinalNumber(dayOfYear, { unit: "dayOfYear" });
    }

    return addLeadingZeros(dayOfYear, token.length);
  },

  // Day of week
  E: function (date, token, localize) {
    const dayOfWeek = date.getDay();
    switch (token) {
      // Tue
      case "E":
      case "EE":
      case "EEE":
        return localize.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting",
        });
      // T
      case "EEEEE":
        return localize.day(dayOfWeek, {
          width: "narrow",
          context: "formatting",
        });
      // Tu
      case "EEEEEE":
        return localize.day(dayOfWeek, {
          width: "short",
          context: "formatting",
        });
      // Tuesday
      case "EEEE":
      default:
        return localize.day(dayOfWeek, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // Local day of week
  e: function (date, token, localize, options) {
    const dayOfWeek = date.getDay();
    const localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      // Numerical value (Nth day of week with current locale or weekStartsOn)
      case "e":
        return String(localDayOfWeek);
      // Padded numerical value
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      // 1st, 2nd, ..., 7th
      case "eo":
        return localize.ordinalNumber(localDayOfWeek, { unit: "day" });
      case "eee":
        return localize.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting",
        });
      // T
      case "eeeee":
        return localize.day(dayOfWeek, {
          width: "narrow",
          context: "formatting",
        });
      // Tu
      case "eeeeee":
        return localize.day(dayOfWeek, {
          width: "short",
          context: "formatting",
        });
      // Tuesday
      case "eeee":
      default:
        return localize.day(dayOfWeek, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // Stand-alone local day of week
  c: function (date, token, localize, options) {
    const dayOfWeek = date.getDay();
    const localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      // Numerical value (same as in `e`)
      case "c":
        return String(localDayOfWeek);
      // Padded numerical value
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      // 1st, 2nd, ..., 7th
      case "co":
        return localize.ordinalNumber(localDayOfWeek, { unit: "day" });
      case "ccc":
        return localize.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone",
        });
      // T
      case "ccccc":
        return localize.day(dayOfWeek, {
          width: "narrow",
          context: "standalone",
        });
      // Tu
      case "cccccc":
        return localize.day(dayOfWeek, {
          width: "short",
          context: "standalone",
        });
      // Tuesday
      case "cccc":
      default:
        return localize.day(dayOfWeek, {
          width: "wide",
          context: "standalone",
        });
    }
  },

  // ISO day of week
  i: function (date, token, localize) {
    const dayOfWeek = date.getDay();
    const isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      // 2
      case "i":
        return String(isoDayOfWeek);
      // 02
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      // 2nd
      case "io":
        return localize.ordinalNumber(isoDayOfWeek, { unit: "day" });
      // Tue
      case "iii":
        return localize.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting",
        });
      // T
      case "iiiii":
        return localize.day(dayOfWeek, {
          width: "narrow",
          context: "formatting",
        });
      // Tu
      case "iiiiii":
        return localize.day(dayOfWeek, {
          width: "short",
          context: "formatting",
        });
      // Tuesday
      case "iiii":
      default:
        return localize.day(dayOfWeek, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // AM or PM
  a: function (date, token, localize) {
    const hours = date.getHours();
    const dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";

    switch (token) {
      case "a":
      case "aa":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting",
        });
      case "aaa":
        return localize
          .dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting",
          })
          .toLowerCase();
      case "aaaaa":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting",
        });
      case "aaaa":
      default:
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // AM, PM, midnight, noon
  b: function (date, token, localize) {
    const hours = date.getHours();
    let dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }

    switch (token) {
      case "b":
      case "bb":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting",
        });
      case "bbb":
        return localize
          .dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting",
          })
          .toLowerCase();
      case "bbbbb":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting",
        });
      case "bbbb":
      default:
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // in the morning, in the afternoon, in the evening, at night
  B: function (date, token, localize) {
    const hours = date.getHours();
    let dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }

    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting",
        });
      case "BBBBB":
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting",
        });
      case "BBBB":
      default:
        return localize.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting",
        });
    }
  },

  // Hour [1-12]
  h: function (date, token, localize) {
    if (token === "ho") {
      let hours = date.getHours() % 12;
      if (hours === 0) hours = 12;
      return localize.ordinalNumber(hours, { unit: "hour" });
    }

    return lightFormatters.h(date, token);
  },

  // Hour [0-23]
  H: function (date, token, localize) {
    if (token === "Ho") {
      return localize.ordinalNumber(date.getHours(), { unit: "hour" });
    }

    return lightFormatters.H(date, token);
  },

  // Hour [0-11]
  K: function (date, token, localize) {
    const hours = date.getHours() % 12;

    if (token === "Ko") {
      return localize.ordinalNumber(hours, { unit: "hour" });
    }

    return addLeadingZeros(hours, token.length);
  },

  // Hour [1-24]
  k: function (date, token, localize) {
    let hours = date.getHours();
    if (hours === 0) hours = 24;

    if (token === "ko") {
      return localize.ordinalNumber(hours, { unit: "hour" });
    }

    return addLeadingZeros(hours, token.length);
  },

  // Minute
  m: function (date, token, localize) {
    if (token === "mo") {
      return localize.ordinalNumber(date.getMinutes(), { unit: "minute" });
    }

    return lightFormatters.m(date, token);
  },

  // Second
  s: function (date, token, localize) {
    if (token === "so") {
      return localize.ordinalNumber(date.getSeconds(), { unit: "second" });
    }

    return lightFormatters.s(date, token);
  },

  // Fraction of second
  S: function (date, token) {
    return lightFormatters.S(date, token);
  },

  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function (date, token, _localize) {
    const timezoneOffset = date.getTimezoneOffset();

    if (timezoneOffset === 0) {
      return "Z";
    }

    switch (token) {
      // Hours and optional minutes
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);

      // Hours, minutes and optional seconds without `:` delimiter
      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
      // so this token always has the same output as `XX`
      case "XXXX":
      case "XX": // Hours and minutes without `:` delimiter
        return formatTimezone(timezoneOffset);

      // Hours, minutes and optional seconds with `:` delimiter
      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
      // so this token always has the same output as `XXX`
      case "XXXXX":
      case "XXX": // Hours and minutes with `:` delimiter
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },

  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function (date, token, _localize) {
    const timezoneOffset = date.getTimezoneOffset();

    switch (token) {
      // Hours and optional minutes
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);

      // Hours, minutes and optional seconds without `:` delimiter
      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
      // so this token always has the same output as `xx`
      case "xxxx":
      case "xx": // Hours and minutes without `:` delimiter
        return formatTimezone(timezoneOffset);

      // Hours, minutes and optional seconds with `:` delimiter
      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
      // so this token always has the same output as `xxx`
      case "xxxxx":
      case "xxx": // Hours and minutes with `:` delimiter
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },

  // Timezone (GMT)
  O: function (date, token, _localize) {
    const timezoneOffset = date.getTimezoneOffset();

    switch (token) {
      // Short
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      // Long
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },

  // Timezone (specific non-location)
  z: function (date, token, _localize) {
    const timezoneOffset = date.getTimezoneOffset();

    switch (token) {
      // Short
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      // Long
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },

  // Seconds timestamp
  t: function (date, token, _localize) {
    const timestamp = Math.trunc(+date / 1000);
    return addLeadingZeros(timestamp, token.length);
  },

  // Milliseconds timestamp
  T: function (date, token, _localize) {
    return addLeadingZeros(+date, token.length);
  },
};

function formatTimezoneShort(offset, delimiter = "") {
  const sign = offset > 0 ? "-" : "+";
  const absOffset = Math.abs(offset);
  const hours = Math.trunc(absOffset / 60);
  const minutes = absOffset % 60;
  if (minutes === 0) {
    return sign + String(hours);
  }
  return sign + String(hours) + delimiter + addLeadingZeros(minutes, 2);
}

function formatTimezoneWithOptionalMinutes(offset, delimiter) {
  if (offset % 60 === 0) {
    const sign = offset > 0 ? "-" : "+";
    return sign + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, delimiter);
}

function formatTimezone(offset, delimiter = "") {
  const sign = offset > 0 ? "-" : "+";
  const absOffset = Math.abs(offset);
  const hours = addLeadingZeros(Math.trunc(absOffset / 60), 2);
  const minutes = addLeadingZeros(absOffset % 60, 2);
  return sign + hours + delimiter + minutes;
}

;// ./packages/dataviews/node_modules/date-fns/_lib/format/longFormatters.js
const dateLongFormatter = (pattern, formatLong) => {
  switch (pattern) {
    case "P":
      return formatLong.date({ width: "short" });
    case "PP":
      return formatLong.date({ width: "medium" });
    case "PPP":
      return formatLong.date({ width: "long" });
    case "PPPP":
    default:
      return formatLong.date({ width: "full" });
  }
};

const timeLongFormatter = (pattern, formatLong) => {
  switch (pattern) {
    case "p":
      return formatLong.time({ width: "short" });
    case "pp":
      return formatLong.time({ width: "medium" });
    case "ppp":
      return formatLong.time({ width: "long" });
    case "pppp":
    default:
      return formatLong.time({ width: "full" });
  }
};

const dateTimeLongFormatter = (pattern, formatLong) => {
  const matchResult = pattern.match(/(P+)(p+)?/) || [];
  const datePattern = matchResult[1];
  const timePattern = matchResult[2];

  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong);
  }

  let dateTimeFormat;

  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong.dateTime({ width: "short" });
      break;
    case "PP":
      dateTimeFormat = formatLong.dateTime({ width: "medium" });
      break;
    case "PPP":
      dateTimeFormat = formatLong.dateTime({ width: "long" });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong.dateTime({ width: "full" });
      break;
  }

  return dateTimeFormat
    .replace("{{date}}", dateLongFormatter(datePattern, formatLong))
    .replace("{{time}}", timeLongFormatter(timePattern, formatLong));
};

const longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter,
};

;// ./packages/dataviews/node_modules/date-fns/_lib/protectedTokens.js
const dayOfYearTokenRE = /^D+$/;
const weekYearTokenRE = /^Y+$/;

const throwTokens = ["D", "DD", "YY", "YYYY"];

function isProtectedDayOfYearToken(token) {
  return dayOfYearTokenRE.test(token);
}

function isProtectedWeekYearToken(token) {
  return weekYearTokenRE.test(token);
}

function warnOrThrowProtectedError(token, format, input) {
  const _message = message(token, format, input);
  console.warn(_message);
  if (throwTokens.includes(token)) throw new RangeError(_message);
}

function message(token, format, input) {
  const subject = token[0] === "Y" ? "years" : "days of the month";
  return `Use \`${token.toLowerCase()}\` instead of \`${token}\` (in \`${format}\`) for formatting ${subject} to the input \`${input}\`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md`;
}

;// ./packages/dataviews/node_modules/date-fns/format.js








// Rexports of internal for libraries to use.
// See: https://github.com/date-fns/date-fns/issues/3638#issuecomment-1877082874


// This RegExp consists of three parts separated by `|`:
// - [yYQqMLwIdDecihHKkms]o matches any available ordinal number token
//   (one of the certain letters followed by `o`)
// - (\w)\1* matches any sequences of the same letter
// - '' matches two quote characters in a row
// - '(''|[^'])+('|$) matches anything surrounded by two quote characters ('),
//   except a single quote symbol, which ends the sequence.
//   Two quote characters do not end the sequence.
//   If there is no matching single quote
//   then the sequence will continue until the end of the string.
// - . matches any single character unmatched by previous parts of the RegExps
const formattingTokensRegExp =
  /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;

// This RegExp catches symbols escaped by quotes, and also
// sequences of symbols P, p, and the combinations like `PPPPPPPppppp`
const longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;

const escapedStringRegExp = /^'([^]*?)'?$/;
const doubleQuoteRegExp = /''/g;
const unescapedLatinCharacterRegExp = /[a-zA-Z]/;



/**
 * The {@link format} function options.
 */

/**
 * @name format
 * @alias formatDate
 * @category Common Helpers
 * @summary Format the date.
 *
 * @description
 * Return the formatted date string in the given format. The result may vary by locale.
 *
 * > ⚠️ Please note that the `format` tokens differ from Moment.js and other libraries.
 * > See: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 *
 * The characters wrapped between two single quotes characters (') are escaped.
 * Two single quotes in a row, whether inside or outside a quoted sequence, represent a 'real' single quote.
 * (see the last example)
 *
 * Format of the string is based on Unicode Technical Standard #35:
 * https://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
 * with a few additions (see note 7 below the table).
 *
 * Accepted patterns:
 * | Unit                            | Pattern | Result examples                   | Notes |
 * |---------------------------------|---------|-----------------------------------|-------|
 * | Era                             | G..GGG  | AD, BC                            |       |
 * |                                 | GGGG    | Anno Domini, Before Christ        | 2     |
 * |                                 | GGGGG   | A, B                              |       |
 * | Calendar year                   | y       | 44, 1, 1900, 2017                 | 5     |
 * |                                 | yo      | 44th, 1st, 0th, 17th              | 5,7   |
 * |                                 | yy      | 44, 01, 00, 17                    | 5     |
 * |                                 | yyy     | 044, 001, 1900, 2017              | 5     |
 * |                                 | yyyy    | 0044, 0001, 1900, 2017            | 5     |
 * |                                 | yyyyy   | ...                               | 3,5   |
 * | Local week-numbering year       | Y       | 44, 1, 1900, 2017                 | 5     |
 * |                                 | Yo      | 44th, 1st, 1900th, 2017th         | 5,7   |
 * |                                 | YY      | 44, 01, 00, 17                    | 5,8   |
 * |                                 | YYY     | 044, 001, 1900, 2017              | 5     |
 * |                                 | YYYY    | 0044, 0001, 1900, 2017            | 5,8   |
 * |                                 | YYYYY   | ...                               | 3,5   |
 * | ISO week-numbering year         | R       | -43, 0, 1, 1900, 2017             | 5,7   |
 * |                                 | RR      | -43, 00, 01, 1900, 2017           | 5,7   |
 * |                                 | RRR     | -043, 000, 001, 1900, 2017        | 5,7   |
 * |                                 | RRRR    | -0043, 0000, 0001, 1900, 2017     | 5,7   |
 * |                                 | RRRRR   | ...                               | 3,5,7 |
 * | Extended year                   | u       | -43, 0, 1, 1900, 2017             | 5     |
 * |                                 | uu      | -43, 01, 1900, 2017               | 5     |
 * |                                 | uuu     | -043, 001, 1900, 2017             | 5     |
 * |                                 | uuuu    | -0043, 0001, 1900, 2017           | 5     |
 * |                                 | uuuuu   | ...                               | 3,5   |
 * | Quarter (formatting)            | Q       | 1, 2, 3, 4                        |       |
 * |                                 | Qo      | 1st, 2nd, 3rd, 4th                | 7     |
 * |                                 | QQ      | 01, 02, 03, 04                    |       |
 * |                                 | QQQ     | Q1, Q2, Q3, Q4                    |       |
 * |                                 | QQQQ    | 1st quarter, 2nd quarter, ...     | 2     |
 * |                                 | QQQQQ   | 1, 2, 3, 4                        | 4     |
 * | Quarter (stand-alone)           | q       | 1, 2, 3, 4                        |       |
 * |                                 | qo      | 1st, 2nd, 3rd, 4th                | 7     |
 * |                                 | qq      | 01, 02, 03, 04                    |       |
 * |                                 | qqq     | Q1, Q2, Q3, Q4                    |       |
 * |                                 | qqqq    | 1st quarter, 2nd quarter, ...     | 2     |
 * |                                 | qqqqq   | 1, 2, 3, 4                        | 4     |
 * | Month (formatting)              | M       | 1, 2, ..., 12                     |       |
 * |                                 | Mo      | 1st, 2nd, ..., 12th               | 7     |
 * |                                 | MM      | 01, 02, ..., 12                   |       |
 * |                                 | MMM     | Jan, Feb, ..., Dec                |       |
 * |                                 | MMMM    | January, February, ..., December  | 2     |
 * |                                 | MMMMM   | J, F, ..., D                      |       |
 * | Month (stand-alone)             | L       | 1, 2, ..., 12                     |       |
 * |                                 | Lo      | 1st, 2nd, ..., 12th               | 7     |
 * |                                 | LL      | 01, 02, ..., 12                   |       |
 * |                                 | LLL     | Jan, Feb, ..., Dec                |       |
 * |                                 | LLLL    | January, February, ..., December  | 2     |
 * |                                 | LLLLL   | J, F, ..., D                      |       |
 * | Local week of year              | w       | 1, 2, ..., 53                     |       |
 * |                                 | wo      | 1st, 2nd, ..., 53th               | 7     |
 * |                                 | ww      | 01, 02, ..., 53                   |       |
 * | ISO week of year                | I       | 1, 2, ..., 53                     | 7     |
 * |                                 | Io      | 1st, 2nd, ..., 53th               | 7     |
 * |                                 | II      | 01, 02, ..., 53                   | 7     |
 * | Day of month                    | d       | 1, 2, ..., 31                     |       |
 * |                                 | do      | 1st, 2nd, ..., 31st               | 7     |
 * |                                 | dd      | 01, 02, ..., 31                   |       |
 * | Day of year                     | D       | 1, 2, ..., 365, 366               | 9     |
 * |                                 | Do      | 1st, 2nd, ..., 365th, 366th       | 7     |
 * |                                 | DD      | 01, 02, ..., 365, 366             | 9     |
 * |                                 | DDD     | 001, 002, ..., 365, 366           |       |
 * |                                 | DDDD    | ...                               | 3     |
 * | Day of week (formatting)        | E..EEE  | Mon, Tue, Wed, ..., Sun           |       |
 * |                                 | EEEE    | Monday, Tuesday, ..., Sunday      | 2     |
 * |                                 | EEEEE   | M, T, W, T, F, S, S               |       |
 * |                                 | EEEEEE  | Mo, Tu, We, Th, Fr, Sa, Su        |       |
 * | ISO day of week (formatting)    | i       | 1, 2, 3, ..., 7                   | 7     |
 * |                                 | io      | 1st, 2nd, ..., 7th                | 7     |
 * |                                 | ii      | 01, 02, ..., 07                   | 7     |
 * |                                 | iii     | Mon, Tue, Wed, ..., Sun           | 7     |
 * |                                 | iiii    | Monday, Tuesday, ..., Sunday      | 2,7   |
 * |                                 | iiiii   | M, T, W, T, F, S, S               | 7     |
 * |                                 | iiiiii  | Mo, Tu, We, Th, Fr, Sa, Su        | 7     |
 * | Local day of week (formatting)  | e       | 2, 3, 4, ..., 1                   |       |
 * |                                 | eo      | 2nd, 3rd, ..., 1st                | 7     |
 * |                                 | ee      | 02, 03, ..., 01                   |       |
 * |                                 | eee     | Mon, Tue, Wed, ..., Sun           |       |
 * |                                 | eeee    | Monday, Tuesday, ..., Sunday      | 2     |
 * |                                 | eeeee   | M, T, W, T, F, S, S               |       |
 * |                                 | eeeeee  | Mo, Tu, We, Th, Fr, Sa, Su        |       |
 * | Local day of week (stand-alone) | c       | 2, 3, 4, ..., 1                   |       |
 * |                                 | co      | 2nd, 3rd, ..., 1st                | 7     |
 * |                                 | cc      | 02, 03, ..., 01                   |       |
 * |                                 | ccc     | Mon, Tue, Wed, ..., Sun           |       |
 * |                                 | cccc    | Monday, Tuesday, ..., Sunday      | 2     |
 * |                                 | ccccc   | M, T, W, T, F, S, S               |       |
 * |                                 | cccccc  | Mo, Tu, We, Th, Fr, Sa, Su        |       |
 * | AM, PM                          | a..aa   | AM, PM                            |       |
 * |                                 | aaa     | am, pm                            |       |
 * |                                 | aaaa    | a.m., p.m.                        | 2     |
 * |                                 | aaaaa   | a, p                              |       |
 * | AM, PM, noon, midnight          | b..bb   | AM, PM, noon, midnight            |       |
 * |                                 | bbb     | am, pm, noon, midnight            |       |
 * |                                 | bbbb    | a.m., p.m., noon, midnight        | 2     |
 * |                                 | bbbbb   | a, p, n, mi                       |       |
 * | Flexible day period             | B..BBB  | at night, in the morning, ...     |       |
 * |                                 | BBBB    | at night, in the morning, ...     | 2     |
 * |                                 | BBBBB   | at night, in the morning, ...     |       |
 * | Hour [1-12]                     | h       | 1, 2, ..., 11, 12                 |       |
 * |                                 | ho      | 1st, 2nd, ..., 11th, 12th         | 7     |
 * |                                 | hh      | 01, 02, ..., 11, 12               |       |
 * | Hour [0-23]                     | H       | 0, 1, 2, ..., 23                  |       |
 * |                                 | Ho      | 0th, 1st, 2nd, ..., 23rd          | 7     |
 * |                                 | HH      | 00, 01, 02, ..., 23               |       |
 * | Hour [0-11]                     | K       | 1, 2, ..., 11, 0                  |       |
 * |                                 | Ko      | 1st, 2nd, ..., 11th, 0th          | 7     |
 * |                                 | KK      | 01, 02, ..., 11, 00               |       |
 * | Hour [1-24]                     | k       | 24, 1, 2, ..., 23                 |       |
 * |                                 | ko      | 24th, 1st, 2nd, ..., 23rd         | 7     |
 * |                                 | kk      | 24, 01, 02, ..., 23               |       |
 * | Minute                          | m       | 0, 1, ..., 59                     |       |
 * |                                 | mo      | 0th, 1st, ..., 59th               | 7     |
 * |                                 | mm      | 00, 01, ..., 59                   |       |
 * | Second                          | s       | 0, 1, ..., 59                     |       |
 * |                                 | so      | 0th, 1st, ..., 59th               | 7     |
 * |                                 | ss      | 00, 01, ..., 59                   |       |
 * | Fraction of second              | S       | 0, 1, ..., 9                      |       |
 * |                                 | SS      | 00, 01, ..., 99                   |       |
 * |                                 | SSS     | 000, 001, ..., 999                |       |
 * |                                 | SSSS    | ...                               | 3     |
 * | Timezone (ISO-8601 w/ Z)        | X       | -08, +0530, Z                     |       |
 * |                                 | XX      | -0800, +0530, Z                   |       |
 * |                                 | XXX     | -08:00, +05:30, Z                 |       |
 * |                                 | XXXX    | -0800, +0530, Z, +123456          | 2     |
 * |                                 | XXXXX   | -08:00, +05:30, Z, +12:34:56      |       |
 * | Timezone (ISO-8601 w/o Z)       | x       | -08, +0530, +00                   |       |
 * |                                 | xx      | -0800, +0530, +0000               |       |
 * |                                 | xxx     | -08:00, +05:30, +00:00            | 2     |
 * |                                 | xxxx    | -0800, +0530, +0000, +123456      |       |
 * |                                 | xxxxx   | -08:00, +05:30, +00:00, +12:34:56 |       |
 * | Timezone (GMT)                  | O...OOO | GMT-8, GMT+5:30, GMT+0            |       |
 * |                                 | OOOO    | GMT-08:00, GMT+05:30, GMT+00:00   | 2     |
 * | Timezone (specific non-locat.)  | z...zzz | GMT-8, GMT+5:30, GMT+0            | 6     |
 * |                                 | zzzz    | GMT-08:00, GMT+05:30, GMT+00:00   | 2,6   |
 * | Seconds timestamp               | t       | 512969520                         | 7     |
 * |                                 | tt      | ...                               | 3,7   |
 * | Milliseconds timestamp          | T       | 512969520900                      | 7     |
 * |                                 | TT      | ...                               | 3,7   |
 * | Long localized date             | P       | 04/29/1453                        | 7     |
 * |                                 | PP      | Apr 29, 1453                      | 7     |
 * |                                 | PPP     | April 29th, 1453                  | 7     |
 * |                                 | PPPP    | Friday, April 29th, 1453          | 2,7   |
 * | Long localized time             | p       | 12:00 AM                          | 7     |
 * |                                 | pp      | 12:00:00 AM                       | 7     |
 * |                                 | ppp     | 12:00:00 AM GMT+2                 | 7     |
 * |                                 | pppp    | 12:00:00 AM GMT+02:00             | 2,7   |
 * | Combination of date and time    | Pp      | 04/29/1453, 12:00 AM              | 7     |
 * |                                 | PPpp    | Apr 29, 1453, 12:00:00 AM         | 7     |
 * |                                 | PPPppp  | April 29th, 1453 at ...           | 7     |
 * |                                 | PPPPpppp| Friday, April 29th, 1453 at ...   | 2,7   |
 * Notes:
 * 1. "Formatting" units (e.g. formatting quarter) in the default en-US locale
 *    are the same as "stand-alone" units, but are different in some languages.
 *    "Formatting" units are declined according to the rules of the language
 *    in the context of a date. "Stand-alone" units are always nominative singular:
 *
 *    `format(new Date(2017, 10, 6), 'do LLLL', {locale: cs}) //=> '6. listopad'`
 *
 *    `format(new Date(2017, 10, 6), 'do MMMM', {locale: cs}) //=> '6. listopadu'`
 *
 * 2. Any sequence of the identical letters is a pattern, unless it is escaped by
 *    the single quote characters (see below).
 *    If the sequence is longer than listed in table (e.g. `EEEEEEEEEEE`)
 *    the output will be the same as default pattern for this unit, usually
 *    the longest one (in case of ISO weekdays, `EEEE`). Default patterns for units
 *    are marked with "2" in the last column of the table.
 *
 *    `format(new Date(2017, 10, 6), 'MMM') //=> 'Nov'`
 *
 *    `format(new Date(2017, 10, 6), 'MMMM') //=> 'November'`
 *
 *    `format(new Date(2017, 10, 6), 'MMMMM') //=> 'N'`
 *
 *    `format(new Date(2017, 10, 6), 'MMMMMM') //=> 'November'`
 *
 *    `format(new Date(2017, 10, 6), 'MMMMMMM') //=> 'November'`
 *
 * 3. Some patterns could be unlimited length (such as `yyyyyyyy`).
 *    The output will be padded with zeros to match the length of the pattern.
 *
 *    `format(new Date(2017, 10, 6), 'yyyyyyyy') //=> '00002017'`
 *
 * 4. `QQQQQ` and `qqqqq` could be not strictly numerical in some locales.
 *    These tokens represent the shortest form of the quarter.
 *
 * 5. The main difference between `y` and `u` patterns are B.C. years:
 *
 *    | Year | `y` | `u` |
 *    |------|-----|-----|
 *    | AC 1 |   1 |   1 |
 *    | BC 1 |   1 |   0 |
 *    | BC 2 |   2 |  -1 |
 *
 *    Also `yy` always returns the last two digits of a year,
 *    while `uu` pads single digit years to 2 characters and returns other years unchanged:
 *
 *    | Year | `yy` | `uu` |
 *    |------|------|------|
 *    | 1    |   01 |   01 |
 *    | 14   |   14 |   14 |
 *    | 376  |   76 |  376 |
 *    | 1453 |   53 | 1453 |
 *
 *    The same difference is true for local and ISO week-numbering years (`Y` and `R`),
 *    except local week-numbering years are dependent on `options.weekStartsOn`
 *    and `options.firstWeekContainsDate` (compare [getISOWeekYear](https://date-fns.org/docs/getISOWeekYear)
 *    and [getWeekYear](https://date-fns.org/docs/getWeekYear)).
 *
 * 6. Specific non-location timezones are currently unavailable in `date-fns`,
 *    so right now these tokens fall back to GMT timezones.
 *
 * 7. These patterns are not in the Unicode Technical Standard #35:
 *    - `i`: ISO day of week
 *    - `I`: ISO week of year
 *    - `R`: ISO week-numbering year
 *    - `t`: seconds timestamp
 *    - `T`: milliseconds timestamp
 *    - `o`: ordinal number modifier
 *    - `P`: long localized date
 *    - `p`: long localized time
 *
 * 8. `YY` and `YYYY` tokens represent week-numbering years but they are often confused with years.
 *    You should enable `options.useAdditionalWeekYearTokens` to use them. See: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 *
 * 9. `D` and `DD` tokens represent days of the year but they are often confused with days of the month.
 *    You should enable `options.useAdditionalDayOfYearTokens` to use them. See: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 *
 * @param date - The original date
 * @param format - The string of tokens
 * @param options - An object with options
 *
 * @returns The formatted date string
 *
 * @throws `date` must not be Invalid Date
 * @throws `options.locale` must contain `localize` property
 * @throws `options.locale` must contain `formatLong` property
 * @throws use `yyyy` instead of `YYYY` for formatting years using [format provided] to the input [input provided]; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 * @throws use `yy` instead of `YY` for formatting years using [format provided] to the input [input provided]; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 * @throws use `d` instead of `D` for formatting days of the month using [format provided] to the input [input provided]; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 * @throws use `dd` instead of `DD` for formatting days of the month using [format provided] to the input [input provided]; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md
 * @throws format string contains an unescaped latin alphabet character
 *
 * @example
 * // Represent 11 February 2014 in middle-endian format:
 * const result = format(new Date(2014, 1, 11), 'MM/dd/yyyy')
 * //=> '02/11/2014'
 *
 * @example
 * // Represent 2 July 2014 in Esperanto:
 * import { eoLocale } from 'date-fns/locale/eo'
 * const result = format(new Date(2014, 6, 2), "do 'de' MMMM yyyy", {
 *   locale: eoLocale
 * })
 * //=> '2-a de julio 2014'
 *
 * @example
 * // Escape string by single quote characters:
 * const result = format(new Date(2014, 6, 2, 15), "h 'o''clock'")
 * //=> "3 o'clock"
 */
function format(date, formatStr, options) {
  const defaultOptions = getDefaultOptions();
  const locale = options?.locale ?? defaultOptions.locale ?? enUS;

  const firstWeekContainsDate =
    options?.firstWeekContainsDate ??
    options?.locale?.options?.firstWeekContainsDate ??
    defaultOptions.firstWeekContainsDate ??
    defaultOptions.locale?.options?.firstWeekContainsDate ??
    1;

  const weekStartsOn =
    options?.weekStartsOn ??
    options?.locale?.options?.weekStartsOn ??
    defaultOptions.weekStartsOn ??
    defaultOptions.locale?.options?.weekStartsOn ??
    0;

  const originalDate = toDate(date, options?.in);

  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }

  let parts = formatStr
    .match(longFormattingTokensRegExp)
    .map((substring) => {
      const firstCharacter = substring[0];
      if (firstCharacter === "p" || firstCharacter === "P") {
        const longFormatter = longFormatters[firstCharacter];
        return longFormatter(substring, locale.formatLong);
      }
      return substring;
    })
    .join("")
    .match(formattingTokensRegExp)
    .map((substring) => {
      // Replace two single quote characters with one single quote character
      if (substring === "''") {
        return { isToken: false, value: "'" };
      }

      const firstCharacter = substring[0];
      if (firstCharacter === "'") {
        return { isToken: false, value: cleanEscapedString(substring) };
      }

      if (formatters[firstCharacter]) {
        return { isToken: true, value: substring };
      }

      if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
        throw new RangeError(
          "Format string contains an unescaped latin alphabet character `" +
            firstCharacter +
            "`",
        );
      }

      return { isToken: false, value: substring };
    });

  // invoke localize preprocessor (only for french locales at the moment)
  if (locale.localize.preprocessor) {
    parts = locale.localize.preprocessor(originalDate, parts);
  }

  const formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale,
  };

  return parts
    .map((part) => {
      if (!part.isToken) return part.value;

      const token = part.value;

      if (
        (!options?.useAdditionalWeekYearTokens &&
          isProtectedWeekYearToken(token)) ||
        (!options?.useAdditionalDayOfYearTokens &&
          isProtectedDayOfYearToken(token))
      ) {
        warnOrThrowProtectedError(token, formatStr, String(date));
      }

      const formatter = formatters[token[0]];
      return formatter(originalDate, token, locale.localize, formatterOptions);
    })
    .join("");
}

function cleanEscapedString(input) {
  const matched = input.match(escapedStringRegExp);

  if (!matched) {
    return input;
  }

  return matched[1].replace(doubleQuoteRegExp, "'");
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_format = ((/* unused pure expression or super */ null && (format)));

;// ./packages/dataviews/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock: lock_unlock_lock,
  unlock: lock_unlock_unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I acknowledge private features are not for use in themes or plugins and doing so will break in the next version of WordPress.', '@wordpress/dataviews');

;// ./packages/dataviews/build-module/dataform-controls/date.js
/**
 * WordPress dependencies
 */





/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




const {
  DateCalendar,
  DateRangeCalendar
} = lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
const DATE_PRESETS = [{
  id: 'today',
  label: (0,external_wp_i18n_namespaceObject.__)('Today'),
  getValue: () => (0,external_wp_date_namespaceObject.getDate)(null)
}, {
  id: 'yesterday',
  label: (0,external_wp_i18n_namespaceObject.__)('Yesterday'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return subDays(today, 1);
  }
}, {
  id: 'past-week',
  label: (0,external_wp_i18n_namespaceObject.__)('Past week'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return subDays(today, 7);
  }
}, {
  id: 'past-month',
  label: (0,external_wp_i18n_namespaceObject.__)('Past month'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return subMonths(today, 1);
  }
}];
const DATE_RANGE_PRESETS = [{
  id: 'last-7-days',
  label: (0,external_wp_i18n_namespaceObject.__)('Last 7 days'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return [subDays(today, 7), today];
  }
}, {
  id: 'last-30-days',
  label: (0,external_wp_i18n_namespaceObject.__)('Last 30 days'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return [subDays(today, 30), today];
  }
}, {
  id: 'month-to-date',
  label: (0,external_wp_i18n_namespaceObject.__)('Month to date'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return [startOfMonth(today), today];
  }
}, {
  id: 'last-year',
  label: (0,external_wp_i18n_namespaceObject.__)('Last year'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return [subYears(today, 1), today];
  }
}, {
  id: 'year-to-date',
  label: (0,external_wp_i18n_namespaceObject.__)('Year to date'),
  getValue: () => {
    const today = (0,external_wp_date_namespaceObject.getDate)(null);
    return [startOfYear(today), today];
  }
}];
const parseDate = dateString => {
  if (!dateString) {
    return null;
  }
  const parsed = (0,external_wp_date_namespaceObject.getDate)(dateString);
  return parsed && isValid(parsed) ? parsed : null;
};
const formatDate = date => {
  if (!date) {
    return '';
  }
  return typeof date === 'string' ? date : format(date, 'yyyy-MM-dd');
};
function CalendarDateControl({
  id,
  value,
  onChange,
  label,
  hideLabelFromVision,
  className
}) {
  const [selectedPresetId, setSelectedPresetId] = (0,external_wp_element_namespaceObject.useState)(null);
  const [calendarMonth, setCalendarMonth] = (0,external_wp_element_namespaceObject.useState)(() => {
    const parsedDate = parseDate(value);
    return parsedDate || new Date(); // Default to current month
  });
  const onSelectDate = (0,external_wp_element_namespaceObject.useCallback)(newDate => {
    const dateValue = newDate ? format(newDate, 'yyyy-MM-dd') : undefined;
    onChange({
      [id]: dateValue
    });
    setSelectedPresetId(null);
  }, [id, onChange]);
  const handlePresetClick = (0,external_wp_element_namespaceObject.useCallback)(preset => {
    const presetDate = preset.getValue();
    const dateValue = formatDate(presetDate);
    setCalendarMonth(presetDate);
    onChange({
      [id]: dateValue
    });
    setSelectedPresetId(preset.id);
  }, [id, onChange]);
  const handleManualDateChange = (0,external_wp_element_namespaceObject.useCallback)(newValue => {
    onChange({
      [id]: newValue
    });
    if (newValue) {
      const parsedDate = parseDate(newValue);
      if (parsedDate) {
        setCalendarMonth(parsedDate);
      }
    }
    setSelectedPresetId(null);
  }, [id, onChange]);
  const {
    timezone: {
      string: timezoneString
    },
    l10n: {
      startOfWeek
    }
  } = (0,external_wp_date_namespaceObject.getSettings)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl, {
    __nextHasNoMarginBottom: true,
    id: id,
    className: className,
    label: label,
    hideLabelFromVision: hideLabelFromVision,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        spacing: 2,
        wrap: true,
        justify: "flex-start",
        children: [DATE_PRESETS.map(preset => {
          const isSelected = selectedPresetId === preset.id;
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            className: "dataviews-controls__date-preset",
            variant: "tertiary",
            isPressed: isSelected,
            size: "small",
            onClick: () => handlePresetClick(preset),
            children: preset.label
          }, preset.id);
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          className: "dataviews-controls__date-preset",
          variant: "tertiary",
          isPressed: !selectedPresetId,
          size: "small",
          disabled: !!selectedPresetId,
          accessibleWhenDisabled: false,
          children: (0,external_wp_i18n_namespaceObject.__)('Custom')
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControl, {
        __next40pxDefaultSize: true,
        type: "date",
        label: (0,external_wp_i18n_namespaceObject.__)('Date'),
        hideLabelFromVision: true,
        value: value,
        onChange: handleManualDateChange
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DateCalendar, {
        style: {
          width: '100%'
        },
        selected: value ? parseDate(value) || undefined : undefined,
        onSelect: onSelectDate,
        month: calendarMonth,
        onMonthChange: setCalendarMonth,
        timeZone: timezoneString || undefined,
        weekStartsOn: startOfWeek
      })]
    })
  });
}
function CalendarDateRangeControl({
  id,
  value,
  onChange,
  label,
  hideLabelFromVision,
  className
}) {
  const [selectedPresetId, setSelectedPresetId] = (0,external_wp_element_namespaceObject.useState)(null);
  const selectedRange = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!value) {
      return {
        from: undefined,
        to: undefined
      };
    }
    const [from, to] = value;
    return {
      from: parseDate(from) || undefined,
      to: parseDate(to) || undefined
    };
  }, [value]);
  const [calendarMonth, setCalendarMonth] = (0,external_wp_element_namespaceObject.useState)(() => {
    return selectedRange.from || new Date();
  });
  const updateDateRange = (0,external_wp_element_namespaceObject.useCallback)((fromDate, toDate) => {
    if (fromDate && toDate) {
      onChange({
        [id]: [formatDate(fromDate), formatDate(toDate)]
      });
    } else if (!fromDate && !toDate) {
      onChange({
        [id]: undefined
      });
    }
    // Do nothing if only one date is set - wait for both
  }, [id, onChange]);
  const onSelectCalendarRange = (0,external_wp_element_namespaceObject.useCallback)(newRange => {
    updateDateRange(newRange?.from, newRange?.to);
    setSelectedPresetId(null);
  }, [updateDateRange]);
  const handlePresetClick = (0,external_wp_element_namespaceObject.useCallback)(preset => {
    const [startDate, endDate] = preset.getValue();
    setCalendarMonth(startDate);
    updateDateRange(startDate, endDate);
    setSelectedPresetId(preset.id);
  }, [updateDateRange]);
  const handleManualDateChange = (0,external_wp_element_namespaceObject.useCallback)((fromOrTo, newValue) => {
    const [currentFrom, currentTo] = value || [undefined, undefined];
    const updatedFrom = fromOrTo === 'from' ? newValue : currentFrom;
    const updatedTo = fromOrTo === 'to' ? newValue : currentTo;
    updateDateRange(updatedFrom, updatedTo);
    if (newValue) {
      const parsedDate = parseDate(newValue);
      if (parsedDate) {
        setCalendarMonth(parsedDate);
      }
    }
    setSelectedPresetId(null);
  }, [value, updateDateRange]);
  const {
    timezone,
    l10n
  } = (0,external_wp_date_namespaceObject.getSettings)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl, {
    __nextHasNoMarginBottom: true,
    id: id,
    className: className,
    label: label,
    hideLabelFromVision: hideLabelFromVision,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        spacing: 2,
        wrap: true,
        justify: "flex-start",
        children: [DATE_RANGE_PRESETS.map(preset => {
          const isSelected = selectedPresetId === preset.id;
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            className: "dataviews-controls__date-preset",
            variant: "tertiary",
            isPressed: isSelected,
            size: "small",
            onClick: () => handlePresetClick(preset),
            children: preset.label
          }, preset.id);
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          className: "dataviews-controls__date-preset",
          variant: "tertiary",
          isPressed: !selectedPresetId,
          size: "small",
          accessibleWhenDisabled: false,
          disabled: !!selectedPresetId,
          children: (0,external_wp_i18n_namespaceObject.__)('Custom')
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        spacing: 2,
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControl, {
          __next40pxDefaultSize: true,
          type: "date",
          label: (0,external_wp_i18n_namespaceObject.__)('From'),
          hideLabelFromVision: true,
          value: value?.[0],
          onChange: newValue => handleManualDateChange('from', newValue)
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControl, {
          __next40pxDefaultSize: true,
          type: "date",
          label: (0,external_wp_i18n_namespaceObject.__)('To'),
          hideLabelFromVision: true,
          value: value?.[1],
          onChange: newValue => handleManualDateChange('to', newValue)
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DateRangeCalendar, {
        style: {
          width: '100%'
        },
        selected: selectedRange,
        onSelect: onSelectCalendarRange,
        month: calendarMonth,
        onMonthChange: setCalendarMonth,
        timeZone: timezone.string || undefined,
        weekStartsOn: l10n.startOfWeek
      })]
    })
  });
}
function DateControl({
  data,
  field,
  onChange,
  hideLabelFromVision,
  operator
}) {
  const {
    id,
    label
  } = field;
  const value = field.getValue({
    item: data
  });
  if (operator === OPERATOR_IN_THE_PAST || operator === OPERATOR_OVER) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(RelativeDateControl, {
      className: "dataviews-controls__date",
      id: id,
      value: value && typeof value === 'object' ? value : {},
      onChange: onChange,
      label: label,
      hideLabelFromVision: hideLabelFromVision,
      options: TIME_UNITS_OPTIONS[operator]
    });
  }
  if (operator === OPERATOR_BETWEEN) {
    let dateRangeValue;
    if (Array.isArray(value) && value.length === 2 && value.every(date => typeof date === 'string')) {
      // Ensure the value is expected format
      dateRangeValue = value;
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CalendarDateRangeControl, {
      className: "dataviews-controls__date",
      id: id,
      value: dateRangeValue,
      onChange: onChange,
      label: label,
      hideLabelFromVision: hideLabelFromVision
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CalendarDateControl, {
    className: "dataviews-controls__date",
    id: id,
    value: typeof value === 'string' ? value : undefined,
    onChange: onChange,
    label: label,
    hideLabelFromVision: hideLabelFromVision
  });
}

;// ./packages/dataviews/build-module/dataform-controls/email.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const {
  ValidatedTextControl
} = lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
function Email({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    id,
    label,
    placeholder,
    description
  } = field;
  const value = field.getValue({
    item: data
  });
  const [customValidity, setCustomValidity] = (0,external_wp_element_namespaceObject.useState)(undefined);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ValidatedTextControl, {
    required: !!field.isValid?.required,
    onValidate: newValue => {
      const message = field.isValid?.custom?.({
        ...data,
        [id]: newValue
      }, field);
      if (message) {
        setCustomValidity({
          type: 'invalid',
          message
        });
        return;
      }
      setCustomValidity(undefined);
    },
    customValidity: customValidity,
    type: "email",
    label: label,
    placeholder: placeholder,
    value: value !== null && value !== void 0 ? value : '',
    help: description,
    onChange: onChangeControl,
    __next40pxDefaultSize: true,
    __nextHasNoMarginBottom: true,
    hideLabelFromVision: hideLabelFromVision
  });
}

;// ./packages/dataviews/build-module/dataform-controls/integer.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const {
  ValidatedNumberControl
} = lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
function BetweenControls({
  id,
  value,
  onChange,
  hideLabelFromVision
}) {
  const [min = '', max = ''] = Array.isArray(value) ? value : [];
  const onChangeMin = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: [Number(newValue), max]
  }), [id, onChange, max]);
  const onChangeMax = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: [min, Number(newValue)]
  }), [id, onChange, min]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl, {
    __nextHasNoMarginBottom: true,
    help: (0,external_wp_i18n_namespaceObject.__)('The max. value must be greater than the min. value.'),
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, {
      direction: "row",
      gap: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Min.'),
        value: min,
        max: max ? Number(max) - 1 : undefined,
        onChange: onChangeMin,
        __next40pxDefaultSize: true,
        hideLabelFromVision: hideLabelFromVision
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Max.'),
        value: max,
        min: min ? Number(min) + 1 : undefined,
        onChange: onChangeMax,
        __next40pxDefaultSize: true,
        hideLabelFromVision: hideLabelFromVision
      })]
    })
  });
}
function Integer({
  data,
  field,
  onChange,
  hideLabelFromVision,
  operator
}) {
  var _field$getValue;
  const {
    id,
    label,
    description
  } = field;
  const value = (_field$getValue = field.getValue({
    item: data
  })) !== null && _field$getValue !== void 0 ? _field$getValue : '';
  const [customValidity, setCustomValidity] = (0,external_wp_element_namespaceObject.useState)(undefined);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => {
    onChange({
      // Do not convert an empty string or undefined to a number,
      // otherwise there's a mismatch between the UI control (empty)
      // and the data relied by onChange (0).
      [id]: ['', undefined].includes(newValue) ? undefined : Number(newValue)
    });
  }, [id, onChange]);
  if (operator === OPERATOR_BETWEEN) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BetweenControls, {
      id: id,
      value: value,
      onChange: onChange,
      hideLabelFromVision: hideLabelFromVision
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ValidatedNumberControl, {
    required: !!field.isValid?.required,
    onValidate: newValue => {
      const message = field.isValid?.custom?.({
        ...data,
        [id]: [undefined, '', null].includes(newValue) ? undefined : Number(newValue)
      }, field);
      if (message) {
        setCustomValidity({
          type: 'invalid',
          message
        });
        return;
      }
      setCustomValidity(undefined);
    },
    customValidity: customValidity,
    label: label,
    help: description,
    value: value,
    onChange: onChangeControl,
    __next40pxDefaultSize: true,
    hideLabelFromVision: hideLabelFromVision
  });
}

;// ./packages/dataviews/build-module/dataform-controls/radio.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

function Radio({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    id,
    label
  } = field;
  const value = field.getValue({
    item: data
  });
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  if (field.elements) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RadioControl, {
      label: label,
      onChange: onChangeControl,
      options: field.elements,
      selected: value,
      hideLabelFromVision: hideLabelFromVision
    });
  }
  return null;
}

;// ./packages/dataviews/build-module/dataform-controls/select.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

function Select({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  var _field$getValue, _field$elements;
  const {
    id,
    label,
    type
  } = field;
  const isMultiple = type === 'array';
  const value = (_field$getValue = field.getValue({
    item: data
  })) !== null && _field$getValue !== void 0 ? _field$getValue : isMultiple ? [] : '';
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  const fieldElements = (_field$elements = field?.elements) !== null && _field$elements !== void 0 ? _field$elements : [];
  const hasEmptyValue = fieldElements.some(({
    value: elementValue
  }) => elementValue === '');
  const elements = hasEmptyValue || isMultiple ? fieldElements : [
  /*
   * Value can be undefined when:
   *
   * - the field is not required
   * - in bulk editing
   *
   */
  {
    label: (0,external_wp_i18n_namespaceObject.__)('Select item'),
    value: ''
  }, ...fieldElements];
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SelectControl, {
    label: label,
    value: value,
    help: field.description,
    options: elements,
    onChange: onChangeControl,
    __next40pxDefaultSize: true,
    __nextHasNoMarginBottom: true,
    hideLabelFromVision: hideLabelFromVision,
    multiple: isMultiple
  });
}

;// ./packages/dataviews/build-module/dataform-controls/text.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const {
  ValidatedTextControl: text_ValidatedTextControl
} = lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
function Text({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    id,
    label,
    placeholder,
    description
  } = field;
  const value = field.getValue({
    item: data
  });
  const [customValidity, setCustomValidity] = (0,external_wp_element_namespaceObject.useState)(undefined);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(text_ValidatedTextControl, {
    required: !!field.isValid?.required,
    onValidate: newValue => {
      const message = field.isValid?.custom?.({
        ...data,
        [id]: newValue
      }, field);
      if (message) {
        setCustomValidity({
          type: 'invalid',
          message
        });
        return;
      }
      setCustomValidity(undefined);
    },
    customValidity: customValidity,
    label: label,
    placeholder: placeholder,
    value: value !== null && value !== void 0 ? value : '',
    help: description,
    onChange: onChangeControl,
    __next40pxDefaultSize: true,
    __nextHasNoMarginBottom: true,
    hideLabelFromVision: hideLabelFromVision
  });
}

;// ./packages/dataviews/build-module/dataform-controls/toggle-group.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

function ToggleGroup({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    id
  } = field;
  const value = field.getValue({
    item: data
  });
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  if (field.elements) {
    const selectedOption = field.elements.find(el => el.value === value);
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      isBlock: true,
      label: field.label,
      help: selectedOption?.description || field.description,
      onChange: onChangeControl,
      value: value,
      hideLabelFromVision: hideLabelFromVision,
      children: field.elements.map(el => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
        label: el.label,
        value: el.value
      }, el.value))
    });
  }
  return null;
}

;// ./packages/dataviews/build-module/dataform-controls/boolean.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const {
  ValidatedToggleControl
} = lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
function boolean_Boolean({
  field,
  onChange,
  data,
  hideLabelFromVision
}) {
  const {
    id,
    getValue,
    label
  } = field;
  const [customValidity, setCustomValidity] = (0,external_wp_element_namespaceObject.useState)(undefined);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ValidatedToggleControl, {
    required: !!field.isValid.required,
    onValidate: newValue => {
      const message = field.isValid?.custom?.({
        ...data,
        [id]: newValue
      }, field);
      if (message) {
        setCustomValidity({
          type: 'invalid',
          message
        });
        return;
      }
      setCustomValidity(undefined);
    },
    customValidity: customValidity,
    hidden: hideLabelFromVision,
    __nextHasNoMarginBottom: true,
    label: label,
    checked: getValue({
      item: data
    }),
    onChange: () => onChange({
      [id]: !getValue({
        item: data
      })
    })
  });
}

;// ./packages/dataviews/build-module/dataform-controls/array.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

function ArrayControl({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  var _elements$map;
  const {
    id,
    label,
    placeholder,
    elements
  } = field;
  const value = field.getValue({
    item: data
  });
  const findElementByValue = (0,external_wp_element_namespaceObject.useCallback)(suggestionValue => {
    return elements?.find(suggestion => suggestion.value === suggestionValue);
  }, [elements]);
  const findElementByLabel = (0,external_wp_element_namespaceObject.useCallback)(suggestionLabel => {
    return elements?.find(suggestion => suggestion.label === suggestionLabel);
  }, [elements]);

  // Ensure value is an array
  const arrayValue = (0,external_wp_element_namespaceObject.useMemo)(() => Array.isArray(value) ? value.map(token => {
    const tokenLabel = findElementByValue(token)?.label;
    return tokenLabel || token;
  }) : [], [value, findElementByValue]);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(tokens => {
    // Convert TokenItem objects to strings
    const stringTokens = tokens.map(token => {
      if (typeof token !== 'string') {
        return token.value;
      }
      const tokenByLabel = findElementByLabel(token);
      return tokenByLabel?.value || token;
    });
    onChange({
      [id]: stringTokens
    });
  }, [id, onChange, findElementByLabel]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FormTokenField, {
    label: hideLabelFromVision ? undefined : label,
    value: arrayValue,
    onChange: onChangeControl,
    placeholder: placeholder,
    suggestions: (_elements$map = elements?.map(suggestion => suggestion.label)) !== null && _elements$map !== void 0 ? _elements$map : [],
    __experimentalExpandOnFocus: elements && elements.length > 0,
    __next40pxDefaultSize: true,
    __nextHasNoMarginBottom: true
  });
}

;// ./packages/dataviews/build-module/dataform-controls/index.js
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */












const FORM_CONTROLS = {
  array: ArrayControl,
  boolean: boolean_Boolean,
  checkbox: Checkbox,
  datetime: DateTime,
  date: DateControl,
  email: Email,
  integer: Integer,
  radio: Radio,
  select: Select,
  text: Text,
  toggleGroup: ToggleGroup
};
function getControl(field, fieldTypeDefinition) {
  if (typeof field.Edit === 'function') {
    return field.Edit;
  }
  if (typeof field.Edit === 'string') {
    return getControlByType(field.Edit);
  }
  if (field.elements && field.type !== 'array') {
    return getControlByType('select');
  }
  if (typeof fieldTypeDefinition.Edit === 'string') {
    return getControlByType(fieldTypeDefinition.Edit);
  }
  return fieldTypeDefinition.Edit;
}
function getControlByType(type) {
  if (Object.keys(FORM_CONTROLS).includes(type)) {
    return FORM_CONTROLS[type];
  }
  throw 'Control ' + type + ' not found';
}

;// ./packages/dataviews/build-module/normalize-fields.js
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



const getValueFromId = id => ({
  item
}) => {
  const path = id.split('.');
  let value = item;
  for (const segment of path) {
    if (value.hasOwnProperty(segment)) {
      value = value[segment];
    } else {
      value = undefined;
    }
  }
  return value;
};
function getFilterBy(field, fieldTypeDefinition) {
  if (field.filterBy === false) {
    return false;
  }
  if (typeof field.filterBy === 'object') {
    let operators = field.filterBy.operators;

    // Assign default values if no operator was provided.
    if (!operators || !Array.isArray(operators)) {
      operators = !!fieldTypeDefinition.filterBy ? fieldTypeDefinition.filterBy.defaultOperators : [];
    }

    // Make sure only valid operators are included.
    let validOperators = ALL_OPERATORS;
    if (typeof fieldTypeDefinition.filterBy === 'object') {
      validOperators = fieldTypeDefinition.filterBy.validOperators;
    }
    operators = operators.filter(operator => validOperators.includes(operator));

    // The `between` operator is not supported when elements are provided.
    if (field.elements && operators.includes(OPERATOR_BETWEEN)) {
      operators = operators.filter(operator => operator !== OPERATOR_BETWEEN);
    }

    // Do not allow mixing single & multiselection operators.
    // Remove multiselection operators if any of the single selection ones is present.
    const hasSingleSelectionOperator = operators.some(operator => SINGLE_SELECTION_OPERATORS.includes(operator));
    if (hasSingleSelectionOperator) {
      operators = operators.filter(operator =>
      // The 'Between' operator is unique as it can be combined with single selection operators.
      [...SINGLE_SELECTION_OPERATORS, OPERATOR_BETWEEN].includes(operator));
    }

    // If no operators are left at this point,
    // the filters should be disabled.
    if (operators.length === 0) {
      return false;
    }
    return {
      isPrimary: !!field.filterBy.isPrimary,
      operators
    };
  }
  if (fieldTypeDefinition.filterBy === false) {
    return false;
  }
  let defaultOperators = fieldTypeDefinition.filterBy.defaultOperators;
  // The `between` operator is not supported when elements are provided.
  if (field.elements && defaultOperators.includes(OPERATOR_BETWEEN)) {
    defaultOperators = defaultOperators.filter(operator => operator !== OPERATOR_BETWEEN);
  }
  return {
    operators: defaultOperators
  };
}

/**
 * Apply default values and normalize the fields config.
 *
 * @param fields Fields config.
 * @return Normalized fields config.
 */
function normalizeFields(fields) {
  return fields.map(field => {
    var _field$sort, _field$render, _field$enableHiding, _ref, _field$enableSorting, _ref2, _field$readOnly;
    const fieldTypeDefinition = getFieldTypeDefinition(field.type);
    const getValue = field.getValue || getValueFromId(field.id);
    const sort = (_field$sort = field.sort) !== null && _field$sort !== void 0 ? _field$sort : function sort(a, b, direction) {
      return fieldTypeDefinition.sort(getValue({
        item: a
      }), getValue({
        item: b
      }), direction);
    };
    const isValid = {
      ...fieldTypeDefinition.isValid,
      ...field.isValid
    };
    const Edit = getControl(field, fieldTypeDefinition);
    const render = (_field$render = field.render) !== null && _field$render !== void 0 ? _field$render : function render({
      item,
      field: renderedField
    }) {
      return fieldTypeDefinition.render({
        item,
        field: renderedField
      });
    };
    const filterBy = getFilterBy(field, fieldTypeDefinition);
    return {
      ...field,
      label: field.label || field.id,
      header: field.header || field.label || field.id,
      getValue,
      render,
      sort,
      isValid,
      Edit,
      enableHiding: (_field$enableHiding = field.enableHiding) !== null && _field$enableHiding !== void 0 ? _field$enableHiding : true,
      enableSorting: (_ref = (_field$enableSorting = field.enableSorting) !== null && _field$enableSorting !== void 0 ? _field$enableSorting : fieldTypeDefinition.enableSorting) !== null && _ref !== void 0 ? _ref : true,
      filterBy,
      readOnly: (_ref2 = (_field$readOnly = field.readOnly) !== null && _field$readOnly !== void 0 ? _field$readOnly : fieldTypeDefinition.readOnly) !== null && _ref2 !== void 0 ? _ref2 : false
    };
  });
}

;// ./packages/dataviews/build-module/dataforms-layouts/is-combined-field.js
/**
 * Internal dependencies
 */

function isCombinedField(field) {
  return field.children !== undefined;
}

;// ./packages/dataviews/build-module/normalize-form-fields.js
/**
 * Internal dependencies
 */

const DEFAULT_LAYOUT = {
  type: 'regular',
  labelPosition: 'top'
};

/**
 * Normalizes a layout configuration based on its type.
 *
 * @param layout The layout object to normalize.
 * @return The normalized layout object.
 */
function normalizeLayout(layout) {
  let normalizedLayout = DEFAULT_LAYOUT;
  if (layout?.type === 'regular') {
    var _layout$labelPosition;
    normalizedLayout = {
      type: 'regular',
      labelPosition: (_layout$labelPosition = layout?.labelPosition) !== null && _layout$labelPosition !== void 0 ? _layout$labelPosition : 'top'
    };
  } else if (layout?.type === 'panel') {
    var _layout$labelPosition2, _layout$openAs;
    normalizedLayout = {
      type: 'panel',
      labelPosition: (_layout$labelPosition2 = layout?.labelPosition) !== null && _layout$labelPosition2 !== void 0 ? _layout$labelPosition2 : 'side',
      openAs: (_layout$openAs = layout?.openAs) !== null && _layout$openAs !== void 0 ? _layout$openAs : 'dropdown'
    };
  } else if (layout?.type === 'card') {
    if (layout.withHeader === false) {
      // Don't let isOpened be false if withHeader is false.
      // Otherwise, the card will not be visible.
      normalizedLayout = {
        type: 'card',
        withHeader: false,
        isOpened: true
      };
    } else {
      normalizedLayout = {
        type: 'card',
        withHeader: true,
        isOpened: typeof layout.isOpened === 'boolean' ? layout.isOpened : true
      };
    }
  }
  return normalizedLayout;
}
function normalizeFormFields(form) {
  var _form$fields;
  const formLayout = normalizeLayout(form?.layout);
  return ((_form$fields = form.fields) !== null && _form$fields !== void 0 ? _form$fields : []).map(field => {
    if (typeof field === 'string') {
      return {
        id: field,
        layout: formLayout
      };
    }
    const fieldLayout = field.layout ? normalizeLayout(field.layout) : formLayout;
    return {
      ...field,
      layout: fieldLayout
    };
  });
}

;// ./packages/dataviews/build-module/dataforms-layouts/regular/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function Header({
  title
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
    className: "dataforms-layouts-regular__header",
    spacing: 4,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      alignment: "center",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalHeading, {
        level: 2,
        size: 13,
        children: title
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalSpacer, {})]
    })
  });
}
function FormRegularField({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    fields
  } = (0,external_wp_element_namespaceObject.useContext)(dataform_context);
  const form = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    layout: DEFAULT_LAYOUT,
    fields: isCombinedField(field) ? field.children : []
  }), [field]);
  if (isCombinedField(field)) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [!hideLabelFromVision && field.label && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Header, {
        title: field.label
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormLayout, {
        data: data,
        form: form,
        onChange: onChange
      })]
    });
  }
  const layout = normalizeLayout({
    ...field.layout,
    type: 'regular'
  });
  const labelPosition = layout.labelPosition;
  const fieldDefinition = fields.find(fieldDef => fieldDef.id === field.id);
  if (!fieldDefinition || !fieldDefinition.Edit) {
    return null;
  }
  if (labelPosition === 'side') {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      className: "dataforms-layouts-regular__field",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: dist_clsx('dataforms-layouts-regular__field-label', `dataforms-layouts-regular__field-label--label-position-${labelPosition}`),
        children: fieldDefinition.label
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "dataforms-layouts-regular__field-control",
        children: fieldDefinition.readOnly === true ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.render, {
          item: data,
          field: fieldDefinition
        }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.Edit, {
          data: data,
          field: fieldDefinition,
          onChange: onChange,
          hideLabelFromVision: true
        }, fieldDefinition.id)
      })]
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "dataforms-layouts-regular__field",
    children: fieldDefinition.readOnly === true ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [!hideLabelFromVision && labelPosition !== 'none' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "dataforms-layouts-regular__field-label",
        children: fieldDefinition.label
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "dataforms-layouts-regular__field-control",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.render, {
          item: data,
          field: fieldDefinition
        })
      })]
    }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.Edit, {
      data: data,
      field: fieldDefinition,
      onChange: onChange,
      hideLabelFromVision: labelPosition === 'none' ? true : hideLabelFromVision
    })
  });
}

;// ./packages/icons/build-module/library/close-small.js
/**
 * WordPress dependencies
 */


const closeSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
  })
});
/* harmony default export */ const close_small = (closeSmall);

;// ./packages/dataviews/build-module/dataforms-layouts/panel/dropdown.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */





function DropdownHeader({
  title,
  onClose
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
    className: "dataforms-layouts-panel__dropdown-header",
    spacing: 4,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      alignment: "center",
      children: [title && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalHeading, {
        level: 2,
        size: 13,
        children: title
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalSpacer, {}), onClose && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        label: (0,external_wp_i18n_namespaceObject.__)('Close'),
        icon: close_small,
        onClick: onClose,
        size: "small"
      })]
    })
  });
}
function PanelDropdown({
  fieldDefinition,
  popoverAnchor,
  labelPosition = 'side',
  data,
  onChange,
  field
}) {
  const fieldLabel = isCombinedField(field) ? field.label : fieldDefinition?.label;
  const form = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    layout: DEFAULT_LAYOUT,
    fields: isCombinedField(field) ? field.children :
    // If not explicit children return the field id itself.
    [{
      id: field.id
    }]
  }), [field]);

  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
    contentClassName: "dataforms-layouts-panel__field-dropdown",
    popoverProps: popoverProps,
    focusOnMount: true,
    toggleProps: {
      size: 'compact',
      variant: 'tertiary',
      tooltipPosition: 'middle left'
    },
    renderToggle: ({
      isOpen,
      onToggle
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      className: "dataforms-layouts-panel__field-control",
      size: "compact",
      variant: ['none', 'top'].includes(labelPosition) ? 'link' : 'tertiary',
      "aria-expanded": isOpen,
      "aria-label": (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: Field name.
      (0,external_wp_i18n_namespaceObject._x)('Edit %s', 'field'), fieldLabel || ''),
      onClick: onToggle,
      disabled: fieldDefinition.readOnly === true,
      accessibleWhenDisabled: true,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.render, {
        item: data,
        field: fieldDefinition
      })
    }),
    renderContent: ({
      onClose
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DropdownHeader, {
        title: fieldLabel,
        onClose: onClose
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormLayout, {
        data: data,
        form: form,
        onChange: onChange,
        children: (FieldLayout, nestedField) => {
          var _form$fields;
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FieldLayout, {
            data: data,
            field: nestedField,
            onChange: onChange,
            hideLabelFromVision: ((_form$fields = form?.fields) !== null && _form$fields !== void 0 ? _form$fields : []).length < 2
          }, nestedField.id);
        }
      })]
    })
  });
}
/* harmony default export */ const dropdown = (PanelDropdown);

;// ./packages/dataviews/build-module/dataforms-layouts/panel/modal.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ModalContent({
  data,
  form,
  fieldLabel,
  onChange,
  onClose
}) {
  const [changes, setChanges] = (0,external_wp_element_namespaceObject.useState)({});
  const onApply = () => {
    onChange(changes);
    onClose();
  };
  const handleOnChange = value => {
    setChanges(prev => ({
      ...prev,
      ...value
    }));
  };

  // Merge original data with local changes for display
  const displayData = {
    ...data,
    ...changes
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Modal, {
    className: "dataforms-layouts-panel__modal",
    onRequestClose: onClose,
    isFullScreen: false,
    title: fieldLabel,
    size: "medium",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormLayout, {
      data: displayData,
      form: form,
      onChange: handleOnChange,
      children: (FieldLayout, nestedField) => {
        var _form$fields;
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FieldLayout, {
          data: displayData,
          field: nestedField,
          onChange: handleOnChange,
          hideLabelFromVision: ((_form$fields = form?.fields) !== null && _form$fields !== void 0 ? _form$fields : []).length < 2
        }, nestedField.id);
      }
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      className: "dataforms-layouts-panel__modal-footer",
      spacing: 3,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalSpacer, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        variant: "tertiary",
        onClick: onClose,
        __next40pxDefaultSize: true,
        children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        variant: "primary",
        onClick: onApply,
        __next40pxDefaultSize: true,
        children: (0,external_wp_i18n_namespaceObject.__)('Apply')
      })]
    })]
  });
}
function PanelModal({
  fieldDefinition,
  labelPosition,
  data,
  onChange,
  field
}) {
  const [isOpen, setIsOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const fieldLabel = isCombinedField(field) ? field.label : fieldDefinition?.label;
  const form = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    layout: DEFAULT_LAYOUT,
    fields: isCombinedField(field) ? field.children :
    // If not explicit children return the field id itself.
    [{
      id: field.id
    }]
  }), [field]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      className: "dataforms-layouts-modal__field-control",
      size: "compact",
      variant: ['none', 'top'].includes(labelPosition) ? 'link' : 'tertiary',
      "aria-expanded": isOpen,
      "aria-label": (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: Field name.
      (0,external_wp_i18n_namespaceObject._x)('Edit %s', 'field'), fieldLabel || ''),
      onClick: () => setIsOpen(true),
      disabled: fieldDefinition.readOnly === true,
      accessibleWhenDisabled: true,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(fieldDefinition.render, {
        item: data,
        field: fieldDefinition
      })
    }), isOpen && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ModalContent, {
      data: data,
      form: form,
      fieldLabel: fieldLabel !== null && fieldLabel !== void 0 ? fieldLabel : '',
      onChange: onChange,
      onClose: () => setIsOpen(false)
    })]
  });
}
/* harmony default export */ const modal = (PanelModal);

;// ./packages/dataviews/build-module/dataforms-layouts/panel/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function FormPanelField({
  data,
  field,
  onChange
}) {
  const {
    fields
  } = (0,external_wp_element_namespaceObject.useContext)(dataform_context);
  const fieldDefinition = fields.find(_field => {
    // Default to the first simple child if it is a combined field.
    if (isCombinedField(field)) {
      const simpleChildren = field.children.filter(child => typeof child === 'string' || !isCombinedField(child));
      if (simpleChildren.length === 0) {
        return false;
      }
      const firstChildFieldId = typeof simpleChildren[0] === 'string' ? simpleChildren[0] : simpleChildren[0].id;
      return _field.id === firstChildFieldId;
    }
    return _field.id === field.id;
  });

  // Use internal state instead of a ref to make sure that the component
  // re-renders when the popover's anchor updates.
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  if (!fieldDefinition) {
    return null;
  }
  const layout = normalizeLayout({
    ...field.layout,
    type: 'panel'
  });
  const labelPosition = layout.labelPosition;
  const labelClassName = dist_clsx('dataforms-layouts-panel__field-label', `dataforms-layouts-panel__field-label--label-position-${labelPosition}`);
  const fieldLabel = isCombinedField(field) ? field.label : fieldDefinition?.label;
  const renderedControl = layout.openAs === 'modal' ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(modal, {
    field: field,
    fieldDefinition: fieldDefinition,
    data: data,
    onChange: onChange,
    labelPosition: labelPosition
  }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(dropdown, {
    field: field,
    popoverAnchor: popoverAnchor,
    fieldDefinition: fieldDefinition,
    data: data,
    onChange: onChange,
    labelPosition: labelPosition
  });
  if (labelPosition === 'top') {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      className: "dataforms-layouts-panel__field",
      spacing: 0,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: labelClassName,
        style: {
          paddingBottom: 0
        },
        children: fieldLabel
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "dataforms-layouts-panel__field-control",
        children: renderedControl
      })]
    });
  }
  if (labelPosition === 'none') {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "dataforms-layouts-panel__field",
      children: renderedControl
    });
  }

  // Defaults to label position side.
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
    ref: setPopoverAnchor,
    className: "dataforms-layouts-panel__field",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: labelClassName,
      children: fieldLabel
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "dataforms-layouts-panel__field-control",
      children: renderedControl
    })]
  });
}

;// ./packages/icons/build-module/library/chevron-up.js
/**
 * WordPress dependencies
 */


const chevronUp = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
  })
});
/* harmony default export */ const chevron_up = (chevronUp);

;// ./packages/icons/build-module/library/chevron-down.js
/**
 * WordPress dependencies
 */


const chevronDown = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
  })
});
/* harmony default export */ const chevron_down = (chevronDown);

;// ./packages/dataviews/build-module/dataforms-layouts/card/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






function useCollapsibleCard(initialIsOpen = true) {
  const [isOpen, setIsOpen] = (0,external_wp_element_namespaceObject.useState)(initialIsOpen);
  const toggle = (0,external_wp_element_namespaceObject.useCallback)(() => {
    setIsOpen(prev => !prev);
  }, []);
  const CollapsibleCardHeader = (0,external_wp_element_namespaceObject.useCallback)(({
    children,
    ...props
  }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.CardHeader, {
    ...props,
    onClick: toggle,
    style: {
      cursor: 'pointer',
      ...props.style
    },
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      style: {
        width: '100%',
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center'
      },
      children: children
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      __next40pxDefaultSize: true,
      variant: "tertiary",
      icon: isOpen ? chevron_up : chevron_down,
      "aria-expanded": isOpen,
      "aria-label": isOpen ? 'Collapse' : 'Expand'
    })]
  }), [toggle, isOpen]);
  return {
    isOpen,
    CollapsibleCardHeader
  };
}
function FormCardField({
  data,
  field,
  onChange,
  hideLabelFromVision
}) {
  const {
    fields
  } = (0,external_wp_element_namespaceObject.useContext)(dataform_context);
  const layout = normalizeLayout({
    ...field.layout,
    type: 'card'
  });
  const form = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    layout: DEFAULT_LAYOUT,
    fields: isCombinedField(field) ? field.children : []
  }), [field]);
  const {
    isOpen,
    CollapsibleCardHeader
  } = useCollapsibleCard(layout.isOpened);
  if (isCombinedField(field)) {
    const withHeader = !!field.label && layout.withHeader;
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Card, {
      className: "dataforms-layouts-card__field",
      children: [withHeader && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CollapsibleCardHeader, {
        className: "dataforms-layouts-card__field-label",
        children: field.label
      }), (isOpen || !withHeader) &&
      /*#__PURE__*/
      // If it doesn't have a header, keep it open.
      // Otherwise, the card will not be visible.
      (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.CardBody, {
        className: "dataforms-layouts-card__field-control",
        children: [field.description && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          className: "dataforms-layouts-card__field-description",
          children: field.description
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormLayout, {
          data: data,
          form: form,
          onChange: onChange
        })]
      })]
    });
  }
  const fieldDefinition = fields.find(fieldDef => fieldDef.id === field.id);
  if (!fieldDefinition || !fieldDefinition.Edit) {
    return null;
  }
  const RegularLayout = getFormFieldLayout('regular')?.component;
  if (!RegularLayout) {
    return null;
  }
  const withHeader = !!fieldDefinition.label && layout.withHeader;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Card, {
    className: "dataforms-layouts-card__field",
    children: [withHeader && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CollapsibleCardHeader, {
      className: "dataforms-layouts-card__field-label",
      children: fieldDefinition.label
    }), (isOpen || !withHeader) &&
    /*#__PURE__*/
    // If it doesn't have a header, keep it open.
    // Otherwise, the card will not be visible.
    (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CardBody, {
      className: "dataforms-layouts-card__field-control",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(RegularLayout, {
        data: data,
        field: field,
        onChange: onChange,
        hideLabelFromVision: hideLabelFromVision || withHeader
      })
    })]
  });
}

;// ./packages/dataviews/build-module/dataforms-layouts/index.js
/**
 * Internal dependencies
 */



const FORM_FIELD_LAYOUTS = [{
  type: 'regular',
  component: FormRegularField
}, {
  type: 'panel',
  component: FormPanelField
}, {
  type: 'card',
  component: FormCardField
}];
function getFormFieldLayout(type) {
  return FORM_FIELD_LAYOUTS.find(layout => layout.type === type);
}

;// ./packages/dataviews/build-module/dataforms-layouts/data-form-layout.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function DataFormLayout({
  data,
  form,
  onChange,
  children
}) {
  const {
    fields: fieldDefinitions
  } = (0,external_wp_element_namespaceObject.useContext)(dataform_context);
  function getFieldDefinition(field) {
    const fieldId = typeof field === 'string' ? field : field.id;
    return fieldDefinitions.find(fieldDefinition => fieldDefinition.id === fieldId);
  }
  const normalizedFormFields = (0,external_wp_element_namespaceObject.useMemo)(() => normalizeFormFields(form), [form]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
    spacing: form.layout?.type === 'panel' ? 2 : 4,
    children: normalizedFormFields.map(formField => {
      const FieldLayout = getFormFieldLayout(formField.layout.type)?.component;
      if (!FieldLayout) {
        return null;
      }
      const fieldDefinition = !isCombinedField(formField) ? getFieldDefinition(formField) : undefined;
      if (fieldDefinition && fieldDefinition.isVisible && !fieldDefinition.isVisible(data)) {
        return null;
      }
      if (children) {
        return children(FieldLayout, formField);
      }
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FieldLayout, {
        data: data,
        field: formField,
        onChange: onChange
      }, formField.id);
    })
  });
}

;// ./packages/dataviews/build-module/components/dataform/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function DataForm({
  data,
  form,
  fields,
  onChange
}) {
  const normalizedFields = (0,external_wp_element_namespaceObject.useMemo)(() => normalizeFields(fields), [fields]);
  if (!form.fields) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormProvider, {
    fields: normalizedFields,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataFormLayout, {
      data: data,
      form: form,
      onChange: onChange
    })
  });
}

;// ./packages/fields/build-module/actions/utils.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

function isTemplate(post) {
  return post.type === 'wp_template';
}
function isTemplatePart(post) {
  return post.type === 'wp_template_part';
}
function isTemplateOrTemplatePart(p) {
  return p.type === 'wp_template' || p.type === 'wp_template_part';
}
function getItemTitle(item) {
  if (typeof item.title === 'string') {
    return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(item.title);
  }
  if (item.title && 'rendered' in item.title) {
    return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(item.title.rendered);
  }
  if (item.title && 'raw' in item.title) {
    return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(item.title.raw);
  }
  return '';
}

/**
 * Check if a template is removable.
 *
 * @param template The template entity to check.
 * @return Whether the template is removable.
 */
function isTemplateRemovable(template) {
  if (!template) {
    return false;
  }
  // In patterns list page we map the templates parts to a different object
  // than the one returned from the endpoint. This is why we need to check for
  // two props whether is custom or has a theme file.
  return [template.source, template.source].includes('custom') && !Boolean(template.type === 'wp_template' && template?.plugin) && !template.has_theme_file;
}

;// ./packages/fields/build-module/fields/title/view.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BaseTitleView({
  item,
  className,
  children
}) {
  const renderedTitle = getItemTitle(item);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
    className: dist_clsx('fields-field__title', className),
    alignment: "center",
    justify: "flex-start",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      children: renderedTitle || (0,external_wp_i18n_namespaceObject.__)('(no title)')
    }), children]
  });
}
function TitleView({
  item
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BaseTitleView, {
    item: item
  });
}

;// ./packages/fields/build-module/fields/title/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const titleField = {
  type: 'text',
  id: 'title',
  label: (0,external_wp_i18n_namespaceObject.__)('Title'),
  placeholder: (0,external_wp_i18n_namespaceObject.__)('No title'),
  getValue: ({
    item
  }) => getItemTitle(item),
  render: TitleView,
  enableHiding: true,
  enableGlobalSearch: true,
  filterBy: false
};

/**
 * Title for the any entity with a `title` property.
 * For patterns, pages or templates you should use the respective field
 * because there are some differences in the rendering, labels, etc.
 */
/* harmony default export */ const title = (titleField);

;// ./packages/fields/build-module/actions/duplicate-post.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



const duplicate_post_fields = [title];
const formDuplicateAction = {
  fields: ['title']
};
const duplicatePost = {
  id: 'duplicate-post',
  label: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label'),
  isEligible({
    status
  }) {
    return status !== 'trash';
  },
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [item, setItem] = (0,external_wp_element_namespaceObject.useState)({
      ...items[0],
      title: (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: Existing post title */
      (0,external_wp_i18n_namespaceObject._x)('%s (Copy)', 'post'), getItemTitle(items[0]))
    });
    const [isCreatingPage, setIsCreatingPage] = (0,external_wp_element_namespaceObject.useState)(false);
    const {
      saveEntityRecord
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
    const {
      createSuccessNotice,
      createErrorNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    async function createPage(event) {
      event.preventDefault();
      if (isCreatingPage) {
        return;
      }
      const newItemObject = {
        status: 'draft',
        title: item.title,
        slug: item.title || (0,external_wp_i18n_namespaceObject.__)('No title'),
        comment_status: item.comment_status,
        content: typeof item.content === 'string' ? item.content : item.content.raw,
        excerpt: typeof item.excerpt === 'string' ? item.excerpt : item.excerpt?.raw,
        meta: item.meta,
        parent: item.parent,
        password: item.password,
        template: item.template,
        format: item.format,
        featured_media: item.featured_media,
        menu_order: item.menu_order,
        ping_status: item.ping_status
      };
      const assignablePropertiesPrefix = 'wp:action-assign-';
      // Get all the properties that the current user is able to assign normally author, categories, tags,
      // and custom taxonomies.
      const assignableProperties = Object.keys(item?._links || {}).filter(property => property.startsWith(assignablePropertiesPrefix)).map(property => property.slice(assignablePropertiesPrefix.length));
      assignableProperties.forEach(property => {
        if (item.hasOwnProperty(property)) {
          // @ts-ignore
          newItemObject[property] = item[property];
        }
      });
      setIsCreatingPage(true);
      try {
        const newItem = await saveEntityRecord('postType', item.type, newItemObject, {
          throwOnError: true
        });
        createSuccessNotice((0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: Title of the created post, e.g: "Hello world".
        (0,external_wp_i18n_namespaceObject.__)('"%s" successfully created.'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(newItem.title?.rendered || item.title)), {
          id: 'duplicate-post-action',
          type: 'snackbar'
        });
        if (onActionPerformed) {
          onActionPerformed([newItem]);
        }
      } catch (error) {
        const typedError = error;
        const errorMessage = typedError.message && typedError.code !== 'unknown_error' ? typedError.message : (0,external_wp_i18n_namespaceObject.__)('An error occurred while duplicating the page.');
        createErrorNotice(errorMessage, {
          type: 'snackbar'
        });
      } finally {
        setIsCreatingPage(false);
        closeModal?.();
      }
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
      onSubmit: createPage,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
        spacing: 3,
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataForm, {
          data: item,
          fields: duplicate_post_fields,
          form: formDuplicateAction,
          onChange: changes => setItem(prev => ({
            ...prev,
            ...changes
          }))
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
          spacing: 2,
          justify: "end",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            variant: "tertiary",
            onClick: closeModal,
            __next40pxDefaultSize: true,
            children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            variant: "primary",
            type: "submit",
            isBusy: isCreatingPage,
            "aria-disabled": isCreatingPage,
            __next40pxDefaultSize: true,
            children: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label')
          })]
        })]
      })
    });
  }
};

/**
 * Duplicate action for BasePost.
 */
/* harmony default export */ const duplicate_post = (duplicatePost);

;// ./packages/icons/build-module/library/check.js
/**
 * WordPress dependencies
 */


const check = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
  })
});
/* harmony default export */ const library_check = (check);

;// ./node_modules/tslib/tslib.es6.mjs
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* harmony default export */ const tslib_es6 = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});

;// ./node_modules/lower-case/dist.es2015/index.js
/**
 * Source: ftp://ftp.unicode.org/Public/UCD/latest/ucd/SpecialCasing.txt
 */
var SUPPORTED_LOCALE = {
    tr: {
        regexp: /\u0130|\u0049|\u0049\u0307/g,
        map: {
            İ: "\u0069",
            I: "\u0131",
            İ: "\u0069",
        },
    },
    az: {
        regexp: /\u0130/g,
        map: {
            İ: "\u0069",
            I: "\u0131",
            İ: "\u0069",
        },
    },
    lt: {
        regexp: /\u0049|\u004A|\u012E|\u00CC|\u00CD|\u0128/g,
        map: {
            I: "\u0069\u0307",
            J: "\u006A\u0307",
            Į: "\u012F\u0307",
            Ì: "\u0069\u0307\u0300",
            Í: "\u0069\u0307\u0301",
            Ĩ: "\u0069\u0307\u0303",
        },
    },
};
/**
 * Localized lower case.
 */
function localeLowerCase(str, locale) {
    var lang = SUPPORTED_LOCALE[locale.toLowerCase()];
    if (lang)
        return lowerCase(str.replace(lang.regexp, function (m) { return lang.map[m]; }));
    return lowerCase(str);
}
/**
 * Lower case as a function.
 */
function lowerCase(str) {
    return str.toLowerCase();
}

;// ./node_modules/no-case/dist.es2015/index.js

// Support camel case ("camelCase" -> "camel Case" and "CAMELCase" -> "CAMEL Case").
var DEFAULT_SPLIT_REGEXP = [/([a-z0-9])([A-Z])/g, /([A-Z])([A-Z][a-z])/g];
// Remove all non-word characters.
var DEFAULT_STRIP_REGEXP = /[^A-Z0-9]+/gi;
/**
 * Normalize the string into something other libraries can manipulate easier.
 */
function noCase(input, options) {
    if (options === void 0) { options = {}; }
    var _a = options.splitRegexp, splitRegexp = _a === void 0 ? DEFAULT_SPLIT_REGEXP : _a, _b = options.stripRegexp, stripRegexp = _b === void 0 ? DEFAULT_STRIP_REGEXP : _b, _c = options.transform, transform = _c === void 0 ? lowerCase : _c, _d = options.delimiter, delimiter = _d === void 0 ? " " : _d;
    var result = replace(replace(input, splitRegexp, "$1\0$2"), stripRegexp, "\0");
    var start = 0;
    var end = result.length;
    // Trim the delimiter from around the output string.
    while (result.charAt(start) === "\0")
        start++;
    while (result.charAt(end - 1) === "\0")
        end--;
    // Transform each token independently.
    return result.slice(start, end).split("\0").map(transform).join(delimiter);
}
/**
 * Replace `re` in the input string with the replacement value.
 */
function replace(input, re, value) {
    if (re instanceof RegExp)
        return input.replace(re, value);
    return re.reduce(function (input, re) { return input.replace(re, value); }, input);
}

;// ./node_modules/dot-case/dist.es2015/index.js


function dotCase(input, options) {
    if (options === void 0) { options = {}; }
    return noCase(input, __assign({ delimiter: "." }, options));
}

;// ./node_modules/param-case/dist.es2015/index.js


function paramCase(input, options) {
    if (options === void 0) { options = {}; }
    return dotCase(input, __assign({ delimiter: "-" }, options));
}

;// ./packages/fields/build-module/components/create-template-part-modal/utils.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const useExistingTemplateParts = () => {
  var _useSelect;
  return (_useSelect = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getEntityRecords('postType', 'wp_template_part', {
    per_page: -1
  }), [])) !== null && _useSelect !== void 0 ? _useSelect : [];
};

/**
 * Return a unique template part title based on
 * the given title and existing template parts.
 *
 * @param {string} title         The original template part title.
 * @param {Object} templateParts The array of template part entities.
 * @return {string} A unique template part title.
 */
const getUniqueTemplatePartTitle = (title, templateParts) => {
  const lowercaseTitle = title.toLowerCase();
  const existingTitles = templateParts.map(templatePart => templatePart.title.rendered.toLowerCase());
  if (!existingTitles.includes(lowercaseTitle)) {
    return title;
  }
  let suffix = 2;
  while (existingTitles.includes(`${lowercaseTitle} ${suffix}`)) {
    suffix++;
  }
  return `${title} ${suffix}`;
};

/**
 * Get a valid slug for a template part.
 * Currently template parts only allow latin chars.
 * The fallback slug will receive suffix by default.
 *
 * @param {string} title The template part title.
 * @return {string} A valid template part slug.
 */
const getCleanTemplatePartSlug = title => {
  return paramCase(title).replace(/[^\w-]+/g, '') || 'wp-custom-part';
};

;// ./packages/fields/build-module/components/create-template-part-modal/index.js
/**
 * WordPress dependencies
 */








// @ts-expect-error serialize is not typed


/**
 * Internal dependencies
 */


function getAreaRadioId(value, instanceId) {
  return `fields-create-template-part-modal__area-option-${value}-${instanceId}`;
}
function getAreaRadioDescriptionId(value, instanceId) {
  return `fields-create-template-part-modal__area-option-description-${value}-${instanceId}`;
}
/**
 * A React component that renders a modal for creating a template part. The modal displays a title and the contents for creating the template part.
 * This component should not live in this package, it should be moved to a dedicated package responsible for managing template.
 * @param {Object} props            The component props.
 * @param          props.modalTitle
 */
function CreateTemplatePartModal({
  modalTitle,
  ...restProps
}) {
  const defaultModalTitle = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getPostType('wp_template_part')?.labels?.add_new_item, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Modal, {
    title: modalTitle || defaultModalTitle,
    onRequestClose: restProps.closeModal,
    overlayClassName: "fields-create-template-part-modal",
    focusOnMount: "firstContentElement",
    size: "medium",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateTemplatePartModalContents, {
      ...restProps
    })
  });
}
const create_template_part_modal_getTemplatePartIcon = iconName => {
  if ('header' === iconName) {
    return library_header;
  } else if ('footer' === iconName) {
    return library_footer;
  } else if ('sidebar' === iconName) {
    return library_sidebar;
  }
  return symbol_filled;
};

/**
 * A React component that renders the content of a model for creating a template part.
 * This component should not live in this package; it should be moved to a dedicated package responsible for managing template.
 *
 * @param {Object}   props                             - The component props.
 * @param {string}   [props.defaultArea=uncategorized] - The default area for the template part.
 * @param {Array}    [props.blocks=[]]                 - The blocks to be included in the template part.
 * @param {string}   [props.confirmLabel='Add']        - The label for the confirm button.
 * @param {Function} props.closeModal                  - Function to close the modal.
 * @param {Function} props.onCreate                    - Function to call when the template part is successfully created.
 * @param {Function} [props.onError]                   - Function to call when there is an error creating the template part.
 * @param {string}   [props.defaultTitle='']           - The default title for the template part.
 */
function CreateTemplatePartModalContents({
  defaultArea = 'uncategorized',
  blocks = [],
  confirmLabel = (0,external_wp_i18n_namespaceObject.__)('Add'),
  closeModal,
  onCreate,
  onError,
  defaultTitle = ''
}) {
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    saveEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const existingTemplateParts = useExistingTemplateParts();
  const [title, setTitle] = (0,external_wp_element_namespaceObject.useState)(defaultTitle);
  const [area, setArea] = (0,external_wp_element_namespaceObject.useState)(defaultArea);
  const [isSubmitting, setIsSubmitting] = (0,external_wp_element_namespaceObject.useState)(false);
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(CreateTemplatePartModal);
  const defaultTemplatePartAreas = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.default_template_part_areas, []);
  async function createTemplatePart() {
    if (!title || isSubmitting) {
      return;
    }
    try {
      setIsSubmitting(true);
      const uniqueTitle = getUniqueTemplatePartTitle(title, existingTemplateParts);
      const cleanSlug = getCleanTemplatePartSlug(uniqueTitle);
      const templatePart = await saveEntityRecord('postType', 'wp_template_part', {
        slug: cleanSlug,
        title: uniqueTitle,
        content: (0,external_wp_blocks_namespaceObject.serialize)(blocks),
        area
      }, {
        throwOnError: true
      });
      await onCreate(templatePart);

      // TODO: Add a success notice?
    } catch (error) {
      const errorMessage = error instanceof Error && 'code' in error && error.message && error.code !== 'unknown_error' ? error.message : (0,external_wp_i18n_namespaceObject.__)('An error occurred while creating the template part.');
      createErrorNotice(errorMessage, {
        type: 'snackbar'
      });
      onError?.();
    } finally {
      setIsSubmitting(false);
    }
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
    onSubmit: async event => {
      event.preventDefault();
      await createTemplatePart();
    },
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "4",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
        __next40pxDefaultSize: true,
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)('Name'),
        value: title,
        onChange: setTitle,
        required: true
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
        className: "fields-create-template-part-modal__area-fieldset",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
          as: "legend",
          children: (0,external_wp_i18n_namespaceObject.__)('Area')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          className: "fields-create-template-part-modal__area-radio-group",
          children: (defaultTemplatePartAreas !== null && defaultTemplatePartAreas !== void 0 ? defaultTemplatePartAreas : []).map(item => {
            const icon = create_template_part_modal_getTemplatePartIcon(item.icon);
            return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
              className: "fields-create-template-part-modal__area-radio-wrapper",
              children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("input", {
                type: "radio",
                id: getAreaRadioId(item.area, instanceId),
                name: `fields-create-template-part-modal__area-${instanceId}`,
                value: item.area,
                checked: area === item.area,
                onChange: () => {
                  setArea(item.area);
                },
                "aria-describedby": getAreaRadioDescriptionId(item.area, instanceId)
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Icon, {
                icon: icon,
                className: "fields-create-template-part-modal__area-radio-icon"
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("label", {
                htmlFor: getAreaRadioId(item.area, instanceId),
                className: "fields-create-template-part-modal__area-radio-label",
                children: item.label
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Icon, {
                icon: library_check,
                className: "fields-create-template-part-modal__area-radio-checkmark"
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
                className: "fields-create-template-part-modal__area-radio-description",
                id: getAreaRadioDescriptionId(item.area, instanceId),
                children: item.description
              })]
            }, item.area);
          })
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "tertiary",
          onClick: () => {
            closeModal();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "primary",
          type: "submit",
          "aria-disabled": !title || isSubmitting,
          isBusy: isSubmitting,
          children: confirmLabel
        })]
      })]
    })
  });
}

;// ./packages/fields/build-module/actions/duplicate-template-part.js
/**
 * WordPress dependencies
 */




// @ts-ignore


/**
 * Internal dependencies
 */




/**
 * This action is used to duplicate a template part.
 */

const duplicateTemplatePart = {
  id: 'duplicate-template-part',
  label: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label'),
  isEligible: item => item.type === 'wp_template_part',
  modalHeader: (0,external_wp_i18n_namespaceObject._x)('Duplicate template part', 'action label'),
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal
  }) => {
    const [item] = items;
    const blocks = (0,external_wp_element_namespaceObject.useMemo)(() => {
      var _item$blocks;
      return (_item$blocks = item.blocks) !== null && _item$blocks !== void 0 ? _item$blocks : (0,external_wp_blocks_namespaceObject.parse)(typeof item.content === 'string' ? item.content : item.content.raw, {
        __unstableSkipMigrationLogs: true
      });
    }, [item.content, item.blocks]);
    const {
      createSuccessNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    function onTemplatePartSuccess(templatePart) {
      createSuccessNotice((0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: The new template part's title e.g. 'Call to action (copy)'.
      (0,external_wp_i18n_namespaceObject._x)('"%s" duplicated.', 'template part'), getItemTitle(templatePart)), {
        type: 'snackbar',
        id: 'edit-site-patterns-success'
      });
      closeModal?.();
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateTemplatePartModalContents, {
      blocks: blocks,
      defaultArea: item.area,
      defaultTitle: (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: Existing template part title */
      (0,external_wp_i18n_namespaceObject._x)('%s (Copy)', 'template part'), getItemTitle(item)),
      onCreate: onTemplatePartSuccess,
      onError: closeModal,
      confirmLabel: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label'),
      closeModal: closeModal !== null && closeModal !== void 0 ? closeModal : () => {}
    });
  }
};
/**
 * Duplicate action for TemplatePart.
 */
/* harmony default export */ const duplicate_template_part = (duplicateTemplatePart);

;// external ["wp","patterns"]
const external_wp_patterns_namespaceObject = window["wp"]["patterns"];
;// ./packages/fields/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock: build_module_lock_unlock_lock,
  unlock: build_module_lock_unlock_unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I acknowledge private features are not for use in themes or plugins and doing so will break in the next version of WordPress.', '@wordpress/fields');

;// ./packages/fields/build-module/actions/duplicate-pattern.js
/**
 * WordPress dependencies
 */

// @ts-ignore

/**
 * Internal dependencies
 */


// Patterns.
const {
  CreatePatternModalContents,
  useDuplicatePatternProps
} = build_module_lock_unlock_unlock(external_wp_patterns_namespaceObject.privateApis);
const duplicatePattern = {
  id: 'duplicate-pattern',
  label: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label'),
  isEligible: item => item.type !== 'wp_template_part',
  modalHeader: (0,external_wp_i18n_namespaceObject._x)('Duplicate pattern', 'action label'),
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal
  }) => {
    const [item] = items;
    const duplicatedProps = useDuplicatePatternProps({
      pattern: item,
      onSuccess: () => closeModal?.()
    });
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreatePatternModalContents, {
      onClose: closeModal,
      confirmLabel: (0,external_wp_i18n_namespaceObject._x)('Duplicate', 'action label'),
      ...duplicatedProps
    });
  }
};

/**
 * Duplicate action for Pattern.
 */
/* harmony default export */ const duplicate_pattern = (duplicatePattern);

;// ./packages/fields/build-module/actions/rename-post.js
/**
 * WordPress dependencies
 */




// @ts-ignore




/**
 * Internal dependencies
 */




// Patterns.
const {
  PATTERN_TYPES
} = build_module_lock_unlock_unlock(external_wp_patterns_namespaceObject.privateApis);
const renamePost = {
  id: 'rename-post',
  label: (0,external_wp_i18n_namespaceObject.__)('Rename'),
  modalFocusOnMount: 'firstContentElement',
  isEligible(post) {
    if (post.status === 'trash') {
      return false;
    }
    // Templates, template parts and patterns have special checks for renaming.
    if (!['wp_template', 'wp_template_part', ...Object.values(PATTERN_TYPES)].includes(post.type)) {
      return post.permissions?.update;
    }

    // In the case of templates, we can only rename custom templates.
    if (isTemplate(post)) {
      return isTemplateRemovable(post) && post.is_custom && post.permissions?.update;
    }
    if (isTemplatePart(post)) {
      return post.source === 'custom' && !post?.has_theme_file && post.permissions?.update;
    }
    return post.type === PATTERN_TYPES.user && post.permissions?.update;
  },
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [item] = items;
    const [title, setTitle] = (0,external_wp_element_namespaceObject.useState)(() => getItemTitle(item));
    const {
      editEntityRecord,
      saveEditedEntityRecord
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
    const {
      createSuccessNotice,
      createErrorNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    async function onRename(event) {
      event.preventDefault();
      try {
        await editEntityRecord('postType', item.type, item.id, {
          title
        });
        // Update state before saving rerenders the list.
        setTitle('');
        closeModal?.();
        // Persist edited entity.
        await saveEditedEntityRecord('postType', item.type, item.id, {
          throwOnError: true
        });
        createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Name updated'), {
          type: 'snackbar'
        });
        onActionPerformed?.(items);
      } catch (error) {
        const typedError = error;
        const errorMessage = typedError.message && typedError.code !== 'unknown_error' ? typedError.message : (0,external_wp_i18n_namespaceObject.__)('An error occurred while updating the name');
        createErrorNotice(errorMessage, {
          type: 'snackbar'
        });
      }
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
      onSubmit: onRename,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
        spacing: "5",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
          __nextHasNoMarginBottom: true,
          __next40pxDefaultSize: true,
          label: (0,external_wp_i18n_namespaceObject.__)('Name'),
          value: title,
          onChange: setTitle,
          required: true
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
          justify: "right",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "tertiary",
            onClick: () => {
              closeModal?.();
            },
            children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "primary",
            type: "submit",
            children: (0,external_wp_i18n_namespaceObject.__)('Save')
          })]
        })]
      })
    });
  }
};

/**
 * Rename action for PostWithPermissions.
 */
/* harmony default export */ const rename_post = (renamePost);

;// ./packages/dataviews/build-module/validation.js
/**
 * Internal dependencies
 */

/**
 * Whether or not the given item's value is valid according to the fields and form config.
 *
 * @param item   The item to validate.
 * @param fields Fields config.
 * @param form   Form config.
 *
 * @return A boolean indicating if the item is valid (true) or not (false).
 */
function isItemValid(item, fields, form) {
  const _fields = normalizeFields(fields.filter(({
    id
  }) => !!form.fields?.includes(id)));
  const isEmptyNullOrUndefined = value => [undefined, '', null].includes(value);
  return _fields.every(field => {
    const value = field.getValue({
      item
    });
    if (field.isValid.required) {
      if (field.type === 'text' && isEmptyNullOrUndefined(value) || field.type === 'email' && isEmptyNullOrUndefined(value) || field.type === 'integer' && isEmptyNullOrUndefined(value) || field.type === undefined && isEmptyNullOrUndefined(value)) {
        return false;
      }
      if (field.type === 'boolean' && value !== true) {
        return false;
      }
    }
    if (typeof field.isValid.custom === 'function' && field.isValid.custom(item, field) !== null) {
      return false;
    }
    return true;
  });
}

;// ./packages/fields/build-module/fields/order/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const orderField = {
  id: 'menu_order',
  type: 'integer',
  label: (0,external_wp_i18n_namespaceObject.__)('Order'),
  description: (0,external_wp_i18n_namespaceObject.__)('Determines the order of pages.'),
  filterBy: false,
  isValid: {
    required: true
  }
};

/**
 * Order field for BasePost.
 */
/* harmony default export */ const order = (orderField);

;// ./packages/fields/build-module/actions/reorder-page.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



const reorder_page_fields = [order];
const formOrderAction = {
  fields: ['menu_order']
};
function ReorderModal({
  items,
  closeModal,
  onActionPerformed
}) {
  const [item, setItem] = (0,external_wp_element_namespaceObject.useState)(items[0]);
  const orderInput = item.menu_order;
  const {
    editEntityRecord,
    saveEditedEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const {
    createSuccessNotice,
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  async function onOrder(event) {
    event.preventDefault();
    if (!isItemValid(item, reorder_page_fields, formOrderAction)) {
      return;
    }
    try {
      await editEntityRecord('postType', item.type, item.id, {
        menu_order: orderInput
      });
      closeModal?.();
      // Persist edited entity.
      await saveEditedEntityRecord('postType', item.type, item.id, {
        throwOnError: true
      });
      createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Order updated.'), {
        type: 'snackbar'
      });
      onActionPerformed?.(items);
    } catch (error) {
      const typedError = error;
      const errorMessage = typedError.message && typedError.code !== 'unknown_error' ? typedError.message : (0,external_wp_i18n_namespaceObject.__)('An error occurred while updating the order');
      createErrorNotice(errorMessage, {
        type: 'snackbar'
      });
    }
  }
  const isSaveDisabled = !isItemValid(item, reorder_page_fields, formOrderAction);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
    onSubmit: onOrder,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "5",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        children: (0,external_wp_i18n_namespaceObject.__)('Determines the order of pages. Pages with the same order value are sorted alphabetically. Negative order values are supported.')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DataForm, {
        data: item,
        fields: reorder_page_fields,
        form: formOrderAction,
        onChange: changes => setItem({
          ...item,
          ...changes
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "tertiary",
          onClick: () => {
            closeModal?.();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "primary",
          type: "submit",
          accessibleWhenDisabled: true,
          disabled: isSaveDisabled,
          children: (0,external_wp_i18n_namespaceObject.__)('Save')
        })]
      })]
    })
  });
}
const reorderPage = {
  id: 'order-pages',
  label: (0,external_wp_i18n_namespaceObject.__)('Order'),
  isEligible({
    status
  }) {
    return status !== 'trash';
  },
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ReorderModal
};

/**
 * Reorder action for BasePost.
 */
/* harmony default export */ const reorder_page = (reorderPage);

;// ./node_modules/client-zip/index.js
"stream"in Blob.prototype||Object.defineProperty(Blob.prototype,"stream",{value(){return new Response(this).body}}),"setBigUint64"in DataView.prototype||Object.defineProperty(DataView.prototype,"setBigUint64",{value(e,n,t){const i=Number(0xffffffffn&n),r=Number(n>>32n);this.setUint32(e+(t?0:4),i,t),this.setUint32(e+(t?4:0),r,t)}});var e=e=>new DataView(new ArrayBuffer(e)),n=e=>new Uint8Array(e.buffer||e),t=e=>(new TextEncoder).encode(String(e)),i=e=>Math.min(4294967295,Number(e)),client_zip_r=e=>Math.min(65535,Number(e));function f(e,i){if(void 0===i||i instanceof Date||(i=new Date(i)),e instanceof File)return{isFile:1,t:i||new Date(e.lastModified),i:e.stream()};if(e instanceof Response)return{isFile:1,t:i||new Date(e.headers.get("Last-Modified")||Date.now()),i:e.body};if(void 0===i)i=new Date;else if(isNaN(i))throw new Error("Invalid modification date.");if(void 0===e)return{isFile:0,t:i};if("string"==typeof e)return{isFile:1,t:i,i:t(e)};if(e instanceof Blob)return{isFile:1,t:i,i:e.stream()};if(e instanceof Uint8Array||e instanceof ReadableStream)return{isFile:1,t:i,i:e};if(e instanceof ArrayBuffer||ArrayBuffer.isView(e))return{isFile:1,t:i,i:n(e)};if(Symbol.asyncIterator in e)return{isFile:1,t:i,i:o(e[Symbol.asyncIterator]())};throw new TypeError("Unsupported input format.")}function o(e,n=e){return new ReadableStream({async pull(n){let t=0;for(;n.desiredSize>t;){const i=await e.next();if(!i.value){n.close();break}{const e=a(i.value);n.enqueue(e),t+=e.byteLength}}},cancel(e){n.throw?.(e)}})}function a(e){return"string"==typeof e?t(e):e instanceof Uint8Array?e:n(e)}function s(e,i,r){let[f,o]=function(e){return e?e instanceof Uint8Array?[e,1]:ArrayBuffer.isView(e)||e instanceof ArrayBuffer?[n(e),1]:[t(e),0]:[void 0,0]}(i);if(e instanceof File)return{o:d(f||t(e.name)),u:BigInt(e.size),l:o};if(e instanceof Response){const n=e.headers.get("content-disposition"),i=n&&n.match(/;\s*filename\*?=["']?(.*?)["']?$/i),a=i&&i[1]||e.url&&new URL(e.url).pathname.split("/").findLast(Boolean),s=a&&decodeURIComponent(a),u=r||+e.headers.get("content-length");return{o:d(f||t(s)),u:BigInt(u),l:o}}return f=d(f,void 0!==e||void 0!==r),"string"==typeof e?{o:f,u:BigInt(t(e).length),l:o}:e instanceof Blob?{o:f,u:BigInt(e.size),l:o}:e instanceof ArrayBuffer||ArrayBuffer.isView(e)?{o:f,u:BigInt(e.byteLength),l:o}:{o:f,u:u(e,r),l:o}}function u(e,n){return n>-1?BigInt(n):e?void 0:0n}function d(e,n=1){if(!e||e.every((c=>47===c)))throw new Error("The file must have a name.");if(n)for(;47===e[e.length-1];)e=e.subarray(0,-1);else 47!==e[e.length-1]&&(e=new Uint8Array([...e,47]));return e}var l=new Uint32Array(256);for(let e=0;e<256;++e){let n=e;for(let e=0;e<8;++e)n=n>>>1^(1&n&&3988292384);l[e]=n}function y(e,n=0){n^=-1;for(var t=0,i=e.length;t<i;t++)n=n>>>8^l[255&n^e[t]];return(-1^n)>>>0}function w(e,n,t=0){const i=e.getSeconds()>>1|e.getMinutes()<<5|e.getHours()<<11,r=e.getDate()|e.getMonth()+1<<5|e.getFullYear()-1980<<9;n.setUint16(t,i,1),n.setUint16(t+2,r,1)}function B({o:e,l:n},t){return 8*(!n||(t??function(e){try{b.decode(e)}catch{return 0}return 1}(e)))}var b=new TextDecoder("utf8",{fatal:1});function p(t,i=0){const r=e(30);return r.setUint32(0,1347093252),r.setUint32(4,754976768|i),w(t.t,r,10),r.setUint16(26,t.o.length,1),n(r)}async function*g(e){let{i:n}=e;if("then"in n&&(n=await n),n instanceof Uint8Array)yield n,e.m=y(n,0),e.u=BigInt(n.length);else{e.u=0n;const t=n.getReader();for(;;){const{value:n,done:i}=await t.read();if(i)break;e.m=y(n,e.m),e.u+=BigInt(n.length),yield n}}}function I(t,r){const f=e(16+(r?8:0));return f.setUint32(0,1347094280),f.setUint32(4,t.isFile?t.m:0,1),r?(f.setBigUint64(8,t.u,1),f.setBigUint64(16,t.u,1)):(f.setUint32(8,i(t.u),1),f.setUint32(12,i(t.u),1)),n(f)}function v(t,r,f=0,o=0){const a=e(46);return a.setUint32(0,1347092738),a.setUint32(4,755182848),a.setUint16(8,2048|f),w(t.t,a,12),a.setUint32(16,t.isFile?t.m:0,1),a.setUint32(20,i(t.u),1),a.setUint32(24,i(t.u),1),a.setUint16(28,t.o.length,1),a.setUint16(30,o,1),a.setUint16(40,t.isFile?33204:16893,1),a.setUint32(42,i(r),1),n(a)}function h(t,i,r){const f=e(r);return f.setUint16(0,1,1),f.setUint16(2,r-4,1),16&r&&(f.setBigUint64(4,t.u,1),f.setBigUint64(12,t.u,1)),f.setBigUint64(r-8,i,1),n(f)}function D(e){return e instanceof File||e instanceof Response?[[e],[e]]:[[e.input,e.name,e.size],[e.input,e.lastModified]]}var S=e=>function(e){let n=BigInt(22),t=0n,i=0;for(const r of e){if(!r.o)throw new Error("Every file must have a non-empty name.");if(void 0===r.u)throw new Error(`Missing size for file "${(new TextDecoder).decode(r.o)}".`);const e=r.u>=0xffffffffn,f=t>=0xffffffffn;t+=BigInt(46+r.o.length+(e&&8))+r.u,n+=BigInt(r.o.length+46+(12*f|28*e)),i||(i=e)}return(i||t>=0xffffffffn)&&(n+=BigInt(76)),n+t}(function*(e){for(const n of e)yield s(...D(n)[0])}(e));function A(e,n={}){const t={"Content-Type":"application/zip","Content-Disposition":"attachment"};return("bigint"==typeof n.length||Number.isInteger(n.length))&&n.length>0&&(t["Content-Length"]=String(n.length)),n.metadata&&(t["Content-Length"]=String(S(n.metadata))),new Response(N(e,n),{headers:t})}function N(t,a={}){const u=function(e){const n=e[Symbol.iterator in e?Symbol.iterator:Symbol.asyncIterator]();return{async next(){const e=await n.next();if(e.done)return e;const[t,i]=D(e.value);return{done:0,value:Object.assign(f(...i),s(...t))}},throw:n.throw?.bind(n),[Symbol.asyncIterator](){return this}}}(t);return o(async function*(t,f){const o=[];let a=0n,s=0n,u=0;for await(const e of t){const n=B(e,f.buffersAreUTF8);yield p(e,n),yield new Uint8Array(e.o),e.isFile&&(yield*g(e));const t=e.u>=0xffffffffn,i=12*(a>=0xffffffffn)|28*t;yield I(e,t),o.push(v(e,a,n,i)),o.push(e.o),i&&o.push(h(e,a,i)),t&&(a+=8n),s++,a+=BigInt(46+e.o.length)+e.u,u||(u=t)}let d=0n;for(const e of o)yield e,d+=BigInt(e.length);if(u||a>=0xffffffffn){const t=e(76);t.setUint32(0,1347094022),t.setBigUint64(4,BigInt(44),1),t.setUint32(12,755182848),t.setBigUint64(24,s,1),t.setBigUint64(32,s,1),t.setBigUint64(40,d,1),t.setBigUint64(48,a,1),t.setUint32(56,1347094023),t.setBigUint64(64,a+d,1),t.setUint32(72,1,1),yield n(t)}const l=e(22);l.setUint32(0,1347093766),l.setUint16(8,client_zip_r(s),1),l.setUint16(10,client_zip_r(s),1),l.setUint32(12,i(d),1),l.setUint32(16,i(a),1),yield n(l)}(u,a),u)}
;// external ["wp","blob"]
const external_wp_blob_namespaceObject = window["wp"]["blob"];
;// ./packages/icons/build-module/library/download.js
/**
 * WordPress dependencies
 */


const download = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18 11.3l-1-1.1-4 4V3h-1.5v11.3L7 10.2l-1 1.1 6.2 5.8 5.8-5.8zm.5 3.7v3.5h-13V15H4v5h16v-5h-1.5z"
  })
});
/* harmony default export */ const library_download = (download);

;// ./packages/fields/build-module/actions/export-pattern.js
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function getJsonFromItem(item) {
  return JSON.stringify({
    __file: item.type,
    title: getItemTitle(item),
    content: typeof item.content === 'string' ? item.content : item.content?.raw,
    syncStatus: item.wp_pattern_sync_status
  }, null, 2);
}
const exportPattern = {
  id: 'export-pattern',
  label: (0,external_wp_i18n_namespaceObject.__)('Export as JSON'),
  icon: library_download,
  supportsBulk: true,
  isEligible: item => item.type === 'wp_block',
  callback: async items => {
    if (items.length === 1) {
      return (0,external_wp_blob_namespaceObject.downloadBlob)(`${paramCase(getItemTitle(items[0]) || items[0].slug)}.json`, getJsonFromItem(items[0]), 'application/json');
    }
    const nameCount = {};
    const filesToZip = items.map(item => {
      const name = paramCase(getItemTitle(item) || item.slug);
      nameCount[name] = (nameCount[name] || 0) + 1;
      return {
        name: `${name + (nameCount[name] > 1 ? '-' + (nameCount[name] - 1) : '')}.json`,
        lastModified: new Date(),
        input: getJsonFromItem(item)
      };
    });
    return (0,external_wp_blob_namespaceObject.downloadBlob)((0,external_wp_i18n_namespaceObject.__)('patterns-export') + '.zip', await A(filesToZip).blob(), 'application/zip');
  }
};

/**
 * Export action as JSON for Pattern.
 */
/* harmony default export */ const export_pattern = (exportPattern);

;// ./packages/icons/build-module/library/backup.js
/**
 * WordPress dependencies
 */


const backup = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M5.5 12h1.75l-2.5 3-2.5-3H4a8 8 0 113.134 6.35l.907-1.194A6.5 6.5 0 105.5 12zm9.53 1.97l-2.28-2.28V8.5a.75.75 0 00-1.5 0V12a.747.747 0 00.218.529l1.282-.84-1.28.842 2.5 2.5a.75.75 0 101.06-1.061z"
  })
});
/* harmony default export */ const library_backup = (backup);

;// ./packages/fields/build-module/actions/restore-post.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

const restorePost = {
  id: 'restore',
  label: (0,external_wp_i18n_namespaceObject.__)('Restore'),
  isPrimary: true,
  icon: library_backup,
  supportsBulk: true,
  isEligible(item) {
    return !isTemplateOrTemplatePart(item) && item.type !== 'wp_block' && item.status === 'trash' && item.permissions?.update;
  },
  async callback(posts, {
    registry,
    onActionPerformed
  }) {
    const {
      createSuccessNotice,
      createErrorNotice
    } = registry.dispatch(external_wp_notices_namespaceObject.store);
    const {
      editEntityRecord,
      saveEditedEntityRecord
    } = registry.dispatch(external_wp_coreData_namespaceObject.store);
    await Promise.allSettled(posts.map(post => {
      return editEntityRecord('postType', post.type, post.id, {
        status: 'draft'
      });
    }));
    const promiseResult = await Promise.allSettled(posts.map(post => {
      return saveEditedEntityRecord('postType', post.type, post.id, {
        throwOnError: true
      });
    }));
    if (promiseResult.every(({
      status
    }) => status === 'fulfilled')) {
      let successMessage;
      if (posts.length === 1) {
        successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The number of posts. */
        (0,external_wp_i18n_namespaceObject.__)('"%s" has been restored.'), getItemTitle(posts[0]));
      } else if (posts[0].type === 'page') {
        successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: The number of posts. */
        (0,external_wp_i18n_namespaceObject.__)('%d pages have been restored.'), posts.length);
      } else {
        successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: The number of posts. */
        (0,external_wp_i18n_namespaceObject.__)('%d posts have been restored.'), posts.length);
      }
      createSuccessNotice(successMessage, {
        type: 'snackbar',
        id: 'restore-post-action'
      });
      if (onActionPerformed) {
        onActionPerformed(posts);
      }
    } else {
      // If there was at lease one failure.
      let errorMessage;
      // If we were trying to move a single post to the trash.
      if (promiseResult.length === 1) {
        const typedError = promiseResult[0];
        if (typedError.reason?.message) {
          errorMessage = typedError.reason.message;
        } else {
          errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while restoring the post.');
        }
        // If we were trying to move multiple posts to the trash
      } else {
        const errorMessages = new Set();
        const failedPromises = promiseResult.filter(({
          status
        }) => status === 'rejected');
        for (const failedPromise of failedPromises) {
          const typedError = failedPromise;
          if (typedError.reason?.message) {
            errorMessages.add(typedError.reason.message);
          }
        }
        if (errorMessages.size === 0) {
          errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while restoring the posts.');
        } else if (errorMessages.size === 1) {
          errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
          (0,external_wp_i18n_namespaceObject.__)('An error occurred while restoring the posts: %s'), [...errorMessages][0]);
        } else {
          errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
          (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while restoring the posts: %s'), [...errorMessages].join(','));
        }
      }
      createErrorNotice(errorMessage, {
        type: 'snackbar'
      });
    }
  }
};

/**
 * Restore action for PostWithPermissions.
 */
/* harmony default export */ const restore_post = (restorePost);

;// ./packages/fields/build-module/actions/reset-post.js
/**
 * WordPress dependencies
 */






// @ts-ignore





/**
 * Internal dependencies
 */


const reset_post_isTemplateRevertable = templateOrTemplatePart => {
  if (!templateOrTemplatePart) {
    return false;
  }
  return templateOrTemplatePart.source === 'custom' && (Boolean(templateOrTemplatePart?.plugin) || templateOrTemplatePart?.has_theme_file);
};

/**
 *  Copied - pasted from https://github.com/WordPress/gutenberg/blob/bf1462ad37d4637ebbf63270b9c244b23c69e2a8/packages/editor/src/store/private-actions.js#L233-L365
 *
 * @param {Object}  template            The template to revert.
 * @param {Object}  [options]
 * @param {boolean} [options.allowUndo] Whether to allow the user to undo
 *                                      reverting the template. Default true.
 */
const revertTemplate = async (template, {
  allowUndo = true
} = {}) => {
  const noticeId = 'edit-site-template-reverted';
  (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).removeNotice(noticeId);
  if (!reset_post_isTemplateRevertable(template)) {
    (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('This template is not revertable.'), {
      type: 'snackbar'
    });
    return;
  }
  try {
    const templateEntityConfig = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store).getEntityConfig('postType', template.type);
    if (!templateEntityConfig) {
      (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('The editor has encountered an unexpected error. Please reload.'), {
        type: 'snackbar'
      });
      return;
    }
    const fileTemplatePath = (0,external_wp_url_namespaceObject.addQueryArgs)(`${templateEntityConfig.baseURL}/${template.id}`, {
      context: 'edit',
      source: template.origin
    });
    const fileTemplate = await external_wp_apiFetch_default()({
      path: fileTemplatePath
    });
    if (!fileTemplate) {
      (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('The editor has encountered an unexpected error. Please reload.'), {
        type: 'snackbar'
      });
      return;
    }
    const serializeBlocks = ({
      blocks: blocksForSerialization = []
    }) => (0,external_wp_blocks_namespaceObject.__unstableSerializeAndClean)(blocksForSerialization);
    const edited = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', template.type, template.id);

    // We are fixing up the undo level here to make sure we can undo
    // the revert in the header toolbar correctly.
    (0,external_wp_data_namespaceObject.dispatch)(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, template.id, {
      content: serializeBlocks,
      // Required to make the `undo` behave correctly.
      blocks: edited.blocks,
      // Required to revert the blocks in the editor.
      source: 'custom' // required to avoid turning the editor into a dirty state
    }, {
      undoIgnore: true // Required to merge this edit with the last undo level.
    });
    const blocks = (0,external_wp_blocks_namespaceObject.parse)(fileTemplate?.content?.raw);
    (0,external_wp_data_namespaceObject.dispatch)(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, fileTemplate.id, {
      content: serializeBlocks,
      blocks,
      source: 'theme'
    });
    if (allowUndo) {
      const undoRevert = () => {
        (0,external_wp_data_namespaceObject.dispatch)(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, edited.id, {
          content: serializeBlocks,
          blocks: edited.blocks,
          source: 'custom'
        });
      };
      (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Template reset.'), {
        type: 'snackbar',
        id: noticeId,
        actions: [{
          label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
          onClick: undoRevert
        }]
      });
    }
  } catch (error) {
    const errorMessage = error.message && error.code !== 'unknown_error' ? error.message : (0,external_wp_i18n_namespaceObject.__)('Template revert failed. Please reload.');
    (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store).createErrorNotice(errorMessage, {
      type: 'snackbar'
    });
  }
};
const resetPostAction = {
  id: 'reset-post',
  label: (0,external_wp_i18n_namespaceObject.__)('Reset'),
  isEligible: item => {
    return isTemplateOrTemplatePart(item) && item?.source === 'custom' && (Boolean(item.type === 'wp_template' && item?.plugin) || item?.has_theme_file);
  },
  icon: library_backup,
  supportsBulk: true,
  hideModalHeader: true,
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [isBusy, setIsBusy] = (0,external_wp_element_namespaceObject.useState)(false);
    const {
      saveEditedEntityRecord
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
    const {
      createSuccessNotice,
      createErrorNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    const onConfirm = async () => {
      try {
        for (const template of items) {
          await revertTemplate(template, {
            allowUndo: false
          });
          await saveEditedEntityRecord('postType', template.type, template.id);
        }
        createSuccessNotice(items.length > 1 ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: The number of items. */
        (0,external_wp_i18n_namespaceObject.__)('%d items reset.'), items.length) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The template/part's name. */
        (0,external_wp_i18n_namespaceObject.__)('"%s" reset.'), getItemTitle(items[0])), {
          type: 'snackbar',
          id: 'revert-template-action'
        });
      } catch (error) {
        let fallbackErrorMessage;
        if (items[0].type === 'wp_template') {
          fallbackErrorMessage = items.length === 1 ? (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the template.') : (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the templates.');
        } else {
          fallbackErrorMessage = items.length === 1 ? (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the template part.') : (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the template parts.');
        }
        const typedError = error;
        const errorMessage = typedError.message && typedError.code !== 'unknown_error' ? typedError.message : fallbackErrorMessage;
        createErrorNotice(errorMessage, {
          type: 'snackbar'
        });
      }
    };
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "5",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
        children: (0,external_wp_i18n_namespaceObject.__)('Reset to default and clear all customizations?')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "tertiary",
          onClick: closeModal,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "primary",
          onClick: async () => {
            setIsBusy(true);
            await onConfirm();
            onActionPerformed?.(items);
            setIsBusy(false);
            closeModal?.();
          },
          isBusy: isBusy,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Reset')
        })]
      })]
    });
  }
};

/**
 * Reset action for Template and TemplatePart.
 */
/* harmony default export */ const reset_post = (resetPostAction);

;// ./packages/icons/build-module/library/trash.js
/**
 * WordPress dependencies
 */


const trash = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 5.5A2.25 2.25 0 0 0 9.878 7h4.244A2.251 2.251 0 0 0 12 5.5ZM12 4a3.751 3.751 0 0 0-3.675 3H5v1.5h1.27l.818 8.997a2.75 2.75 0 0 0 2.739 2.501h4.347a2.75 2.75 0 0 0 2.738-2.5L17.73 8.5H19V7h-3.325A3.751 3.751 0 0 0 12 4Zm4.224 4.5H7.776l.806 8.861a1.25 1.25 0 0 0 1.245 1.137h4.347a1.25 1.25 0 0 0 1.245-1.137l.805-8.861Z"
  })
});
/* harmony default export */ const library_trash = (trash);

;// ./packages/fields/build-module/mutation/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

function getErrorMessagesFromPromises(allSettledResults) {
  const errorMessages = new Set();
  // If there was at lease one failure.
  if (allSettledResults.length === 1) {
    const typedError = allSettledResults[0];
    if (typedError.reason?.message) {
      errorMessages.add(typedError.reason.message);
    }
  } else {
    const failedPromises = allSettledResults.filter(({
      status
    }) => status === 'rejected');
    for (const failedPromise of failedPromises) {
      const typedError = failedPromise;
      if (typedError.reason?.message) {
        errorMessages.add(typedError.reason.message);
      }
    }
  }
  return errorMessages;
}
const deletePostWithNotices = async (posts, notice, callbacks) => {
  const {
    createSuccessNotice,
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.dispatch)(external_wp_notices_namespaceObject.store);
  const {
    deleteEntityRecord
  } = (0,external_wp_data_namespaceObject.dispatch)(external_wp_coreData_namespaceObject.store);
  const allSettledResults = await Promise.allSettled(posts.map(post => {
    return deleteEntityRecord('postType', post.type, post.id, {
      force: true
    }, {
      throwOnError: true
    });
  }));
  // If all the promises were fulfilled with success.
  if (allSettledResults.every(({
    status
  }) => status === 'fulfilled')) {
    var _notice$success$type;
    let successMessage;
    if (allSettledResults.length === 1) {
      successMessage = notice.success.messages.getMessage(posts[0]);
    } else {
      successMessage = notice.success.messages.getBatchMessage(posts);
    }
    createSuccessNotice(successMessage, {
      type: (_notice$success$type = notice.success.type) !== null && _notice$success$type !== void 0 ? _notice$success$type : 'snackbar',
      id: notice.success.id
    });
    callbacks.onActionPerformed?.(posts);
  } else {
    var _notice$error$type;
    const errorMessages = getErrorMessagesFromPromises(allSettledResults);
    let errorMessage = '';
    if (allSettledResults.length === 1) {
      errorMessage = notice.error.messages.getMessage(errorMessages);
    } else {
      errorMessage = notice.error.messages.getBatchMessage(errorMessages);
    }
    createErrorNotice(errorMessage, {
      type: (_notice$error$type = notice.error.type) !== null && _notice$error$type !== void 0 ? _notice$error$type : 'snackbar',
      id: notice.error.id
    });
    callbacks.onActionError?.();
  }
};
const editPostWithNotices = async (postsWithUpdates, notice, callbacks) => {
  const {
    createSuccessNotice,
    createErrorNotice
  } = dispatch(noticesStore);
  const {
    editEntityRecord,
    saveEditedEntityRecord
  } = dispatch(coreStore);
  await Promise.allSettled(postsWithUpdates.map(post => {
    return editEntityRecord('postType', post.originalPost.type, post.originalPost.id, {
      ...post.changes
    });
  }));
  const allSettledResults = await Promise.allSettled(postsWithUpdates.map(post => {
    return saveEditedEntityRecord('postType', post.originalPost.type, post.originalPost.id, {
      throwOnError: true
    });
  }));
  // If all the promises were fulfilled with success.
  if (allSettledResults.every(({
    status
  }) => status === 'fulfilled')) {
    var _notice$success$type2;
    let successMessage;
    if (allSettledResults.length === 1) {
      successMessage = notice.success.messages.getMessage(postsWithUpdates[0].originalPost);
    } else {
      successMessage = notice.success.messages.getBatchMessage(postsWithUpdates.map(post => post.originalPost));
    }
    createSuccessNotice(successMessage, {
      type: (_notice$success$type2 = notice.success.type) !== null && _notice$success$type2 !== void 0 ? _notice$success$type2 : 'snackbar',
      id: notice.success.id
    });
    callbacks.onActionPerformed?.(postsWithUpdates.map(post => post.originalPost));
  } else {
    var _notice$error$type2;
    const errorMessages = getErrorMessagesFromPromises(allSettledResults);
    let errorMessage = '';
    if (allSettledResults.length === 1) {
      errorMessage = notice.error.messages.getMessage(errorMessages);
    } else {
      errorMessage = notice.error.messages.getBatchMessage(errorMessages);
    }
    createErrorNotice(errorMessage, {
      type: (_notice$error$type2 = notice.error.type) !== null && _notice$error$type2 !== void 0 ? _notice$error$type2 : 'snackbar',
      id: notice.error.id
    });
    callbacks.onActionError?.();
  }
};

;// ./packages/fields/build-module/actions/delete-post.js
/**
 * WordPress dependencies
 */




// @ts-ignore



/**
 * Internal dependencies
 */




const {
  PATTERN_TYPES: delete_post_PATTERN_TYPES
} = build_module_lock_unlock_unlock(external_wp_patterns_namespaceObject.privateApis);

// This action is used for templates, patterns and template parts.
// Every other post type uses the similar `trashPostAction` which
// moves the post to trash.
const deletePostAction = {
  id: 'delete-post',
  label: (0,external_wp_i18n_namespaceObject.__)('Delete'),
  isPrimary: true,
  icon: library_trash,
  isEligible(post) {
    if (isTemplateOrTemplatePart(post)) {
      return isTemplateRemovable(post);
    }
    // We can only remove user patterns.
    return post.type === delete_post_PATTERN_TYPES.user;
  },
  supportsBulk: true,
  hideModalHeader: true,
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [isBusy, setIsBusy] = (0,external_wp_element_namespaceObject.useState)(false);
    const isResetting = items.every(item => isTemplateOrTemplatePart(item) && item?.has_theme_file);
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "5",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
        children: items.length > 1 ? (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %d: number of items to delete.
        (0,external_wp_i18n_namespaceObject._n)('Delete %d item?', 'Delete %d items?', items.length), items.length) : (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: The template or template part's title
        (0,external_wp_i18n_namespaceObject._x)('Delete "%s"?', 'template part'), getItemTitle(items[0]))
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          variant: "tertiary",
          onClick: closeModal,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          __next40pxDefaultSize: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          variant: "primary",
          onClick: async () => {
            setIsBusy(true);
            const notice = {
              success: {
                messages: {
                  getMessage: item => {
                    return isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The template/part's name. */
                    (0,external_wp_i18n_namespaceObject.__)('"%s" reset.'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(getItemTitle(item))) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The template/part's name. */
                    (0,external_wp_i18n_namespaceObject._x)('"%s" deleted.', 'template part'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(getItemTitle(item)));
                  },
                  getBatchMessage: () => {
                    return isResetting ? (0,external_wp_i18n_namespaceObject.__)('Items reset.') : (0,external_wp_i18n_namespaceObject.__)('Items deleted.');
                  }
                }
              },
              error: {
                messages: {
                  getMessage: error => {
                    if (error.size === 1) {
                      return [...error][0];
                    }
                    return isResetting ? (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the item.') : (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the item.');
                  },
                  getBatchMessage: errors => {
                    if (errors.size === 0) {
                      return isResetting ? (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the items.') : (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the items.');
                    }
                    if (errors.size === 1) {
                      return isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
                      (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the items: %s'), [...errors][0]) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
                      (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the items: %s'), [...errors][0]);
                    }
                    return isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
                    (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while reverting the items: %s'), [...errors].join(',')) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
                    (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while deleting the items: %s'), [...errors].join(','));
                  }
                }
              }
            };
            await deletePostWithNotices(items, notice, {
              onActionPerformed
            });
            setIsBusy(false);
            closeModal?.();
          },
          isBusy: isBusy,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          __next40pxDefaultSize: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Delete')
        })]
      })]
    });
  }
};

/**
 * Delete action for Templates, Patterns and Template Parts.
 */
/* harmony default export */ const delete_post = (deletePostAction);

;// ./packages/fields/build-module/actions/trash-post.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


const trash_post_trashPost = {
  id: 'move-to-trash',
  label: (0,external_wp_i18n_namespaceObject.__)('Move to trash'),
  isPrimary: true,
  icon: library_trash,
  isEligible(item) {
    if (isTemplateOrTemplatePart(item) || item.type === 'wp_block') {
      return false;
    }
    return !!item.status && !['auto-draft', 'trash'].includes(item.status) && item.permissions?.delete;
  },
  supportsBulk: true,
  hideModalHeader: true,
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [isBusy, setIsBusy] = (0,external_wp_element_namespaceObject.useState)(false);
    const {
      createSuccessNotice,
      createErrorNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    const {
      deleteEntityRecord
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "5",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
        children: items.length === 1 ? (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: The item's title.
        (0,external_wp_i18n_namespaceObject.__)('Are you sure you want to move "%s" to the trash?'), getItemTitle(items[0])) : (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %d: The number of items (2 or more).
        (0,external_wp_i18n_namespaceObject._n)('Are you sure you want to move %d item to the trash ?', 'Are you sure you want to move %d items to the trash ?', items.length), items.length)
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "tertiary",
          onClick: closeModal,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "primary",
          onClick: async () => {
            setIsBusy(true);
            const promiseResult = await Promise.allSettled(items.map(item => deleteEntityRecord('postType', item.type, item.id.toString(), {}, {
              throwOnError: true
            })));
            // If all the promises were fulfilled with success.
            if (promiseResult.every(({
              status
            }) => status === 'fulfilled')) {
              let successMessage;
              if (promiseResult.length === 1) {
                successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The item's title. */
                (0,external_wp_i18n_namespaceObject.__)('"%s" moved to the trash.'), getItemTitle(items[0]));
              } else {
                successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: The number of items. */
                (0,external_wp_i18n_namespaceObject._n)('%d item moved to the trash.', '%d items moved to the trash.', items.length), items.length);
              }
              createSuccessNotice(successMessage, {
                type: 'snackbar',
                id: 'move-to-trash-action'
              });
            } else {
              // If there was at least one failure.
              let errorMessage;
              // If we were trying to delete a single item.
              if (promiseResult.length === 1) {
                const typedError = promiseResult[0];
                if (typedError.reason?.message) {
                  errorMessage = typedError.reason.message;
                } else {
                  errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while moving the item to the trash.');
                }
                // If we were trying to delete multiple items.
              } else {
                const errorMessages = new Set();
                const failedPromises = promiseResult.filter(({
                  status
                }) => status === 'rejected');
                for (const failedPromise of failedPromises) {
                  const typedError = failedPromise;
                  if (typedError.reason?.message) {
                    errorMessages.add(typedError.reason.message);
                  }
                }
                if (errorMessages.size === 0) {
                  errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while moving the items to the trash.');
                } else if (errorMessages.size === 1) {
                  errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
                  (0,external_wp_i18n_namespaceObject.__)('An error occurred while moving the item to the trash: %s'), [...errorMessages][0]);
                } else {
                  errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
                  (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while moving the items to the trash: %s'), [...errorMessages].join(','));
                }
              }
              createErrorNotice(errorMessage, {
                type: 'snackbar'
              });
            }
            if (onActionPerformed) {
              onActionPerformed(items);
            }
            setIsBusy(false);
            closeModal?.();
          },
          isBusy: isBusy,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          children: (0,external_wp_i18n_namespaceObject._x)('Trash', 'verb')
        })]
      })]
    });
  }
};

/**
 * Trash action for PostWithPermissions.
 */
/* harmony default export */ const trash_post = (trash_post_trashPost);

;// ./packages/fields/build-module/actions/permanently-delete-post.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */


const permanentlyDeletePost = {
  id: 'permanently-delete',
  label: (0,external_wp_i18n_namespaceObject.__)('Permanently delete'),
  supportsBulk: true,
  icon: library_trash,
  isEligible(item) {
    if (isTemplateOrTemplatePart(item) || item.type === 'wp_block') {
      return false;
    }
    const {
      status,
      permissions
    } = item;
    return status === 'trash' && permissions?.delete;
  },
  hideModalHeader: true,
  modalFocusOnMount: 'firstContentElement',
  RenderModal: ({
    items,
    closeModal,
    onActionPerformed
  }) => {
    const [isBusy, setIsBusy] = (0,external_wp_element_namespaceObject.useState)(false);
    const {
      createSuccessNotice,
      createErrorNotice
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
    const {
      deleteEntityRecord
    } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: "5",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
        children: items.length > 1 ? (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %d: number of items to delete.
        (0,external_wp_i18n_namespaceObject._n)('Are you sure you want to permanently delete %d item?', 'Are you sure you want to permanently delete %d items?', items.length), items.length) : (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: The post's title
        (0,external_wp_i18n_namespaceObject.__)('Are you sure you want to permanently delete "%s"?'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(getItemTitle(items[0])))
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "right",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          variant: "tertiary",
          onClick: closeModal,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          __next40pxDefaultSize: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          variant: "primary",
          onClick: async () => {
            setIsBusy(true);
            const promiseResult = await Promise.allSettled(items.map(post => deleteEntityRecord('postType', post.type, post.id, {
              force: true
            }, {
              throwOnError: true
            })));

            // If all the promises were fulfilled with success.
            if (promiseResult.every(({
              status
            }) => status === 'fulfilled')) {
              let successMessage;
              if (promiseResult.length === 1) {
                successMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The posts's title. */
                (0,external_wp_i18n_namespaceObject.__)('"%s" permanently deleted.'), getItemTitle(items[0]));
              } else {
                successMessage = (0,external_wp_i18n_namespaceObject.__)('The items were permanently deleted.');
              }
              createSuccessNotice(successMessage, {
                type: 'snackbar',
                id: 'permanently-delete-post-action'
              });
              onActionPerformed?.(items);
            } else {
              // If there was at lease one failure.
              let errorMessage;
              // If we were trying to permanently delete a single post.
              if (promiseResult.length === 1) {
                const typedError = promiseResult[0];
                if (typedError.reason?.message) {
                  errorMessage = typedError.reason.message;
                } else {
                  errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while permanently deleting the item.');
                }
                // If we were trying to permanently delete multiple posts
              } else {
                const errorMessages = new Set();
                const failedPromises = promiseResult.filter(({
                  status
                }) => status === 'rejected');
                for (const failedPromise of failedPromises) {
                  const typedError = failedPromise;
                  if (typedError.reason?.message) {
                    errorMessages.add(typedError.reason.message);
                  }
                }
                if (errorMessages.size === 0) {
                  errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while permanently deleting the items.');
                } else if (errorMessages.size === 1) {
                  errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
                  (0,external_wp_i18n_namespaceObject.__)('An error occurred while permanently deleting the items: %s'), [...errorMessages][0]);
                } else {
                  errorMessage = (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
                  (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while permanently deleting the items: %s'), [...errorMessages].join(','));
                }
              }
              createErrorNotice(errorMessage, {
                type: 'snackbar'
              });
            }
            setIsBusy(false);
            closeModal?.();
          },
          isBusy: isBusy,
          disabled: isBusy,
          accessibleWhenDisabled: true,
          __next40pxDefaultSize: true,
          children: (0,external_wp_i18n_namespaceObject.__)('Delete permanently')
        })]
      })]
    });
  }
};

/**
 * Delete action for PostWithPermissions.
 */
/* harmony default export */ const permanently_delete_post = (permanentlyDeletePost);

;// external ["wp","mediaUtils"]
const external_wp_mediaUtils_namespaceObject = window["wp"]["mediaUtils"];
;// ./packages/icons/build-module/library/line-solid.js
/**
 * WordPress dependencies
 */


const lineSolid = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M5 11.25h14v1.5H5z"
  })
});
/* harmony default export */ const line_solid = (lineSolid);

;// ./packages/fields/build-module/fields/featured-image/featured-image-edit.js
/**
 * WordPress dependencies
 */



// @ts-ignore





/**
 * Internal dependencies
 */

const FeaturedImageEdit = ({
  data,
  field,
  onChange
}) => {
  const {
    id
  } = field;
  const value = field.getValue({
    item: data
  });
  const media = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    return getEntityRecord('postType', 'attachment', value);
  }, [value]);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  const url = media?.source_url;
  const title = media?.title?.rendered;
  const ref = (0,external_wp_element_namespaceObject.useRef)(null);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("fieldset", {
    className: "fields-controls__featured-image",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "fields-controls__featured-image-container",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_mediaUtils_namespaceObject.MediaUpload, {
        onSelect: selectedMedia => {
          onChangeControl(selectedMedia.id);
        },
        allowedTypes: ['image'],
        render: ({
          open
        }) => {
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
            ref: ref,
            role: "button",
            tabIndex: -1,
            onClick: () => {
              open();
            },
            onKeyDown: open,
            children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalGrid, {
              rowGap: 0,
              columnGap: 8,
              templateColumns: "24px 1fr 24px",
              children: [url && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
                children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
                  className: "fields-controls__featured-image-image",
                  alt: "",
                  width: 24,
                  height: 24,
                  src: url
                }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
                  className: "fields-controls__featured-image-title",
                  children: title
                })]
              }), !url && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
                children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
                  className: "fields-controls__featured-image-placeholder",
                  style: {
                    width: '24px',
                    height: '24px'
                  }
                }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
                  className: "fields-controls__featured-image-title",
                  children: (0,external_wp_i18n_namespaceObject.__)('Choose an image…')
                })]
              }), url && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, {
                children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
                  size: "small",
                  className: "fields-controls__featured-image-remove-button",
                  icon: line_solid,
                  onClick: event => {
                    event.stopPropagation();
                    onChangeControl(0);
                  }
                })
              })]
            })
          });
        }
      })
    })
  });
};

;// ./packages/fields/build-module/fields/featured-image/featured-image-view.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const FeaturedImageView = ({
  item,
  config
}) => {
  const mediaId = item.featured_media;
  const media = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    return mediaId ? getEntityRecord('postType', 'attachment', mediaId) : null;
  }, [mediaId]);
  const url = media?.source_url;
  if (url) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
      className: "fields-controls__featured-image-image",
      src: url,
      alt: "",
      srcSet: media?.media_details?.sizes ? Object.values(media.media_details.sizes).map(size => `${size.source_url} ${size.width}w`).join(', ') : undefined,
      sizes: config?.sizes || '100vw'
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
    className: "fields-controls__featured-image-placeholder"
  });
};

;// ./packages/fields/build-module/fields/featured-image/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const featuredImageField = {
  id: 'featured_media',
  type: 'media',
  label: (0,external_wp_i18n_namespaceObject.__)('Featured Image'),
  Edit: FeaturedImageEdit,
  render: FeaturedImageView,
  enableSorting: false,
  filterBy: false
};

/**
 * Featured Image field for BasePost.
 */
/* harmony default export */ const featured_image = (featuredImageField);

;// ./packages/icons/build-module/library/comment-author-avatar.js
/**
 * WordPress dependencies
 */


const commentAuthorAvatar = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    d: "M7.25 16.437a6.5 6.5 0 1 1 9.5 0V16A2.75 2.75 0 0 0 14 13.25h-4A2.75 2.75 0 0 0 7.25 16v.437Zm1.5 1.193a6.47 6.47 0 0 0 3.25.87 6.47 6.47 0 0 0 3.25-.87V16c0-.69-.56-1.25-1.25-1.25h-4c-.69 0-1.25.56-1.25 1.25v1.63ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm10-2a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z",
    clipRule: "evenodd"
  })
});
/* harmony default export */ const comment_author_avatar = (commentAuthorAvatar);

;// ./packages/fields/build-module/fields/author/author-view.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */

function AuthorView({
  item
}) {
  const {
    text,
    imageUrl
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    let user;
    if (!!item.author) {
      user = getEntityRecord('root', 'user', item.author);
    }
    return {
      imageUrl: user?.avatar_urls?.[48],
      text: user?.name
    };
  }, [item]);
  const [isImageLoaded, setIsImageLoaded] = (0,external_wp_element_namespaceObject.useState)(false);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
    alignment: "left",
    spacing: 0,
    children: [!!imageUrl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: dist_clsx('page-templates-author-field__avatar', {
        'is-loaded': isImageLoaded
      }),
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
        onLoad: () => setIsImageLoaded(true),
        alt: (0,external_wp_i18n_namespaceObject.__)('Author avatar'),
        src: imageUrl
      })
    }), !imageUrl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "page-templates-author-field__icon",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Icon, {
        icon: comment_author_avatar
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      className: "page-templates-author-field__name",
      children: text
    })]
  });
}
/* harmony default export */ const author_view = (AuthorView);

;// ./packages/fields/build-module/fields/author/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const authorField = {
  label: (0,external_wp_i18n_namespaceObject.__)('Author'),
  id: 'author',
  type: 'integer',
  elements: [],
  render: author_view,
  sort: (a, b, direction) => {
    const nameA = a._embedded?.author?.[0]?.name || '';
    const nameB = b._embedded?.author?.[0]?.name || '';
    return direction === 'asc' ? nameA.localeCompare(nameB) : nameB.localeCompare(nameA);
  },
  filterBy: {
    operators: ['isAny', 'isNone']
  }
};

/**
 * Author field for BasePost.
 */
/* harmony default export */ const author = (authorField);

;// ./packages/icons/build-module/library/drafts.js
/**
 * WordPress dependencies
 */


const drafts = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 18.5a6.5 6.5 0 1 1 0-13 6.5 6.5 0 0 1 0 13ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8 4a4 4 0 0 0 4-4H8a4 4 0 0 0 4 4Z"
  })
});
/* harmony default export */ const library_drafts = (drafts);

;// ./packages/icons/build-module/library/scheduled.js
/**
 * WordPress dependencies
 */


const scheduled = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 18.5a6.5 6.5 0 1 1 0-13 6.5 6.5 0 0 1 0 13ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm9 1V8h-1.5v3.5h-2V13H13Z"
  })
});
/* harmony default export */ const library_scheduled = (scheduled);

;// ./packages/icons/build-module/library/pending.js
/**
 * WordPress dependencies
 */


const pending = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 18.5a6.5 6.5 0 1 1 0-13 6.5 6.5 0 0 1 0 13ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8 4a4 4 0 0 1-4-4h4V8a4 4 0 0 1 0 8Z"
  })
});
/* harmony default export */ const library_pending = (pending);

;// ./packages/icons/build-module/library/not-allowed.js
/**
 * WordPress dependencies
 */


const notAllowed = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 18.5A6.5 6.5 0 0 1 6.93 7.931l9.139 9.138A6.473 6.473 0 0 1 12 18.5Zm5.123-2.498a6.5 6.5 0 0 0-9.124-9.124l9.124 9.124ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Z"
  })
});
/* harmony default export */ const not_allowed = (notAllowed);

;// ./packages/icons/build-module/library/published.js
/**
 * WordPress dependencies
 */


const published = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 18.5a6.5 6.5 0 1 1 0-13 6.5 6.5 0 0 1 0 13ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm11.53-1.47-1.06-1.06L11 12.94l-1.47-1.47-1.06 1.06L11 15.06l4.53-4.53Z"
  })
});
/* harmony default export */ const library_published = (published);

;// ./packages/fields/build-module/fields/status/status-elements.js
/**
 * WordPress dependencies
 */



// See https://github.com/WordPress/gutenberg/issues/55886
// We do not support custom statutes at the moment.
const STATUSES = [{
  value: 'draft',
  label: (0,external_wp_i18n_namespaceObject.__)('Draft'),
  icon: library_drafts,
  description: (0,external_wp_i18n_namespaceObject.__)('Not ready to publish.')
}, {
  value: 'future',
  label: (0,external_wp_i18n_namespaceObject.__)('Scheduled'),
  icon: library_scheduled,
  description: (0,external_wp_i18n_namespaceObject.__)('Publish automatically on a chosen date.')
}, {
  value: 'pending',
  label: (0,external_wp_i18n_namespaceObject.__)('Pending Review'),
  icon: library_pending,
  description: (0,external_wp_i18n_namespaceObject.__)('Waiting for review before publishing.')
}, {
  value: 'private',
  label: (0,external_wp_i18n_namespaceObject.__)('Private'),
  icon: not_allowed,
  description: (0,external_wp_i18n_namespaceObject.__)('Only visible to site admins and editors.')
}, {
  value: 'publish',
  label: (0,external_wp_i18n_namespaceObject.__)('Published'),
  icon: library_published,
  description: (0,external_wp_i18n_namespaceObject.__)('Visible to everyone.')
}, {
  value: 'trash',
  label: (0,external_wp_i18n_namespaceObject.__)('Trash'),
  icon: library_trash
}];
/* harmony default export */ const status_elements = (STATUSES);

;// ./packages/fields/build-module/fields/status/status-view.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function StatusView({
  item
}) {
  const status = status_elements.find(({
    value
  }) => value === item.status);
  const label = status?.label || item.status;
  const icon = status?.icon;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
    alignment: "left",
    spacing: 0,
    children: [icon && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "edit-site-post-list__status-icon",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Icon, {
        icon: icon
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      children: label
    })]
  });
}
/* harmony default export */ const status_view = (StatusView);

;// ./packages/fields/build-module/fields/status/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const status_OPERATOR_IS_ANY = 'isAny';
const statusField = {
  label: (0,external_wp_i18n_namespaceObject.__)('Status'),
  id: 'status',
  type: 'text',
  elements: status_elements,
  render: status_view,
  Edit: 'radio',
  enableSorting: false,
  filterBy: {
    operators: [status_OPERATOR_IS_ANY]
  }
};

/**
 * Status field for BasePost.
 */
/* harmony default export */ const fields_status = (statusField);

;// ./packages/fields/build-module/fields/date/date-view.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

const date_view_getFormattedDate = dateToDisplay => (0,external_wp_date_namespaceObject.dateI18n)((0,external_wp_date_namespaceObject.getSettings)().formats.datetimeAbbreviated, (0,external_wp_date_namespaceObject.getDate)(dateToDisplay));
const DateView = ({
  item
}) => {
  var _item$status, _item$modified, _item$date4, _item$date5;
  const isDraftOrPrivate = ['draft', 'private'].includes((_item$status = item.status) !== null && _item$status !== void 0 ? _item$status : '');
  if (isDraftOrPrivate) {
    var _item$date;
    return (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: page creation or modification date. */
    (0,external_wp_i18n_namespaceObject.__)('<span>Modified: <time>%s</time></span>'), date_view_getFormattedDate((_item$date = item.date) !== null && _item$date !== void 0 ? _item$date : null)), {
      span: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {}),
      time: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("time", {})
    });
  }
  const isScheduled = item.status === 'future';
  if (isScheduled) {
    var _item$date2;
    return (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: page creation date */
    (0,external_wp_i18n_namespaceObject.__)('<span>Scheduled: <time>%s</time></span>'), date_view_getFormattedDate((_item$date2 = item.date) !== null && _item$date2 !== void 0 ? _item$date2 : null)), {
      span: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {}),
      time: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("time", {})
    });
  }
  const isPublished = item.status === 'publish';
  if (isPublished) {
    var _item$date3;
    return (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: page creation time */
    (0,external_wp_i18n_namespaceObject.__)('<span>Published: <time>%s</time></span>'), date_view_getFormattedDate((_item$date3 = item.date) !== null && _item$date3 !== void 0 ? _item$date3 : null)), {
      span: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {}),
      time: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("time", {})
    });
  }

  // Pending posts show the modified date if it's newer.
  const dateToDisplay = (0,external_wp_date_namespaceObject.getDate)((_item$modified = item.modified) !== null && _item$modified !== void 0 ? _item$modified : null) > (0,external_wp_date_namespaceObject.getDate)((_item$date4 = item.date) !== null && _item$date4 !== void 0 ? _item$date4 : null) ? item.modified : item.date;
  const isPending = item.status === 'pending';
  if (isPending) {
    return (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: page creation or modification date. */
    (0,external_wp_i18n_namespaceObject.__)('<span>Modified: <time>%s</time></span>'), date_view_getFormattedDate(dateToDisplay !== null && dateToDisplay !== void 0 ? dateToDisplay : null)), {
      span: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {}),
      time: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("time", {})
    });
  }

  // Unknow status.
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("time", {
    children: date_view_getFormattedDate((_item$date5 = item.date) !== null && _item$date5 !== void 0 ? _item$date5 : null)
  });
};
/* harmony default export */ const date_view = (DateView);

;// ./packages/fields/build-module/fields/date/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const dateField = {
  id: 'date',
  type: 'datetime',
  label: (0,external_wp_i18n_namespaceObject.__)('Date'),
  render: date_view,
  filterBy: false
};

/**
 * Date field for BasePost.
 */
/* harmony default export */ const fields_date = (dateField);

;// ./packages/icons/build-module/library/copy-small.js
/**
 * WordPress dependencies
 */


const copySmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.625 5.5h9.75c.069 0 .125.056.125.125v9.75a.125.125 0 0 1-.125.125h-9.75a.125.125 0 0 1-.125-.125v-9.75c0-.069.056-.125.125-.125ZM4 5.625C4 4.728 4.728 4 5.625 4h9.75C16.273 4 17 4.728 17 5.625v9.75c0 .898-.727 1.625-1.625 1.625h-9.75A1.625 1.625 0 0 1 4 15.375v-9.75Zm14.5 11.656v-9H20v9C20 18.8 18.77 20 17.251 20H6.25v-1.5h11.001c.69 0 1.249-.528 1.249-1.219Z"
  })
});
/* harmony default export */ const copy_small = (copySmall);

;// ./packages/fields/build-module/fields/slug/utils.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const getSlug = item => {
  if (typeof item !== 'object') {
    return '';
  }
  return item.slug || (0,external_wp_url_namespaceObject.cleanForSlug)(getItemTitle(item)) || item.id.toString();
};

;// ./packages/fields/build-module/fields/slug/slug-edit.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */



const SlugEdit = ({
  field,
  onChange,
  data
}) => {
  const {
    id
  } = field;
  const slug = field.getValue({
    item: data
  }) || getSlug(data);
  const permalinkTemplate = data.permalink_template || '';
  const PERMALINK_POSTNAME_REGEX = /%(?:postname|pagename)%/;
  const [prefix, suffix] = permalinkTemplate.split(PERMALINK_POSTNAME_REGEX);
  const permalinkPrefix = prefix;
  const permalinkSuffix = suffix;
  const isEditable = PERMALINK_POSTNAME_REGEX.test(permalinkTemplate);
  const originalSlugRef = (0,external_wp_element_namespaceObject.useRef)(slug);
  const slugToDisplay = slug || originalSlugRef.current;
  const permalink = isEditable ? `${permalinkPrefix}${slugToDisplay}${permalinkSuffix}` : (0,external_wp_url_namespaceObject.safeDecodeURIComponent)(data.link || '');
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (slug && originalSlugRef.current === undefined) {
      originalSlugRef.current = slug;
    }
  }, [slug]);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  const {
    createNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const copyButtonRef = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(permalink, () => {
    createNotice('info', (0,external_wp_i18n_namespaceObject.__)('Copied Permalink to clipboard.'), {
      isDismissible: true,
      type: 'snackbar'
    });
  });
  const postUrlSlugDescriptionId = 'editor-post-url__slug-description-' + (0,external_wp_compose_namespaceObject.useInstanceId)(SlugEdit);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "fields-controls__slug",
    children: [isEditable && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
        spacing: "0px",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          children: (0,external_wp_i18n_namespaceObject.__)('Customize the last part of the Permalink.')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
          href: "https://wordpress.org/documentation/article/page-post-settings-sidebar/#permalink",
          children: (0,external_wp_i18n_namespaceObject.__)('Learn more')
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControl, {
        __next40pxDefaultSize: true,
        prefix: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlPrefixWrapper, {
          children: "/"
        }),
        suffix: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          icon: copy_small,
          ref: copyButtonRef,
          label: (0,external_wp_i18n_namespaceObject.__)('Copy')
        }),
        label: (0,external_wp_i18n_namespaceObject.__)('Link'),
        hideLabelFromVision: true,
        value: slug,
        autoComplete: "off",
        spellCheck: "false",
        type: "text",
        className: "fields-controls__slug-input",
        onChange: newValue => {
          onChangeControl(newValue);
        },
        onBlur: () => {
          if (slug === '') {
            onChangeControl(originalSlugRef.current);
          }
        },
        "aria-describedby": postUrlSlugDescriptionId
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        className: "fields-controls__slug-help",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          className: "fields-controls__slug-help-visual-label",
          children: (0,external_wp_i18n_namespaceObject.__)('Permalink:')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.ExternalLink, {
          className: "fields-controls__slug-help-link",
          href: permalink,
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "fields-controls__slug-help-prefix",
            children: permalinkPrefix
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "fields-controls__slug-help-slug",
            children: slugToDisplay
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "fields-controls__slug-help-suffix",
            children: permalinkSuffix
          })]
        })]
      })]
    }), !isEditable && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
      className: "fields-controls__slug-help",
      href: permalink,
      children: permalink
    })]
  });
};
/* harmony default export */ const slug_edit = (SlugEdit);

;// ./packages/fields/build-module/fields/slug/slug-view.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const SlugView = ({
  item
}) => {
  const slug = getSlug(item);
  const originalSlugRef = (0,external_wp_element_namespaceObject.useRef)(slug);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (slug && originalSlugRef.current === undefined) {
      originalSlugRef.current = slug;
    }
  }, [slug]);
  const slugToDisplay = slug || originalSlugRef.current;
  return `${slugToDisplay}`;
};
/* harmony default export */ const slug_view = (SlugView);

;// ./packages/fields/build-module/fields/slug/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const slugField = {
  id: 'slug',
  type: 'text',
  label: (0,external_wp_i18n_namespaceObject.__)('Slug'),
  Edit: slug_edit,
  render: slug_view,
  filterBy: false
};

/**
 * Slug field for BasePost.
 */
/* harmony default export */ const slug = (slugField);

// EXTERNAL MODULE: ./node_modules/remove-accents/index.js
var remove_accents = __webpack_require__(9681);
var remove_accents_default = /*#__PURE__*/__webpack_require__.n(remove_accents);
;// ./packages/fields/build-module/fields/parent/utils.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

function getTitleWithFallbackName(post) {
  return typeof post.title === 'object' && 'rendered' in post.title && post.title.rendered ? (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(post.title.rendered) : `#${post?.id} (${(0,external_wp_i18n_namespaceObject.__)('no title')})`;
}

;// ./packages/fields/build-module/fields/parent/parent-edit.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



// @ts-ignore






/**
 * Internal dependencies
 */



function buildTermsTree(flatTerms) {
  const flatTermsWithParentAndChildren = flatTerms.map(term => {
    return {
      children: [],
      ...term
    };
  });

  // All terms should have a `parent` because we're about to index them by it.
  if (flatTermsWithParentAndChildren.some(({
    parent
  }) => parent === null || parent === undefined)) {
    return flatTermsWithParentAndChildren;
  }
  const termsByParent = flatTermsWithParentAndChildren.reduce((acc, term) => {
    const {
      parent
    } = term;
    if (!acc[parent]) {
      acc[parent] = [];
    }
    acc[parent].push(term);
    return acc;
  }, {});
  const fillWithChildren = terms => {
    return terms.map(term => {
      const children = termsByParent[term.id];
      return {
        ...term,
        children: children && children.length ? fillWithChildren(children) : []
      };
    });
  };
  return fillWithChildren(termsByParent['0'] || []);
}
const getItemPriority = (name, searchValue) => {
  const normalizedName = remove_accents_default()(name || '').toLowerCase();
  const normalizedSearch = remove_accents_default()(searchValue || '').toLowerCase();
  if (normalizedName === normalizedSearch) {
    return 0;
  }
  if (normalizedName.startsWith(normalizedSearch)) {
    return normalizedName.length;
  }
  return Infinity;
};
function PageAttributesParent({
  data,
  onChangeControl
}) {
  const [fieldValue, setFieldValue] = (0,external_wp_element_namespaceObject.useState)(null);
  const pageId = data.parent;
  const postId = data.id;
  const postTypeSlug = data.type;
  const {
    parentPostTitle,
    pageItems,
    isHierarchical
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord,
      getEntityRecords,
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    const postTypeInfo = getPostType(postTypeSlug);
    const postIsHierarchical = postTypeInfo?.hierarchical && postTypeInfo.viewable;
    const parentPost = pageId ? getEntityRecord('postType', postTypeSlug, pageId) : null;
    const query = {
      per_page: 100,
      exclude: postId,
      parent_exclude: postId,
      orderby: 'menu_order',
      order: 'asc',
      _fields: 'id,title,parent',
      ...(fieldValue !== null && {
        search: fieldValue
      })
    };
    return {
      isHierarchical: postIsHierarchical,
      parentPostTitle: parentPost ? getTitleWithFallbackName(parentPost) : '',
      pageItems: postIsHierarchical ? getEntityRecords('postType', postTypeSlug, query) : null
    };
  }, [fieldValue, pageId, postId, postTypeSlug]);

  /**
   * This logic has been copied from https://github.com/WordPress/gutenberg/blob/0249771b519d5646171fb9fae422006c8ab773f2/packages/editor/src/components/page-attributes/parent.js#L106.
   */
  const parentOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const getOptionsFromTree = (tree, level = 0) => {
      const mappedNodes = tree.map(treeNode => [{
        value: treeNode.id,
        label: '— '.repeat(level) + (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(treeNode.name),
        rawName: treeNode.name
      }, ...getOptionsFromTree(treeNode.children || [], level + 1)]);
      const sortedNodes = mappedNodes.sort(([a], [b]) => {
        const priorityA = getItemPriority(a.rawName, fieldValue !== null && fieldValue !== void 0 ? fieldValue : '');
        const priorityB = getItemPriority(b.rawName, fieldValue !== null && fieldValue !== void 0 ? fieldValue : '');
        return priorityA >= priorityB ? 1 : -1;
      });
      return sortedNodes.flat();
    };
    if (!pageItems) {
      return [];
    }
    let tree = pageItems.map(item => {
      var _item$parent;
      return {
        id: item.id,
        parent: (_item$parent = item.parent) !== null && _item$parent !== void 0 ? _item$parent : null,
        name: getTitleWithFallbackName(item)
      };
    });

    // Only build a hierarchical tree when not searching.
    if (!fieldValue) {
      tree = buildTermsTree(tree);
    }
    const opts = getOptionsFromTree(tree);

    // Ensure the current parent is in the options list.
    const optsHasParent = opts.find(item => item.value === pageId);
    if (pageId && parentPostTitle && !optsHasParent) {
      opts.unshift({
        value: pageId,
        label: parentPostTitle,
        rawName: ''
      });
    }
    return opts.map(option => ({
      ...option,
      value: option.value.toString()
    }));
  }, [pageItems, fieldValue, parentPostTitle, pageId]);
  if (!isHierarchical) {
    return null;
  }

  /**
   * Handle user input.
   *
   * @param {string} inputValue The current value of the input field.
   */
  const handleKeydown = inputValue => {
    setFieldValue(inputValue);
  };

  /**
   * Handle author selection.
   *
   * @param {Object} selectedPostId The selected Author.
   */
  const handleChange = selectedPostId => {
    if (selectedPostId) {
      var _parseInt;
      return onChangeControl((_parseInt = parseInt(selectedPostId, 10)) !== null && _parseInt !== void 0 ? _parseInt : 0);
    }
    onChangeControl(0);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ComboboxControl, {
    __nextHasNoMarginBottom: true,
    __next40pxDefaultSize: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Parent'),
    help: (0,external_wp_i18n_namespaceObject.__)('Choose a parent page.'),
    value: pageId?.toString(),
    options: parentOptions,
    onFilterValueChange: (0,external_wp_compose_namespaceObject.debounce)(value => handleKeydown(value), 300),
    onChange: handleChange,
    hideLabelFromVision: true
  });
}
const ParentEdit = ({
  data,
  field,
  onChange
}) => {
  const {
    id
  } = field;
  const homeUrl = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_coreData_namespaceObject.store).getEntityRecord('root', '__unstableBase')?.home;
  }, []);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("fieldset", {
    className: "fields-controls__parent",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      children: [(0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %1$s The home URL of the WordPress installation without the scheme. */
      (0,external_wp_i18n_namespaceObject.__)('Child pages inherit characteristics from their parent, such as URL structure. For instance, if "Pricing" is a child of "Services", its URL would be %1$s<wbr />/services<wbr />/pricing.'), (0,external_wp_url_namespaceObject.filterURLForDisplay)(homeUrl).replace(/([/.])/g, '<wbr />$1')), {
        wbr: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("wbr", {})
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
        children: (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('They also show up as sub-items in the default navigation menu. <a>Learn more.</a>'), {
          a: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
            href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/page-post-settings-sidebar/#page-attributes'),
            children: undefined
          })
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PageAttributesParent, {
        data: data,
        onChangeControl: onChangeControl
      })]
    })
  });
};

;// ./packages/fields/build-module/fields/parent/parent-view.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const ParentView = ({
  item
}) => {
  const parent = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    return item?.parent ? getEntityRecord('postType', item.type, item.parent) : null;
  }, [item.parent, item.type]);
  if (parent) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: getTitleWithFallbackName(parent)
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: (0,external_wp_i18n_namespaceObject.__)('None')
  });
};

;// ./packages/fields/build-module/fields/parent/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const parentField = {
  id: 'parent',
  type: 'text',
  label: (0,external_wp_i18n_namespaceObject.__)('Parent'),
  Edit: ParentEdit,
  render: ParentView,
  enableSorting: true,
  filterBy: false
};

/**
 * Parent field for BasePost.
 */
/* harmony default export */ const fields_parent = (parentField);

;// ./packages/fields/build-module/fields/comment-status/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const commentStatusField = {
  id: 'comment_status',
  label: (0,external_wp_i18n_namespaceObject.__)('Discussion'),
  type: 'text',
  Edit: 'radio',
  enableSorting: false,
  filterBy: false,
  elements: [{
    value: 'open',
    label: (0,external_wp_i18n_namespaceObject.__)('Open'),
    description: (0,external_wp_i18n_namespaceObject.__)('Visitors can add new comments and replies.')
  }, {
    value: 'closed',
    label: (0,external_wp_i18n_namespaceObject.__)('Closed'),
    description: (0,external_wp_i18n_namespaceObject.__)('Visitors cannot add new comments or replies. Existing comments remain visible.')
  }]
};

/**
 * Comment status field for BasePost.
 */
/* harmony default export */ const comment_status = (commentStatusField);

;// ./packages/fields/build-module/fields/template/template-edit.js
/**
 * WordPress dependencies
 */

// @ts-ignore


/**
 * Internal dependencies
 */
// @ts-expect-error block-editor is not typed correctly.









const EMPTY_ARRAY = [];
const TemplateEdit = ({
  data,
  field,
  onChange
}) => {
  const {
    id
  } = field;
  const postType = data.type;
  const postId = typeof data.id === 'number' ? data.id : parseInt(data.id, 10);
  const slug = data.slug;
  const {
    canSwitchTemplate,
    templates
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getEntityReco;
    const allTemplates = (_select$getEntityReco = select(external_wp_coreData_namespaceObject.store).getEntityRecords('postType', 'wp_template', {
      per_page: -1,
      post_type: postType
    })) !== null && _select$getEntityReco !== void 0 ? _select$getEntityReco : EMPTY_ARRAY;
    const {
      getHomePage,
      getPostsPageId
    } = build_module_lock_unlock_unlock(select(external_wp_coreData_namespaceObject.store));
    const isPostsPage = getPostsPageId() === +postId;
    const isFrontPage = postType === 'page' && getHomePage()?.postId === +postId;
    const allowSwitchingTemplate = !isPostsPage && !isFrontPage;
    return {
      templates: allTemplates,
      canSwitchTemplate: allowSwitchingTemplate
    };
  }, [postId, postType]);
  const templatesAsPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!canSwitchTemplate) {
      return [];
    }
    return templates.filter(template => template.is_custom && template.slug !== data.template &&
    // Skip empty templates.
    !!template.content.raw).map(template => ({
      name: template.slug,
      blocks: (0,external_wp_blocks_namespaceObject.parse)(template.content.raw),
      title: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title.rendered),
      id: template.id
    }));
  }, [canSwitchTemplate, data.template, templates]);
  const shownTemplates = (0,external_wp_compose_namespaceObject.useAsyncList)(templatesAsPatterns);
  const value = field.getValue({
    item: data
  });
  const foundTemplate = templates.find(template => template.slug === value);
  const currentTemplate = (0,external_wp_data_namespaceObject.useSelect)(select => {
    if (foundTemplate) {
      return foundTemplate;
    }
    let slugToCheck;
    // In `draft` status we might not have a slug available, so we use the `single`
    // post type templates slug(ex page, single-post, single-product etc..).
    // Pages do not need the `single` prefix in the slug to be prioritized
    // through template hierarchy.
    if (slug) {
      slugToCheck = postType === 'page' ? `${postType}-${slug}` : `single-${postType}-${slug}`;
    } else {
      slugToCheck = postType === 'page' ? 'page' : `single-${postType}`;
    }
    if (postType) {
      const templateId = select(external_wp_coreData_namespaceObject.store).getDefaultTemplateId({
        slug: slugToCheck
      });
      return select(external_wp_coreData_namespaceObject.store).getEntityRecord('postType', 'wp_template', templateId);
    }
  }, [foundTemplate, postType, slug]);
  const [showModal, setShowModal] = (0,external_wp_element_namespaceObject.useState)(false);
  const onChangeControl = (0,external_wp_element_namespaceObject.useCallback)(newValue => onChange({
    [id]: newValue
  }), [id, onChange]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "fields-controls__template",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
      popoverProps: {
        placement: 'bottom-start'
      },
      renderToggle: ({
        onToggle
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        __next40pxDefaultSize: true,
        variant: "tertiary",
        size: "compact",
        onClick: onToggle,
        children: currentTemplate ? getItemTitle(currentTemplate) : ''
      }),
      renderContent: ({
        onToggle
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.MenuGroup, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
          onClick: () => {
            setShowModal(true);
            onToggle();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Change template')
        }),
        // The default template in a post is indicated by an empty string
        value !== '' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
          onClick: () => {
            onChangeControl('');
            onToggle();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Use default template')
        })]
      })
    }), showModal && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Modal, {
      title: (0,external_wp_i18n_namespaceObject.__)('Choose a template'),
      onRequestClose: () => setShowModal(false),
      overlayClassName: "fields-controls__template-modal",
      isFullScreen: true,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "fields-controls__template-content",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalBlockPatternsList, {
          label: (0,external_wp_i18n_namespaceObject.__)('Templates'),
          blockPatterns: templatesAsPatterns,
          shownPatterns: shownTemplates,
          onClickPattern: template => {
            onChangeControl(template.name);
            setShowModal(false);
          }
        })
      })
    })]
  });
};

;// ./packages/fields/build-module/fields/template/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const templateField = {
  id: 'template',
  type: 'text',
  label: (0,external_wp_i18n_namespaceObject.__)('Template'),
  Edit: TemplateEdit,
  enableSorting: false,
  filterBy: false
};

/**
 * Template field for BasePost.
 */
/* harmony default export */ const fields_template = (templateField);

;// ./packages/fields/build-module/fields/password/edit.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

function PasswordEdit({
  data,
  onChange,
  field
}) {
  const [showPassword, setShowPassword] = (0,external_wp_element_namespaceObject.useState)(!!field.getValue({
    item: data
  }));
  const handleTogglePassword = value => {
    setShowPassword(value);
    if (!value) {
      onChange({
        password: ''
      });
    }
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
    as: "fieldset",
    spacing: 4,
    className: "fields-controls__password",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Password protected'),
      help: (0,external_wp_i18n_namespaceObject.__)('Only visible to those who know the password'),
      checked: showPassword,
      onChange: handleTogglePassword
    }), showPassword && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "fields-controls__password-input",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Password'),
        onChange: value => onChange({
          password: value
        }),
        value: field.getValue({
          item: data
        }) || '',
        placeholder: (0,external_wp_i18n_namespaceObject.__)('Use a secure password'),
        type: "text",
        __next40pxDefaultSize: true,
        __nextHasNoMarginBottom: true,
        maxLength: 255
      })
    })]
  });
}
/* harmony default export */ const edit = (PasswordEdit);

;// ./packages/fields/build-module/fields/password/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const passwordField = {
  id: 'password',
  type: 'text',
  label: (0,external_wp_i18n_namespaceObject.__)('Password'),
  Edit: edit,
  enableSorting: false,
  enableHiding: false,
  isVisible: item => item.status !== 'private',
  filterBy: false
};

/**
 * Password field for BasePost.
 */
/* harmony default export */ const fields_password = (passwordField);

;// ./packages/fields/build-module/fields/page-title/view.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const {
  Badge
} = build_module_lock_unlock_unlock(external_wp_components_namespaceObject.privateApis);
function PageTitleView({
  item
}) {
  const {
    frontPageId,
    postsPageId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const siteSettings = getEntityRecord('root', 'site');
    return {
      frontPageId: siteSettings?.page_on_front,
      postsPageId: siteSettings?.page_for_posts
    };
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BaseTitleView, {
    item: item,
    className: "fields-field__page-title",
    children: [frontPageId, postsPageId].includes(item.id) && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Badge, {
      children: item.id === frontPageId ? (0,external_wp_i18n_namespaceObject.__)('Homepage') : (0,external_wp_i18n_namespaceObject.__)('Posts Page')
    })
  });
}

;// ./packages/fields/build-module/fields/page-title/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const pageTitleField = {
  type: 'text',
  id: 'title',
  label: (0,external_wp_i18n_namespaceObject.__)('Title'),
  placeholder: (0,external_wp_i18n_namespaceObject.__)('No title'),
  getValue: ({
    item
  }) => getItemTitle(item),
  render: PageTitleView,
  enableHiding: false,
  enableGlobalSearch: true,
  filterBy: false
};

/**
 * Title for the page entity.
 */
/* harmony default export */ const page_title = (pageTitleField);

;// ./packages/fields/build-module/fields/template-title/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const templateTitleField = {
  type: 'text',
  label: (0,external_wp_i18n_namespaceObject.__)('Template'),
  placeholder: (0,external_wp_i18n_namespaceObject.__)('No title'),
  id: 'title',
  getValue: ({
    item
  }) => getItemTitle(item),
  render: TitleView,
  enableHiding: false,
  enableGlobalSearch: true,
  filterBy: false
};

/**
 * Title for the template entity.
 */
/* harmony default export */ const template_title = (templateTitleField);

;// ./packages/icons/build-module/icon/index.js
/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */

/**
 * Return an SVG icon.
 *
 * @param props The component props.
 *
 * @return Icon component
 */
/* harmony default export */ const icon = ((0,external_wp_element_namespaceObject.forwardRef)(({
  icon,
  size = 24,
  ...props
}, ref) => {
  return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}));

;// ./packages/icons/build-module/library/lock-small.js
/**
 * WordPress dependencies
 */


const lockSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M15 11h-.2V9c0-1.5-1.2-2.8-2.8-2.8S9.2 7.5 9.2 9v2H9c-.6 0-1 .4-1 1v4c0 .6.4 1 1 1h6c.6 0 1-.4 1-1v-4c0-.6-.4-1-1-1zm-1.8 0h-2.5V9c0-.7.6-1.2 1.2-1.2s1.2.6 1.2 1.2v2z"
  })
});
/* harmony default export */ const lock_small = (lockSmall);

;// ./packages/fields/build-module/fields/pattern-title/view.js
/**
 * WordPress dependencies
 */



// @ts-ignore


/**
 * Internal dependencies
 */




const {
  PATTERN_TYPES: view_PATTERN_TYPES
} = build_module_lock_unlock_unlock(external_wp_patterns_namespaceObject.privateApis);
function PatternTitleView({
  item
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BaseTitleView, {
    item: item,
    className: "fields-field__pattern-title",
    children: item.type === view_PATTERN_TYPES.theme && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, {
      placement: "top",
      text: (0,external_wp_i18n_namespaceObject.__)('This pattern cannot be edited.'),
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(icon, {
        icon: lock_small,
        size: 24
      })
    })
  });
}

;// ./packages/fields/build-module/fields/pattern-title/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const patternTitleField = {
  type: 'text',
  id: 'title',
  label: (0,external_wp_i18n_namespaceObject.__)('Title'),
  placeholder: (0,external_wp_i18n_namespaceObject.__)('No title'),
  getValue: ({
    item
  }) => getItemTitle(item),
  render: PatternTitleView,
  enableHiding: false,
  enableGlobalSearch: true,
  filterBy: false
};

/**
 * Title for the pattern entity.
 */
/* harmony default export */ const pattern_title = (patternTitleField);

;// ./packages/editor/build-module/components/provider/with-registry-provider.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function getSubRegistry(subRegistries, registry, useSubRegistry) {
  if (!useSubRegistry) {
    return registry;
  }
  let subRegistry = subRegistries.get(registry);
  if (!subRegistry) {
    subRegistry = (0,external_wp_data_namespaceObject.createRegistry)({
      'core/block-editor': external_wp_blockEditor_namespaceObject.storeConfig
    }, registry);
    // Todo: The interface store should also be created per instance.
    subRegistry.registerStore('core/editor', storeConfig);
    subRegistries.set(registry, subRegistry);
  }
  return subRegistry;
}
const withRegistryProvider = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(WrappedComponent => ({
  useSubRegistry = true,
  ...props
}) => {
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const [subRegistries] = (0,external_wp_element_namespaceObject.useState)(() => new WeakMap());
  const subRegistry = getSubRegistry(subRegistries, registry, useSubRegistry);
  if (subRegistry === registry) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(WrappedComponent, {
      registry: registry,
      ...props
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_data_namespaceObject.RegistryProvider, {
    value: subRegistry,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(WrappedComponent, {
      registry: subRegistry,
      ...props
    })
  });
}, 'withRegistryProvider');
/* harmony default export */ const with_registry_provider = (withRegistryProvider);

;// ./packages/editor/build-module/components/media-categories/index.js
/* wp:polyfill */
/**
 * The `editor` settings here need to be in sync with the corresponding ones in `editor` package.
 * See `packages/editor/src/components/media-categories/index.js`.
 *
 * In the future we could consider creating an Openvese package that can be used in both `editor` and `site-editor`.
 * The rest of the settings would still need to be in sync though.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/block-editor').InserterMediaRequest} InserterMediaRequest */
/** @typedef {import('@wordpress/block-editor').InserterMediaItem} InserterMediaItem */
/** @typedef {import('@wordpress/block-editor').InserterMediaCategory} InserterMediaCategory */

const getExternalLink = (url, text) => `<a ${getExternalLinkAttributes(url)}>${text}</a>`;
const getExternalLinkAttributes = url => `href="${url}" target="_blank" rel="noreferrer noopener"`;
const getOpenverseLicense = (license, licenseVersion) => {
  let licenseName = license.trim();
  // PDM has no abbreviation
  if (license !== 'pdm') {
    licenseName = license.toUpperCase().replace('SAMPLING', 'Sampling');
  }
  // If version is known, append version to the name.
  // The license has to have a version to be valid. Only
  // PDM (public domain mark) doesn't have a version.
  if (licenseVersion) {
    licenseName += ` ${licenseVersion}`;
  }
  // For licenses other than public-domain marks, prepend 'CC' to the name.
  if (!['pdm', 'cc0'].includes(license)) {
    licenseName = `CC ${licenseName}`;
  }
  return licenseName;
};
const getOpenverseCaption = item => {
  const {
    title,
    foreign_landing_url: foreignLandingUrl,
    creator,
    creator_url: creatorUrl,
    license,
    license_version: licenseVersion,
    license_url: licenseUrl
  } = item;
  const fullLicense = getOpenverseLicense(license, licenseVersion);
  const _creator = (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(creator);
  let _caption;
  if (_creator) {
    _caption = title ? (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %1s: Title of a media work from Openverse; %2$s: Name of the work's creator; %3s: Work's licence e.g: "CC0 1.0".
    (0,external_wp_i18n_namespaceObject._x)('"%1$s" by %2$s/ %3$s', 'caption'), getExternalLink(foreignLandingUrl, (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title)), creatorUrl ? getExternalLink(creatorUrl, _creator) : _creator, licenseUrl ? getExternalLink(`${licenseUrl}?ref=openverse`, fullLicense) : fullLicense) : (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %1s: Link attributes for a given Openverse media work; %2s: Name of the work's creator; %3s: Works's licence e.g: "CC0 1.0".
    (0,external_wp_i18n_namespaceObject._x)('<a %1$s>Work</a> by %2$s/ %3$s', 'caption'), getExternalLinkAttributes(foreignLandingUrl), creatorUrl ? getExternalLink(creatorUrl, _creator) : _creator, licenseUrl ? getExternalLink(`${licenseUrl}?ref=openverse`, fullLicense) : fullLicense);
  } else {
    _caption = title ? (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %1s: Title of a media work from Openverse; %2s: Work's licence e.g: "CC0 1.0".
    (0,external_wp_i18n_namespaceObject._x)('"%1$s"/ %2$s', 'caption'), getExternalLink(foreignLandingUrl, (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title)), licenseUrl ? getExternalLink(`${licenseUrl}?ref=openverse`, fullLicense) : fullLicense) : (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %1s: Link attributes for a given Openverse media work; %2s: Works's licence e.g: "CC0 1.0".
    (0,external_wp_i18n_namespaceObject._x)('<a %1$s>Work</a>/ %2$s', 'caption'), getExternalLinkAttributes(foreignLandingUrl), licenseUrl ? getExternalLink(`${licenseUrl}?ref=openverse`, fullLicense) : fullLicense);
  }
  return _caption.replace(/\s{2}/g, ' ');
};
const coreMediaFetch = async (query = {}) => {
  const mediaItems = await (0,external_wp_data_namespaceObject.resolveSelect)(external_wp_coreData_namespaceObject.store).getEntityRecords('postType', 'attachment', {
    ...query,
    orderBy: !!query?.search ? 'relevance' : 'date'
  });
  return mediaItems.map(mediaItem => ({
    ...mediaItem,
    alt: mediaItem.alt_text,
    url: mediaItem.source_url,
    previewUrl: mediaItem.media_details?.sizes?.medium?.source_url,
    caption: mediaItem.caption?.raw
  }));
};

/** @type {InserterMediaCategory[]} */
const inserterMediaCategories = [{
  name: 'images',
  labels: {
    name: (0,external_wp_i18n_namespaceObject.__)('Images'),
    search_items: (0,external_wp_i18n_namespaceObject.__)('Search images')
  },
  mediaType: 'image',
  async fetch(query = {}) {
    return coreMediaFetch({
      ...query,
      media_type: 'image'
    });
  }
}, {
  name: 'videos',
  labels: {
    name: (0,external_wp_i18n_namespaceObject.__)('Videos'),
    search_items: (0,external_wp_i18n_namespaceObject.__)('Search videos')
  },
  mediaType: 'video',
  async fetch(query = {}) {
    return coreMediaFetch({
      ...query,
      media_type: 'video'
    });
  }
}, {
  name: 'audio',
  labels: {
    name: (0,external_wp_i18n_namespaceObject.__)('Audio'),
    search_items: (0,external_wp_i18n_namespaceObject.__)('Search audio')
  },
  mediaType: 'audio',
  async fetch(query = {}) {
    return coreMediaFetch({
      ...query,
      media_type: 'audio'
    });
  }
}, {
  name: 'openverse',
  labels: {
    name: (0,external_wp_i18n_namespaceObject.__)('Openverse'),
    search_items: (0,external_wp_i18n_namespaceObject.__)('Search Openverse')
  },
  mediaType: 'image',
  async fetch(query = {}) {
    const defaultArgs = {
      mature: false,
      excluded_source: 'flickr,inaturalist,wikimedia',
      license: 'pdm,cc0'
    };
    const finalQuery = {
      ...query,
      ...defaultArgs
    };
    const mapFromInserterMediaRequest = {
      per_page: 'page_size',
      search: 'q'
    };
    const url = new URL('https://api.openverse.org/v1/images/');
    Object.entries(finalQuery).forEach(([key, value]) => {
      const queryKey = mapFromInserterMediaRequest[key] || key;
      url.searchParams.set(queryKey, value);
    });
    const response = await window.fetch(url, {
      headers: {
        'User-Agent': 'WordPress/inserter-media-fetch'
      }
    });
    const jsonResponse = await response.json();
    const results = jsonResponse.results;
    return results.map(result => ({
      ...result,
      // This is a temp solution for better titles, until Openverse API
      // completes the cleaning up of some titles of their upstream data.
      title: result.title?.toLowerCase().startsWith('file:') ? result.title.slice(5) : result.title,
      sourceId: result.id,
      id: undefined,
      caption: getOpenverseCaption(result),
      previewUrl: result.thumbnail
    }));
  },
  getReportUrl: ({
    sourceId
  }) => `https://wordpress.org/openverse/image/${sourceId}/report/`,
  isExternalResource: true
}];
/* harmony default export */ const media_categories = (inserterMediaCategories);

;// ./node_modules/uuid/dist/esm-browser/native.js
const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
/* harmony default export */ const esm_browser_native = ({
  randomUUID
});
;// ./node_modules/uuid/dist/esm-browser/rng.js
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
;// ./node_modules/uuid/dist/esm-browser/stringify.js

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!validate(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

/* harmony default export */ const esm_browser_stringify = ((/* unused pure expression or super */ null && (stringify)));
;// ./node_modules/uuid/dist/esm-browser/v4.js




function v4(options, buf, offset) {
  if (esm_browser_native.randomUUID && !buf && !options) {
    return esm_browser_native.randomUUID();
  }

  options = options || {};
  const rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return unsafeStringify(rnds);
}

/* harmony default export */ const esm_browser_v4 = (v4);
;// ./packages/editor/build-module/utils/media-upload/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

const noop = () => {};

/**
 * Upload a media file when the file upload button is activated.
 * Wrapper around uploadMedia() that injects the current post ID.
 *
 * @param {Object}   $0                   Parameters object passed to the function.
 * @param {?Object}  $0.additionalData    Additional data to include in the request.
 * @param {string}   $0.allowedTypes      Array with the types of media that can be uploaded, if unset all types are allowed.
 * @param {Array}    $0.filesList         List of files.
 * @param {?number}  $0.maxUploadFileSize Maximum upload size in bytes allowed for the site.
 * @param {Function} $0.onError           Function called when an error happens.
 * @param {Function} $0.onFileChange      Function called each time a file or a temporary representation of the file is available.
 * @param {Function} $0.onSuccess         Function called after the final representation of the file is available.
 * @param {boolean}  $0.multiple          Whether to allow multiple files to be uploaded.
 */
function mediaUpload({
  additionalData = {},
  allowedTypes,
  filesList,
  maxUploadFileSize,
  onError = noop,
  onFileChange,
  onSuccess,
  multiple = true
}) {
  const {
    receiveEntityRecords
  } = (0,external_wp_data_namespaceObject.dispatch)(external_wp_coreData_namespaceObject.store);
  const {
    getCurrentPost,
    getEditorSettings
  } = (0,external_wp_data_namespaceObject.select)(store_store);
  const {
    lockPostAutosaving,
    unlockPostAutosaving,
    lockPostSaving,
    unlockPostSaving
  } = (0,external_wp_data_namespaceObject.dispatch)(store_store);
  const wpAllowedMimeTypes = getEditorSettings().allowedMimeTypes;
  const lockKey = `image-upload-${esm_browser_v4()}`;
  let imageIsUploading = false;
  maxUploadFileSize = maxUploadFileSize || getEditorSettings().maxUploadFileSize;
  const currentPost = getCurrentPost();
  // Templates and template parts' numerical ID is stored in `wp_id`.
  const currentPostId = typeof currentPost?.id === 'number' ? currentPost.id : currentPost?.wp_id;
  const setSaveLock = () => {
    lockPostSaving(lockKey);
    lockPostAutosaving(lockKey);
    imageIsUploading = true;
  };
  const postData = currentPostId ? {
    post: currentPostId
  } : {};
  const clearSaveLock = () => {
    unlockPostSaving(lockKey);
    unlockPostAutosaving(lockKey);
    imageIsUploading = false;
  };
  (0,external_wp_mediaUtils_namespaceObject.uploadMedia)({
    allowedTypes,
    filesList,
    onFileChange: file => {
      if (!imageIsUploading) {
        setSaveLock();
      } else {
        clearSaveLock();
      }
      onFileChange?.(file);

      // Files are initially received by `onFileChange` as a blob.
      // After that the function is called a second time with the file as an entity.
      // For core-data, we only care about receiving/invalidating entities.
      const entityFiles = file.filter(_file => _file?.id);
      if (entityFiles?.length) {
        const invalidateCache = true;
        receiveEntityRecords('postType', 'attachment', entityFiles, undefined, invalidateCache);
      }
    },
    onSuccess,
    additionalData: {
      ...postData,
      ...additionalData
    },
    maxUploadFileSize,
    onError: ({
      message
    }) => {
      clearSaveLock();
      onError(message);
    },
    wpAllowedMimeTypes,
    multiple
  });
}

;// ./packages/editor/build-module/utils/media-sideload/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  sideloadMedia: mediaSideload
} = unlock(external_wp_mediaUtils_namespaceObject.privateApis);
/* harmony default export */ const media_sideload = (mediaSideload);

// EXTERNAL MODULE: ./node_modules/deepmerge/dist/cjs.js
var cjs = __webpack_require__(66);
var cjs_default = /*#__PURE__*/__webpack_require__.n(cjs);
;// ./node_modules/is-plain-object/dist/is-plain-object.mjs
/*!
 * is-plain-object <https://github.com/jonschlinkert/is-plain-object>
 *
 * Copyright (c) 2014-2017, Jon Schlinkert.
 * Released under the MIT License.
 */

function isObject(o) {
  return Object.prototype.toString.call(o) === '[object Object]';
}

function isPlainObject(o) {
  var ctor,prot;

  if (isObject(o) === false) return false;

  // If has modified constructor
  ctor = o.constructor;
  if (ctor === undefined) return true;

  // If has modified prototype
  prot = ctor.prototype;
  if (isObject(prot) === false) return false;

  // If constructor does not have an Object-specific method
  if (prot.hasOwnProperty('isPrototypeOf') === false) {
    return false;
  }

  // Most likely a plain Object
  return true;
}



;// ./packages/editor/build-module/components/global-styles-provider/index.js
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


const {
  GlobalStylesContext,
  cleanEmptyObject
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function mergeBaseAndUserConfigs(base, user) {
  return cjs_default()(base, user, {
    /*
     * We only pass as arrays the presets,
     * in which case we want the new array of values
     * to override the old array (no merging).
     */
    isMergeableObject: isPlainObject,
    /*
     * Exceptions to the above rule.
     * Background images should be replaced, not merged,
     * as they themselves are specific object definitions for the style.
     */
    customMerge: key => {
      if (key === 'backgroundImage') {
        return (baseConfig, userConfig) => userConfig;
      }
      return undefined;
    }
  });
}
function useGlobalStylesUserConfig() {
  const {
    globalStylesId,
    isReady,
    settings,
    styles,
    _links
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord,
      getEditedEntityRecord,
      hasFinishedResolution,
      canUser
    } = select(external_wp_coreData_namespaceObject.store);
    const _globalStylesId = select(external_wp_coreData_namespaceObject.store).__experimentalGetCurrentGlobalStylesId();
    let record;

    /*
     * Ensure that the global styles ID request is complete by testing `_globalStylesId`,
     * before firing off the `canUser` OPTIONS request for user capabilities, otherwise it will
     * fetch `/wp/v2/global-styles` instead of `/wp/v2/global-styles/{id}`.
     * NOTE: Please keep in sync any preload paths sent to `block_editor_rest_api_preload()`,
     * or set using the `block_editor_rest_api_preload_paths` filter, if this changes.
     */
    const userCanEditGlobalStyles = _globalStylesId ? canUser('update', {
      kind: 'root',
      name: 'globalStyles',
      id: _globalStylesId
    }) : null;
    if (_globalStylesId &&
    /*
     * Test that the OPTIONS request for user capabilities is complete
     * before fetching the global styles entity record.
     * This is to avoid fetching the global styles entity unnecessarily.
     */
    typeof userCanEditGlobalStyles === 'boolean') {
      /*
       * Fetch the global styles entity record based on the user's capabilities.
       * The default context is `edit` for users who can edit global styles.
       * Otherwise, the context is `view`.
       * NOTE: There is an equivalent conditional check using `current_user_can()` in the backend
       * to preload the global styles entity. Please keep in sync any preload paths sent to `block_editor_rest_api_preload()`,
       * or set using `block_editor_rest_api_preload_paths` filter, if this changes.
       */
      if (userCanEditGlobalStyles) {
        record = getEditedEntityRecord('root', 'globalStyles', _globalStylesId);
      } else {
        record = getEntityRecord('root', 'globalStyles', _globalStylesId, {
          context: 'view'
        });
      }
    }
    let hasResolved = false;
    if (hasFinishedResolution('__experimentalGetCurrentGlobalStylesId')) {
      if (_globalStylesId) {
        hasResolved = userCanEditGlobalStyles ? hasFinishedResolution('getEditedEntityRecord', ['root', 'globalStyles', _globalStylesId]) : hasFinishedResolution('getEntityRecord', ['root', 'globalStyles', _globalStylesId, {
          context: 'view'
        }]);
      } else {
        hasResolved = true;
      }
    }
    return {
      globalStylesId: _globalStylesId,
      isReady: hasResolved,
      settings: record?.settings,
      styles: record?.styles,
      _links: record?._links
    };
  }, []);
  const {
    getEditedEntityRecord
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_coreData_namespaceObject.store);
  const {
    editEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const config = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      settings: settings !== null && settings !== void 0 ? settings : {},
      styles: styles !== null && styles !== void 0 ? styles : {},
      _links: _links !== null && _links !== void 0 ? _links : {}
    };
  }, [settings, styles, _links]);
  const setConfig = (0,external_wp_element_namespaceObject.useCallback)(
  /**
   * Set the global styles config.
   * @param {Function|Object} callbackOrObject If the callbackOrObject is a function, pass the current config to the callback so the consumer can merge values.
   *                                           Otherwise, overwrite the current config with the incoming object.
   * @param {Object}          options          Options for editEntityRecord Core selector.
   */
  (callbackOrObject, options = {}) => {
    var _record$styles, _record$settings, _record$_links;
    const record = getEditedEntityRecord('root', 'globalStyles', globalStylesId);
    const currentConfig = {
      styles: (_record$styles = record?.styles) !== null && _record$styles !== void 0 ? _record$styles : {},
      settings: (_record$settings = record?.settings) !== null && _record$settings !== void 0 ? _record$settings : {},
      _links: (_record$_links = record?._links) !== null && _record$_links !== void 0 ? _record$_links : {}
    };
    const updatedConfig = typeof callbackOrObject === 'function' ? callbackOrObject(currentConfig) : callbackOrObject;
    editEntityRecord('root', 'globalStyles', globalStylesId, {
      styles: cleanEmptyObject(updatedConfig.styles) || {},
      settings: cleanEmptyObject(updatedConfig.settings) || {},
      _links: cleanEmptyObject(updatedConfig._links) || {}
    }, options);
  }, [globalStylesId, editEntityRecord, getEditedEntityRecord]);
  return [isReady, config, setConfig];
}
function useGlobalStylesBaseConfig() {
  const baseConfig = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).__experimentalGetCurrentThemeBaseGlobalStyles(), []);
  return [!!baseConfig, baseConfig];
}
function useGlobalStylesContext() {
  const [isUserConfigReady, userConfig, setUserConfig] = useGlobalStylesUserConfig();
  const [isBaseConfigReady, baseConfig] = useGlobalStylesBaseConfig();
  const mergedConfig = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!baseConfig || !userConfig) {
      return {};
    }
    return mergeBaseAndUserConfigs(baseConfig, userConfig);
  }, [userConfig, baseConfig]);
  const context = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      isReady: isUserConfigReady && isBaseConfigReady,
      user: userConfig,
      base: baseConfig,
      merged: mergedConfig,
      setUserConfig
    };
  }, [mergedConfig, userConfig, baseConfig, setUserConfig, isUserConfigReady, isBaseConfigReady]);
  return context;
}
function GlobalStylesProvider({
  children
}) {
  const context = useGlobalStylesContext();
  if (!context.isReady) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GlobalStylesContext.Provider, {
    value: context,
    children: children
  });
}

;// ./packages/editor/build-module/components/provider/use-block-editor-settings.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */






const use_block_editor_settings_EMPTY_OBJECT = {};
function __experimentalReusableBlocksSelect(select) {
  const {
    RECEIVE_INTERMEDIATE_RESULTS
  } = unlock(external_wp_coreData_namespaceObject.privateApis);
  const {
    getEntityRecords
  } = select(external_wp_coreData_namespaceObject.store);
  return getEntityRecords('postType', 'wp_block', {
    per_page: -1,
    [RECEIVE_INTERMEDIATE_RESULTS]: true
  });
}
const BLOCK_EDITOR_SETTINGS = ['__experimentalBlockDirectory', '__experimentalDiscussionSettings', '__experimentalFeatures', '__experimentalGlobalStylesBaseStyles', 'alignWide', 'blockInspectorTabs', 'maxUploadFileSize', 'allowedMimeTypes', 'bodyPlaceholder', 'canLockBlocks', 'canUpdateBlockBindings', 'capabilities', 'clearBlockSelection', 'codeEditingEnabled', 'colors', 'disableCustomColors', 'disableCustomFontSizes', 'disableCustomSpacingSizes', 'disableCustomGradients', 'disableLayoutStyles', 'enableCustomLineHeight', 'enableCustomSpacing', 'enableCustomUnits', 'enableOpenverseMediaCategory', 'fontSizes', 'gradients', 'generateAnchors', 'onNavigateToEntityRecord', 'imageDefaultSize', 'imageDimensions', 'imageEditing', 'imageSizes', 'isPreviewMode', 'isRTL', 'locale', 'maxWidth', 'postContentAttributes', 'postsPerPage', 'readOnly', 'styles', 'titlePlaceholder', 'supportsLayout', 'widgetTypesToHideFromLegacyWidgetBlock', '__unstableHasCustomAppender', '__unstableResolvedAssets', '__unstableIsBlockBasedTheme'];
const {
  globalStylesDataKey,
  globalStylesLinksDataKey,
  selectBlockPatternsKey,
  reusableBlocksSelectKey,
  sectionRootClientIdKey,
  mediaEditKey
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);

/**
 * React hook used to compute the block editor settings to use for the post editor.
 *
 * @param {Object} settings      EditorProvider settings prop.
 * @param {string} postType      Editor root level post type.
 * @param {string} postId        Editor root level post ID.
 * @param {string} renderingMode Editor rendering mode.
 *
 * @return {Object} Block Editor Settings.
 */
function useBlockEditorSettings(settings, postType, postId, renderingMode) {
  var _mergedGlobalStyles$s, _mergedGlobalStyles$_, _settings$__experimen, _settings$__experimen2;
  const isLargeViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium');
  const {
    allowRightClickOverrides,
    blockTypes,
    focusMode,
    hasFixedToolbar,
    isDistractionFree,
    keepCaretInsideBlock,
    hasUploadPermissions,
    hiddenBlockTypes,
    canUseUnfilteredHTML,
    userCanCreatePages,
    pageOnFront,
    pageForPosts,
    userPatternCategories,
    restBlockPatternCategories,
    sectionRootClientId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _canUser;
    const {
      canUser,
      getRawEntityRecord,
      getEntityRecord,
      getUserPatternCategories,
      getBlockPatternCategories
    } = select(external_wp_coreData_namespaceObject.store);
    const {
      get
    } = select(external_wp_preferences_namespaceObject.store);
    const {
      getBlockTypes
    } = select(external_wp_blocks_namespaceObject.store);
    const {
      getBlocksByName,
      getBlockAttributes
    } = select(external_wp_blockEditor_namespaceObject.store);
    const siteSettings = canUser('read', {
      kind: 'root',
      name: 'site'
    }) ? getEntityRecord('root', 'site') : undefined;
    function getSectionRootBlock() {
      var _getBlocksByName$find;
      if (renderingMode === 'template-locked') {
        var _getBlocksByName$;
        return (_getBlocksByName$ = getBlocksByName('core/post-content')?.[0]) !== null && _getBlocksByName$ !== void 0 ? _getBlocksByName$ : '';
      }
      return (_getBlocksByName$find = getBlocksByName('core/group').find(clientId => getBlockAttributes(clientId)?.tagName === 'main')) !== null && _getBlocksByName$find !== void 0 ? _getBlocksByName$find : '';
    }
    return {
      allowRightClickOverrides: get('core', 'allowRightClickOverrides'),
      blockTypes: getBlockTypes(),
      canUseUnfilteredHTML: getRawEntityRecord('postType', postType, postId)?._links?.hasOwnProperty('wp:action-unfiltered-html'),
      focusMode: get('core', 'focusMode'),
      hasFixedToolbar: get('core', 'fixedToolbar') || !isLargeViewport,
      hiddenBlockTypes: get('core', 'hiddenBlockTypes'),
      isDistractionFree: get('core', 'distractionFree'),
      keepCaretInsideBlock: get('core', 'keepCaretInsideBlock'),
      hasUploadPermissions: (_canUser = canUser('create', {
        kind: 'postType',
        name: 'attachment'
      })) !== null && _canUser !== void 0 ? _canUser : true,
      userCanCreatePages: canUser('create', {
        kind: 'postType',
        name: 'page'
      }),
      pageOnFront: siteSettings?.page_on_front,
      pageForPosts: siteSettings?.page_for_posts,
      userPatternCategories: getUserPatternCategories(),
      restBlockPatternCategories: getBlockPatternCategories(),
      sectionRootClientId: getSectionRootBlock()
    };
  }, [postType, postId, isLargeViewport, renderingMode]);
  const {
    merged: mergedGlobalStyles
  } = useGlobalStylesContext();
  const globalStylesData = (_mergedGlobalStyles$s = mergedGlobalStyles.styles) !== null && _mergedGlobalStyles$s !== void 0 ? _mergedGlobalStyles$s : use_block_editor_settings_EMPTY_OBJECT;
  const globalStylesLinksData = (_mergedGlobalStyles$_ = mergedGlobalStyles._links) !== null && _mergedGlobalStyles$_ !== void 0 ? _mergedGlobalStyles$_ : use_block_editor_settings_EMPTY_OBJECT;
  const settingsBlockPatterns = (_settings$__experimen = settings.__experimentalAdditionalBlockPatterns) !== null && _settings$__experimen !== void 0 ? _settings$__experimen :
  // WP 6.0
  settings.__experimentalBlockPatterns; // WP 5.9
  const settingsBlockPatternCategories = (_settings$__experimen2 = settings.__experimentalAdditionalBlockPatternCategories) !== null && _settings$__experimen2 !== void 0 ? _settings$__experimen2 :
  // WP 6.0
  settings.__experimentalBlockPatternCategories; // WP 5.9

  const blockPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => [...(settingsBlockPatterns || [])].filter(({
    postTypes
  }) => {
    return !postTypes || Array.isArray(postTypes) && postTypes.includes(postType);
  }), [settingsBlockPatterns, postType]);
  const blockPatternCategories = (0,external_wp_element_namespaceObject.useMemo)(() => [...(settingsBlockPatternCategories || []), ...(restBlockPatternCategories || [])].filter((x, index, arr) => index === arr.findIndex(y => x.name === y.name)), [settingsBlockPatternCategories, restBlockPatternCategories]);
  const {
    undo,
    setIsInserterOpened
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    editMediaEntity
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store));
  const {
    saveEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);

  /**
   * Creates a Post entity.
   * This is utilised by the Link UI to allow for on-the-fly creation of Posts/Pages.
   *
   * @param {Object} options parameters for the post being created. These mirror those used on 3rd param of saveEntityRecord.
   * @return {Object} the post type object that was created.
   */
  const createPageEntity = (0,external_wp_element_namespaceObject.useCallback)(options => {
    if (!userCanCreatePages) {
      return Promise.reject({
        message: (0,external_wp_i18n_namespaceObject.__)('You do not have permission to create Pages.')
      });
    }
    return saveEntityRecord('postType', 'page', options);
  }, [saveEntityRecord, userCanCreatePages]);
  const allowedBlockTypes = (0,external_wp_element_namespaceObject.useMemo)(() => {
    // Omit hidden block types if exists and non-empty.
    if (hiddenBlockTypes && hiddenBlockTypes.length > 0) {
      // Defer to passed setting for `allowedBlockTypes` if provided as
      // anything other than `true` (where `true` is equivalent to allow
      // all block types).
      const defaultAllowedBlockTypes = true === settings.allowedBlockTypes ? blockTypes.map(({
        name
      }) => name) : settings.allowedBlockTypes || [];
      return defaultAllowedBlockTypes.filter(type => !hiddenBlockTypes.includes(type));
    }
    return settings.allowedBlockTypes;
  }, [settings.allowedBlockTypes, hiddenBlockTypes, blockTypes]);
  const forceDisableFocusMode = settings.focusMode === false;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const blockEditorSettings = {
      ...Object.fromEntries(Object.entries(settings).filter(([key]) => BLOCK_EDITOR_SETTINGS.includes(key))),
      [globalStylesDataKey]: globalStylesData,
      [globalStylesLinksDataKey]: globalStylesLinksData,
      allowedBlockTypes,
      allowRightClickOverrides,
      focusMode: focusMode && !forceDisableFocusMode,
      hasFixedToolbar,
      isDistractionFree,
      keepCaretInsideBlock,
      [mediaEditKey]: hasUploadPermissions ? editMediaEntity : undefined,
      mediaUpload: hasUploadPermissions ? mediaUpload : undefined,
      mediaSideload: hasUploadPermissions ? media_sideload : undefined,
      __experimentalBlockPatterns: blockPatterns,
      [selectBlockPatternsKey]: select => {
        const {
          hasFinishedResolution,
          getBlockPatternsForPostType
        } = unlock(select(external_wp_coreData_namespaceObject.store));
        const patterns = getBlockPatternsForPostType(postType);
        return hasFinishedResolution('getBlockPatterns') ? patterns : undefined;
      },
      [reusableBlocksSelectKey]: __experimentalReusableBlocksSelect,
      __experimentalBlockPatternCategories: blockPatternCategories,
      __experimentalUserPatternCategories: userPatternCategories,
      __experimentalFetchLinkSuggestions: (search, searchOptions) => (0,external_wp_coreData_namespaceObject.__experimentalFetchLinkSuggestions)(search, searchOptions, settings),
      inserterMediaCategories: media_categories,
      __experimentalFetchRichUrlData: external_wp_coreData_namespaceObject.__experimentalFetchUrlData,
      // Todo: This only checks the top level post, not the post within a template or any other entity that can be edited.
      // This might be better as a generic "canUser" selector.
      __experimentalCanUserUseUnfilteredHTML: canUseUnfilteredHTML,
      //Todo: this is only needed for native and should probably be removed.
      __experimentalUndo: undo,
      // Check whether we want all site editor frames to have outlines
      // including the navigation / pattern / parts editors.
      outlineMode: !isDistractionFree && postType === 'wp_template',
      // Check these two properties: they were not present in the site editor.
      __experimentalCreatePageEntity: createPageEntity,
      __experimentalUserCanCreatePages: userCanCreatePages,
      pageOnFront,
      pageForPosts,
      __experimentalPreferPatternsOnRoot: postType === 'wp_template',
      templateLock: postType === 'wp_navigation' ? 'insert' : settings.templateLock,
      template: postType === 'wp_navigation' ? [['core/navigation', {}, []]] : settings.template,
      __experimentalSetIsInserterOpened: setIsInserterOpened,
      [sectionRootClientIdKey]: sectionRootClientId,
      editorTool: renderingMode === 'post-only' && postType !== 'wp_template' ? 'edit' : undefined
    };
    return blockEditorSettings;
  }, [allowedBlockTypes, allowRightClickOverrides, focusMode, forceDisableFocusMode, hasFixedToolbar, isDistractionFree, keepCaretInsideBlock, settings, hasUploadPermissions, userPatternCategories, blockPatterns, blockPatternCategories, canUseUnfilteredHTML, undo, createPageEntity, userCanCreatePages, pageOnFront, pageForPosts, postType, setIsInserterOpened, sectionRootClientId, globalStylesData, globalStylesLinksData, renderingMode, editMediaEntity]);
}
/* harmony default export */ const use_block_editor_settings = (useBlockEditorSettings);

;// ./packages/editor/build-module/components/provider/use-post-content-blocks.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const POST_CONTENT_BLOCK_TYPES = ['core/post-title', 'core/post-featured-image', 'core/post-content'];
function usePostContentBlocks() {
  const contentOnlyBlockTypes = (0,external_wp_element_namespaceObject.useMemo)(() => [...(0,external_wp_hooks_namespaceObject.applyFilters)('editor.postContentBlockTypes', POST_CONTENT_BLOCK_TYPES)], []);

  // Note that there are two separate subscriptions because the result for each
  // returns a new array.
  const contentOnlyIds = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getPostBlocksByName
    } = unlock(select(store_store));
    return getPostBlocksByName(contentOnlyBlockTypes);
  }, [contentOnlyBlockTypes]);
  return contentOnlyIds;
}

;// ./packages/editor/build-module/components/provider/disable-non-page-content-blocks.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Component that when rendered, makes it so that the site editor allows only
 * page content to be edited.
 */
function DisableNonPageContentBlocks() {
  const contentOnlyIds = usePostContentBlocks();
  const {
    templateParts,
    isNavigationMode
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlocksByName,
      isNavigationMode: _isNavigationMode
    } = select(external_wp_blockEditor_namespaceObject.store);
    return {
      templateParts: getBlocksByName('core/template-part'),
      isNavigationMode: _isNavigationMode()
    };
  }, []);
  const disabledIds = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockOrder
    } = select(external_wp_blockEditor_namespaceObject.store);
    return templateParts.flatMap(clientId => getBlockOrder(clientId));
  }, [templateParts]);
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();

  // The code here is split into multiple `useEffects` calls.
  // This is done to avoid setting/unsetting block editing modes multiple times unnecessarily.
  //
  // For example, the block editing mode of the root block (clientId: '') only
  // needs to be set once, not when `contentOnlyIds` or `disabledIds` change.
  //
  // It's also unlikely that these different types of blocks are being inserted
  // or removed at the same time, so using different effects reflects that.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      setBlockEditingMode,
      unsetBlockEditingMode
    } = registry.dispatch(external_wp_blockEditor_namespaceObject.store);
    setBlockEditingMode('', 'disabled');
    return () => {
      unsetBlockEditingMode('');
    };
  }, [registry]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      setBlockEditingMode,
      unsetBlockEditingMode
    } = registry.dispatch(external_wp_blockEditor_namespaceObject.store);
    registry.batch(() => {
      for (const clientId of contentOnlyIds) {
        setBlockEditingMode(clientId, 'contentOnly');
      }
    });
    return () => {
      registry.batch(() => {
        for (const clientId of contentOnlyIds) {
          unsetBlockEditingMode(clientId);
        }
      });
    };
  }, [contentOnlyIds, registry]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      setBlockEditingMode,
      unsetBlockEditingMode
    } = registry.dispatch(external_wp_blockEditor_namespaceObject.store);
    registry.batch(() => {
      if (!isNavigationMode) {
        for (const clientId of templateParts) {
          setBlockEditingMode(clientId, 'contentOnly');
        }
      }
    });
    return () => {
      registry.batch(() => {
        if (!isNavigationMode) {
          for (const clientId of templateParts) {
            unsetBlockEditingMode(clientId);
          }
        }
      });
    };
  }, [templateParts, isNavigationMode, registry]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const {
      setBlockEditingMode,
      unsetBlockEditingMode
    } = registry.dispatch(external_wp_blockEditor_namespaceObject.store);
    registry.batch(() => {
      for (const clientId of disabledIds) {
        setBlockEditingMode(clientId, 'disabled');
      }
    });
    return () => {
      registry.batch(() => {
        for (const clientId of disabledIds) {
          unsetBlockEditingMode(clientId);
        }
      });
    };
  }, [disabledIds, registry]);
  return null;
}

;// ./packages/editor/build-module/components/provider/navigation-block-editing-mode.js
/**
 * WordPress dependencies
 */




/**
 * For the Navigation block editor, we need to force the block editor to contentOnly for that block.
 *
 * Set block editing mode to contentOnly when entering Navigation focus mode.
 * this ensures that non-content controls on the block will be hidden and thus
 * the user can focus on editing the Navigation Menu content only.
 */

function NavigationBlockEditingMode() {
  // In the navigation block editor,
  // the navigation block is the only root block.
  const blockClientId = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getBlockOrder()?.[0], []);
  const {
    setBlockEditingMode,
    unsetBlockEditingMode
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!blockClientId) {
      return;
    }
    setBlockEditingMode(blockClientId, 'contentOnly');
    return () => {
      unsetBlockEditingMode(blockClientId);
    };
  }, [blockClientId, unsetBlockEditingMode, setBlockEditingMode]);
}

;// ./packages/editor/build-module/components/provider/use-hide-blocks-from-inserter.js
/**
 * WordPress dependencies
 */



// These post types are "structural" block lists.
// We should be allowed to use
// the post content and template parts blocks within them.
const POST_TYPES_ALLOWING_POST_CONTENT_TEMPLATE_PART = ['wp_block', 'wp_template', 'wp_template_part'];

/**
 * In some specific contexts,
 * the template part and post content blocks need to be hidden.
 *
 * @param {string} postType Post Type
 * @param {string} mode     Rendering mode
 */
function useHideBlocksFromInserter(postType, mode) {
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    /*
     * Prevent adding template part in the editor.
     */
    (0,external_wp_hooks_namespaceObject.addFilter)('blockEditor.__unstableCanInsertBlockType', 'removeTemplatePartsFromInserter', (canInsert, blockType) => {
      if (!POST_TYPES_ALLOWING_POST_CONTENT_TEMPLATE_PART.includes(postType) && blockType.name === 'core/template-part' && mode === 'post-only') {
        return false;
      }
      return canInsert;
    });

    /*
     * Prevent adding post content block (except in query block) in the editor.
     */
    (0,external_wp_hooks_namespaceObject.addFilter)('blockEditor.__unstableCanInsertBlockType', 'removePostContentFromInserter', (canInsert, blockType, rootClientId, {
      getBlockParentsByBlockName
    }) => {
      if (!POST_TYPES_ALLOWING_POST_CONTENT_TEMPLATE_PART.includes(postType) && blockType.name === 'core/post-content') {
        return getBlockParentsByBlockName(rootClientId, 'core/query').length > 0;
      }
      return canInsert;
    });
    return () => {
      (0,external_wp_hooks_namespaceObject.removeFilter)('blockEditor.__unstableCanInsertBlockType', 'removeTemplatePartsFromInserter');
      (0,external_wp_hooks_namespaceObject.removeFilter)('blockEditor.__unstableCanInsertBlockType', 'removePostContentFromInserter');
    };
  }, [postType, mode]);
}

;// ./packages/icons/build-module/library/keyboard.js
/**
 * WordPress dependencies
 */


const keyboard = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m16 15.5h-8v-1.5h8zm-7.5-2.5h-2v-2h2zm3 0h-2v-2h2zm3 0h-2v-2h2zm3 0h-2v-2h2zm-9-3h-2v-2h2zm3 0h-2v-2h2zm3 0h-2v-2h2zm3 0h-2v-2h2z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m18.5 6.5h-13a.5.5 0 0 0 -.5.5v9.5a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-9.5a.5.5 0 0 0 -.5-.5zm-13-1.5h13a2 2 0 0 1 2 2v9.5a2 2 0 0 1 -2 2h-13a2 2 0 0 1 -2-2v-9.5a2 2 0 0 1 2-2z"
  })]
});
/* harmony default export */ const library_keyboard = (keyboard);

;// ./packages/icons/build-module/library/list-view.js
/**
 * WordPress dependencies
 */


const listView = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M3 6h11v1.5H3V6Zm3.5 5.5h11V13h-11v-1.5ZM21 17H10v1.5h11V17Z"
  })
});
/* harmony default export */ const list_view = (listView);

;// ./packages/icons/build-module/library/code.js
/**
 * WordPress dependencies
 */


const code = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M20.8 10.7l-4.3-4.3-1.1 1.1 4.3 4.3c.1.1.1.3 0 .4l-4.3 4.3 1.1 1.1 4.3-4.3c.7-.8.7-1.9 0-2.6zM4.2 11.8l4.3-4.3-1-1-4.3 4.3c-.7.7-.7 1.8 0 2.5l4.3 4.3 1.1-1.1-4.3-4.3c-.2-.1-.2-.3-.1-.4z"
  })
});
/* harmony default export */ const library_code = (code);

;// ./packages/icons/build-module/library/drawer-left.js
/**
 * WordPress dependencies
 */


const drawerLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM8.5 18.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h2.5v13zm10-.5c0 .3-.2.5-.5.5h-8v-13h8c.3 0 .5.2.5.5v12z"
  })
});
/* harmony default export */ const drawer_left = (drawerLeft);

;// ./packages/icons/build-module/library/drawer-right.js
/**
 * WordPress dependencies
 */


const drawerRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-4 14.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h8v13zm4.5-.5c0 .3-.2.5-.5.5h-2.5v-13H18c.3 0 .5.2.5.5v12z"
  })
});
/* harmony default export */ const drawer_right = (drawerRight);

;// ./packages/icons/build-module/library/block-default.js
/**
 * WordPress dependencies
 */


const blockDefault = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19 8h-1V6h-5v2h-2V6H6v2H5c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-8c0-1.1-.9-2-2-2zm.5 10c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5v-8c0-.3.2-.5.5-.5h14c.3 0 .5.2.5.5v8z"
  })
});
/* harmony default export */ const block_default = (blockDefault);

;// ./packages/icons/build-module/library/format-list-bullets.js
/**
 * WordPress dependencies
 */


const formatListBullets = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM6 13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-7c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
  })
});
/* harmony default export */ const format_list_bullets = (formatListBullets);

;// ./packages/icons/build-module/library/pencil.js
/**
 * WordPress dependencies
 */


const pencil = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
  })
});
/* harmony default export */ const library_pencil = (pencil);

;// ./packages/icons/build-module/library/edit.js
/**
 * Internal dependencies
 */


/* harmony default export */ const library_edit = (library_pencil);

;// ./packages/icons/build-module/library/symbol.js
/**
 * WordPress dependencies
 */


const symbol = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
  })
});
/* harmony default export */ const library_symbol = (symbol);

;// ./packages/icons/build-module/library/page.js
/**
 * WordPress dependencies
 */


const page = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M15.5 7.5h-7V9h7V7.5Zm-7 3.5h7v1.5h-7V11Zm7 3.5h-7V16h7v-1.5Z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2ZM7 5.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H7a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5Z"
  })]
});
/* harmony default export */ const library_page = (page);

;// ./packages/icons/build-module/library/rotate-right.js
/**
 * WordPress dependencies
 */


const rotateRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M15.1 4.8l-3-2.5V4c-4.4 0-8 3.6-8 8 0 3.7 2.5 6.9 6 7.7.3.1.6.1 1 .2l.2-1.5c-.4 0-.7-.1-1.1-.2l-.1.2v-.2c-2.6-.8-4.5-3.3-4.5-6.2 0-3.6 2.9-6.5 6.5-6.5v1.8l3-2.5zM20 11c-.2-1.4-.7-2.7-1.6-3.8l-1.2.8c.7.9 1.1 2 1.3 3.1L20 11zm-1.5 1.8c-.1.5-.2 1.1-.4 1.6s-.5 1-.8 1.5l1.2.9c.4-.5.8-1.1 1-1.8s.5-1.3.5-2l-1.5-.2zm-5.6 5.6l.2 1.5c1.4-.2 2.7-.7 3.8-1.6l-.9-1.1c-.9.7-2 1.1-3.1 1.2z"
  })
});
/* harmony default export */ const rotate_right = (rotateRight);

;// ./packages/icons/build-module/library/rotate-left.js
/**
 * WordPress dependencies
 */


const rotateLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 4V2.2L9 4.8l3 2.5V5.5c3.6 0 6.5 2.9 6.5 6.5 0 2.9-1.9 5.3-4.5 6.2v.2l-.1-.2c-.4.1-.7.2-1.1.2l.2 1.5c.3 0 .6-.1 1-.2 3.5-.9 6-4 6-7.7 0-4.4-3.6-8-8-8zm-7.9 7l1.5.2c.1-1.2.5-2.3 1.2-3.2l-1.1-.9C4.8 8.2 4.3 9.6 4.1 11zm1.5 1.8l-1.5.2c.1.7.3 1.4.5 2 .3.7.6 1.3 1 1.8l1.2-.8c-.3-.5-.6-1-.8-1.5s-.4-1.1-.4-1.7zm1.5 5.5c1.1.9 2.4 1.4 3.8 1.6l.2-1.5c-1.1-.1-2.2-.5-3.1-1.2l-.9 1.1z"
  })
});
/* harmony default export */ const rotate_left = (rotateLeft);

;// external ["wp","commands"]
const external_wp_commands_namespaceObject = window["wp"]["commands"];
;// ./packages/icons/build-module/library/star-filled.js
/**
 * WordPress dependencies
 */


const starFilled = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M11.776 4.454a.25.25 0 01.448 0l2.069 4.192a.25.25 0 00.188.137l4.626.672a.25.25 0 01.139.426l-3.348 3.263a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.362.263l-4.138-2.175a.25.25 0 00-.232 0l-4.138 2.175a.25.25 0 01-.363-.263l.79-4.607a.25.25 0 00-.071-.222L4.754 9.881a.25.25 0 01.139-.426l4.626-.672a.25.25 0 00.188-.137l2.069-4.192z"
  })
});
/* harmony default export */ const star_filled = (starFilled);

;// ./packages/icons/build-module/library/star-empty.js
/**
 * WordPress dependencies
 */


const starEmpty = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    d: "M9.706 8.646a.25.25 0 01-.188.137l-4.626.672a.25.25 0 00-.139.427l3.348 3.262a.25.25 0 01.072.222l-.79 4.607a.25.25 0 00.362.264l4.138-2.176a.25.25 0 01.233 0l4.137 2.175a.25.25 0 00.363-.263l-.79-4.607a.25.25 0 01.072-.222l3.347-3.262a.25.25 0 00-.139-.427l-4.626-.672a.25.25 0 01-.188-.137l-2.069-4.192a.25.25 0 00-.448 0L9.706 8.646zM12 7.39l-.948 1.921a1.75 1.75 0 01-1.317.957l-2.12.308 1.534 1.495c.412.402.6.982.503 1.55l-.362 2.11 1.896-.997a1.75 1.75 0 011.629 0l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39z",
    clipRule: "evenodd"
  })
});
/* harmony default export */ const star_empty = (starEmpty);

;// external ["wp","viewport"]
const external_wp_viewport_namespaceObject = window["wp"]["viewport"];
;// external ["wp","plugins"]
const external_wp_plugins_namespaceObject = window["wp"]["plugins"];
;// ./packages/interface/build-module/store/deprecated.js
/**
 * WordPress dependencies
 */

function normalizeComplementaryAreaScope(scope) {
  if (['core/edit-post', 'core/edit-site'].includes(scope)) {
    external_wp_deprecated_default()(`${scope} interface scope`, {
      alternative: 'core interface scope',
      hint: 'core/edit-post and core/edit-site are merging.',
      version: '6.6'
    });
    return 'core';
  }
  return scope;
}
function normalizeComplementaryAreaName(scope, name) {
  if (scope === 'core' && name === 'edit-site/template') {
    external_wp_deprecated_default()(`edit-site/template sidebar`, {
      alternative: 'edit-post/document',
      version: '6.6'
    });
    return 'edit-post/document';
  }
  if (scope === 'core' && name === 'edit-site/block-inspector') {
    external_wp_deprecated_default()(`edit-site/block-inspector sidebar`, {
      alternative: 'edit-post/block',
      version: '6.6'
    });
    return 'edit-post/block';
  }
  return name;
}

;// ./packages/interface/build-module/store/actions.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Set a default complementary area.
 *
 * @param {string} scope Complementary area scope.
 * @param {string} area  Area identifier.
 *
 * @return {Object} Action object.
 */
const setDefaultComplementaryArea = (scope, area) => {
  scope = normalizeComplementaryAreaScope(scope);
  area = normalizeComplementaryAreaName(scope, area);
  return {
    type: 'SET_DEFAULT_COMPLEMENTARY_AREA',
    scope,
    area
  };
};

/**
 * Enable the complementary area.
 *
 * @param {string} scope Complementary area scope.
 * @param {string} area  Area identifier.
 */
const enableComplementaryArea = (scope, area) => ({
  registry,
  dispatch
}) => {
  // Return early if there's no area.
  if (!area) {
    return;
  }
  scope = normalizeComplementaryAreaScope(scope);
  area = normalizeComplementaryAreaName(scope, area);
  const isComplementaryAreaVisible = registry.select(external_wp_preferences_namespaceObject.store).get(scope, 'isComplementaryAreaVisible');
  if (!isComplementaryAreaVisible) {
    registry.dispatch(external_wp_preferences_namespaceObject.store).set(scope, 'isComplementaryAreaVisible', true);
  }
  dispatch({
    type: 'ENABLE_COMPLEMENTARY_AREA',
    scope,
    area
  });
};

/**
 * Disable the complementary area.
 *
 * @param {string} scope Complementary area scope.
 */
const disableComplementaryArea = scope => ({
  registry
}) => {
  scope = normalizeComplementaryAreaScope(scope);
  const isComplementaryAreaVisible = registry.select(external_wp_preferences_namespaceObject.store).get(scope, 'isComplementaryAreaVisible');
  if (isComplementaryAreaVisible) {
    registry.dispatch(external_wp_preferences_namespaceObject.store).set(scope, 'isComplementaryAreaVisible', false);
  }
};

/**
 * Pins an item.
 *
 * @param {string} scope Item scope.
 * @param {string} item  Item identifier.
 *
 * @return {Object} Action object.
 */
const pinItem = (scope, item) => ({
  registry
}) => {
  // Return early if there's no item.
  if (!item) {
    return;
  }
  scope = normalizeComplementaryAreaScope(scope);
  item = normalizeComplementaryAreaName(scope, item);
  const pinnedItems = registry.select(external_wp_preferences_namespaceObject.store).get(scope, 'pinnedItems');

  // The item is already pinned, there's nothing to do.
  if (pinnedItems?.[item] === true) {
    return;
  }
  registry.dispatch(external_wp_preferences_namespaceObject.store).set(scope, 'pinnedItems', {
    ...pinnedItems,
    [item]: true
  });
};

/**
 * Unpins an item.
 *
 * @param {string} scope Item scope.
 * @param {string} item  Item identifier.
 */
const unpinItem = (scope, item) => ({
  registry
}) => {
  // Return early if there's no item.
  if (!item) {
    return;
  }
  scope = normalizeComplementaryAreaScope(scope);
  item = normalizeComplementaryAreaName(scope, item);
  const pinnedItems = registry.select(external_wp_preferences_namespaceObject.store).get(scope, 'pinnedItems');
  registry.dispatch(external_wp_preferences_namespaceObject.store).set(scope, 'pinnedItems', {
    ...pinnedItems,
    [item]: false
  });
};

/**
 * Returns an action object used in signalling that a feature should be toggled.
 *
 * @param {string} scope       The feature scope (e.g. core/edit-post).
 * @param {string} featureName The feature name.
 */
function toggleFeature(scope, featureName) {
  return function ({
    registry
  }) {
    external_wp_deprecated_default()(`dispatch( 'core/interface' ).toggleFeature`, {
      since: '6.0',
      alternative: `dispatch( 'core/preferences' ).toggle`
    });
    registry.dispatch(external_wp_preferences_namespaceObject.store).toggle(scope, featureName);
  };
}

/**
 * Returns an action object used in signalling that a feature should be set to
 * a true or false value
 *
 * @param {string}  scope       The feature scope (e.g. core/edit-post).
 * @param {string}  featureName The feature name.
 * @param {boolean} value       The value to set.
 *
 * @return {Object} Action object.
 */
function setFeatureValue(scope, featureName, value) {
  return function ({
    registry
  }) {
    external_wp_deprecated_default()(`dispatch( 'core/interface' ).setFeatureValue`, {
      since: '6.0',
      alternative: `dispatch( 'core/preferences' ).set`
    });
    registry.dispatch(external_wp_preferences_namespaceObject.store).set(scope, featureName, !!value);
  };
}

/**
 * Returns an action object used in signalling that defaults should be set for features.
 *
 * @param {string}                  scope    The feature scope (e.g. core/edit-post).
 * @param {Object<string, boolean>} defaults A key/value map of feature names to values.
 *
 * @return {Object} Action object.
 */
function setFeatureDefaults(scope, defaults) {
  return function ({
    registry
  }) {
    external_wp_deprecated_default()(`dispatch( 'core/interface' ).setFeatureDefaults`, {
      since: '6.0',
      alternative: `dispatch( 'core/preferences' ).setDefaults`
    });
    registry.dispatch(external_wp_preferences_namespaceObject.store).setDefaults(scope, defaults);
  };
}

/**
 * Returns an action object used in signalling that the user opened a modal.
 *
 * @param {string} name A string that uniquely identifies the modal.
 *
 * @return {Object} Action object.
 */
function openModal(name) {
  return {
    type: 'OPEN_MODAL',
    name
  };
}

/**
 * Returns an action object signalling that the user closed a modal.
 *
 * @return {Object} Action object.
 */
function closeModal() {
  return {
    type: 'CLOSE_MODAL'
  };
}

;// ./packages/interface/build-module/store/selectors.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Returns the complementary area that is active in a given scope.
 *
 * @param {Object} state Global application state.
 * @param {string} scope Item scope.
 *
 * @return {string | null | undefined} The complementary area that is active in the given scope.
 */
const getActiveComplementaryArea = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, scope) => {
  scope = normalizeComplementaryAreaScope(scope);
  const isComplementaryAreaVisible = select(external_wp_preferences_namespaceObject.store).get(scope, 'isComplementaryAreaVisible');

  // Return `undefined` to indicate that the user has never toggled
  // visibility, this is the vanilla default. Other code relies on this
  // nuance in the return value.
  if (isComplementaryAreaVisible === undefined) {
    return undefined;
  }

  // Return `null` to indicate the user hid the complementary area.
  if (isComplementaryAreaVisible === false) {
    return null;
  }
  return state?.complementaryAreas?.[scope];
});
const isComplementaryAreaLoading = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, scope) => {
  scope = normalizeComplementaryAreaScope(scope);
  const isVisible = select(external_wp_preferences_namespaceObject.store).get(scope, 'isComplementaryAreaVisible');
  const identifier = state?.complementaryAreas?.[scope];
  return isVisible && identifier === undefined;
});

/**
 * Returns a boolean indicating if an item is pinned or not.
 *
 * @param {Object} state Global application state.
 * @param {string} scope Scope.
 * @param {string} item  Item to check.
 *
 * @return {boolean} True if the item is pinned and false otherwise.
 */
const isItemPinned = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, scope, item) => {
  var _pinnedItems$item;
  scope = normalizeComplementaryAreaScope(scope);
  item = normalizeComplementaryAreaName(scope, item);
  const pinnedItems = select(external_wp_preferences_namespaceObject.store).get(scope, 'pinnedItems');
  return (_pinnedItems$item = pinnedItems?.[item]) !== null && _pinnedItems$item !== void 0 ? _pinnedItems$item : true;
});

/**
 * Returns a boolean indicating whether a feature is active for a particular
 * scope.
 *
 * @param {Object} state       The store state.
 * @param {string} scope       The scope of the feature (e.g. core/edit-post).
 * @param {string} featureName The name of the feature.
 *
 * @return {boolean} Is the feature enabled?
 */
const isFeatureActive = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, scope, featureName) => {
  external_wp_deprecated_default()(`select( 'core/interface' ).isFeatureActive( scope, featureName )`, {
    since: '6.0',
    alternative: `select( 'core/preferences' ).get( scope, featureName )`
  });
  return !!select(external_wp_preferences_namespaceObject.store).get(scope, featureName);
});

/**
 * Returns true if a modal is active, or false otherwise.
 *
 * @param {Object} state     Global application state.
 * @param {string} modalName A string that uniquely identifies the modal.
 *
 * @return {boolean} Whether the modal is active.
 */
function isModalActive(state, modalName) {
  return state.activeModal === modalName;
}

;// ./packages/interface/build-module/store/reducer.js
/**
 * WordPress dependencies
 */

function complementaryAreas(state = {}, action) {
  switch (action.type) {
    case 'SET_DEFAULT_COMPLEMENTARY_AREA':
      {
        const {
          scope,
          area
        } = action;

        // If there's already an area, don't overwrite it.
        if (state[scope]) {
          return state;
        }
        return {
          ...state,
          [scope]: area
        };
      }
    case 'ENABLE_COMPLEMENTARY_AREA':
      {
        const {
          scope,
          area
        } = action;
        return {
          ...state,
          [scope]: area
        };
      }
  }
  return state;
}

/**
 * Reducer for storing the name of the open modal, or null if no modal is open.
 *
 * @param {Object} state  Previous state.
 * @param {Object} action Action object containing the `name` of the modal
 *
 * @return {Object} Updated state
 */
function activeModal(state = null, action) {
  switch (action.type) {
    case 'OPEN_MODAL':
      return action.name;
    case 'CLOSE_MODAL':
      return null;
  }
  return state;
}
/* harmony default export */ const build_module_store_reducer = ((0,external_wp_data_namespaceObject.combineReducers)({
  complementaryAreas,
  activeModal
}));

;// ./packages/interface/build-module/store/constants.js
/**
 * The identifier for the data store.
 *
 * @type {string}
 */
const constants_STORE_NAME = 'core/interface';

;// ./packages/interface/build-module/store/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Store definition for the interface namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 *
 * @type {Object}
 */
const store = (0,external_wp_data_namespaceObject.createReduxStore)(constants_STORE_NAME, {
  reducer: build_module_store_reducer,
  actions: store_actions_namespaceObject,
  selectors: store_selectors_namespaceObject
});
(0,external_wp_data_namespaceObject.register)(store);

;// ./packages/interface/build-module/components/complementary-area-toggle/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Whether the role supports checked state.
 *
 * @see https://www.w3.org/TR/wai-aria-1.1/#aria-checked
 * @param {import('react').AriaRole} role Role.
 * @return {boolean} Whether the role supports checked state.
 */

function roleSupportsCheckedState(role) {
  return ['checkbox', 'option', 'radio', 'switch', 'menuitemcheckbox', 'menuitemradio', 'treeitem'].includes(role);
}
function ComplementaryAreaToggle({
  as = external_wp_components_namespaceObject.Button,
  scope,
  identifier: identifierProp,
  icon: iconProp,
  selectedIcon,
  name,
  shortcut,
  ...props
}) {
  const ComponentToUse = as;
  const context = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  const icon = iconProp || context.icon;
  const identifier = identifierProp || `${context.name}/${name}`;
  const isSelected = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getActiveComplementaryArea(scope) === identifier, [identifier, scope]);
  const {
    enableComplementaryArea,
    disableComplementaryArea
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComponentToUse, {
    icon: selectedIcon && isSelected ? selectedIcon : icon,
    "aria-controls": identifier.replace('/', ':')
    // Make sure aria-checked matches spec https://www.w3.org/TR/wai-aria-1.1/#aria-checked
    ,
    "aria-checked": roleSupportsCheckedState(props.role) ? isSelected : undefined,
    onClick: () => {
      if (isSelected) {
        disableComplementaryArea(scope);
      } else {
        enableComplementaryArea(scope, identifier);
      }
    },
    shortcut: shortcut,
    ...props
  });
}

;// ./packages/interface/build-module/components/complementary-area-header/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const ComplementaryAreaHeader = ({
  children,
  className,
  toggleButtonProps
}) => {
  const toggleButton = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComplementaryAreaToggle, {
    icon: close_small,
    ...toggleButtonProps
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: dist_clsx('components-panel__header', 'interface-complementary-area-header', className),
    tabIndex: -1,
    children: [children, toggleButton]
  });
};
/* harmony default export */ const complementary_area_header = (ComplementaryAreaHeader);

;// ./packages/interface/build-module/components/action-item/index.js
/**
 * WordPress dependencies
 */



const action_item_noop = () => {};
function ActionItemSlot({
  name,
  as: Component = external_wp_components_namespaceObject.MenuGroup,
  fillProps = {},
  bubblesVirtually,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Slot, {
    name: name,
    bubblesVirtually: bubblesVirtually,
    fillProps: fillProps,
    children: fills => {
      if (!external_wp_element_namespaceObject.Children.toArray(fills).length) {
        return null;
      }

      // Special handling exists for backward compatibility.
      // It ensures that menu items created by plugin authors aren't
      // duplicated with automatically injected menu items coming
      // from pinnable plugin sidebars.
      // @see https://github.com/WordPress/gutenberg/issues/14457
      const initializedByPlugins = [];
      external_wp_element_namespaceObject.Children.forEach(fills, ({
        props: {
          __unstableExplicitMenuItem,
          __unstableTarget
        }
      }) => {
        if (__unstableTarget && __unstableExplicitMenuItem) {
          initializedByPlugins.push(__unstableTarget);
        }
      });
      const children = external_wp_element_namespaceObject.Children.map(fills, child => {
        if (!child.props.__unstableExplicitMenuItem && initializedByPlugins.includes(child.props.__unstableTarget)) {
          return null;
        }
        return child;
      });
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Component, {
        ...props,
        children: children
      });
    }
  });
}
function ActionItem({
  name,
  as: Component = external_wp_components_namespaceObject.Button,
  onClick,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Fill, {
    name: name,
    children: ({
      onClick: fpOnClick
    }) => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Component, {
        onClick: onClick || fpOnClick ? (...args) => {
          (onClick || action_item_noop)(...args);
          (fpOnClick || action_item_noop)(...args);
        } : undefined,
        ...props
      });
    }
  });
}
ActionItem.Slot = ActionItemSlot;
/* harmony default export */ const action_item = (ActionItem);

;// ./packages/interface/build-module/components/complementary-area-more-menu-item/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const PluginsMenuItem = ({
  // Menu item is marked with unstable prop for backward compatibility.
  // They are removed so they don't leak to DOM elements.
  // @see https://github.com/WordPress/gutenberg/issues/14457
  __unstableExplicitMenuItem,
  __unstableTarget,
  ...restProps
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
  ...restProps
});
function ComplementaryAreaMoreMenuItem({
  scope,
  target,
  __unstableExplicitMenuItem,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComplementaryAreaToggle, {
    as: toggleProps => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(action_item, {
        __unstableExplicitMenuItem: __unstableExplicitMenuItem,
        __unstableTarget: `${scope}/${target}`,
        as: PluginsMenuItem,
        name: `${scope}/plugin-more-menu`,
        ...toggleProps
      });
    },
    role: "menuitemcheckbox",
    selectedIcon: library_check,
    name: target,
    scope: scope,
    ...props
  });
}

;// ./packages/interface/build-module/components/pinned-items/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


function PinnedItems({
  scope,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Fill, {
    name: `PinnedItems/${scope}`,
    ...props
  });
}
function PinnedItemsSlot({
  scope,
  className,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Slot, {
    name: `PinnedItems/${scope}`,
    ...props,
    children: fills => fills?.length > 0 && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: dist_clsx(className, 'interface-pinned-items'),
      children: fills
    })
  });
}
PinnedItems.Slot = PinnedItemsSlot;
/* harmony default export */ const pinned_items = (PinnedItems);

;// ./packages/interface/build-module/components/complementary-area/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */






const ANIMATION_DURATION = 0.3;
function ComplementaryAreaSlot({
  scope,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Slot, {
    name: `ComplementaryArea/${scope}`,
    ...props
  });
}
const SIDEBAR_WIDTH = 280;
const variants = {
  open: {
    width: SIDEBAR_WIDTH
  },
  closed: {
    width: 0
  },
  mobileOpen: {
    width: '100vw'
  }
};
function ComplementaryAreaFill({
  activeArea,
  isActive,
  scope,
  children,
  className,
  id
}) {
  const disableMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const isMobileViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');
  // This is used to delay the exit animation to the next tick.
  // The reason this is done is to allow us to apply the right transition properties
  // When we switch from an open sidebar to another open sidebar.
  // we don't want to animate in this case.
  const previousActiveArea = (0,external_wp_compose_namespaceObject.usePrevious)(activeArea);
  const previousIsActive = (0,external_wp_compose_namespaceObject.usePrevious)(isActive);
  const [, setState] = (0,external_wp_element_namespaceObject.useState)({});
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setState({});
  }, [isActive]);
  const transition = {
    type: 'tween',
    duration: disableMotion || isMobileViewport || !!previousActiveArea && !!activeArea && activeArea !== previousActiveArea ? 0 : ANIMATION_DURATION,
    ease: [0.6, 0, 0.4, 1]
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Fill, {
    name: `ComplementaryArea/${scope}`,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__unstableAnimatePresence, {
      initial: false,
      children: (previousIsActive || isActive) && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__unstableMotion.div, {
        variants: variants,
        initial: "closed",
        animate: isMobileViewport ? 'mobileOpen' : 'open',
        exit: "closed",
        transition: transition,
        className: "interface-complementary-area__fill",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          id: id,
          className: className,
          style: {
            width: isMobileViewport ? '100vw' : SIDEBAR_WIDTH
          },
          children: children
        })
      })
    })
  });
}
function useAdjustComplementaryListener(scope, identifier, activeArea, isActive, isSmall) {
  const previousIsSmallRef = (0,external_wp_element_namespaceObject.useRef)(false);
  const shouldOpenWhenNotSmallRef = (0,external_wp_element_namespaceObject.useRef)(false);
  const {
    enableComplementaryArea,
    disableComplementaryArea
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // If the complementary area is active and the editor is switching from
    // a big to a small window size.
    if (isActive && isSmall && !previousIsSmallRef.current) {
      disableComplementaryArea(scope);
      // Flag the complementary area to be reopened when the window size
      // goes from small to big.
      shouldOpenWhenNotSmallRef.current = true;
    } else if (
    // If there is a flag indicating the complementary area should be
    // enabled when we go from small to big window size and we are going
    // from a small to big window size.
    shouldOpenWhenNotSmallRef.current && !isSmall && previousIsSmallRef.current) {
      // Remove the flag indicating the complementary area should be
      // enabled.
      shouldOpenWhenNotSmallRef.current = false;
      enableComplementaryArea(scope, identifier);
    } else if (
    // If the flag is indicating the current complementary should be
    // reopened but another complementary area becomes active, remove
    // the flag.
    shouldOpenWhenNotSmallRef.current && activeArea && activeArea !== identifier) {
      shouldOpenWhenNotSmallRef.current = false;
    }
    if (isSmall !== previousIsSmallRef.current) {
      previousIsSmallRef.current = isSmall;
    }
  }, [isActive, isSmall, scope, identifier, activeArea, disableComplementaryArea, enableComplementaryArea]);
}
function ComplementaryArea({
  children,
  className,
  closeLabel = (0,external_wp_i18n_namespaceObject.__)('Close plugin'),
  identifier: identifierProp,
  header,
  headerClassName,
  icon: iconProp,
  isPinnable = true,
  panelClassName,
  scope,
  name,
  title,
  toggleShortcut,
  isActiveByDefault
}) {
  const context = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  const icon = iconProp || context.icon;
  const identifier = identifierProp || `${context.name}/${name}`;

  // This state is used to delay the rendering of the Fill
  // until the initial effect runs.
  // This prevents the animation from running on mount if
  // the complementary area is active by default.
  const [isReady, setIsReady] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    isLoading,
    isActive,
    isPinned,
    activeArea,
    isSmall,
    isLarge,
    showIconLabels
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getActiveComplementaryArea,
      isComplementaryAreaLoading,
      isItemPinned
    } = select(store);
    const {
      get
    } = select(external_wp_preferences_namespaceObject.store);
    const _activeArea = getActiveComplementaryArea(scope);
    return {
      isLoading: isComplementaryAreaLoading(scope),
      isActive: _activeArea === identifier,
      isPinned: isItemPinned(scope, identifier),
      activeArea: _activeArea,
      isSmall: select(external_wp_viewport_namespaceObject.store).isViewportMatch('< medium'),
      isLarge: select(external_wp_viewport_namespaceObject.store).isViewportMatch('large'),
      showIconLabels: get('core', 'showIconLabels')
    };
  }, [identifier, scope]);
  const isMobileViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');
  useAdjustComplementaryListener(scope, identifier, activeArea, isActive, isSmall);
  const {
    enableComplementaryArea,
    disableComplementaryArea,
    pinItem,
    unpinItem
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Set initial visibility: For large screens, enable if it's active by
    // default. For small screens, always initially disable.
    if (isActiveByDefault && activeArea === undefined && !isSmall) {
      enableComplementaryArea(scope, identifier);
    } else if (activeArea === undefined && isSmall) {
      disableComplementaryArea(scope, identifier);
    }
    setIsReady(true);
  }, [activeArea, isActiveByDefault, scope, identifier, isSmall, enableComplementaryArea, disableComplementaryArea]);
  if (!isReady) {
    return;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [isPinnable && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(pinned_items, {
      scope: scope,
      children: isPinned && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComplementaryAreaToggle, {
        scope: scope,
        identifier: identifier,
        isPressed: isActive && (!showIconLabels || isLarge),
        "aria-expanded": isActive,
        "aria-disabled": isLoading,
        label: title,
        icon: showIconLabels ? library_check : icon,
        showTooltip: !showIconLabels,
        variant: showIconLabels ? 'tertiary' : undefined,
        size: "compact",
        shortcut: toggleShortcut
      })
    }), name && isPinnable && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComplementaryAreaMoreMenuItem, {
      target: name,
      scope: scope,
      icon: icon,
      children: title
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(ComplementaryAreaFill, {
      activeArea: activeArea,
      isActive: isActive,
      className: dist_clsx('interface-complementary-area', className),
      scope: scope,
      id: identifier.replace('/', ':'),
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(complementary_area_header, {
        className: headerClassName,
        closeLabel: closeLabel,
        onClose: () => disableComplementaryArea(scope),
        toggleButtonProps: {
          label: closeLabel,
          size: 'compact',
          shortcut: toggleShortcut,
          scope,
          identifier
        },
        children: header || /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("h2", {
            className: "interface-complementary-area-header__title",
            children: title
          }), isPinnable && !isMobileViewport && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            className: "interface-complementary-area__pin-unpin-item",
            icon: isPinned ? star_filled : star_empty,
            label: isPinned ? (0,external_wp_i18n_namespaceObject.__)('Unpin from toolbar') : (0,external_wp_i18n_namespaceObject.__)('Pin to toolbar'),
            onClick: () => (isPinned ? unpinItem : pinItem)(scope, identifier),
            isPressed: isPinned,
            "aria-expanded": isPinned,
            size: "compact"
          })]
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Panel, {
        className: panelClassName,
        children: children
      })]
    })]
  });
}
ComplementaryArea.Slot = ComplementaryAreaSlot;
/* harmony default export */ const complementary_area = (ComplementaryArea);

;// ./packages/interface/build-module/components/fullscreen-mode/index.js
/**
 * WordPress dependencies
 */

const FullscreenMode = ({
  isActive
}) => {
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    let isSticky = false;
    // `is-fullscreen-mode` is set in PHP as a body class by Gutenberg, and this causes
    // `sticky-menu` to be applied by WordPress and prevents the admin menu being scrolled
    // even if `is-fullscreen-mode` is then removed. Let's remove `sticky-menu` here as
    // a consequence of the FullscreenMode setup.
    if (document.body.classList.contains('sticky-menu')) {
      isSticky = true;
      document.body.classList.remove('sticky-menu');
    }
    return () => {
      if (isSticky) {
        document.body.classList.add('sticky-menu');
      }
    };
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (isActive) {
      document.body.classList.add('is-fullscreen-mode');
    } else {
      document.body.classList.remove('is-fullscreen-mode');
    }
    return () => {
      if (isActive) {
        document.body.classList.remove('is-fullscreen-mode');
      }
    };
  }, [isActive]);
  return null;
};
/* harmony default export */ const fullscreen_mode = (FullscreenMode);

;// ./packages/interface/build-module/components/navigable-region/index.js
/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const NavigableRegion = (0,external_wp_element_namespaceObject.forwardRef)(({
  children,
  className,
  ariaLabel,
  as: Tag = 'div',
  ...props
}, ref) => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Tag, {
    ref: ref,
    className: dist_clsx('interface-navigable-region', className),
    "aria-label": ariaLabel,
    role: "region",
    tabIndex: "-1",
    ...props,
    children: children
  });
});
NavigableRegion.displayName = 'NavigableRegion';
/* harmony default export */ const navigable_region = (NavigableRegion);

;// ./packages/interface/build-module/components/interface-skeleton/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


const interface_skeleton_ANIMATION_DURATION = 0.25;
const commonTransition = {
  type: 'tween',
  duration: interface_skeleton_ANIMATION_DURATION,
  ease: [0.6, 0, 0.4, 1]
};
function useHTMLClass(className) {
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const element = document && document.querySelector(`html:not(.${className})`);
    if (!element) {
      return;
    }
    element.classList.toggle(className);
    return () => {
      element.classList.toggle(className);
    };
  }, [className]);
}
const headerVariants = {
  hidden: {
    opacity: 1,
    marginTop: -60
  },
  visible: {
    opacity: 1,
    marginTop: 0
  },
  distractionFreeHover: {
    opacity: 1,
    marginTop: 0,
    transition: {
      ...commonTransition,
      delay: 0.2,
      delayChildren: 0.2
    }
  },
  distractionFreeHidden: {
    opacity: 0,
    marginTop: -60
  },
  distractionFreeDisabled: {
    opacity: 0,
    marginTop: 0,
    transition: {
      ...commonTransition,
      delay: 0.8,
      delayChildren: 0.8
    }
  }
};
function InterfaceSkeleton({
  isDistractionFree,
  footer,
  header,
  editorNotices,
  sidebar,
  secondarySidebar,
  content,
  actions,
  labels,
  className
}, ref) {
  const [secondarySidebarResizeListener, secondarySidebarSize] = (0,external_wp_compose_namespaceObject.useResizeObserver)();
  const isMobileViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');
  const disableMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const defaultTransition = {
    type: 'tween',
    duration: disableMotion ? 0 : interface_skeleton_ANIMATION_DURATION,
    ease: [0.6, 0, 0.4, 1]
  };
  useHTMLClass('interface-interface-skeleton__html-container');
  const defaultLabels = {
    /* translators: accessibility text for the top bar landmark region. */
    header: (0,external_wp_i18n_namespaceObject._x)('Header', 'header landmark area'),
    /* translators: accessibility text for the content landmark region. */
    body: (0,external_wp_i18n_namespaceObject.__)('Content'),
    /* translators: accessibility text for the secondary sidebar landmark region. */
    secondarySidebar: (0,external_wp_i18n_namespaceObject.__)('Block Library'),
    /* translators: accessibility text for the settings landmark region. */
    sidebar: (0,external_wp_i18n_namespaceObject._x)('Settings', 'settings landmark area'),
    /* translators: accessibility text for the publish landmark region. */
    actions: (0,external_wp_i18n_namespaceObject.__)('Publish'),
    /* translators: accessibility text for the footer landmark region. */
    footer: (0,external_wp_i18n_namespaceObject.__)('Footer')
  };
  const mergedLabels = {
    ...defaultLabels,
    ...labels
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    ref: ref,
    className: dist_clsx(className, 'interface-interface-skeleton', !!footer && 'has-footer'),
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "interface-interface-skeleton__editor",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__unstableAnimatePresence, {
        initial: false,
        children: !!header && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
          as: external_wp_components_namespaceObject.__unstableMotion.div,
          className: "interface-interface-skeleton__header",
          "aria-label": mergedLabels.header,
          initial: isDistractionFree && !isMobileViewport ? 'distractionFreeHidden' : 'hidden',
          whileHover: isDistractionFree && !isMobileViewport ? 'distractionFreeHover' : 'visible',
          animate: isDistractionFree && !isMobileViewport ? 'distractionFreeDisabled' : 'visible',
          exit: isDistractionFree && !isMobileViewport ? 'distractionFreeHidden' : 'hidden',
          variants: headerVariants,
          transition: defaultTransition,
          children: header
        })
      }), isDistractionFree && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "interface-interface-skeleton__header",
        children: editorNotices
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        className: "interface-interface-skeleton__body",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__unstableAnimatePresence, {
          initial: false,
          children: !!secondarySidebar && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
            className: "interface-interface-skeleton__secondary-sidebar",
            ariaLabel: mergedLabels.secondarySidebar,
            as: external_wp_components_namespaceObject.__unstableMotion.div,
            initial: "closed",
            animate: "open",
            exit: "closed",
            variants: {
              open: {
                width: secondarySidebarSize.width
              },
              closed: {
                width: 0
              }
            },
            transition: defaultTransition,
            children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__unstableMotion.div, {
              style: {
                position: 'absolute',
                width: isMobileViewport ? '100vw' : 'fit-content',
                height: '100%',
                left: 0
              },
              variants: {
                open: {
                  x: 0
                },
                closed: {
                  x: '-100%'
                }
              },
              transition: defaultTransition,
              children: [secondarySidebarResizeListener, secondarySidebar]
            })
          })
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
          className: "interface-interface-skeleton__content",
          ariaLabel: mergedLabels.body,
          children: content
        }), !!sidebar && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
          className: "interface-interface-skeleton__sidebar",
          ariaLabel: mergedLabels.sidebar,
          children: sidebar
        }), !!actions && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
          className: "interface-interface-skeleton__actions",
          ariaLabel: mergedLabels.actions,
          children: actions
        })]
      })]
    }), !!footer && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(navigable_region, {
      className: "interface-interface-skeleton__footer",
      ariaLabel: mergedLabels.footer,
      children: footer
    })]
  });
}
/* harmony default export */ const interface_skeleton = ((0,external_wp_element_namespaceObject.forwardRef)(InterfaceSkeleton));

;// ./packages/interface/build-module/components/index.js








;// ./packages/interface/build-module/index.js



;// ./packages/editor/build-module/components/pattern-rename-modal/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const {
  RenamePatternModal
} = unlock(external_wp_patterns_namespaceObject.privateApis);
const modalName = 'editor/pattern-rename';
function PatternRenameModal() {
  const {
    record,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId
    } = select(store_store);
    const {
      getEditedEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const _postType = getCurrentPostType();
    return {
      record: getEditedEntityRecord('postType', _postType, getCurrentPostId()),
      postType: _postType
    };
  }, []);
  const {
    closeModal
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const isActive = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).isModalActive(modalName));
  if (!isActive || postType !== PATTERN_POST_TYPE) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(RenamePatternModal, {
    onClose: closeModal,
    pattern: record
  });
}

;// ./packages/editor/build-module/components/pattern-duplicate-modal/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const {
  DuplicatePatternModal
} = unlock(external_wp_patterns_namespaceObject.privateApis);
const pattern_duplicate_modal_modalName = 'editor/pattern-duplicate';
function PatternDuplicateModal() {
  const {
    record,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId
    } = select(store_store);
    const {
      getEditedEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const _postType = getCurrentPostType();
    return {
      record: getEditedEntityRecord('postType', _postType, getCurrentPostId()),
      postType: _postType
    };
  }, []);
  const {
    closeModal
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const isActive = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).isModalActive(pattern_duplicate_modal_modalName));
  if (!isActive || postType !== PATTERN_POST_TYPE) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DuplicatePatternModal, {
    onClose: closeModal,
    onSuccess: () => closeModal(),
    pattern: record
  });
}

;// ./packages/editor/build-module/components/commands/index.js
/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */






const getEditorCommandLoader = () => function useEditorCommandLoader() {
  const {
    editorMode,
    isListViewOpen,
    showBlockBreadcrumbs,
    isDistractionFree,
    isFocusMode,
    isPreviewMode,
    isViewable,
    isCodeEditingEnabled,
    isRichEditingEnabled,
    isPublishSidebarEnabled
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _get, _getPostType$viewable;
    const {
      get
    } = select(external_wp_preferences_namespaceObject.store);
    const {
      isListViewOpened,
      getCurrentPostType,
      getEditorSettings
    } = select(store_store);
    const {
      getSettings
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      editorMode: (_get = get('core', 'editorMode')) !== null && _get !== void 0 ? _get : 'visual',
      isListViewOpen: isListViewOpened(),
      showBlockBreadcrumbs: get('core', 'showBlockBreadcrumbs'),
      isDistractionFree: get('core', 'distractionFree'),
      isFocusMode: get('core', 'focusMode'),
      isPreviewMode: getSettings().isPreviewMode,
      isViewable: (_getPostType$viewable = getPostType(getCurrentPostType())?.viewable) !== null && _getPostType$viewable !== void 0 ? _getPostType$viewable : false,
      isCodeEditingEnabled: getEditorSettings().codeEditingEnabled,
      isRichEditingEnabled: getEditorSettings().richEditingEnabled,
      isPublishSidebarEnabled: select(store_store).isPublishSidebarEnabled()
    };
  }, []);
  const {
    getActiveComplementaryArea
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    toggle
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_preferences_namespaceObject.store);
  const {
    createInfoNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    __unstableSaveForPreview,
    setIsListViewOpened,
    switchEditorMode,
    toggleDistractionFree,
    toggleSpotlightMode,
    toggleTopToolbar
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    openModal,
    enableComplementaryArea,
    disableComplementaryArea
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    getCurrentPostId
  } = (0,external_wp_data_namespaceObject.useSelect)(store_store);
  const allowSwitchEditorMode = isCodeEditingEnabled && isRichEditingEnabled;
  if (isPreviewMode) {
    return {
      commands: [],
      isLoading: false
    };
  }
  const commands = [];
  commands.push({
    name: 'core/open-shortcut-help',
    label: (0,external_wp_i18n_namespaceObject.__)('Keyboard shortcuts'),
    icon: library_keyboard,
    callback: ({
      close
    }) => {
      close();
      openModal('editor/keyboard-shortcut-help');
    }
  });
  commands.push({
    name: 'core/toggle-distraction-free',
    label: isDistractionFree ? (0,external_wp_i18n_namespaceObject.__)('Exit Distraction free') : (0,external_wp_i18n_namespaceObject.__)('Enter Distraction free'),
    callback: ({
      close
    }) => {
      toggleDistractionFree();
      close();
    }
  });
  commands.push({
    name: 'core/open-preferences',
    label: (0,external_wp_i18n_namespaceObject.__)('Editor preferences'),
    callback: ({
      close
    }) => {
      close();
      openModal('editor/preferences');
    }
  });
  commands.push({
    name: 'core/toggle-spotlight-mode',
    label: isFocusMode ? (0,external_wp_i18n_namespaceObject.__)('Exit Spotlight mode') : (0,external_wp_i18n_namespaceObject.__)('Enter Spotlight mode'),
    callback: ({
      close
    }) => {
      toggleSpotlightMode();
      close();
    }
  });
  commands.push({
    name: 'core/toggle-list-view',
    label: isListViewOpen ? (0,external_wp_i18n_namespaceObject.__)('Close List View') : (0,external_wp_i18n_namespaceObject.__)('Open List View'),
    icon: list_view,
    callback: ({
      close
    }) => {
      setIsListViewOpened(!isListViewOpen);
      close();
      createInfoNotice(isListViewOpen ? (0,external_wp_i18n_namespaceObject.__)('List View off.') : (0,external_wp_i18n_namespaceObject.__)('List View on.'), {
        id: 'core/editor/toggle-list-view/notice',
        type: 'snackbar'
      });
    }
  });
  commands.push({
    name: 'core/toggle-top-toolbar',
    label: (0,external_wp_i18n_namespaceObject.__)('Top toolbar'),
    callback: ({
      close
    }) => {
      toggleTopToolbar();
      close();
    }
  });
  if (allowSwitchEditorMode) {
    commands.push({
      name: 'core/toggle-code-editor',
      label: editorMode === 'visual' ? (0,external_wp_i18n_namespaceObject.__)('Open code editor') : (0,external_wp_i18n_namespaceObject.__)('Exit code editor'),
      icon: library_code,
      callback: ({
        close
      }) => {
        switchEditorMode(editorMode === 'visual' ? 'text' : 'visual');
        close();
      }
    });
  }
  commands.push({
    name: 'core/toggle-breadcrumbs',
    label: showBlockBreadcrumbs ? (0,external_wp_i18n_namespaceObject.__)('Hide block breadcrumbs') : (0,external_wp_i18n_namespaceObject.__)('Show block breadcrumbs'),
    callback: ({
      close
    }) => {
      toggle('core', 'showBlockBreadcrumbs');
      close();
      createInfoNotice(showBlockBreadcrumbs ? (0,external_wp_i18n_namespaceObject.__)('Breadcrumbs hidden.') : (0,external_wp_i18n_namespaceObject.__)('Breadcrumbs visible.'), {
        id: 'core/editor/toggle-breadcrumbs/notice',
        type: 'snackbar'
      });
    }
  });
  commands.push({
    name: 'core/open-settings-sidebar',
    label: (0,external_wp_i18n_namespaceObject.__)('Show or hide the Settings panel'),
    icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? drawer_left : drawer_right,
    callback: ({
      close
    }) => {
      const activeSidebar = getActiveComplementaryArea('core');
      close();
      if (activeSidebar === 'edit-post/document') {
        disableComplementaryArea('core');
      } else {
        enableComplementaryArea('core', 'edit-post/document');
      }
    }
  });
  commands.push({
    name: 'core/open-block-inspector',
    label: (0,external_wp_i18n_namespaceObject.__)('Show or hide the Block settings panel'),
    icon: block_default,
    callback: ({
      close
    }) => {
      const activeSidebar = getActiveComplementaryArea('core');
      close();
      if (activeSidebar === 'edit-post/block') {
        disableComplementaryArea('core');
      } else {
        enableComplementaryArea('core', 'edit-post/block');
      }
    }
  });
  commands.push({
    name: 'core/toggle-publish-sidebar',
    label: isPublishSidebarEnabled ? (0,external_wp_i18n_namespaceObject.__)('Disable pre-publish checks') : (0,external_wp_i18n_namespaceObject.__)('Enable pre-publish checks'),
    icon: format_list_bullets,
    callback: ({
      close
    }) => {
      close();
      toggle('core', 'isPublishSidebarEnabled');
      createInfoNotice(isPublishSidebarEnabled ? (0,external_wp_i18n_namespaceObject.__)('Pre-publish checks disabled.') : (0,external_wp_i18n_namespaceObject.__)('Pre-publish checks enabled.'), {
        id: 'core/editor/publish-sidebar/notice',
        type: 'snackbar'
      });
    }
  });
  if (isViewable) {
    commands.push({
      name: 'core/preview-link',
      label: (0,external_wp_i18n_namespaceObject.__)('Preview in a new tab'),
      icon: library_external,
      callback: async ({
        close
      }) => {
        close();
        const postId = getCurrentPostId();
        const link = await __unstableSaveForPreview();
        window.open(link, `wp-preview-${postId}`);
      }
    });
  }
  return {
    commands,
    isLoading: false
  };
};
const getEditedEntityContextualCommands = () => function useEditedEntityContextualCommands() {
  const {
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType
    } = select(store_store);
    return {
      postType: getCurrentPostType()
    };
  }, []);
  const {
    openModal
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const commands = [];
  if (postType === PATTERN_POST_TYPE) {
    commands.push({
      name: 'core/rename-pattern',
      label: (0,external_wp_i18n_namespaceObject.__)('Rename pattern'),
      icon: library_edit,
      callback: ({
        close
      }) => {
        openModal(modalName);
        close();
      }
    });
    commands.push({
      name: 'core/duplicate-pattern',
      label: (0,external_wp_i18n_namespaceObject.__)('Duplicate pattern'),
      icon: library_symbol,
      callback: ({
        close
      }) => {
        openModal(pattern_duplicate_modal_modalName);
        close();
      }
    });
  }
  return {
    isLoading: false,
    commands
  };
};
const getPageContentFocusCommands = () => function usePageContentFocusCommands() {
  const {
    onNavigateToEntityRecord,
    goBack,
    templateId,
    isPreviewMode
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getRenderingMode,
      getEditorSettings: _getEditorSettings,
      getCurrentTemplateId
    } = unlock(select(store_store));
    const editorSettings = _getEditorSettings();
    return {
      isTemplateHidden: getRenderingMode() === 'post-only',
      onNavigateToEntityRecord: editorSettings.onNavigateToEntityRecord,
      getEditorSettings: _getEditorSettings,
      goBack: editorSettings.onNavigateToPreviousEntityRecord,
      templateId: getCurrentTemplateId(),
      isPreviewMode: editorSettings.isPreviewMode
    };
  }, []);
  const {
    editedRecord: template,
    hasResolved
  } = (0,external_wp_coreData_namespaceObject.useEntityRecord)('postType', 'wp_template', templateId);
  if (isPreviewMode) {
    return {
      isLoading: false,
      commands: []
    };
  }
  const commands = [];
  if (templateId && hasResolved) {
    commands.push({
      name: 'core/switch-to-template-focus',
      label: (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: template title */
      (0,external_wp_i18n_namespaceObject.__)('Edit template: %s'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title)),
      icon: library_layout,
      callback: ({
        close
      }) => {
        onNavigateToEntityRecord({
          postId: templateId,
          postType: 'wp_template'
        });
        close();
      }
    });
  }
  if (!!goBack) {
    commands.push({
      name: 'core/switch-to-previous-entity',
      label: (0,external_wp_i18n_namespaceObject.__)('Go back'),
      icon: library_page,
      callback: ({
        close
      }) => {
        goBack();
        close();
      }
    });
  }
  return {
    isLoading: false,
    commands
  };
};
const getManipulateDocumentCommands = () => function useManipulateDocumentCommands() {
  const {
    postType,
    postId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostId,
      getCurrentPostType
    } = select(store_store);
    return {
      postType: getCurrentPostType(),
      postId: getCurrentPostId()
    };
  }, []);
  const {
    editedRecord: template,
    hasResolved
  } = (0,external_wp_coreData_namespaceObject.useEntityRecord)('postType', postType, postId);
  // eslint-disable-next-line @wordpress/no-unused-vars-before-return
  const {
    revertTemplate
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store_store));
  if (!hasResolved || ![TEMPLATE_PART_POST_TYPE, TEMPLATE_POST_TYPE].includes(postType)) {
    return {
      isLoading: true,
      commands: []
    };
  }
  const commands = [];
  if (isTemplateRevertable(template)) {
    const label = template.type === TEMPLATE_POST_TYPE ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: template title */
    (0,external_wp_i18n_namespaceObject.__)('Reset template: %s'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title)) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: template part title */
    (0,external_wp_i18n_namespaceObject.__)('Reset template part: %s'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title));
    commands.push({
      name: 'core/reset-template',
      label,
      icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? rotate_right : rotate_left,
      callback: ({
        close
      }) => {
        revertTemplate(template);
        close();
      }
    });
  }
  return {
    isLoading: !hasResolved,
    commands
  };
};
function useCommands() {
  (0,external_wp_commands_namespaceObject.useCommandLoader)({
    name: 'core/editor/edit-ui',
    hook: getEditorCommandLoader()
  });
  (0,external_wp_commands_namespaceObject.useCommandLoader)({
    name: 'core/editor/contextual-commands',
    hook: getEditedEntityContextualCommands(),
    context: 'entity-edit'
  });
  (0,external_wp_commands_namespaceObject.useCommandLoader)({
    name: 'core/editor/page-content-focus',
    hook: getPageContentFocusCommands(),
    context: 'entity-edit'
  });
  (0,external_wp_commands_namespaceObject.useCommandLoader)({
    name: 'core/edit-site/manipulate-document',
    hook: getManipulateDocumentCommands()
  });
}

;// ./packages/editor/build-module/components/block-removal-warnings/index.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



const {
  BlockRemovalWarningModal
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);

// Prevent accidental removal of certain blocks, asking the user for confirmation first.
const TEMPLATE_BLOCKS = ['core/post-content', 'core/post-template', 'core/query'];
const BLOCK_REMOVAL_RULES = [{
  // Template blocks.
  // The warning is only shown when a user manipulates templates or template parts.
  postTypes: ['wp_template', 'wp_template_part'],
  callback(removedBlocks) {
    const removedTemplateBlocks = removedBlocks.filter(({
      name
    }) => TEMPLATE_BLOCKS.includes(name));
    if (removedTemplateBlocks.length) {
      return (0,external_wp_i18n_namespaceObject._n)('Deleting this block will stop your post or page content from displaying on this template. It is not recommended.', 'Some of the deleted blocks will stop your post or page content from displaying on this template. It is not recommended.', removedBlocks.length);
    }
  }
}, {
  // Pattern overrides.
  // The warning is only shown when the user edits a pattern.
  postTypes: ['wp_block'],
  callback(removedBlocks) {
    const removedBlocksWithOverrides = removedBlocks.filter(({
      attributes
    }) => attributes?.metadata?.bindings && Object.values(attributes.metadata.bindings).some(binding => binding.source === 'core/pattern-overrides'));
    if (removedBlocksWithOverrides.length) {
      return (0,external_wp_i18n_namespaceObject._n)('The deleted block allows instance overrides. Removing it may result in content not displaying where this pattern is used. Are you sure you want to proceed?', 'Some of the deleted blocks allow instance overrides. Removing them may result in content not displaying where this pattern is used. Are you sure you want to proceed?', removedBlocks.length);
    }
  }
}];
function BlockRemovalWarnings() {
  const currentPostType = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getCurrentPostType(), []);
  const removalRulesForPostType = (0,external_wp_element_namespaceObject.useMemo)(() => BLOCK_REMOVAL_RULES.filter(rule => rule.postTypes.includes(currentPostType)), [currentPostType]);

  // `BlockRemovalWarnings` is rendered in the editor provider, a shared component
  // across react native and web. However, `BlockRemovalWarningModal` is web only.
  // Check it exists before trying to render it.
  if (!BlockRemovalWarningModal) {
    return null;
  }
  if (!removalRulesForPostType) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockRemovalWarningModal, {
    rules: removalRulesForPostType
  });
}

;// ./packages/editor/build-module/components/start-page-options/index.js
/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */



function useStartPatterns() {
  // A pattern is a start pattern if it includes 'core/post-content' in its blockTypes,
  // and it has no postTypes declared and the current post type is page or if
  // the current post type is part of the postTypes declared.
  const {
    blockPatternsWithPostContentBlockType,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getPatternsByBlockTypes,
      getBlocksByName
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      getCurrentPostType,
      getRenderingMode
    } = select(store_store);
    const rootClientId = getRenderingMode() === 'post-only' ? '' : getBlocksByName('core/post-content')?.[0];
    return {
      blockPatternsWithPostContentBlockType: getPatternsByBlockTypes('core/post-content', rootClientId),
      postType: getCurrentPostType()
    };
  }, []);
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!blockPatternsWithPostContentBlockType?.length) {
      return [];
    }

    /*
     * Filter patterns without postTypes declared if the current postType is page
     * or patterns that declare the current postType in its post type array.
     */
    return blockPatternsWithPostContentBlockType.filter(pattern => {
      return postType === 'page' && !pattern.postTypes || Array.isArray(pattern.postTypes) && pattern.postTypes.includes(postType);
    });
  }, [postType, blockPatternsWithPostContentBlockType]);
}
function PatternSelection({
  blockPatterns,
  onChoosePattern
}) {
  const {
    editEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const {
    postType,
    postId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId
    } = select(store_store);
    return {
      postType: getCurrentPostType(),
      postId: getCurrentPostId()
    };
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalBlockPatternsList, {
    blockPatterns: blockPatterns,
    onClickPattern: (_pattern, blocks) => {
      editEntityRecord('postType', postType, postId, {
        blocks,
        content: ({
          blocks: blocksForSerialization = []
        }) => (0,external_wp_blocks_namespaceObject.__unstableSerializeAndClean)(blocksForSerialization)
      });
      onChoosePattern();
    }
  });
}
function StartPageOptionsModal({
  onClose
}) {
  const [showStartPatterns, setShowStartPatterns] = (0,external_wp_element_namespaceObject.useState)(true);
  const {
    set: setPreference
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_preferences_namespaceObject.store);
  const startPatterns = useStartPatterns();
  const hasStartPattern = startPatterns.length > 0;
  if (!hasStartPattern) {
    return null;
  }
  function handleClose() {
    onClose();
    setPreference('core', 'enableChoosePatternModal', showStartPatterns);
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Modal, {
    className: "editor-start-page-options__modal",
    title: (0,external_wp_i18n_namespaceObject.__)('Choose a pattern'),
    isFullScreen: true,
    onRequestClose: handleClose,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "editor-start-page-options__modal-content",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternSelection, {
        blockPatterns: startPatterns,
        onChoosePattern: handleClose
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
      className: "editor-start-page-options__modal__actions",
      justify: "flex-end",
      expanded: false,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToggleControl, {
          __nextHasNoMarginBottom: true,
          checked: showStartPatterns,
          label: (0,external_wp_i18n_namespaceObject.__)('Show starter patterns'),
          help: (0,external_wp_i18n_namespaceObject.__)('Shows starter patterns when creating a new page.'),
          onChange: newValue => {
            setShowStartPatterns(newValue);
          }
        })
      })
    })]
  });
}
function StartPageOptions() {
  const [isOpen, setIsOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    isEditedPostDirty,
    isEditedPostEmpty
  } = (0,external_wp_data_namespaceObject.useSelect)(store_store);
  const {
    isModalActive
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    enabled,
    postId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostId,
      getCurrentPostType
    } = select(store_store);
    const choosePatternModalEnabled = select(external_wp_preferences_namespaceObject.store).get('core', 'enableChoosePatternModal');
    return {
      postId: getCurrentPostId(),
      enabled: choosePatternModalEnabled && TEMPLATE_POST_TYPE !== getCurrentPostType()
    };
  }, []);

  // Note: The `postId` ensures the effect re-runs when pages are switched without remounting the component.
  // Examples: changing pages in the List View, creating a new page via Command Palette.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const isFreshPage = !isEditedPostDirty() && isEditedPostEmpty();
    // Prevents immediately opening when features is enabled via preferences modal.
    const isPreferencesModalActive = isModalActive('editor/preferences');
    if (!enabled || !isFreshPage || isPreferencesModalActive) {
      return;
    }

    // Open the modal after the initial render for a new page.
    setIsOpen(true);
  }, [enabled, postId, isEditedPostDirty, isEditedPostEmpty, isModalActive]);
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(StartPageOptionsModal, {
    onClose: () => setIsOpen(false)
  });
}

;// external ["wp","keyboardShortcuts"]
const external_wp_keyboardShortcuts_namespaceObject = window["wp"]["keyboardShortcuts"];
;// ./packages/editor/build-module/components/keyboard-shortcut-help-modal/config.js
/**
 * WordPress dependencies
 */

const textFormattingShortcuts = [{
  keyCombination: {
    modifier: 'primary',
    character: 'b'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Make the selected text bold.')
}, {
  keyCombination: {
    modifier: 'primary',
    character: 'i'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Make the selected text italic.')
}, {
  keyCombination: {
    modifier: 'primary',
    character: 'k'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Convert the selected text into a link.')
}, {
  keyCombination: {
    modifier: 'primaryShift',
    character: 'k'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Remove a link.')
}, {
  keyCombination: {
    character: '[['
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Insert a link to a post or page.')
}, {
  keyCombination: {
    modifier: 'primary',
    character: 'u'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Underline the selected text.')
}, {
  keyCombination: {
    modifier: 'access',
    character: 'd'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Strikethrough the selected text.')
}, {
  keyCombination: {
    modifier: 'access',
    character: 'x'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Make the selected text inline code.')
}, {
  keyCombination: {
    modifier: 'access',
    character: '0'
  },
  aliases: [{
    modifier: 'access',
    character: '7'
  }],
  description: (0,external_wp_i18n_namespaceObject.__)('Convert the current heading to a paragraph.')
}, {
  keyCombination: {
    modifier: 'access',
    character: '1-6'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Convert the current paragraph or heading to a heading of level 1 to 6.')
}, {
  keyCombination: {
    modifier: 'primaryShift',
    character: 'SPACE'
  },
  description: (0,external_wp_i18n_namespaceObject.__)('Add non breaking space.')
}];

;// external ["wp","keycodes"]
const external_wp_keycodes_namespaceObject = window["wp"]["keycodes"];
;// ./packages/editor/build-module/components/keyboard-shortcut-help-modal/shortcut.js
/**
 * WordPress dependencies
 */



function KeyCombination({
  keyCombination,
  forceAriaLabel
}) {
  const shortcut = keyCombination.modifier ? external_wp_keycodes_namespaceObject.displayShortcutList[keyCombination.modifier](keyCombination.character) : keyCombination.character;
  const ariaLabel = keyCombination.modifier ? external_wp_keycodes_namespaceObject.shortcutAriaLabel[keyCombination.modifier](keyCombination.character) : keyCombination.character;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("kbd", {
    className: "editor-keyboard-shortcut-help-modal__shortcut-key-combination",
    "aria-label": forceAriaLabel || ariaLabel,
    children: (Array.isArray(shortcut) ? shortcut : [shortcut]).map((character, index) => {
      if (character === '+') {
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_element_namespaceObject.Fragment, {
          children: character
        }, index);
      }
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("kbd", {
        className: "editor-keyboard-shortcut-help-modal__shortcut-key",
        children: character
      }, index);
    })
  });
}
function Shortcut({
  description,
  keyCombination,
  aliases = [],
  ariaLabel
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "editor-keyboard-shortcut-help-modal__shortcut-description",
      children: description
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "editor-keyboard-shortcut-help-modal__shortcut-term",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(KeyCombination, {
        keyCombination: keyCombination,
        forceAriaLabel: ariaLabel
      }), aliases.map((alias, index) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(KeyCombination, {
        keyCombination: alias,
        forceAriaLabel: ariaLabel
      }, index))]
    })]
  });
}
/* harmony default export */ const keyboard_shortcut_help_modal_shortcut = (Shortcut);

;// ./packages/editor/build-module/components/keyboard-shortcut-help-modal/dynamic-shortcut.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function DynamicShortcut({
  name
}) {
  const {
    keyCombination,
    description,
    aliases
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getShortcutKeyCombination,
      getShortcutDescription,
      getShortcutAliases
    } = select(external_wp_keyboardShortcuts_namespaceObject.store);
    return {
      keyCombination: getShortcutKeyCombination(name),
      aliases: getShortcutAliases(name),
      description: getShortcutDescription(name)
    };
  }, [name]);
  if (!keyCombination) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(keyboard_shortcut_help_modal_shortcut, {
    keyCombination: keyCombination,
    description: description,
    aliases: aliases
  });
}
/* harmony default export */ const dynamic_shortcut = (DynamicShortcut);

;// ./packages/editor/build-module/components/keyboard-shortcut-help-modal/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




const KEYBOARD_SHORTCUT_HELP_MODAL_NAME = 'editor/keyboard-shortcut-help';
const ShortcutList = ({
  shortcuts
}) =>
/*#__PURE__*/
/*
 * Disable reason: The `list` ARIA role is redundant but
 * Safari+VoiceOver won't announce the list otherwise.
 */
/* eslint-disable jsx-a11y/no-redundant-roles */
(0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", {
  className: "editor-keyboard-shortcut-help-modal__shortcut-list",
  role: "list",
  children: shortcuts.map((shortcut, index) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("li", {
    className: "editor-keyboard-shortcut-help-modal__shortcut",
    children: typeof shortcut === 'string' ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(dynamic_shortcut, {
      name: shortcut
    }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(keyboard_shortcut_help_modal_shortcut, {
      ...shortcut
    })
  }, index))
})
/* eslint-enable jsx-a11y/no-redundant-roles */;
const ShortcutSection = ({
  title,
  shortcuts,
  className
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("section", {
  className: dist_clsx('editor-keyboard-shortcut-help-modal__section', className),
  children: [!!title && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("h2", {
    className: "editor-keyboard-shortcut-help-modal__section-title",
    children: title
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutList, {
    shortcuts: shortcuts
  })]
});
const ShortcutCategorySection = ({
  title,
  categoryName,
  additionalShortcuts = []
}) => {
  const categoryShortcuts = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_keyboardShortcuts_namespaceObject.store).getCategoryShortcuts(categoryName);
  }, [categoryName]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutSection, {
    title: title,
    shortcuts: categoryShortcuts.concat(additionalShortcuts)
  });
};
function KeyboardShortcutHelpModal() {
  const isModalActive = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).isModalActive(KEYBOARD_SHORTCUT_HELP_MODAL_NAME), []);
  const {
    openModal,
    closeModal
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const toggleModal = () => {
    if (isModalActive) {
      closeModal();
    } else {
      openModal(KEYBOARD_SHORTCUT_HELP_MODAL_NAME);
    }
  };
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/keyboard-shortcuts', toggleModal);
  if (!isModalActive) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Modal, {
    className: "editor-keyboard-shortcut-help-modal",
    title: (0,external_wp_i18n_namespaceObject.__)('Keyboard shortcuts'),
    closeButtonLabel: (0,external_wp_i18n_namespaceObject.__)('Close'),
    onRequestClose: toggleModal,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutSection, {
      className: "editor-keyboard-shortcut-help-modal__main-shortcuts",
      shortcuts: ['core/editor/keyboard-shortcuts']
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutCategorySection, {
      title: (0,external_wp_i18n_namespaceObject.__)('Global shortcuts'),
      categoryName: "global"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutCategorySection, {
      title: (0,external_wp_i18n_namespaceObject.__)('Selection shortcuts'),
      categoryName: "selection"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutCategorySection, {
      title: (0,external_wp_i18n_namespaceObject.__)('Block shortcuts'),
      categoryName: "block",
      additionalShortcuts: [{
        keyCombination: {
          character: '/'
        },
        description: (0,external_wp_i18n_namespaceObject.__)('Change the block type after adding a new paragraph.'),
        /* translators: The forward-slash character. e.g. '/'. */
        ariaLabel: (0,external_wp_i18n_namespaceObject.__)('Forward-slash')
      }]
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutSection, {
      title: (0,external_wp_i18n_namespaceObject.__)('Text formatting'),
      shortcuts: textFormattingShortcuts
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShortcutCategorySection, {
      title: (0,external_wp_i18n_namespaceObject.__)('List View shortcuts'),
      categoryName: "list-view"
    })]
  });
}
/* harmony default export */ const keyboard_shortcut_help_modal = (KeyboardShortcutHelpModal);

;// ./packages/editor/build-module/components/block-settings-menu/content-only-settings-menu.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function ContentOnlySettingsMenuItems({
  clientId,
  onClose
}) {
  const postContentBlocks = usePostContentBlocks();
  const {
    entity,
    onNavigateToEntityRecord,
    canEditTemplates
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockParentsByBlockName,
      getSettings,
      getBlockAttributes,
      getBlockParents
    } = select(external_wp_blockEditor_namespaceObject.store);
    const {
      getCurrentTemplateId,
      getRenderingMode
    } = select(store_store);
    const patternParent = getBlockParentsByBlockName(clientId, 'core/block', true)[0];
    let record;
    if (patternParent) {
      record = select(external_wp_coreData_namespaceObject.store).getEntityRecord('postType', 'wp_block', getBlockAttributes(patternParent).ref);
    } else if (getRenderingMode() === 'template-locked' && !getBlockParents(clientId).some(parent => postContentBlocks.includes(parent))) {
      record = select(external_wp_coreData_namespaceObject.store).getEntityRecord('postType', 'wp_template', getCurrentTemplateId());
    }
    if (!record) {
      return {};
    }
    const _canEditTemplates = select(external_wp_coreData_namespaceObject.store).canUser('create', {
      kind: 'postType',
      name: 'wp_template'
    });
    return {
      canEditTemplates: _canEditTemplates,
      entity: record,
      onNavigateToEntityRecord: getSettings().onNavigateToEntityRecord
    };
  }, [clientId, postContentBlocks]);
  if (!entity) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TemplateLockContentOnlyMenuItems, {
      clientId: clientId,
      onClose: onClose
    });
  }
  const isPattern = entity.type === 'wp_block';
  let helpText = isPattern ? (0,external_wp_i18n_namespaceObject.__)('Edit the pattern to move, delete, or make further changes to this block.') : (0,external_wp_i18n_namespaceObject.__)('Edit the template to move, delete, or make further changes to this block.');
  if (!canEditTemplates) {
    helpText = (0,external_wp_i18n_namespaceObject.__)('Only users with permissions to edit the template can move or delete this block');
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__unstableBlockSettingsMenuFirstItem, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
        onClick: () => {
          onNavigateToEntityRecord({
            postId: entity.id,
            postType: entity.type
          });
        },
        disabled: !canEditTemplates,
        children: isPattern ? (0,external_wp_i18n_namespaceObject.__)('Edit pattern') : (0,external_wp_i18n_namespaceObject.__)('Edit template')
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
      variant: "muted",
      as: "p",
      className: "editor-content-only-settings-menu__description",
      children: helpText
    })]
  });
}
function TemplateLockContentOnlyMenuItems({
  clientId,
  onClose
}) {
  const {
    contentLockingParent
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getContentLockingParent
    } = unlock(select(external_wp_blockEditor_namespaceObject.store));
    return {
      contentLockingParent: getContentLockingParent(clientId)
    };
  }, [clientId]);
  const blockDisplayInformation = (0,external_wp_blockEditor_namespaceObject.useBlockDisplayInformation)(contentLockingParent);
  const blockEditorActions = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  if (!blockDisplayInformation?.title) {
    return null;
  }
  const {
    modifyContentLockBlock
  } = unlock(blockEditorActions);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__unstableBlockSettingsMenuFirstItem, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
        onClick: () => {
          modifyContentLockBlock(contentLockingParent);
          onClose();
        },
        children: (0,external_wp_i18n_namespaceObject._x)('Unlock', 'Unlock content locked blocks')
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
      variant: "muted",
      as: "p",
      className: "editor-content-only-settings-menu__description",
      children: (0,external_wp_i18n_namespaceObject.__)('Temporarily unlock the parent block to edit, delete or make further changes to this block.')
    })]
  });
}
function ContentOnlySettingsMenu() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockSettingsMenuControls, {
    children: ({
      selectedClientIds,
      onClose
    }) => selectedClientIds.length === 1 && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ContentOnlySettingsMenuItems, {
      clientId: selectedClientIds[0],
      onClose: onClose
    })
  });
}

;// ./packages/editor/build-module/components/start-template-options/index.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



function useFallbackTemplateContent(slug, isCustom = false) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEntityRecord,
      getDefaultTemplateId
    } = select(external_wp_coreData_namespaceObject.store);
    const templateId = getDefaultTemplateId({
      slug,
      is_custom: isCustom,
      ignore_empty: true
    });
    return templateId ? getEntityRecord('postType', TEMPLATE_POST_TYPE, templateId)?.content?.raw : undefined;
  }, [slug, isCustom]);
}
function start_template_options_useStartPatterns(fallbackContent) {
  const {
    slug,
    patterns
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId
    } = select(store_store);
    const {
      getEntityRecord,
      getBlockPatterns
    } = select(external_wp_coreData_namespaceObject.store);
    const postId = getCurrentPostId();
    const postType = getCurrentPostType();
    const record = getEntityRecord('postType', postType, postId);
    return {
      slug: record.slug,
      patterns: getBlockPatterns()
    };
  }, []);
  const currentThemeStylesheet = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getCurrentTheme().stylesheet);

  // Duplicated from packages/block-library/src/pattern/edit.js.
  function injectThemeAttributeInBlockTemplateContent(block) {
    if (block.innerBlocks.find(innerBlock => innerBlock.name === 'core/template-part')) {
      block.innerBlocks = block.innerBlocks.map(innerBlock => {
        if (innerBlock.name === 'core/template-part' && innerBlock.attributes.theme === undefined) {
          innerBlock.attributes.theme = currentThemeStylesheet;
        }
        return innerBlock;
      });
    }
    if (block.name === 'core/template-part' && block.attributes.theme === undefined) {
      block.attributes.theme = currentThemeStylesheet;
    }
    return block;
  }
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    // filter patterns that are supposed to be used in the current template being edited.
    return [{
      name: 'fallback',
      blocks: (0,external_wp_blocks_namespaceObject.parse)(fallbackContent),
      title: (0,external_wp_i18n_namespaceObject.__)('Fallback content')
    }, ...patterns.filter(pattern => {
      return Array.isArray(pattern.templateTypes) && pattern.templateTypes.some(templateType => slug.startsWith(templateType));
    }).map(pattern => {
      return {
        ...pattern,
        blocks: (0,external_wp_blocks_namespaceObject.parse)(pattern.content).map(block => injectThemeAttributeInBlockTemplateContent(block))
      };
    })];
  }, [fallbackContent, slug, patterns]);
}
function start_template_options_PatternSelection({
  fallbackContent,
  onChoosePattern,
  postType
}) {
  const [,, onChange] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', postType);
  const blockPatterns = start_template_options_useStartPatterns(fallbackContent);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalBlockPatternsList, {
    blockPatterns: blockPatterns,
    onClickPattern: (pattern, blocks) => {
      onChange(blocks, {
        selection: undefined
      });
      onChoosePattern();
    }
  });
}
function StartModal({
  slug,
  isCustom,
  onClose,
  postType
}) {
  const fallbackContent = useFallbackTemplateContent(slug, isCustom);
  if (!fallbackContent) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Modal, {
    className: "editor-start-template-options__modal",
    title: (0,external_wp_i18n_namespaceObject.__)('Choose a pattern'),
    closeLabel: (0,external_wp_i18n_namespaceObject.__)('Cancel'),
    focusOnMount: "firstElement",
    onRequestClose: onClose,
    isFullScreen: true,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "editor-start-template-options__modal-content",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(start_template_options_PatternSelection, {
        fallbackContent: fallbackContent,
        slug: slug,
        isCustom: isCustom,
        postType: postType,
        onChoosePattern: () => {
          onClose();
        }
      })
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
      className: "editor-start-template-options__modal__actions",
      justify: "flex-end",
      expanded: false,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "tertiary",
          onClick: onClose,
          children: (0,external_wp_i18n_namespaceObject.__)('Skip')
        })
      })
    })]
  });
}
function StartTemplateOptions() {
  const [isClosed, setIsClosed] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    shouldOpenModal,
    slug,
    isCustom,
    postType,
    postId
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId
    } = select(store_store);
    const _postType = getCurrentPostType();
    const _postId = getCurrentPostId();
    const {
      getEditedEntityRecord,
      hasEditsForEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const templateRecord = getEditedEntityRecord('postType', _postType, _postId);
    const hasEdits = hasEditsForEntityRecord('postType', _postType, _postId);
    return {
      shouldOpenModal: !hasEdits && '' === templateRecord.content && TEMPLATE_POST_TYPE === _postType,
      slug: templateRecord.slug,
      isCustom: templateRecord.is_custom,
      postType: _postType,
      postId: _postId
    };
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Should reset the modal state when navigating to a new page/post.
    setIsClosed(false);
  }, [postType, postId]);
  if (!shouldOpenModal || isClosed) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(StartModal, {
    slug: slug,
    isCustom: isCustom,
    postType: postType,
    onClose: () => setIsClosed(true)
  });
}

;// ./packages/editor/build-module/components/global-keyboard-shortcuts/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


/**
 * Handles the keyboard shortcuts for the editor.
 *
 * It provides functionality for various keyboard shortcuts such as toggling editor mode,
 * toggling distraction-free mode, undo/redo, saving the post, toggling list view,
 * and toggling the sidebar.
 */
function EditorKeyboardShortcuts() {
  const isModeToggleDisabled = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      richEditingEnabled,
      codeEditingEnabled
    } = select(store_store).getEditorSettings();
    return !richEditingEnabled || !codeEditingEnabled;
  }, []);
  const {
    getBlockSelectionStart
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const {
    getActiveComplementaryArea
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const {
    enableComplementaryArea,
    disableComplementaryArea
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    redo,
    undo,
    savePost,
    setIsListViewOpened,
    switchEditorMode,
    toggleDistractionFree
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    isEditedPostDirty,
    isPostSavingLocked,
    isListViewOpened,
    getEditorMode
  } = (0,external_wp_data_namespaceObject.useSelect)(store_store);
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/toggle-mode', () => {
    switchEditorMode(getEditorMode() === 'visual' ? 'text' : 'visual');
  }, {
    isDisabled: isModeToggleDisabled
  });
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/toggle-distraction-free', () => {
    toggleDistractionFree();
  });
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/undo', event => {
    undo();
    event.preventDefault();
  });
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/redo', event => {
    redo();
    event.preventDefault();
  });
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/save', event => {
    event.preventDefault();

    /**
     * Do not save the post if post saving is locked.
     */
    if (isPostSavingLocked()) {
      return;
    }

    // TODO: This should be handled in the `savePost` effect in
    // considering `isSaveable`. See note on `isEditedPostSaveable`
    // selector about dirtiness and meta-boxes.
    //
    // See: `isEditedPostSaveable`
    if (!isEditedPostDirty()) {
      return;
    }
    savePost();
  });

  // Only opens the list view. Other functionality for this shortcut happens in the rendered sidebar.
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/toggle-list-view', event => {
    if (!isListViewOpened()) {
      event.preventDefault();
      setIsListViewOpened(true);
    }
  });
  (0,external_wp_keyboardShortcuts_namespaceObject.useShortcut)('core/editor/toggle-sidebar', event => {
    // This shortcut has no known clashes, but use preventDefault to prevent any
    // obscure shortcuts from triggering.
    event.preventDefault();
    const isEditorSidebarOpened = ['edit-post/document', 'edit-post/block'].includes(getActiveComplementaryArea('core'));
    if (isEditorSidebarOpened) {
      disableComplementaryArea('core');
    } else {
      const sidebarToOpen = getBlockSelectionStart() ? 'edit-post/block' : 'edit-post/document';
      enableComplementaryArea('core', sidebarToOpen);
    }
  });
  return null;
}

;// ./packages/editor/build-module/components/template-part-menu-items/convert-to-regular.js
/**
 * WordPress dependencies
 */





function ConvertToRegularBlocks({
  clientId,
  onClose
}) {
  const {
    getBlocks
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const {
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const canRemove = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).canRemoveBlock(clientId), [clientId]);
  if (!canRemove) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
    onClick: () => {
      replaceBlocks(clientId, getBlocks(clientId));
      onClose();
    },
    children: (0,external_wp_i18n_namespaceObject.__)('Detach')
  });
}

;// ./packages/editor/build-module/components/template-part-menu-items/convert-to-template-part.js
/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */


function ConvertToTemplatePart({
  clientIds,
  blocks
}) {
  const [isModalOpen, setIsModalOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    replaceBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    isBlockBasedTheme,
    canCreate
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return {
      isBlockBasedTheme: select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.is_block_theme,
      canCreate: select(external_wp_blockEditor_namespaceObject.store).canInsertBlockType('core/template-part')
    };
  }, []);
  if (!isBlockBasedTheme || !canCreate) {
    return null;
  }
  const onConvert = async templatePart => {
    replaceBlocks(clientIds, (0,external_wp_blocks_namespaceObject.createBlock)('core/template-part', {
      slug: templatePart.slug,
      theme: templatePart.theme
    }));
    createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Template part created.'), {
      type: 'snackbar'
    });

    // The modal and this component will be unmounted because of `replaceBlocks` above,
    // so no need to call `closeModal` or `onClose`.
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
      icon: symbol_filled,
      onClick: () => {
        setIsModalOpen(true);
      },
      "aria-expanded": isModalOpen,
      "aria-haspopup": "dialog",
      children: (0,external_wp_i18n_namespaceObject.__)('Create template part')
    }), isModalOpen && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateTemplatePartModal, {
      closeModal: () => {
        setIsModalOpen(false);
      },
      blocks: blocks,
      onCreate: onConvert
    })]
  });
}

;// ./packages/editor/build-module/components/template-part-menu-items/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function TemplatePartMenuItems() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockSettingsMenuControls, {
    children: ({
      selectedClientIds,
      onClose
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TemplatePartConverterMenuItem, {
      clientIds: selectedClientIds,
      onClose: onClose
    })
  });
}
function TemplatePartConverterMenuItem({
  clientIds,
  onClose
}) {
  const {
    blocks
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlocksByClientId
    } = select(external_wp_blockEditor_namespaceObject.store);
    return {
      blocks: getBlocksByClientId(clientIds)
    };
  }, [clientIds]);

  // Allow converting a single template part to standard blocks.
  if (blocks.length === 1 && blocks[0]?.name === 'core/template-part') {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ConvertToRegularBlocks, {
      clientId: clientIds[0],
      onClose: onClose
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ConvertToTemplatePart, {
    clientIds: clientIds,
    blocks: blocks
  });
}

;// ./packages/editor/build-module/components/provider/index.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */


















const {
  ExperimentalBlockEditorProvider
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
const {
  PatternsMenuItems
} = unlock(external_wp_patterns_namespaceObject.privateApis);
const provider_noop = () => {};

/**
 * These are global entities that are only there to split blocks into logical units
 * They don't provide a "context" for the current post/page being rendered.
 * So we should not use their ids as post context. This is important to allow post blocks
 * (post content, post title) to be used within them without issues.
 */
const NON_CONTEXTUAL_POST_TYPES = ['wp_block', 'wp_navigation', 'wp_template_part'];

/**
 * Depending on the post, template and template mode,
 * returns the appropriate blocks and change handlers for the block editor provider.
 *
 * @param {Array}   post     Block list.
 * @param {boolean} template Whether the page content has focus (and the surrounding template is inert). If `true` return page content blocks. Default `false`.
 * @param {string}  mode     Rendering mode.
 *
 * @example
 * ```jsx
 * const [ blocks, onInput, onChange ] = useBlockEditorProps( post, template, mode );
 * ```
 *
 * @return {Array} Block editor props.
 */
function useBlockEditorProps(post, template, mode) {
  const rootLevelPost = mode === 'template-locked' ? 'template' : 'post';
  const [postBlocks, onInput, onChange] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', post.type, {
    id: post.id
  });
  const [templateBlocks, onInputTemplate, onChangeTemplate] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', template?.type, {
    id: template?.id
  });
  const maybeNavigationBlocks = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (post.type === 'wp_navigation') {
      return [(0,external_wp_blocks_namespaceObject.createBlock)('core/navigation', {
        ref: post.id,
        // As the parent editor is locked with `templateLock`, the template locking
        // must be explicitly "unset" on the block itself to allow the user to modify
        // the block's content.
        templateLock: false
      })];
    }
  }, [post.type, post.id]);

  // It is important that we don't create a new instance of blocks on every change
  // We should only create a new instance if the blocks them selves change, not a dependency of them.
  const blocks = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (maybeNavigationBlocks) {
      return maybeNavigationBlocks;
    }
    if (rootLevelPost === 'template') {
      return templateBlocks;
    }
    return postBlocks;
  }, [maybeNavigationBlocks, rootLevelPost, templateBlocks, postBlocks]);

  // Handle fallback to postBlocks outside of the above useMemo, to ensure
  // that constructed block templates that call `createBlock` are not generated
  // too frequently. This ensures that clientIds are stable.
  const disableRootLevelChanges = !!template && mode === 'template-locked' || post.type === 'wp_navigation';
  if (disableRootLevelChanges) {
    return [blocks, provider_noop, provider_noop];
  }
  return [blocks, rootLevelPost === 'post' ? onInput : onInputTemplate, rootLevelPost === 'post' ? onChange : onChangeTemplate];
}

/**
 * This component provides the editor context and manages the state of the block editor.
 *
 * @param {Object}  props                                The component props.
 * @param {Object}  props.post                           The post object.
 * @param {Object}  props.settings                       The editor settings.
 * @param {boolean} props.recovery                       Indicates if the editor is in recovery mode.
 * @param {Array}   props.initialEdits                   The initial edits for the editor.
 * @param {Object}  props.children                       The child components.
 * @param {Object}  [props.BlockEditorProviderComponent] The block editor provider component to use. Defaults to ExperimentalBlockEditorProvider.
 * @param {Object}  [props.__unstableTemplate]           The template object.
 *
 * @example
 * ```jsx
 * <ExperimentalEditorProvider
 *   post={ post }
 *   settings={ settings }
 *   recovery={ recovery }
 *   initialEdits={ initialEdits }
 *   __unstableTemplate={ template }
 * >
 *   { children }
 * </ExperimentalEditorProvider>
 *
 * @return {Object} The rendered ExperimentalEditorProvider component.
 */
const ExperimentalEditorProvider = with_registry_provider(({
  post,
  settings,
  recovery,
  initialEdits,
  children,
  BlockEditorProviderComponent = ExperimentalBlockEditorProvider,
  __unstableTemplate: template
}) => {
  const hasTemplate = !!template;
  const {
    editorSettings,
    selection,
    isReady,
    mode,
    defaultMode,
    postTypeEntities
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditorSettings,
      getEditorSelection,
      getRenderingMode,
      __unstableIsEditorReady,
      getDefaultRenderingMode
    } = unlock(select(store_store));
    const {
      getEntitiesConfig
    } = select(external_wp_coreData_namespaceObject.store);
    const _mode = getRenderingMode();
    const _defaultMode = getDefaultRenderingMode(post.type);
    /**
     * To avoid content "flash", wait until rendering mode has been resolved.
     * This is important for the initial render of the editor.
     *
     * - Wait for template to be resolved if the default mode is 'template-locked'.
     * - Wait for default mode to be resolved otherwise.
     */
    const hasResolvedDefaultMode = _defaultMode === 'template-locked' ? hasTemplate : _defaultMode !== undefined;
    // Wait until the default mode is retrieved and start rendering canvas.
    const isRenderingModeReady = _defaultMode !== undefined;
    return {
      editorSettings: getEditorSettings(),
      isReady: __unstableIsEditorReady(),
      mode: isRenderingModeReady ? _mode : undefined,
      defaultMode: hasResolvedDefaultMode ? _defaultMode : undefined,
      selection: getEditorSelection(),
      postTypeEntities: post.type === 'wp_template' ? getEntitiesConfig('postType') : null
    };
  }, [post.type, hasTemplate]);
  const shouldRenderTemplate = hasTemplate && mode !== 'post-only';
  const rootLevelPost = shouldRenderTemplate ? template : post;
  const defaultBlockContext = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const postContext = {};
    // If it is a template, try to inherit the post type from the name.
    if (post.type === 'wp_template') {
      if (post.slug === 'page') {
        postContext.postType = 'page';
      } else if (post.slug === 'single') {
        postContext.postType = 'post';
      } else if (post.slug.split('-')[0] === 'single') {
        // If the slug is single-{postType}, infer the post type from the name.
        const postTypeNames = postTypeEntities?.map(entity => entity.name) || [];
        const match = post.slug.match(`^single-(${postTypeNames.join('|')})(?:-.+)?$`);
        if (match) {
          postContext.postType = match[1];
        }
      }
    } else if (!NON_CONTEXTUAL_POST_TYPES.includes(rootLevelPost.type) || shouldRenderTemplate) {
      postContext.postId = post.id;
      postContext.postType = post.type;
    }
    return {
      ...postContext,
      templateSlug: rootLevelPost.type === 'wp_template' ? rootLevelPost.slug : undefined
    };
  }, [shouldRenderTemplate, post.id, post.type, post.slug, rootLevelPost.type, rootLevelPost.slug, postTypeEntities]);
  const {
    id,
    type
  } = rootLevelPost;
  const blockEditorSettings = use_block_editor_settings(editorSettings, type, id, mode);
  const [blocks, onInput, onChange] = useBlockEditorProps(post, template, mode);
  const {
    updatePostLock,
    setupEditor,
    updateEditorSettings,
    setCurrentTemplateId,
    setEditedPost,
    setRenderingMode
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store_store));
  const {
    createWarningNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);

  // Ideally this should be synced on each change and not just something you do once.
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    // Assume that we don't need to initialize in the case of an error recovery.
    if (recovery) {
      return;
    }
    updatePostLock(settings.postLock);
    setupEditor(post, initialEdits, settings.template);
    if (settings.autosave) {
      createWarningNotice((0,external_wp_i18n_namespaceObject.__)('There is an autosave of this post that is more recent than the version below.'), {
        id: 'autosave-exists',
        actions: [{
          label: (0,external_wp_i18n_namespaceObject.__)('View the autosave'),
          url: settings.autosave.editLink
        }]
      });
    }

    // The dependencies of the hook are omitted deliberately
    // We only want to run setupEditor (with initialEdits) only once per post.
    // A better solution in the future would be to split this effect into multiple ones.
  }, []);

  // Synchronizes the active post with the state
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setEditedPost(post.type, post.id);
  }, [post.type, post.id, setEditedPost]);

  // Synchronize the editor settings as they change.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    updateEditorSettings(settings);
  }, [settings, updateEditorSettings]);

  // Synchronizes the active template with the state.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setCurrentTemplateId(template?.id);
  }, [template?.id, setCurrentTemplateId]);

  // Sets the right rendering mode when loading the editor.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (defaultMode) {
      setRenderingMode(defaultMode);
    }
  }, [defaultMode, setRenderingMode]);
  useHideBlocksFromInserter(post.type, mode);

  // Register the editor commands.
  useCommands();
  if (!isReady || !mode) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_coreData_namespaceObject.EntityProvider, {
    kind: "root",
    type: "site",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_coreData_namespaceObject.EntityProvider, {
      kind: "postType",
      type: post.type,
      id: post.id,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockContextProvider, {
        value: defaultBlockContext,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(BlockEditorProviderComponent, {
          value: blocks,
          onChange: onChange,
          onInput: onInput,
          selection: selection,
          settings: blockEditorSettings,
          useSubRegistry: false,
          children: [children, !settings.isPreviewMode && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternsMenuItems, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TemplatePartMenuItems, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ContentOnlySettingsMenu, {}), mode === 'template-locked' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(DisableNonPageContentBlocks, {}), type === 'wp_navigation' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(NavigationBlockEditingMode, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EditorKeyboardShortcuts, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(keyboard_shortcut_help_modal, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockRemovalWarnings, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(StartPageOptions, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(StartTemplateOptions, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternRenameModal, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternDuplicateModal, {})]
          })]
        })
      })
    })
  });
});

/**
 * This component establishes a new post editing context, and serves as the entry point for a new post editor (or post with template editor).
 *
 * It supports a large number of post types, including post, page, templates,
 * custom post types, patterns, template parts.
 *
 * All modification and changes are performed to the `@wordpress/core-data` store.
 *
 * @param {Object}          props                      The component props.
 * @param {Object}          [props.post]               The post object to edit. This is required.
 * @param {Object}          [props.__unstableTemplate] The template object wrapper the edited post.
 *                                                     This is optional and can only be used when the post type supports templates (like posts and pages).
 * @param {Object}          [props.settings]           The settings object to use for the editor.
 *                                                     This is optional and can be used to override the default settings.
 * @param {React.ReactNode} [props.children]           Children elements for which the BlockEditorProvider context should apply.
 *                                                     This is optional.
 *
 * @example
 * ```jsx
 * <EditorProvider
 *   post={ post }
 *   settings={ settings }
 *   __unstableTemplate={ template }
 * >
 *   { children }
 * </EditorProvider>
 * ```
 *
 * @return {React.ReactNode} The rendered EditorProvider component.
 */
function EditorProvider(props) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ExperimentalEditorProvider, {
    ...props,
    BlockEditorProviderComponent: external_wp_blockEditor_namespaceObject.BlockEditorProvider,
    children: props.children
  });
}
/* harmony default export */ const provider = (EditorProvider);

;// ./packages/editor/build-module/dataviews/fields/content-preview/content-preview-view.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


// @ts-ignore


const {
  useGlobalStyle
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function PostPreviewContainer({
  template,
  post
}) {
  const [backgroundColor = 'white'] = useGlobalStyle('color.background');
  const [postBlocks] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', post.type, {
    id: post.id
  });
  const [templateBlocks] = (0,external_wp_coreData_namespaceObject.useEntityBlockEditor)('postType', template?.type, {
    id: template?.id
  });
  const blocks = template && templateBlocks ? templateBlocks : postBlocks;
  const isEmpty = !blocks?.length;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-fields-content-preview",
    style: {
      backgroundColor
    },
    children: [isEmpty && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      className: "editor-fields-content-preview__empty",
      children: (0,external_wp_i18n_namespaceObject.__)('Empty content')
    }), !isEmpty && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockPreview.Async, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockPreview, {
        blocks: blocks
      })
    })]
  });
}
function PostPreviewView({
  item
}) {
  const {
    settings,
    template
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getPostType$viewable;
    const {
      canUser,
      getPostType,
      getTemplateId,
      getEntityRecord
    } = unlock(select(external_wp_coreData_namespaceObject.store));
    const canViewTemplate = canUser('read', {
      kind: 'postType',
      name: 'wp_template'
    });
    const _settings = select(store_store).getEditorSettings();
    // @ts-ignore
    const supportsTemplateMode = _settings.supportsTemplateMode;
    const isViewable = (_getPostType$viewable = getPostType(item.type)?.viewable) !== null && _getPostType$viewable !== void 0 ? _getPostType$viewable : false;
    const templateId = supportsTemplateMode && isViewable && canViewTemplate ? getTemplateId(item.type, item.id) : null;
    return {
      settings: _settings,
      template: templateId ? getEntityRecord('postType', 'wp_template', templateId) : undefined
    };
  }, [item.type, item.id]);
  // Wrap everything in a block editor provider to ensure 'styles' that are needed
  // for the previews are synced between the site editor store and the block editor store.
  // Additionally we need to have the `__experimentalBlockPatterns` setting in order to
  // render patterns inside the previews.
  // TODO: Same approach is used in the patterns list and it becomes obvious that some of
  // the block editor settings are needed in context where we don't have the block editor.
  // Explore how we can solve this in a better way.
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EditorProvider, {
    post: item,
    settings: settings,
    __unstableTemplate: template,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostPreviewContainer, {
      template: template,
      post: item
    })
  });
}

;// ./packages/editor/build-module/dataviews/fields/content-preview/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

const postPreviewField = {
  type: 'media',
  id: 'content-preview',
  label: (0,external_wp_i18n_namespaceObject.__)('Content preview'),
  render: PostPreviewView,
  enableSorting: false
};
/* harmony default export */ const content_preview = (postPreviewField);

;// ./packages/editor/build-module/dataviews/store/private-actions.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function registerEntityAction(kind, name, config) {
  return {
    type: 'REGISTER_ENTITY_ACTION',
    kind,
    name,
    config
  };
}
function unregisterEntityAction(kind, name, actionId) {
  return {
    type: 'UNREGISTER_ENTITY_ACTION',
    kind,
    name,
    actionId
  };
}
function registerEntityField(kind, name, config) {
  return {
    type: 'REGISTER_ENTITY_FIELD',
    kind,
    name,
    config
  };
}
function unregisterEntityField(kind, name, fieldId) {
  return {
    type: 'UNREGISTER_ENTITY_FIELD',
    kind,
    name,
    fieldId
  };
}
function setIsReady(kind, name) {
  return {
    type: 'SET_IS_READY',
    kind,
    name
  };
}
const registerPostTypeSchema = postType => async ({
  registry
}) => {
  const isReady = unlock(registry.select(store_store)).isEntityReady('postType', postType);
  if (isReady) {
    return;
  }
  unlock(registry.dispatch(store_store)).setIsReady('postType', postType);
  const postTypeConfig = await registry.resolveSelect(external_wp_coreData_namespaceObject.store).getPostType(postType);
  const canCreate = await registry.resolveSelect(external_wp_coreData_namespaceObject.store).canUser('create', {
    kind: 'postType',
    name: postType
  });
  const currentTheme = await registry.resolveSelect(external_wp_coreData_namespaceObject.store).getCurrentTheme();
  const actions = [postTypeConfig.viewable ? view_post : undefined, !!postTypeConfig.supports?.revisions ? view_post_revisions : undefined,
  // @ts-ignore
   true ? !['wp_template', 'wp_block', 'wp_template_part'].includes(postTypeConfig.slug) && canCreate && duplicate_post : 0, postTypeConfig.slug === 'wp_template_part' && canCreate && currentTheme?.is_block_theme ? duplicate_template_part : undefined, canCreate && postTypeConfig.slug === 'wp_block' ? duplicate_pattern : undefined, postTypeConfig.supports?.title ? rename_post : undefined, postTypeConfig.supports?.['page-attributes'] ? reorder_page : undefined, postTypeConfig.slug === 'wp_block' ? export_pattern : undefined, restore_post, reset_post, delete_post, trash_post, permanently_delete_post].filter(Boolean);
  const fields = [postTypeConfig.supports?.thumbnail && currentTheme?.theme_supports?.['post-thumbnails'] && featured_image, postTypeConfig.supports?.author && author, fields_status, fields_date, slug, postTypeConfig.supports?.['page-attributes'] && fields_parent, postTypeConfig.supports?.comments && comment_status, fields_template, fields_password, postTypeConfig.supports?.editor && postTypeConfig.viewable && content_preview].filter(Boolean);
  if (postTypeConfig.supports?.title) {
    let _titleField;
    if (postType === 'page') {
      _titleField = page_title;
    } else if (postType === 'wp_template') {
      _titleField = template_title;
    } else if (postType === 'wp_block') {
      _titleField = pattern_title;
    } else {
      _titleField = title;
    }
    fields.push(_titleField);
  }
  registry.batch(() => {
    actions.forEach(action => {
      unlock(registry.dispatch(store_store)).registerEntityAction('postType', postType, action);
    });
    fields.forEach(field => {
      unlock(registry.dispatch(store_store)).registerEntityField('postType', postType, field);
    });
  });
  (0,external_wp_hooks_namespaceObject.doAction)('core.registerPostTypeSchema', postType);
};

;// ./packages/editor/build-module/store/private-actions.js
/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */



/**
 * Returns an action object used to set which template is currently being used/edited.
 *
 * @param {string} id Template Id.
 *
 * @return {Object} Action object.
 */
function setCurrentTemplateId(id) {
  return {
    type: 'SET_CURRENT_TEMPLATE_ID',
    id
  };
}

/**
 * Create a block based template.
 *
 * @param {?Object} template Template to create and assign.
 */
const createTemplate = template => async ({
  select,
  dispatch,
  registry
}) => {
  const savedTemplate = await registry.dispatch(external_wp_coreData_namespaceObject.store).saveEntityRecord('postType', 'wp_template', template);
  registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', select.getCurrentPostType(), select.getCurrentPostId(), {
    template: savedTemplate.slug
  });
  registry.dispatch(external_wp_notices_namespaceObject.store).createSuccessNotice((0,external_wp_i18n_namespaceObject.__)("Custom template created. You're in template mode now."), {
    type: 'snackbar',
    actions: [{
      label: (0,external_wp_i18n_namespaceObject.__)('Go back'),
      onClick: () => dispatch.setRenderingMode(select.getEditorSettings().defaultRenderingMode)
    }]
  });
  return savedTemplate;
};

/**
 * Update the provided block types to be visible.
 *
 * @param {string[]} blockNames Names of block types to show.
 */
const showBlockTypes = blockNames => ({
  registry
}) => {
  var _registry$select$get;
  const existingBlockNames = (_registry$select$get = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'hiddenBlockTypes')) !== null && _registry$select$get !== void 0 ? _registry$select$get : [];
  const newBlockNames = existingBlockNames.filter(type => !(Array.isArray(blockNames) ? blockNames : [blockNames]).includes(type));
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'hiddenBlockTypes', newBlockNames);
};

/**
 * Update the provided block types to be hidden.
 *
 * @param {string[]} blockNames Names of block types to hide.
 */
const hideBlockTypes = blockNames => ({
  registry
}) => {
  var _registry$select$get2;
  const existingBlockNames = (_registry$select$get2 = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'hiddenBlockTypes')) !== null && _registry$select$get2 !== void 0 ? _registry$select$get2 : [];
  const mergedBlockNames = new Set([...existingBlockNames, ...(Array.isArray(blockNames) ? blockNames : [blockNames])]);
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'hiddenBlockTypes', [...mergedBlockNames]);
};

/**
 * Save entity records marked as dirty.
 *
 * @param {Object}   options                      Options for the action.
 * @param {Function} [options.onSave]             Callback when saving happens.
 * @param {object[]} [options.dirtyEntityRecords] Array of dirty entities.
 * @param {object[]} [options.entitiesToSkip]     Array of entities to skip saving.
 * @param {Function} [options.close]              Callback when the actions is called. It should be consolidated with `onSave`.
 */
const saveDirtyEntities = ({
  onSave,
  dirtyEntityRecords = [],
  entitiesToSkip = [],
  close
} = {}) => ({
  registry
}) => {
  const PUBLISH_ON_SAVE_ENTITIES = [{
    kind: 'postType',
    name: 'wp_navigation'
  }];
  const saveNoticeId = 'site-editor-save-success';
  const homeUrl = registry.select(external_wp_coreData_namespaceObject.store).getEntityRecord('root', '__unstableBase')?.home;
  registry.dispatch(external_wp_notices_namespaceObject.store).removeNotice(saveNoticeId);
  const entitiesToSave = dirtyEntityRecords.filter(({
    kind,
    name,
    key,
    property
  }) => {
    return !entitiesToSkip.some(elt => elt.kind === kind && elt.name === name && elt.key === key && elt.property === property);
  });
  close?.(entitiesToSave);
  const siteItemsToSave = [];
  const pendingSavedRecords = [];
  entitiesToSave.forEach(({
    kind,
    name,
    key,
    property
  }) => {
    if ('root' === kind && 'site' === name) {
      siteItemsToSave.push(property);
    } else {
      if (PUBLISH_ON_SAVE_ENTITIES.some(typeToPublish => typeToPublish.kind === kind && typeToPublish.name === name)) {
        registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord(kind, name, key, {
          status: 'publish'
        });
      }
      pendingSavedRecords.push(registry.dispatch(external_wp_coreData_namespaceObject.store).saveEditedEntityRecord(kind, name, key));
    }
  });
  if (siteItemsToSave.length) {
    pendingSavedRecords.push(registry.dispatch(external_wp_coreData_namespaceObject.store).__experimentalSaveSpecifiedEntityEdits('root', 'site', undefined, siteItemsToSave));
  }
  registry.dispatch(external_wp_blockEditor_namespaceObject.store).__unstableMarkLastChangeAsPersistent();
  Promise.all(pendingSavedRecords).then(values => {
    return onSave ? onSave(values) : values;
  }).then(values => {
    if (values.some(value => typeof value === 'undefined')) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('Saving failed.'));
    } else {
      registry.dispatch(external_wp_notices_namespaceObject.store).createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Site updated.'), {
        type: 'snackbar',
        id: saveNoticeId,
        actions: [{
          label: (0,external_wp_i18n_namespaceObject.__)('View site'),
          url: homeUrl,
          openInNewTab: true
        }]
      });
    }
  }).catch(error => registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(`${(0,external_wp_i18n_namespaceObject.__)('Saving failed.')} ${error}`));
};

/**
 * Reverts a template to its original theme-provided file.
 *
 * @param {Object}  template            The template to revert.
 * @param {Object}  [options]
 * @param {boolean} [options.allowUndo] Whether to allow the user to undo
 *                                      reverting the template. Default true.
 */
const private_actions_revertTemplate = (template, {
  allowUndo = true
} = {}) => async ({
  registry
}) => {
  const noticeId = 'edit-site-template-reverted';
  registry.dispatch(external_wp_notices_namespaceObject.store).removeNotice(noticeId);
  if (!isTemplateRevertable(template)) {
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('This template is not revertable.'), {
      type: 'snackbar'
    });
    return;
  }
  try {
    const templateEntityConfig = registry.select(external_wp_coreData_namespaceObject.store).getEntityConfig('postType', template.type);
    if (!templateEntityConfig) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('The editor has encountered an unexpected error. Please reload.'), {
        type: 'snackbar'
      });
      return;
    }
    const fileTemplatePath = (0,external_wp_url_namespaceObject.addQueryArgs)(`${templateEntityConfig.baseURL}/${template.id}`, {
      context: 'edit',
      source: template.origin
    });
    const fileTemplate = await external_wp_apiFetch_default()({
      path: fileTemplatePath
    });
    if (!fileTemplate) {
      registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice((0,external_wp_i18n_namespaceObject.__)('The editor has encountered an unexpected error. Please reload.'), {
        type: 'snackbar'
      });
      return;
    }
    const serializeBlocks = ({
      blocks: blocksForSerialization = []
    }) => (0,external_wp_blocks_namespaceObject.__unstableSerializeAndClean)(blocksForSerialization);
    const edited = registry.select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', template.type, template.id);

    // We are fixing up the undo level here to make sure we can undo
    // the revert in the header toolbar correctly.
    registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, template.id, {
      content: serializeBlocks,
      // Required to make the `undo` behave correctly.
      blocks: edited.blocks,
      // Required to revert the blocks in the editor.
      source: 'custom' // required to avoid turning the editor into a dirty state
    }, {
      undoIgnore: true // Required to merge this edit with the last undo level.
    });
    const blocks = (0,external_wp_blocks_namespaceObject.parse)(fileTemplate?.content?.raw);
    registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, fileTemplate.id, {
      content: serializeBlocks,
      blocks,
      source: 'theme'
    });
    if (allowUndo) {
      const undoRevert = () => {
        registry.dispatch(external_wp_coreData_namespaceObject.store).editEntityRecord('postType', template.type, edited.id, {
          content: serializeBlocks,
          blocks: edited.blocks,
          source: 'custom'
        });
      };
      registry.dispatch(external_wp_notices_namespaceObject.store).createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Template reset.'), {
        type: 'snackbar',
        id: noticeId,
        actions: [{
          label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
          onClick: undoRevert
        }]
      });
    }
  } catch (error) {
    const errorMessage = error.message && error.code !== 'unknown_error' ? error.message : (0,external_wp_i18n_namespaceObject.__)('Template revert failed. Please reload.');
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(errorMessage, {
      type: 'snackbar'
    });
  }
};

/**
 * Action that removes an array of templates, template parts or patterns.
 *
 * @param {Array} items An array of template,template part or pattern objects to remove.
 */
const removeTemplates = items => async ({
  registry
}) => {
  const isResetting = items.every(item => item?.has_theme_file);
  const promiseResult = await Promise.allSettled(items.map(item => {
    return registry.dispatch(external_wp_coreData_namespaceObject.store).deleteEntityRecord('postType', item.type, item.id, {
      force: true
    }, {
      throwOnError: true
    });
  }));

  // If all the promises were fulfilled with success.
  if (promiseResult.every(({
    status
  }) => status === 'fulfilled')) {
    let successMessage;
    if (items.length === 1) {
      // Depending on how the entity was retrieved its title might be
      // an object or simple string.
      let title;
      if (typeof items[0].title === 'string') {
        title = items[0].title;
      } else if (typeof items[0].title?.rendered === 'string') {
        title = items[0].title?.rendered;
      } else if (typeof items[0].title?.raw === 'string') {
        title = items[0].title?.raw;
      }
      successMessage = isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The template/part's name. */
      (0,external_wp_i18n_namespaceObject.__)('"%s" reset.'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title)) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The template/part's name. */
      (0,external_wp_i18n_namespaceObject._x)('"%s" deleted.', 'template part'), (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title));
    } else {
      successMessage = isResetting ? (0,external_wp_i18n_namespaceObject.__)('Items reset.') : (0,external_wp_i18n_namespaceObject.__)('Items deleted.');
    }
    registry.dispatch(external_wp_notices_namespaceObject.store).createSuccessNotice(successMessage, {
      type: 'snackbar',
      id: 'editor-template-deleted-success'
    });
  } else {
    // If there was at lease one failure.
    let errorMessage;
    // If we were trying to delete a single template.
    if (promiseResult.length === 1) {
      if (promiseResult[0].reason?.message) {
        errorMessage = promiseResult[0].reason.message;
      } else {
        errorMessage = isResetting ? (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the item.') : (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the item.');
      }
      // If we were trying to delete a multiple templates
    } else {
      const errorMessages = new Set();
      const failedPromises = promiseResult.filter(({
        status
      }) => status === 'rejected');
      for (const failedPromise of failedPromises) {
        if (failedPromise.reason?.message) {
          errorMessages.add(failedPromise.reason.message);
        }
      }
      if (errorMessages.size === 0) {
        errorMessage = (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the items.');
      } else if (errorMessages.size === 1) {
        errorMessage = isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
        (0,external_wp_i18n_namespaceObject.__)('An error occurred while reverting the items: %s'), [...errorMessages][0]) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: an error message */
        (0,external_wp_i18n_namespaceObject.__)('An error occurred while deleting the items: %s'), [...errorMessages][0]);
      } else {
        errorMessage = isResetting ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
        (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while reverting the items: %s'), [...errorMessages].join(',')) : (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: a list of comma separated error messages */
        (0,external_wp_i18n_namespaceObject.__)('Some errors occurred while deleting the items: %s'), [...errorMessages].join(','));
      }
    }
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(errorMessage, {
      type: 'snackbar'
    });
  }
};

/**
 * Set the default rendering mode preference for the current post type.
 *
 * @param {string} mode The rendering mode to set as default.
 */
const setDefaultRenderingMode = mode => ({
  select,
  registry
}) => {
  var _registry$select$get$;
  const postType = select.getCurrentPostType();
  const theme = registry.select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.stylesheet;
  const renderingModes = (_registry$select$get$ = registry.select(external_wp_preferences_namespaceObject.store).get('core', 'renderingModes')?.[theme]) !== null && _registry$select$get$ !== void 0 ? _registry$select$get$ : {};
  if (renderingModes[postType] === mode) {
    return;
  }
  const newModes = {
    [theme]: {
      ...renderingModes,
      [postType]: mode
    }
  };
  registry.dispatch(external_wp_preferences_namespaceObject.store).set('core', 'renderingModes', newModes);
};

// EXTERNAL MODULE: ./node_modules/fast-deep-equal/index.js
var fast_deep_equal = __webpack_require__(5215);
var fast_deep_equal_default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal);
;// ./packages/icons/build-module/library/navigation.js
/**
 * WordPress dependencies
 */


const navigation = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 14.5c-3.6 0-6.5-2.9-6.5-6.5S8.4 5.5 12 5.5s6.5 2.9 6.5 6.5-2.9 6.5-6.5 6.5zM9 16l4.5-3L15 8.4l-4.5 3L9 16z"
  })
});
/* harmony default export */ const library_navigation = (navigation);

;// ./packages/icons/build-module/library/verse.js
/**
 * WordPress dependencies
 */


const verse = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17.8 2l-.9.3c-.1 0-3.6 1-5.2 2.1C10 5.5 9.3 6.5 8.9 7.1c-.6.9-1.7 4.7-1.7 6.3l-.9 2.3c-.2.4 0 .8.4 1 .1 0 .2.1.3.1.3 0 .6-.2.7-.5l.6-1.5c.3 0 .7-.1 1.2-.2.7-.1 1.4-.3 2.2-.5.8-.2 1.6-.5 2.4-.8.7-.3 1.4-.7 1.9-1.2s.8-1.2 1-1.9c.2-.7.3-1.6.4-2.4.1-.8.1-1.7.2-2.5 0-.8.1-1.5.2-2.1V2zm-1.9 5.6c-.1.8-.2 1.5-.3 2.1-.2.6-.4 1-.6 1.3-.3.3-.8.6-1.4.9-.7.3-1.4.5-2.2.8-.6.2-1.3.3-1.8.4L15 7.5c.3-.3.6-.7 1-1.1 0 .4 0 .8-.1 1.2zM6 20h8v-1.5H6V20z"
  })
});
/* harmony default export */ const library_verse = (verse);

;// ./packages/editor/build-module/dataviews/store/private-selectors.js
/**
 * Internal dependencies
 */

const private_selectors_EMPTY_ARRAY = [];
function getEntityActions(state, kind, name) {
  var _state$actions$kind$n;
  return (_state$actions$kind$n = state.actions[kind]?.[name]) !== null && _state$actions$kind$n !== void 0 ? _state$actions$kind$n : private_selectors_EMPTY_ARRAY;
}
function getEntityFields(state, kind, name) {
  var _state$fields$kind$na;
  return (_state$fields$kind$na = state.fields[kind]?.[name]) !== null && _state$fields$kind$na !== void 0 ? _state$fields$kind$na : private_selectors_EMPTY_ARRAY;
}
function isEntityReady(state, kind, name) {
  return state.isReady[kind]?.[name];
}

;// ./packages/editor/build-module/store/private-selectors.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



const EMPTY_INSERTION_POINT = {
  rootClientId: undefined,
  insertionIndex: undefined,
  filterValue: undefined
};

/**
 * These are rendering modes that the editor supports.
 */
const RENDERING_MODES = ['post-only', 'template-locked'];

/**
 * Get the inserter.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} The root client ID, index to insert at and starting filter value.
 */
const getInserter = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)(state => {
  if (typeof state.blockInserterPanel === 'object') {
    return state.blockInserterPanel;
  }
  if (getRenderingMode(state) === 'template-locked') {
    const [postContentClientId] = select(external_wp_blockEditor_namespaceObject.store).getBlocksByName('core/post-content');
    if (postContentClientId) {
      return {
        rootClientId: postContentClientId,
        insertionIndex: undefined,
        filterValue: undefined
      };
    }
  }
  return EMPTY_INSERTION_POINT;
}, state => {
  const [postContentClientId] = select(external_wp_blockEditor_namespaceObject.store).getBlocksByName('core/post-content');
  return [state.blockInserterPanel, getRenderingMode(state), postContentClientId];
}));
function getListViewToggleRef(state) {
  return state.listViewToggleRef;
}
function getInserterSidebarToggleRef(state) {
  return state.inserterSidebarToggleRef;
}
const CARD_ICONS = {
  wp_block: library_symbol,
  wp_navigation: library_navigation,
  page: library_page,
  post: library_verse
};
const getPostIcon = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, postType, options) => {
  {
    if (postType === 'wp_template_part' || postType === 'wp_template') {
      const templateAreas = select(external_wp_coreData_namespaceObject.store).getCurrentTheme()?.default_template_part_areas || [];
      const areaData = templateAreas.find(item => options.area === item.area);
      if (areaData?.icon) {
        return getTemplatePartIcon(areaData.icon);
      }
      return library_layout;
    }
    if (CARD_ICONS[postType]) {
      return CARD_ICONS[postType];
    }
    const postTypeEntity = select(external_wp_coreData_namespaceObject.store).getPostType(postType);
    // `icon` is the `menu_icon` property of a post type. We
    // only handle `dashicons` for now, even if the `menu_icon`
    // also supports urls and svg as values.
    if (typeof postTypeEntity?.icon === 'string' && postTypeEntity.icon.startsWith('dashicons-')) {
      return postTypeEntity.icon.slice(10);
    }
    return library_page;
  }
});

/**
 * Returns true if there are unsaved changes to the
 * post's meta fields, and false otherwise.
 *
 * @param {Object} state    Global application state.
 * @param {string} postType The post type of the post.
 * @param {number} postId   The ID of the post.
 *
 * @return {boolean} Whether there are edits or not in the meta fields of the relevant post.
 */
const hasPostMetaChanges = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, postType, postId) => {
  const {
    type: currentPostType,
    id: currentPostId
  } = getCurrentPost(state);
  // If no postType or postId is passed, use the current post.
  const edits = select(external_wp_coreData_namespaceObject.store).getEntityRecordNonTransientEdits('postType', postType || currentPostType, postId || currentPostId);
  if (!edits?.meta) {
    return false;
  }

  // Compare if anything apart from `footnotes` has changed.
  const originalPostMeta = select(external_wp_coreData_namespaceObject.store).getEntityRecord('postType', postType || currentPostType, postId || currentPostId)?.meta;
  return !fast_deep_equal_default()({
    ...originalPostMeta,
    footnotes: undefined
  }, {
    ...edits.meta,
    footnotes: undefined
  });
});
function private_selectors_getEntityActions(state, ...args) {
  return getEntityActions(state.dataviews, ...args);
}
function private_selectors_isEntityReady(state, ...args) {
  return isEntityReady(state.dataviews, ...args);
}
function private_selectors_getEntityFields(state, ...args) {
  return getEntityFields(state.dataviews, ...args);
}

/**
 * Similar to getBlocksByName in @wordpress/block-editor, but only returns the top-most
 * blocks that aren't descendants of the query block.
 *
 * @param {Object}       state      Global application state.
 * @param {Array|string} blockNames Block names of the blocks to retrieve.
 *
 * @return {Array} Block client IDs.
 */
const getPostBlocksByName = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, blockNames) => {
  blockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
  const {
    getBlocksByName,
    getBlockParents,
    getBlockName
  } = select(external_wp_blockEditor_namespaceObject.store);
  return getBlocksByName(blockNames).filter(clientId => getBlockParents(clientId).every(parentClientId => {
    const parentBlockName = getBlockName(parentClientId);
    return (
      // Ignore descendents of the query block.
      parentBlockName !== 'core/query' &&
      // Enable only the top-most block.
      !blockNames.includes(parentBlockName)
    );
  }));
}, () => [select(external_wp_blockEditor_namespaceObject.store).getBlocks()]));

/**
 * Returns the default rendering mode for a post type by user preference or post type configuration.
 *
 * @param {Object} state    Global application state.
 * @param {string} postType The post type.
 *
 * @return {string} The default rendering mode. Returns `undefined` while resolving value.
 */
const getDefaultRenderingMode = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, postType) => {
  const {
    getPostType,
    getCurrentTheme,
    hasFinishedResolution
  } = select(external_wp_coreData_namespaceObject.store);

  // This needs to be called before `hasFinishedResolution`.
  // eslint-disable-next-line @wordpress/no-unused-vars-before-return
  const currentTheme = getCurrentTheme();
  // eslint-disable-next-line @wordpress/no-unused-vars-before-return
  const postTypeEntity = getPostType(postType);

  // Wait for the post type and theme resolution.
  if (!hasFinishedResolution('getPostType', [postType]) || !hasFinishedResolution('getCurrentTheme')) {
    return undefined;
  }
  const theme = currentTheme?.stylesheet;
  const defaultModePreference = select(external_wp_preferences_namespaceObject.store).get('core', 'renderingModes')?.[theme]?.[postType];
  const postTypeDefaultMode = Array.isArray(postTypeEntity?.supports?.editor) ? postTypeEntity.supports.editor.find(features => 'default-mode' in features)?.['default-mode'] : undefined;
  const defaultMode = defaultModePreference || postTypeDefaultMode;

  // Fallback gracefully to 'post-only' when rendering mode is not supported.
  if (!RENDERING_MODES.includes(defaultMode)) {
    return 'post-only';
  }
  return defaultMode;
});

;// ./packages/editor/build-module/store/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








/**
 * Post editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registerStore
 */
const storeConfig = {
  reducer: store_reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
};

/**
 * Store definition for the editor namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 */
const store_store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, {
  ...storeConfig
});
(0,external_wp_data_namespaceObject.register)(store_store);
unlock(store_store).registerPrivateActions(store_private_actions_namespaceObject);
unlock(store_store).registerPrivateSelectors(store_private_selectors_namespaceObject);

;// ./packages/editor/build-module/hooks/custom-sources-backwards-compatibility.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/compose').WPHigherOrderComponent} WPHigherOrderComponent */
/** @typedef {import('@wordpress/blocks').WPBlockSettings} WPBlockSettings */

/**
 * Object whose keys are the names of block attributes, where each value
 * represents the meta key to which the block attribute is intended to save.
 *
 * @see https://developer.wordpress.org/reference/functions/register_meta/
 *
 * @typedef {Object<string,string>} WPMetaAttributeMapping
 */

/**
 * Given a mapping of attribute names (meta source attributes) to their
 * associated meta key, returns a higher order component that overrides its
 * `attributes` and `setAttributes` props to sync any changes with the edited
 * post's meta keys.
 *
 * @param {WPMetaAttributeMapping} metaAttributes Meta attribute mapping.
 *
 * @return {WPHigherOrderComponent} Higher-order component.
 */

const createWithMetaAttributeSource = metaAttributes => (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => ({
  attributes,
  setAttributes,
  ...props
}) => {
  const postType = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getCurrentPostType(), []);
  const [meta, setMeta] = (0,external_wp_coreData_namespaceObject.useEntityProp)('postType', postType, 'meta');
  const mergedAttributes = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    ...attributes,
    ...Object.fromEntries(Object.entries(metaAttributes).map(([attributeKey, metaKey]) => [attributeKey, meta[metaKey]]))
  }), [attributes, meta]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockEdit, {
    attributes: mergedAttributes,
    setAttributes: nextAttributes => {
      const nextMeta = Object.fromEntries(Object.entries(nextAttributes !== null && nextAttributes !== void 0 ? nextAttributes : {}).filter(
      // Filter to intersection of keys between the updated
      // attributes and those with an associated meta key.
      ([key]) => key in metaAttributes).map(([attributeKey, value]) => [
      // Rename the keys to the expected meta key name.
      metaAttributes[attributeKey], value]));
      if (Object.entries(nextMeta).length) {
        setMeta(nextMeta);
      }
      setAttributes(nextAttributes);
    },
    ...props
  });
}, 'withMetaAttributeSource');

/**
 * Filters a registered block's settings to enhance a block's `edit` component
 * to upgrade meta-sourced attributes to use the post's meta entity property.
 *
 * @param {WPBlockSettings} settings Registered block settings.
 *
 * @return {WPBlockSettings} Filtered block settings.
 */
function shimAttributeSource(settings) {
  var _settings$attributes;
  /** @type {WPMetaAttributeMapping} */
  const metaAttributes = Object.fromEntries(Object.entries((_settings$attributes = settings.attributes) !== null && _settings$attributes !== void 0 ? _settings$attributes : {}).filter(([, {
    source
  }]) => source === 'meta').map(([attributeKey, {
    meta
  }]) => [attributeKey, meta]));
  if (Object.entries(metaAttributes).length) {
    settings.edit = createWithMetaAttributeSource(metaAttributes)(settings.edit);
  }
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/editor/custom-sources-backwards-compatibility/shim-attribute-source', shimAttributeSource);

;// ./packages/editor/build-module/components/autocompleters/user.js
/**
 * WordPress dependencies
 */




function getUserLabel(user) {
  const avatar = user.avatar_urls && user.avatar_urls[24] ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
    className: "editor-autocompleters__user-avatar",
    alt: "",
    src: user.avatar_urls[24]
  }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
    className: "editor-autocompleters__no-avatar"
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [avatar, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      className: "editor-autocompleters__user-name",
      children: user.name
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
      className: "editor-autocompleters__user-slug",
      children: user.slug
    })]
  });
}

/**
 * A user mentions completer.
 *
 * @type {Object}
 */
/* harmony default export */ const user = ({
  name: 'users',
  className: 'editor-autocompleters__user',
  triggerPrefix: '@',
  useItems(filterValue) {
    const users = (0,external_wp_data_namespaceObject.useSelect)(select => {
      const {
        getUsers
      } = select(external_wp_coreData_namespaceObject.store);
      return getUsers({
        context: 'view',
        search: encodeURIComponent(filterValue)
      });
    }, [filterValue]);
    const options = (0,external_wp_element_namespaceObject.useMemo)(() => users ? users.map(user => ({
      key: `user-${user.slug}`,
      value: user,
      label: getUserLabel(user)
    })) : [], [users]);
    return [options];
  },
  getOptionCompletion(user) {
    return `@${user.slug}`;
  }
});

;// ./packages/editor/build-module/hooks/default-autocompleters.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

function setDefaultCompleters(completers = []) {
  // Provide copies so filters may directly modify them.
  completers.push({
    ...user
  });
  return completers;
}
(0,external_wp_hooks_namespaceObject.addFilter)('editor.Autocomplete.completers', 'editor/autocompleters/set-default-completers', setDefaultCompleters);

;// ./packages/editor/build-module/hooks/media-upload.js
/**
 * WordPress dependencies
 */


(0,external_wp_hooks_namespaceObject.addFilter)('editor.MediaUpload', 'core/editor/components/media-upload', () => external_wp_mediaUtils_namespaceObject.MediaUpload);

;// ./packages/editor/build-module/hooks/pattern-overrides.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



/** @typedef {import('@wordpress/blocks').WPBlockSettings} WPBlockSettings */

const {
  PatternOverridesControls,
  ResetOverridesControl,
  PatternOverridesBlockControls,
  PATTERN_TYPES: pattern_overrides_PATTERN_TYPES,
  PARTIAL_SYNCING_SUPPORTED_BLOCKS,
  PATTERN_SYNC_TYPES
} = unlock(external_wp_patterns_namespaceObject.privateApis);

/**
 * Override the default edit UI to include a new block inspector control for
 * assigning a partial syncing controls to supported blocks in the pattern editor.
 * Currently, only the `core/paragraph` block is supported.
 *
 * @param {Component} BlockEdit Original component.
 *
 * @return {Component} Wrapped component.
 */
const withPatternOverrideControls = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => props => {
  const isSupportedBlock = !!PARTIAL_SYNCING_SUPPORTED_BLOCKS[props.name];
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockEdit, {
      ...props
    }, "edit"), props.isSelected && isSupportedBlock && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ControlsWithStoreSubscription, {
      ...props
    }), isSupportedBlock && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternOverridesBlockControls, {})]
  });
}, 'withPatternOverrideControls');

// Split into a separate component to avoid a store subscription
// on every block.
function ControlsWithStoreSubscription(props) {
  const blockEditingMode = (0,external_wp_blockEditor_namespaceObject.useBlockEditingMode)();
  const {
    hasPatternOverridesSource,
    isEditingSyncedPattern
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getEditedPostAttribute
    } = select(store_store);
    return {
      // For editing link to the site editor if the theme and user permissions support it.
      hasPatternOverridesSource: !!(0,external_wp_blocks_namespaceObject.getBlockBindingsSource)('core/pattern-overrides'),
      isEditingSyncedPattern: getCurrentPostType() === pattern_overrides_PATTERN_TYPES.user && getEditedPostAttribute('meta')?.wp_pattern_sync_status !== PATTERN_SYNC_TYPES.unsynced && getEditedPostAttribute('wp_pattern_sync_status') !== PATTERN_SYNC_TYPES.unsynced
    };
  }, []);
  const bindings = props.attributes.metadata?.bindings;
  const hasPatternBindings = !!bindings && Object.values(bindings).some(binding => binding.source === 'core/pattern-overrides');
  const shouldShowPatternOverridesControls = isEditingSyncedPattern && blockEditingMode === 'default';
  const shouldShowResetOverridesControl = !isEditingSyncedPattern && !!props.attributes.metadata?.name && blockEditingMode !== 'disabled' && hasPatternBindings;
  if (!hasPatternOverridesSource) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [shouldShowPatternOverridesControls && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternOverridesControls, {
      ...props
    }), shouldShowResetOverridesControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ResetOverridesControl, {
      ...props
    })]
  });
}
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/with-pattern-override-controls', withPatternOverrideControls);

;// ./packages/editor/build-module/hooks/navigation-link-view-button.js
/**
 * WordPress dependencies
 */








// Target blocks that should have the View button.

const SUPPORTED_BLOCKS = ['core/navigation-link', 'core/navigation-submenu'];

/**
 * Component that renders the View button for navigation blocks.
 *
 * @param {Object} props            Component props.
 * @param {Object} props.attributes Block attributes.
 * @return {JSX.Element|null} The View button component or null if not applicable.
 */
function NavigationViewButton({
  attributes
}) {
  const {
    kind,
    id,
    type
  } = attributes;
  const blockEditingMode = (0,external_wp_blockEditor_namespaceObject.useBlockEditingMode)();
  const onNavigateToEntityRecord = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_blockEditor_namespaceObject.store).getSettings().onNavigateToEntityRecord, []);
  const onViewPage = (0,external_wp_element_namespaceObject.useCallback)(() => {
    if (kind === 'post-type' && type === 'page' && id && onNavigateToEntityRecord) {
      onNavigateToEntityRecord({
        postId: id,
        postType: type
      });
    }
  }, [kind, id, type, onNavigateToEntityRecord]);

  // Only show for page-type links, when navigation is available, and when in contentOnly mode.
  if (kind !== 'post-type' || type !== 'page' || !id || !onNavigateToEntityRecord || blockEditingMode !== 'contentOnly') {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__unstableBlockToolbarLastItem, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarButton, {
        name: "view",
        title: (0,external_wp_i18n_namespaceObject.__)('View'),
        onClick: onViewPage,
        children: (0,external_wp_i18n_namespaceObject.__)('View')
      })
    })
  });
}

/**
 * Higher-order component that adds the View button to navigation blocks.
 */
const withNavigationViewButton = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockEdit => props => {
  const isSupportedBlock = SUPPORTED_BLOCKS.includes(props.name);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockEdit, {
      ...props
    }, "edit"), props.isSelected && isSupportedBlock && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(NavigationViewButton, {
      ...props
    })]
  });
}, 'withNavigationViewButton');

// Register the filter.
(0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/with-navigation-view-button', withNavigationViewButton);

;// ./packages/editor/build-module/hooks/index.js
/**
 * Internal dependencies
 */






;// ./packages/editor/build-module/components/autocompleters/index.js


;// ./packages/editor/build-module/components/autosave-monitor/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */

class AutosaveMonitor extends external_wp_element_namespaceObject.Component {
  constructor(props) {
    super(props);
    this.needsAutosave = !!(props.isDirty && props.isAutosaveable);
  }
  componentDidMount() {
    if (!this.props.disableIntervalChecks) {
      this.setAutosaveTimer();
    }
  }
  componentDidUpdate(prevProps) {
    if (this.props.disableIntervalChecks) {
      if (this.props.editsReference !== prevProps.editsReference) {
        this.props.autosave();
      }
      return;
    }
    if (this.props.interval !== prevProps.interval) {
      clearTimeout(this.timerId);
      this.setAutosaveTimer();
    }
    if (!this.props.isDirty) {
      this.needsAutosave = false;
      return;
    }
    if (this.props.isAutosaving && !prevProps.isAutosaving) {
      this.needsAutosave = false;
      return;
    }
    if (this.props.editsReference !== prevProps.editsReference) {
      this.needsAutosave = true;
    }
  }
  componentWillUnmount() {
    clearTimeout(this.timerId);
  }
  setAutosaveTimer(timeout = this.props.interval * 1000) {
    this.timerId = setTimeout(() => {
      this.autosaveTimerHandler();
    }, timeout);
  }
  autosaveTimerHandler() {
    if (!this.props.isAutosaveable) {
      this.setAutosaveTimer(1000);
      return;
    }
    if (this.needsAutosave) {
      this.needsAutosave = false;
      this.props.autosave();
    }
    this.setAutosaveTimer();
  }
  render() {
    return null;
  }
}

/**
 * Monitors the changes made to the edited post and triggers autosave if necessary.
 *
 * The logic is straightforward: a check is performed every `props.interval` seconds. If any changes are detected, `props.autosave()` is called.
 * The time between the change and the autosave varies but is no larger than `props.interval` seconds. Refer to the code below for more details, such as
 * the specific way of detecting changes.
 *
 * There are two caveats:
 * * If `props.isAutosaveable` happens to be false at a time of checking for changes, the check is retried every second.
 * * The timer may be disabled by setting `props.disableIntervalChecks` to `true`. In that mode, any change will immediately trigger `props.autosave()`.
 *
 * @param {Object}   props                       - The properties passed to the component.
 * @param {Function} props.autosave              - The function to call when changes need to be saved.
 * @param {number}   props.interval              - The maximum time in seconds between an unsaved change and an autosave.
 * @param {boolean}  props.isAutosaveable        - If false, the check for changes is retried every second.
 * @param {boolean}  props.disableIntervalChecks - If true, disables the timer and any change will immediately trigger `props.autosave()`.
 * @param {boolean}  props.isDirty               - Indicates if there are unsaved changes.
 *
 * @example
 * ```jsx
 * <AutosaveMonitor interval={30000} />
 * ```
 */
/* harmony default export */ const autosave_monitor = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)((select, ownProps) => {
  const {
    getReferenceByDistinctEdits
  } = select(external_wp_coreData_namespaceObject.store);
  const {
    isEditedPostDirty,
    isEditedPostAutosaveable,
    isAutosavingPost,
    getEditorSettings
  } = select(store_store);
  const {
    interval = getEditorSettings().autosaveInterval
  } = ownProps;
  return {
    editsReference: getReferenceByDistinctEdits(),
    isDirty: isEditedPostDirty(),
    isAutosaveable: isEditedPostAutosaveable(),
    isAutosaving: isAutosavingPost(),
    interval
  };
}), (0,external_wp_data_namespaceObject.withDispatch)((dispatch, ownProps) => ({
  autosave() {
    const {
      autosave = dispatch(store_store).autosave
    } = ownProps;
    autosave();
  }
}))])(AutosaveMonitor));

;// ./packages/icons/build-module/library/chevron-right-small.js
/**
 * WordPress dependencies
 */


const chevronRightSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M10.8622 8.04053L14.2805 12.0286L10.8622 16.0167L9.72327 15.0405L12.3049 12.0286L9.72327 9.01672L10.8622 8.04053Z"
  })
});
/* harmony default export */ const chevron_right_small = (chevronRightSmall);

;// ./packages/icons/build-module/library/chevron-left-small.js
/**
 * WordPress dependencies
 */


const chevronLeftSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m13.1 16-3.4-4 3.4-4 1.1 1-2.6 3 2.6 3-1.1 1z"
  })
});
/* harmony default export */ const chevron_left_small = (chevronLeftSmall);

;// external ["wp","dom"]
const external_wp_dom_namespaceObject = window["wp"]["dom"];
;// ./packages/editor/build-module/utils/pageTypeBadge.js
/**
 * WordPress dependencies
 */




/**
 * Custom hook to get the page type badge for the current post on edit site view.
 *
 * @param {number|string} postId postId of the current post being edited.
 */
function usePageTypeBadge(postId) {
  const {
    isFrontPage,
    isPostsPage
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canUser,
      getEditedEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const siteSettings = canUser('read', {
      kind: 'root',
      name: 'site'
    }) ? getEditedEntityRecord('root', 'site') : undefined;
    const _postId = parseInt(postId, 10);
    return {
      isFrontPage: siteSettings?.page_on_front === _postId,
      isPostsPage: siteSettings?.page_for_posts === _postId
    };
  });
  if (isFrontPage) {
    return (0,external_wp_i18n_namespaceObject.__)('Homepage');
  } else if (isPostsPage) {
    return (0,external_wp_i18n_namespaceObject.__)('Posts Page');
  }
  return false;
}

;// ./packages/editor/build-module/components/document-bar/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */













/**
 * Internal dependencies
 */





/** @typedef {import("@wordpress/components").IconType} IconType */

const MotionButton = external_wp_components_namespaceObject.__unstableMotion.create(external_wp_components_namespaceObject.Button);

/**
 * This component renders a navigation bar at the top of the editor. It displays the title of the current document,
 * a back button (if applicable), and a command center button. It also handles different states of the document,
 * such as "not found" or "unsynced".
 *
 * @example
 * ```jsx
 * <DocumentBar />
 * ```
 * @param {Object}   props       The component props.
 * @param {string}   props.title A title for the document, defaulting to the document or
 *                               template title currently being edited.
 * @param {IconType} props.icon  An icon for the document, no default.
 *                               (A default icon indicating the document post type is no longer used.)
 *
 * @return {React.ReactNode} The rendered DocumentBar component.
 */
function DocumentBar(props) {
  const {
    postId,
    postType,
    postTypeLabel,
    documentTitle,
    isNotFound,
    templateTitle,
    onNavigateToPreviousEntityRecord,
    isTemplatePreview
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getCurrentTheme;
    const {
      getCurrentPostType,
      getCurrentPostId,
      getEditorSettings,
      getRenderingMode
    } = select(store_store);
    const {
      getEditedEntityRecord,
      getPostType,
      getCurrentTheme,
      isResolving: isResolvingSelector
    } = select(external_wp_coreData_namespaceObject.store);
    const _postType = getCurrentPostType();
    const _postId = getCurrentPostId();
    const _document = getEditedEntityRecord('postType', _postType, _postId);
    const {
      default_template_types: templateTypes = []
    } = (_getCurrentTheme = getCurrentTheme()) !== null && _getCurrentTheme !== void 0 ? _getCurrentTheme : {};
    const _templateInfo = getTemplateInfo({
      templateTypes,
      template: _document
    });
    const _postTypeLabel = getPostType(_postType)?.labels?.singular_name;
    return {
      postId: _postId,
      postType: _postType,
      postTypeLabel: _postTypeLabel,
      documentTitle: _document.title,
      isNotFound: !_document && !isResolvingSelector('getEditedEntityRecord', 'postType', _postType, _postId),
      templateTitle: _templateInfo.title,
      onNavigateToPreviousEntityRecord: getEditorSettings().onNavigateToPreviousEntityRecord,
      isTemplatePreview: getRenderingMode() === 'template-locked'
    };
  }, []);
  const {
    open: openCommandCenter
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_commands_namespaceObject.store);
  const isReducedMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const isTemplate = TEMPLATE_POST_TYPES.includes(postType);
  const hasBackButton = !!onNavigateToPreviousEntityRecord;
  const entityTitle = isTemplate ? templateTitle : documentTitle;
  const title = props.title || entityTitle;
  const icon = props.icon;
  const pageTypeBadge = usePageTypeBadge(postId);
  const mountedRef = (0,external_wp_element_namespaceObject.useRef)(false);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    mountedRef.current = true;
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: dist_clsx('editor-document-bar', {
      'has-back-button': hasBackButton
    }),
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__unstableAnimatePresence, {
      children: hasBackButton && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(MotionButton, {
        className: "editor-document-bar__back",
        icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? chevron_right_small : chevron_left_small,
        onClick: event => {
          event.stopPropagation();
          onNavigateToPreviousEntityRecord();
        },
        size: "compact",
        initial: mountedRef.current ? {
          opacity: 0,
          transform: 'translateX(15%)'
        } : false // Don't show entry animation when DocumentBar mounts.
        ,
        animate: {
          opacity: 1,
          transform: 'translateX(0%)'
        },
        exit: {
          opacity: 0,
          transform: 'translateX(15%)'
        },
        transition: isReducedMotion ? {
          duration: 0
        } : undefined,
        children: (0,external_wp_i18n_namespaceObject.__)('Back')
      })
    }), !isTemplate && isTemplatePreview && !hasBackButton && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, {
      icon: library_layout,
      className: "editor-document-bar__icon-layout"
    }), isNotFound ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
      children: (0,external_wp_i18n_namespaceObject.__)('Document not found')
    }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Button, {
      className: "editor-document-bar__command",
      onClick: () => openCommandCenter(),
      size: "compact",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__unstableMotion.div, {
        className: "editor-document-bar__title"
        // Force entry animation when the back button is added or removed.
        ,

        initial: mountedRef.current ? {
          opacity: 0,
          transform: hasBackButton ? 'translateX(15%)' : 'translateX(-15%)'
        } : false // Don't show entry animation when DocumentBar mounts.
        ,
        animate: {
          opacity: 1,
          transform: 'translateX(0%)'
        },
        transition: isReducedMotion ? {
          duration: 0
        } : undefined,
        children: [icon && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, {
          icon: icon
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalText, {
          size: "body",
          as: "h1",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "editor-document-bar__post-title",
            children: title ? (0,external_wp_dom_namespaceObject.__unstableStripHTML)(title) : (0,external_wp_i18n_namespaceObject.__)('No title')
          }), pageTypeBadge && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "editor-document-bar__post-type-label",
            children: `· ${pageTypeBadge}`
          }), postTypeLabel && !props.title && !pageTypeBadge && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "editor-document-bar__post-type-label",
            children: `· ${(0,external_wp_htmlEntities_namespaceObject.decodeEntities)(postTypeLabel)}`
          })]
        })]
      }, hasBackButton), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
        className: "editor-document-bar__shortcut",
        children: external_wp_keycodes_namespaceObject.displayShortcut.primary('k')
      })]
    })]
  });
}

;// external ["wp","richText"]
const external_wp_richText_namespaceObject = window["wp"]["richText"];
;// ./packages/editor/build-module/components/document-outline/item.js
/**
 * External dependencies
 */


const TableOfContentsItem = ({
  children,
  isValid,
  isDisabled,
  level,
  href,
  onSelect
}) => {
  function handleClick(event) {
    if (isDisabled) {
      event.preventDefault();
      return;
    }
    onSelect();
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("li", {
    className: dist_clsx('document-outline__item', `is-${level.toLowerCase()}`, {
      'is-invalid': !isValid,
      'is-disabled': isDisabled
    }),
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("a", {
      href: href,
      className: "document-outline__button",
      "aria-disabled": isDisabled,
      onClick: handleClick,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
        className: "document-outline__emdash",
        "aria-hidden": "true"
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("strong", {
        className: "document-outline__level",
        children: level
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
        className: "document-outline__item-content",
        children: children
      })]
    })
  });
};
/* harmony default export */ const document_outline_item = (TableOfContentsItem);

;// ./packages/editor/build-module/components/document-outline/index.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



/**
 * Module constants
 */

const emptyHeadingContent = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("em", {
  children: (0,external_wp_i18n_namespaceObject.__)('(Empty heading)')
});
const incorrectLevelContent = [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("br", {}, "incorrect-break"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("em", {
  children: (0,external_wp_i18n_namespaceObject.__)('(Incorrect heading level)')
}, "incorrect-message")];
const singleH1Headings = [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("br", {}, "incorrect-break-h1"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("em", {
  children: (0,external_wp_i18n_namespaceObject.__)('(Your theme may already use a H1 for the post title)')
}, "incorrect-message-h1")];
const multipleH1Headings = [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("br", {}, "incorrect-break-multiple-h1"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("em", {
  children: (0,external_wp_i18n_namespaceObject.__)('(Multiple H1 headings are not recommended)')
}, "incorrect-message-multiple-h1")];
function EmptyOutlineIllustration() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.SVG, {
    width: "138",
    height: "148",
    viewBox: "0 0 138 148",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Rect, {
      width: "138",
      height: "148",
      rx: "4",
      fill: "#F0F6FC"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Line, {
      x1: "44",
      y1: "28",
      x2: "24",
      y2: "28",
      stroke: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Rect, {
      x: "48",
      y: "16",
      width: "27",
      height: "23",
      rx: "4",
      fill: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
      d: "M54.7585 32V23.2727H56.6037V26.8736H60.3494V23.2727H62.1903V32H60.3494V28.3949H56.6037V32H54.7585ZM67.4574 23.2727V32H65.6122V25.0241H65.5611L63.5625 26.277V24.6406L65.723 23.2727H67.4574Z",
      fill: "black"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Line, {
      x1: "55",
      y1: "59",
      x2: "24",
      y2: "59",
      stroke: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Rect, {
      x: "59",
      y: "47",
      width: "29",
      height: "23",
      rx: "4",
      fill: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
      d: "M65.7585 63V54.2727H67.6037V57.8736H71.3494V54.2727H73.1903V63H71.3494V59.3949H67.6037V63H65.7585ZM74.6605 63V61.6705L77.767 58.794C78.0313 58.5384 78.2528 58.3082 78.4318 58.1037C78.6136 57.8991 78.7514 57.6989 78.8452 57.5028C78.9389 57.304 78.9858 57.0895 78.9858 56.8594C78.9858 56.6037 78.9276 56.3835 78.8111 56.1989C78.6946 56.0114 78.5355 55.8679 78.3338 55.7685C78.1321 55.6662 77.9034 55.6151 77.6477 55.6151C77.3807 55.6151 77.1477 55.669 76.9489 55.777C76.75 55.8849 76.5966 56.0398 76.4886 56.2415C76.3807 56.4432 76.3267 56.6832 76.3267 56.9616H74.5753C74.5753 56.3906 74.7045 55.8949 74.9631 55.4744C75.2216 55.054 75.5838 54.7287 76.0497 54.4986C76.5156 54.2685 77.0526 54.1534 77.6605 54.1534C78.2855 54.1534 78.8295 54.2642 79.2926 54.4858C79.7585 54.7045 80.1207 55.0085 80.3793 55.3977C80.6378 55.7869 80.767 56.233 80.767 56.7358C80.767 57.0653 80.7017 57.3906 80.571 57.7116C80.4432 58.0327 80.2145 58.3892 79.8849 58.7812C79.5554 59.1705 79.0909 59.6378 78.4915 60.1832L77.2173 61.4318V61.4915H80.8821V63H74.6605Z",
      fill: "black"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Line, {
      x1: "80",
      y1: "90",
      x2: "24",
      y2: "90",
      stroke: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Rect, {
      x: "84",
      y: "78",
      width: "30",
      height: "23",
      rx: "4",
      fill: "#F0B849"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
      d: "M90.7585 94V85.2727H92.6037V88.8736H96.3494V85.2727H98.1903V94H96.3494V90.3949H92.6037V94H90.7585ZM99.5284 92.4659V91.0128L103.172 85.2727H104.425V87.2841H103.683L101.386 90.919V90.9872H106.564V92.4659H99.5284ZM103.717 94V92.0227L103.751 91.3793V85.2727H105.482V94H103.717Z",
      fill: "black"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Line, {
      x1: "66",
      y1: "121",
      x2: "24",
      y2: "121",
      stroke: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Rect, {
      x: "70",
      y: "109",
      width: "29",
      height: "23",
      rx: "4",
      fill: "#DDDDDD"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
      d: "M76.7585 125V116.273H78.6037V119.874H82.3494V116.273H84.1903V125H82.3494V121.395H78.6037V125H76.7585ZM88.8864 125.119C88.25 125.119 87.6832 125.01 87.1861 124.791C86.6918 124.57 86.3011 124.266 86.0142 123.879C85.7301 123.49 85.5838 123.041 85.5753 122.533H87.4332C87.4446 122.746 87.5142 122.933 87.642 123.095C87.7727 123.254 87.946 123.378 88.1619 123.466C88.3778 123.554 88.6207 123.598 88.8906 123.598C89.1719 123.598 89.4205 123.548 89.6364 123.449C89.8523 123.349 90.0213 123.212 90.1435 123.036C90.2656 122.859 90.3267 122.656 90.3267 122.426C90.3267 122.193 90.2614 121.987 90.1307 121.808C90.0028 121.626 89.8182 121.484 89.5767 121.382C89.3381 121.28 89.054 121.229 88.7244 121.229H87.9105V119.874H88.7244C89.0028 119.874 89.2486 119.825 89.4616 119.729C89.6776 119.632 89.8452 119.499 89.9645 119.328C90.0838 119.155 90.1435 118.953 90.1435 118.723C90.1435 118.504 90.0909 118.312 89.9858 118.148C89.8835 117.98 89.7386 117.849 89.5511 117.756C89.3665 117.662 89.1506 117.615 88.9034 117.615C88.6534 117.615 88.4247 117.661 88.2173 117.751C88.0099 117.839 87.8438 117.966 87.7188 118.131C87.5938 118.295 87.527 118.489 87.5185 118.71H85.75C85.7585 118.207 85.902 117.764 86.1804 117.381C86.4588 116.997 86.8338 116.697 87.3054 116.482C87.7798 116.263 88.3153 116.153 88.9119 116.153C89.5142 116.153 90.0412 116.263 90.4929 116.482C90.9446 116.7 91.2955 116.996 91.5455 117.368C91.7983 117.737 91.9233 118.152 91.9205 118.612C91.9233 119.101 91.7713 119.509 91.4645 119.835C91.1605 120.162 90.7642 120.369 90.2756 120.457V120.526C90.9176 120.608 91.4063 120.831 91.7415 121.195C92.0795 121.555 92.2472 122.007 92.2443 122.55C92.2472 123.047 92.1037 123.489 91.8139 123.875C91.527 124.261 91.1307 124.565 90.625 124.787C90.1193 125.009 89.5398 125.119 88.8864 125.119Z",
      fill: "black"
    })]
  });
}

/**
 * Returns an array of heading blocks enhanced with the following properties:
 * level   - An integer with the heading level.
 * isEmpty - Flag indicating if the heading has no content.
 *
 * @param {?Array} blocks An array of blocks.
 *
 * @return {Array} An array of heading blocks enhanced with the properties described above.
 */
const computeOutlineHeadings = (blocks = []) => {
  return blocks.filter(block => block.name === 'core/heading').map(block => ({
    ...block,
    level: block.attributes.level,
    isEmpty: isEmptyHeading(block)
  }));
};
const isEmptyHeading = heading => !heading.attributes.content || heading.attributes.content.trim().length === 0;

/**
 * Renders a document outline component.
 *
 * @param {Object}   props                         Props.
 * @param {Function} props.onSelect                Function to be called when an outline item is selected
 * @param {boolean}  props.hasOutlineItemsDisabled Indicates whether the outline items are disabled.
 *
 * @return {React.ReactNode} The rendered component.
 */
function DocumentOutline({
  onSelect,
  hasOutlineItemsDisabled
}) {
  const {
    selectBlock
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const {
    title,
    isTitleSupported
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _postType$supports$ti;
    const {
      getEditedPostAttribute
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    const postType = getPostType(getEditedPostAttribute('type'));
    return {
      title: getEditedPostAttribute('title'),
      isTitleSupported: (_postType$supports$ti = postType?.supports?.title) !== null && _postType$supports$ti !== void 0 ? _postType$supports$ti : false
    };
  });
  const blocks = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getClientIdsWithDescendants,
      getBlock
    } = select(external_wp_blockEditor_namespaceObject.store);
    const clientIds = getClientIdsWithDescendants();
    // Note: Don't modify data inside the `Array.map` callback,
    // all compulations should happen in `computeOutlineHeadings`.
    return clientIds.map(id => getBlock(id));
  });
  const contentBlocks = (0,external_wp_data_namespaceObject.useSelect)(select => {
    // When rendering in `post-only` mode all blocks are considered content blocks.
    if (select(store_store).getRenderingMode() === 'post-only') {
      return undefined;
    }
    const {
      getBlocksByName,
      getClientIdsOfDescendants
    } = select(external_wp_blockEditor_namespaceObject.store);
    const [postContentClientId] = getBlocksByName('core/post-content');

    // Do nothing if there's no post content block.
    if (!postContentClientId) {
      return undefined;
    }
    return getClientIdsOfDescendants(postContentClientId);
  }, []);
  const prevHeadingLevelRef = (0,external_wp_element_namespaceObject.useRef)(1);
  const headings = (0,external_wp_element_namespaceObject.useMemo)(() => computeOutlineHeadings(blocks), [blocks]);
  if (headings.length < 1) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "editor-document-outline has-no-headings",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EmptyOutlineIllustration, {}), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
        children: (0,external_wp_i18n_namespaceObject.__)('Navigate the structure of your document and address issues like empty or incorrect heading levels.')
      })]
    });
  }

  // Not great but it's the simplest way to locate the title right now.
  const titleNode = document.querySelector('.editor-post-title__input');
  const hasTitle = isTitleSupported && title && titleNode;
  const countByLevel = headings.reduce((acc, heading) => ({
    ...acc,
    [heading.level]: (acc[heading.level] || 0) + 1
  }), {});
  const hasMultipleH1 = countByLevel[1] > 1;
  function isContentBlock(clientId) {
    return Array.isArray(contentBlocks) ? contentBlocks.includes(clientId) : true;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "document-outline",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("ul", {
      children: [hasTitle && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(document_outline_item, {
        level: (0,external_wp_i18n_namespaceObject.__)('Title'),
        isValid: true,
        onSelect: onSelect,
        href: `#${titleNode.id}`,
        isDisabled: hasOutlineItemsDisabled,
        children: title
      }), headings.map(item => {
        // Headings remain the same, go up by one, or down by any amount.
        // Otherwise there are missing levels.
        const isIncorrectLevel = item.level > prevHeadingLevelRef.current + 1;
        const isValid = !item.isEmpty && !isIncorrectLevel && !!item.level && (item.level !== 1 || !hasMultipleH1 && !hasTitle);
        prevHeadingLevelRef.current = item.level;
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(document_outline_item, {
          level: `H${item.level}`,
          isValid: isValid,
          isDisabled: hasOutlineItemsDisabled || !isContentBlock(item.clientId),
          href: `#block-${item.clientId}`,
          onSelect: () => {
            selectBlock(item.clientId);
            onSelect?.();
          },
          children: [item.isEmpty ? emptyHeadingContent : (0,external_wp_richText_namespaceObject.getTextContent)((0,external_wp_richText_namespaceObject.create)({
            html: item.attributes.content
          })), isIncorrectLevel && incorrectLevelContent, item.level === 1 && hasMultipleH1 && multipleH1Headings, hasTitle && item.level === 1 && !hasMultipleH1 && singleH1Headings]
        }, item.clientId);
      })]
    })
  });
}

;// ./packages/editor/build-module/components/document-outline/check.js
/**
 * WordPress dependencies
 */



/**
 * Component check if there are any headings (core/heading blocks) present in the document.
 *
 * @param {Object}          props          Props.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} The component to be rendered or null if there are headings.
 */
function DocumentOutlineCheck({
  children
}) {
  const hasHeadings = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getGlobalBlockCount
    } = select(external_wp_blockEditor_namespaceObject.store);
    return getGlobalBlockCount('core/heading') > 0;
  });
  if (!hasHeadings) {
    return null;
  }
  return children;
}

;// ./packages/editor/build-module/components/global-keyboard-shortcuts/register-shortcuts.js
/**
 * WordPress dependencies
 */







/**
 * Component for registering editor keyboard shortcuts.
 *
 * @return {Element} The component to be rendered.
 */

function EditorKeyboardShortcutsRegister() {
  // Registering the shortcuts.
  const {
    registerShortcut
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_keyboardShortcuts_namespaceObject.store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    registerShortcut({
      name: 'core/editor/toggle-mode',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Switch between visual editor and code editor.'),
      keyCombination: {
        modifier: 'secondary',
        character: 'm'
      }
    });
    registerShortcut({
      name: 'core/editor/save',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Save your changes.'),
      keyCombination: {
        modifier: 'primary',
        character: 's'
      }
    });
    registerShortcut({
      name: 'core/editor/undo',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Undo your last changes.'),
      keyCombination: {
        modifier: 'primary',
        character: 'z'
      }
    });
    registerShortcut({
      name: 'core/editor/redo',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Redo your last undo.'),
      keyCombination: {
        modifier: 'primaryShift',
        character: 'z'
      },
      // Disable on Apple OS because it conflicts with the browser's
      // history shortcut. It's a fine alias for both Windows and Linux.
      // Since there's no conflict for Ctrl+Shift+Z on both Windows and
      // Linux, we keep it as the default for consistency.
      aliases: (0,external_wp_keycodes_namespaceObject.isAppleOS)() ? [] : [{
        modifier: 'primary',
        character: 'y'
      }]
    });
    registerShortcut({
      name: 'core/editor/toggle-list-view',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Show or hide the List View.'),
      keyCombination: {
        modifier: 'access',
        character: 'o'
      }
    });
    registerShortcut({
      name: 'core/editor/toggle-distraction-free',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Enter or exit distraction free mode.'),
      keyCombination: {
        modifier: 'primaryShift',
        character: '\\'
      }
    });
    registerShortcut({
      name: 'core/editor/toggle-sidebar',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Show or hide the Settings panel.'),
      keyCombination: {
        modifier: 'primaryShift',
        character: ','
      }
    });
    registerShortcut({
      name: 'core/editor/keyboard-shortcuts',
      category: 'main',
      description: (0,external_wp_i18n_namespaceObject.__)('Display these keyboard shortcuts.'),
      keyCombination: {
        modifier: 'access',
        character: 'h'
      }
    });
    registerShortcut({
      name: 'core/editor/next-region',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Navigate to the next part of the editor.'),
      keyCombination: {
        modifier: 'ctrl',
        character: '`'
      },
      aliases: [{
        modifier: 'access',
        character: 'n'
      }]
    });
    registerShortcut({
      name: 'core/editor/previous-region',
      category: 'global',
      description: (0,external_wp_i18n_namespaceObject.__)('Navigate to the previous part of the editor.'),
      keyCombination: {
        modifier: 'ctrlShift',
        character: '`'
      },
      aliases: [{
        modifier: 'access',
        character: 'p'
      }, {
        modifier: 'ctrlShift',
        character: '~'
      }]
    });
  }, [registerShortcut]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockEditorKeyboardShortcuts.Register, {});
}
/* harmony default export */ const register_shortcuts = (EditorKeyboardShortcutsRegister);

;// ./packages/icons/build-module/library/redo.js
/**
 * WordPress dependencies
 */


const redo_redo = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M15.6 6.5l-1.1 1 2.9 3.3H8c-.9 0-1.7.3-2.3.9-1.4 1.5-1.4 4.2-1.4 5.6v.2h1.5v-.3c0-1.1 0-3.5 1-4.5.3-.3.7-.5 1.3-.5h9.2L14.5 15l1.1 1.1 4.6-4.6-4.6-5z"
  })
});
/* harmony default export */ const library_redo = (redo_redo);

;// ./packages/icons/build-module/library/undo.js
/**
 * WordPress dependencies
 */


const undo_undo = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18.3 11.7c-.6-.6-1.4-.9-2.3-.9H6.7l2.9-3.3-1.1-1-4.5 5L8.5 16l1-1-2.7-2.7H16c.5 0 .9.2 1.3.5 1 1 1 3.4 1 4.5v.3h1.5v-.2c0-1.5 0-4.3-1.5-5.7z"
  })
});
/* harmony default export */ const library_undo = (undo_undo);

;// ./packages/editor/build-module/components/editor-history/redo.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


function EditorHistoryRedo(props, ref) {
  const shortcut = (0,external_wp_keycodes_namespaceObject.isAppleOS)() ? external_wp_keycodes_namespaceObject.displayShortcut.primaryShift('z') : external_wp_keycodes_namespaceObject.displayShortcut.primary('y');
  const hasRedo = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).hasEditorRedo(), []);
  const {
    redo
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    __next40pxDefaultSize: true,
    ...props,
    ref: ref,
    icon: !(0,external_wp_i18n_namespaceObject.isRTL)() ? library_redo : library_undo
    /* translators: button label text should, if possible, be under 16 characters. */,
    label: (0,external_wp_i18n_namespaceObject.__)('Redo'),
    shortcut: shortcut
    // If there are no redo levels we don't want to actually disable this
    // button, because it will remove focus for keyboard users.
    // See: https://github.com/WordPress/gutenberg/issues/3486
    ,
    "aria-disabled": !hasRedo,
    onClick: hasRedo ? redo : undefined,
    className: "editor-history__redo"
  });
}

/** @typedef {import('react').Ref<HTMLElement>} Ref */

/**
 * Renders the redo button for the editor history.
 *
 * @param {Object} props - Props.
 * @param {Ref}    ref   - Forwarded ref.
 *
 * @return {React.ReactNode} The rendered component.
 */
/* harmony default export */ const editor_history_redo = ((0,external_wp_element_namespaceObject.forwardRef)(EditorHistoryRedo));

;// ./packages/editor/build-module/components/editor-history/undo.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


function EditorHistoryUndo(props, ref) {
  const hasUndo = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).hasEditorUndo(), []);
  const {
    undo
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    __next40pxDefaultSize: true,
    ...props,
    ref: ref,
    icon: !(0,external_wp_i18n_namespaceObject.isRTL)() ? library_undo : library_redo
    /* translators: button label text should, if possible, be under 16 characters. */,
    label: (0,external_wp_i18n_namespaceObject.__)('Undo'),
    shortcut: external_wp_keycodes_namespaceObject.displayShortcut.primary('z')
    // If there are no undo levels we don't want to actually disable this
    // button, because it will remove focus for keyboard users.
    // See: https://github.com/WordPress/gutenberg/issues/3486
    ,
    "aria-disabled": !hasUndo,
    onClick: hasUndo ? undo : undefined,
    className: "editor-history__undo"
  });
}

/** @typedef {import('react').Ref<HTMLElement>} Ref */

/**
 * Renders the undo button for the editor history.
 *
 * @param {Object} props - Props.
 * @param {Ref}    ref   - Forwarded ref.
 *
 * @return {React.ReactNode} The rendered component.
 */
/* harmony default export */ const editor_history_undo = ((0,external_wp_element_namespaceObject.forwardRef)(EditorHistoryUndo));

;// ./packages/editor/build-module/components/template-validation-notice/index.js
/**
 * WordPress dependencies
 */






function TemplateValidationNotice() {
  const [showConfirmDialog, setShowConfirmDialog] = (0,external_wp_element_namespaceObject.useState)(false);
  const isValid = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(external_wp_blockEditor_namespaceObject.store).isValidTemplate();
  }, []);
  const {
    setTemplateValidity,
    synchronizeTemplate
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  if (isValid) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Notice, {
      className: "editor-template-validation-notice",
      isDismissible: false,
      status: "warning",
      actions: [{
        label: (0,external_wp_i18n_namespaceObject.__)('Keep it as is'),
        onClick: () => setTemplateValidity(true)
      }, {
        label: (0,external_wp_i18n_namespaceObject.__)('Reset the template'),
        onClick: () => setShowConfirmDialog(true)
      }],
      children: (0,external_wp_i18n_namespaceObject.__)('The content of your post doesn’t match the template assigned to your post type.')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalConfirmDialog, {
      isOpen: showConfirmDialog,
      confirmButtonText: (0,external_wp_i18n_namespaceObject.__)('Reset'),
      onConfirm: () => {
        setShowConfirmDialog(false);
        synchronizeTemplate();
      },
      onCancel: () => setShowConfirmDialog(false),
      size: "medium",
      children: (0,external_wp_i18n_namespaceObject.__)('Resetting the template may result in loss of content, do you want to continue?')
    })]
  });
}

;// ./packages/editor/build-module/components/editor-notices/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * This component renders the notices displayed in the editor. It displays pinned notices first, followed by dismissible
 *
 * @example
 * ```jsx
 * <EditorNotices />
 * ```
 *
 * @return {React.ReactNode} The rendered EditorNotices component.
 */

function EditorNotices() {
  const {
    notices
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    notices: select(external_wp_notices_namespaceObject.store).getNotices()
  }), []);
  const {
    removeNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const dismissibleNotices = notices.filter(({
    isDismissible,
    type
  }) => isDismissible && type === 'default');
  const nonDismissibleNotices = notices.filter(({
    isDismissible,
    type
  }) => !isDismissible && type === 'default');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.NoticeList, {
      notices: nonDismissibleNotices,
      className: "components-editor-notices__pinned"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.NoticeList, {
      notices: dismissibleNotices,
      className: "components-editor-notices__dismissible",
      onRemove: removeNotice,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TemplateValidationNotice, {})
    })]
  });
}
/* harmony default export */ const editor_notices = (EditorNotices);

;// ./packages/editor/build-module/components/editor-snackbars/index.js
/**
 * WordPress dependencies
 */




// Last three notices. Slices from the tail end of the list.

const MAX_VISIBLE_NOTICES = -3;

/**
 * Renders the editor snackbars component.
 *
 * @return {React.ReactNode} The rendered component.
 */
function EditorSnackbars() {
  const notices = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_notices_namespaceObject.store).getNotices(), []);
  const {
    removeNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const snackbarNotices = notices.filter(({
    type
  }) => type === 'snackbar').slice(MAX_VISIBLE_NOTICES);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SnackbarList, {
    notices: snackbarNotices,
    className: "components-editor-notices__snackbar",
    onRemove: removeNotice
  });
}

;// ./packages/editor/build-module/components/entities-saved-states/entity-record-item.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function EntityRecordItem({
  record,
  checked,
  onChange
}) {
  const {
    name,
    kind,
    title,
    key
  } = record;

  // Handle templates that might use default descriptive titles.
  const {
    entityRecordTitle,
    hasPostMetaChanges
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getCurrentThe;
    if ('postType' !== kind || 'wp_template' !== name) {
      return {
        entityRecordTitle: title,
        hasPostMetaChanges: unlock(select(store_store)).hasPostMetaChanges(name, key)
      };
    }
    const template = select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord(kind, name, key);
    const {
      default_template_types: templateTypes = []
    } = (_select$getCurrentThe = select(external_wp_coreData_namespaceObject.store).getCurrentTheme()) !== null && _select$getCurrentThe !== void 0 ? _select$getCurrentThe : {};
    return {
      entityRecordTitle: getTemplateInfo({
        template,
        templateTypes
      }).title,
      hasPostMetaChanges: unlock(select(store_store)).hasPostMetaChanges(name, key)
    };
  }, [name, kind, title, key]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelRow, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(entityRecordTitle) || (0,external_wp_i18n_namespaceObject.__)('Untitled'),
        checked: checked,
        onChange: onChange,
        className: "entities-saved-states__change-control"
      })
    }), hasPostMetaChanges && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", {
      className: "entities-saved-states__changes",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("li", {
        children: (0,external_wp_i18n_namespaceObject.__)('Post Meta.')
      })
    })]
  });
}

;// ./packages/editor/build-module/components/entities-saved-states/entity-type-list.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



const {
  getGlobalStylesChanges,
  GlobalStylesContext: entity_type_list_GlobalStylesContext
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function getEntityDescription(entity, count) {
  switch (entity) {
    case 'site':
      return 1 === count ? (0,external_wp_i18n_namespaceObject.__)('This change will affect your whole site.') : (0,external_wp_i18n_namespaceObject.__)('These changes will affect your whole site.');
    case 'wp_template':
      return (0,external_wp_i18n_namespaceObject.__)('This change will affect other parts of your site that use this template.');
    case 'page':
    case 'post':
      return (0,external_wp_i18n_namespaceObject.__)('The following has been modified.');
  }
}
function GlobalStylesDescription({
  record
}) {
  const {
    user: currentEditorGlobalStyles
  } = (0,external_wp_element_namespaceObject.useContext)(entity_type_list_GlobalStylesContext);
  const savedRecord = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getEntityRecord(record.kind, record.name, record.key), [record.kind, record.name, record.key]);
  const globalStylesChanges = getGlobalStylesChanges(currentEditorGlobalStyles, savedRecord, {
    maxResults: 10
  });
  return globalStylesChanges.length ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", {
    className: "entities-saved-states__changes",
    children: globalStylesChanges.map(change => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("li", {
      children: change
    }, change))
  }) : null;
}
function EntityDescription({
  record,
  count
}) {
  if ('globalStyles' === record?.name) {
    return null;
  }
  const description = getEntityDescription(record?.name, count);
  return description ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelRow, {
    children: description
  }) : null;
}
function EntityTypeList({
  list,
  unselectedEntities,
  setUnselectedEntities
}) {
  const count = list.length;
  const firstRecord = list[0];
  const entityConfig = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getEntityConfig(firstRecord.kind, firstRecord.name), [firstRecord.kind, firstRecord.name]);
  let entityLabel = entityConfig.label;
  if (firstRecord?.name === 'wp_template_part') {
    entityLabel = 1 === count ? (0,external_wp_i18n_namespaceObject.__)('Template Part') : (0,external_wp_i18n_namespaceObject.__)('Template Parts');
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.PanelBody, {
    title: entityLabel,
    initialOpen: true,
    className: "entities-saved-states__panel-body",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EntityDescription, {
      record: firstRecord,
      count: count
    }), list.map(record => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EntityRecordItem, {
        record: record,
        checked: !unselectedEntities.some(elt => elt.kind === record.kind && elt.name === record.name && elt.key === record.key && elt.property === record.property),
        onChange: value => setUnselectedEntities(record, value)
      }, record.key || record.property);
    }), 'globalStyles' === firstRecord?.name && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GlobalStylesDescription, {
      record: firstRecord
    })]
  });
}

;// ./packages/editor/build-module/components/entities-saved-states/hooks/use-is-dirty.js
/**
 * WordPress dependencies
 */




/**
 * Custom hook that determines if any entities are dirty (edited) and provides a way to manage selected/unselected entities.
 *
 * @return {Object} An object containing the following properties:
 *   - dirtyEntityRecords: An array of dirty entity records.
 *   - isDirty: A boolean indicating if there are any dirty entity records.
 *   - setUnselectedEntities: A function to set the unselected entities.
 *   - unselectedEntities: An array of unselected entities.
 */
const useIsDirty = () => {
  const {
    editedEntities,
    siteEdits,
    siteEntityConfig
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      __experimentalGetDirtyEntityRecords,
      getEntityRecordEdits,
      getEntityConfig
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      editedEntities: __experimentalGetDirtyEntityRecords(),
      siteEdits: getEntityRecordEdits('root', 'site'),
      siteEntityConfig: getEntityConfig('root', 'site')
    };
  }, []);
  const dirtyEntityRecords = (0,external_wp_element_namespaceObject.useMemo)(() => {
    var _siteEntityConfig$met;
    // Remove site object and decouple into its edited pieces.
    const editedEntitiesWithoutSite = editedEntities.filter(record => !(record.kind === 'root' && record.name === 'site'));
    const siteEntityLabels = (_siteEntityConfig$met = siteEntityConfig?.meta?.labels) !== null && _siteEntityConfig$met !== void 0 ? _siteEntityConfig$met : {};
    const editedSiteEntities = [];
    for (const property in siteEdits) {
      editedSiteEntities.push({
        kind: 'root',
        name: 'site',
        title: siteEntityLabels[property] || property,
        property
      });
    }
    return [...editedEntitiesWithoutSite, ...editedSiteEntities];
  }, [editedEntities, siteEdits, siteEntityConfig]);

  // Unchecked entities to be ignored by save function.
  const [unselectedEntities, _setUnselectedEntities] = (0,external_wp_element_namespaceObject.useState)([]);
  const setUnselectedEntities = ({
    kind,
    name,
    key,
    property
  }, checked) => {
    if (checked) {
      _setUnselectedEntities(unselectedEntities.filter(elt => elt.kind !== kind || elt.name !== name || elt.key !== key || elt.property !== property));
    } else {
      _setUnselectedEntities([...unselectedEntities, {
        kind,
        name,
        key,
        property
      }]);
    }
  };
  const isDirty = dirtyEntityRecords.length - unselectedEntities.length > 0;
  return {
    dirtyEntityRecords,
    isDirty,
    setUnselectedEntities,
    unselectedEntities
  };
};

;// ./packages/editor/build-module/components/entities-saved-states/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */





function identity(values) {
  return values;
}

/**
 * Renders the component for managing saved states of entities.
 *
 * @param {Object}   props              The component props.
 * @param {Function} props.close        The function to close the dialog.
 * @param {boolean}  props.renderDialog Whether to render the component with modal dialog behavior.
 * @param {string}   props.variant      Changes the layout of the component. When an `inline` value is provided, the action buttons are rendered at the end of the component instead of at the start.
 *
 * @return {React.ReactNode} The rendered component.
 */
function EntitiesSavedStates({
  close,
  renderDialog,
  variant
}) {
  const isDirtyProps = useIsDirty();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EntitiesSavedStatesExtensible, {
    close: close,
    renderDialog: renderDialog,
    variant: variant,
    ...isDirtyProps
  });
}

/**
 * Renders a panel for saving entities with dirty records.
 *
 * @param {Object}   props                       The component props.
 * @param {string}   props.additionalPrompt      Additional prompt to display.
 * @param {Function} props.close                 Function to close the panel.
 * @param {Function} props.onSave                Function to call when saving entities.
 * @param {boolean}  props.saveEnabled           Flag indicating if save is enabled.
 * @param {string}   props.saveLabel             Label for the save button.
 * @param {boolean}  props.renderDialog          Whether to render the component with modal dialog behavior.
 * @param {Array}    props.dirtyEntityRecords    Array of dirty entity records.
 * @param {boolean}  props.isDirty               Flag indicating if there are dirty entities.
 * @param {Function} props.setUnselectedEntities Function to set unselected entities.
 * @param {Array}    props.unselectedEntities    Array of unselected entities.
 * @param {string}   props.variant               Changes the layout of the component. When an `inline` value is provided, the action buttons are rendered at the end of the component instead of at the start.
 *
 * @return {React.ReactNode} The rendered component.
 */
function EntitiesSavedStatesExtensible({
  additionalPrompt = undefined,
  close,
  onSave = identity,
  saveEnabled: saveEnabledProp = undefined,
  saveLabel = (0,external_wp_i18n_namespaceObject.__)('Save'),
  renderDialog,
  dirtyEntityRecords,
  isDirty,
  setUnselectedEntities,
  unselectedEntities,
  variant = 'default'
}) {
  const saveButtonRef = (0,external_wp_element_namespaceObject.useRef)();
  const {
    saveDirtyEntities
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store_store));
  // To group entities by type.
  const partitionedSavables = dirtyEntityRecords.reduce((acc, record) => {
    const {
      name
    } = record;
    if (!acc[name]) {
      acc[name] = [];
    }
    acc[name].push(record);
    return acc;
  }, {});

  // Sort entity groups.
  const {
    site: siteSavables,
    wp_template: templateSavables,
    wp_template_part: templatePartSavables,
    ...contentSavables
  } = partitionedSavables;
  const sortedPartitionedSavables = [siteSavables, templateSavables, templatePartSavables, ...Object.values(contentSavables)].filter(Array.isArray);
  const saveEnabled = saveEnabledProp !== null && saveEnabledProp !== void 0 ? saveEnabledProp : isDirty;
  // Explicitly define this with no argument passed.  Using `close` on
  // its own will use the event object in place of the expected saved entities.
  const dismissPanel = (0,external_wp_element_namespaceObject.useCallback)(() => close(), [close]);
  const [saveDialogRef, saveDialogProps] = (0,external_wp_compose_namespaceObject.__experimentalUseDialog)({
    onClose: () => dismissPanel()
  });
  const dialogLabelId = (0,external_wp_compose_namespaceObject.useInstanceId)(EntitiesSavedStatesExtensible, 'entities-saved-states__panel-label');
  const dialogDescriptionId = (0,external_wp_compose_namespaceObject.useInstanceId)(EntitiesSavedStatesExtensible, 'entities-saved-states__panel-description');
  const selectItemsToSaveDescription = !!dirtyEntityRecords.length ? (0,external_wp_i18n_namespaceObject.__)('Select the items you want to save.') : undefined;
  const isInline = variant === 'inline';
  const actionButtons = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
      isBlock: isInline ? false : true,
      as: external_wp_components_namespaceObject.Button,
      variant: isInline ? 'tertiary' : 'secondary',
      size: isInline ? undefined : 'compact',
      onClick: dismissPanel,
      children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
      isBlock: isInline ? false : true,
      as: external_wp_components_namespaceObject.Button,
      ref: saveButtonRef,
      variant: "primary",
      size: isInline ? undefined : 'compact',
      disabled: !saveEnabled,
      accessibleWhenDisabled: true,
      onClick: () => saveDirtyEntities({
        onSave,
        dirtyEntityRecords,
        entitiesToSkip: unselectedEntities,
        close
      }),
      className: "editor-entities-saved-states__save-button",
      children: saveLabel
    })]
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    ref: renderDialog ? saveDialogRef : undefined,
    ...(renderDialog && saveDialogProps),
    className: dist_clsx('entities-saved-states__panel', {
      'is-inline': isInline
    }),
    role: renderDialog ? 'dialog' : undefined,
    "aria-labelledby": renderDialog ? dialogLabelId : undefined,
    "aria-describedby": renderDialog ? dialogDescriptionId : undefined,
    children: [!isInline && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
      className: "entities-saved-states__panel-header",
      gap: 2,
      children: actionButtons
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "entities-saved-states__text-prompt",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "entities-saved-states__text-prompt--header-wrapper",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("strong", {
          id: renderDialog ? dialogLabelId : undefined,
          className: "entities-saved-states__text-prompt--header",
          children: (0,external_wp_i18n_namespaceObject.__)('Are you ready to save?')
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        id: renderDialog ? dialogDescriptionId : undefined,
        children: [additionalPrompt, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
          className: "entities-saved-states__text-prompt--changes-count",
          children: isDirty ? (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %d: number of site changes waiting to be saved. */
          (0,external_wp_i18n_namespaceObject._n)('There is <strong>%d site change</strong> waiting to be saved.', 'There are <strong>%d site changes</strong> waiting to be saved.', dirtyEntityRecords.length), dirtyEntityRecords.length), {
            strong: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("strong", {})
          }) : selectItemsToSaveDescription
        })]
      })]
    }), sortedPartitionedSavables.map(list => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EntityTypeList, {
        list: list,
        unselectedEntities: unselectedEntities,
        setUnselectedEntities: setUnselectedEntities
      }, list[0].name);
    }), isInline && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
      direction: "row",
      justify: "flex-end",
      className: "entities-saved-states__panel-footer",
      children: actionButtons
    })]
  });
}

;// ./packages/editor/build-module/components/error-boundary/index.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


function getContent() {
  try {
    // While `select` in a component is generally discouraged, it is
    // used here because it (a) reduces the chance of data loss in the
    // case of additional errors by performing a direct retrieval and
    // (b) avoids the performance cost associated with unnecessary
    // content serialization throughout the lifetime of a non-erroring
    // application.
    return (0,external_wp_data_namespaceObject.select)(store_store).getEditedPostContent();
  } catch (error) {}
}
function CopyButton({
  text,
  children,
  variant = 'secondary'
}) {
  const ref = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(text);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    __next40pxDefaultSize: true,
    variant: variant,
    ref: ref,
    children: children
  });
}
class ErrorBoundary extends external_wp_element_namespaceObject.Component {
  constructor() {
    super(...arguments);
    this.state = {
      error: null
    };
  }
  componentDidCatch(error) {
    (0,external_wp_hooks_namespaceObject.doAction)('editor.ErrorBoundary.errorLogged', error);
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  render() {
    const {
      error
    } = this.state;
    const {
      canCopyContent = false
    } = this.props;
    if (!error) {
      return this.props.children;
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      className: "editor-error-boundary",
      alignment: "baseline",
      spacing: 4,
      justify: "space-between",
      expanded: false,
      wrap: true,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
        as: "p",
        children: (0,external_wp_i18n_namespaceObject.__)('The editor has encountered an unexpected error.')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        expanded: false,
        children: [canCopyContent && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CopyButton, {
          text: getContent,
          children: (0,external_wp_i18n_namespaceObject.__)('Copy contents')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CopyButton, {
          variant: "primary",
          text: error?.stack,
          children: (0,external_wp_i18n_namespaceObject.__)('Copy error')
        })]
      })]
    });
  }
}

/**
 * ErrorBoundary is used to catch JavaScript errors anywhere in a child component tree, log those errors, and display a fallback UI.
 *
 * It uses the lifecycle methods getDerivedStateFromError and componentDidCatch to catch errors in a child component tree.
 *
 * getDerivedStateFromError is used to render a fallback UI after an error has been thrown, and componentDidCatch is used to log error information.
 *
 * @class ErrorBoundary
 * @augments Component
 */
/* harmony default export */ const error_boundary = (ErrorBoundary);

;// ./packages/editor/build-module/components/local-autosave-monitor/index.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */




const requestIdleCallback = window.requestIdleCallback ? window.requestIdleCallback : window.requestAnimationFrame;
let hasStorageSupport;

/**
 * Function which returns true if the current environment supports browser
 * sessionStorage, or false otherwise. The result of this function is cached and
 * reused in subsequent invocations.
 */
const hasSessionStorageSupport = () => {
  if (hasStorageSupport !== undefined) {
    return hasStorageSupport;
  }
  try {
    // Private Browsing in Safari 10 and earlier will throw an error when
    // attempting to set into sessionStorage. The test here is intentional in
    // causing a thrown error as condition bailing from local autosave.
    window.sessionStorage.setItem('__wpEditorTestSessionStorage', '');
    window.sessionStorage.removeItem('__wpEditorTestSessionStorage');
    hasStorageSupport = true;
  } catch {
    hasStorageSupport = false;
  }
  return hasStorageSupport;
};

/**
 * Custom hook which manages the creation of a notice prompting the user to
 * restore a local autosave, if one exists.
 */
function useAutosaveNotice() {
  const {
    postId,
    isEditedPostNew,
    hasRemoteAutosave
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    postId: select(store_store).getCurrentPostId(),
    isEditedPostNew: select(store_store).isEditedPostNew(),
    hasRemoteAutosave: !!select(store_store).getEditorSettings().autosave
  }), []);
  const {
    getEditedPostAttribute
  } = (0,external_wp_data_namespaceObject.useSelect)(store_store);
  const {
    createWarningNotice,
    removeNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    editPost,
    resetEditorBlocks
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    let localAutosave = localAutosaveGet(postId, isEditedPostNew);
    if (!localAutosave) {
      return;
    }
    try {
      localAutosave = JSON.parse(localAutosave);
    } catch {
      // Not usable if it can't be parsed.
      return;
    }
    const {
      post_title: title,
      content,
      excerpt
    } = localAutosave;
    const edits = {
      title,
      content,
      excerpt
    };
    {
      // Only display a notice if there is a difference between what has been
      // saved and that which is stored in sessionStorage.
      const hasDifference = Object.keys(edits).some(key => {
        return edits[key] !== getEditedPostAttribute(key);
      });
      if (!hasDifference) {
        // If there is no difference, it can be safely ejected from storage.
        localAutosaveClear(postId, isEditedPostNew);
        return;
      }
    }
    if (hasRemoteAutosave) {
      return;
    }
    const id = 'wpEditorAutosaveRestore';
    createWarningNotice((0,external_wp_i18n_namespaceObject.__)('The backup of this post in your browser is different from the version below.'), {
      id,
      actions: [{
        label: (0,external_wp_i18n_namespaceObject.__)('Restore the backup'),
        onClick() {
          const {
            content: editsContent,
            ...editsWithoutContent
          } = edits;
          editPost(editsWithoutContent);
          resetEditorBlocks((0,external_wp_blocks_namespaceObject.parse)(edits.content));
          removeNotice(id);
        }
      }]
    });
  }, [isEditedPostNew, postId]);
}

/**
 * Custom hook which ejects a local autosave after a successful save occurs.
 */
function useAutosavePurge() {
  const {
    postId,
    isEditedPostNew,
    isDirty,
    isAutosaving,
    didError
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    postId: select(store_store).getCurrentPostId(),
    isEditedPostNew: select(store_store).isEditedPostNew(),
    isDirty: select(store_store).isEditedPostDirty(),
    isAutosaving: select(store_store).isAutosavingPost(),
    didError: select(store_store).didPostSaveRequestFail()
  }), []);
  const lastIsDirtyRef = (0,external_wp_element_namespaceObject.useRef)(isDirty);
  const lastIsAutosavingRef = (0,external_wp_element_namespaceObject.useRef)(isAutosaving);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!didError && (lastIsAutosavingRef.current && !isAutosaving || lastIsDirtyRef.current && !isDirty)) {
      localAutosaveClear(postId, isEditedPostNew);
    }
    lastIsDirtyRef.current = isDirty;
    lastIsAutosavingRef.current = isAutosaving;
  }, [isDirty, isAutosaving, didError]);

  // Once the isEditedPostNew changes from true to false, let's clear the auto-draft autosave.
  const wasEditedPostNew = (0,external_wp_compose_namespaceObject.usePrevious)(isEditedPostNew);
  const prevPostId = (0,external_wp_compose_namespaceObject.usePrevious)(postId);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (prevPostId === postId && wasEditedPostNew && !isEditedPostNew) {
      localAutosaveClear(postId, true);
    }
  }, [isEditedPostNew, postId]);
}
function LocalAutosaveMonitor() {
  const {
    autosave
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const deferredAutosave = (0,external_wp_element_namespaceObject.useCallback)(() => {
    requestIdleCallback(() => autosave({
      local: true
    }));
  }, []);
  useAutosaveNotice();
  useAutosavePurge();
  const localAutosaveInterval = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getEditorSettings().localAutosaveInterval, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(autosave_monitor, {
    interval: localAutosaveInterval,
    autosave: deferredAutosave
  });
}

/**
 * Monitors local autosaves of a post in the editor.
 * It uses several hooks and functions to manage autosave behavior:
 * - `useAutosaveNotice` hook: Manages the creation of a notice prompting the user to restore a local autosave, if one exists.
 * - `useAutosavePurge` hook: Ejects a local autosave after a successful save occurs.
 * - `hasSessionStorageSupport` function: Checks if the current environment supports browser sessionStorage.
 * - `LocalAutosaveMonitor` component: Uses the `AutosaveMonitor` component to perform autosaves at a specified interval.
 *
 * The module also checks for sessionStorage support and conditionally exports the `LocalAutosaveMonitor` component based on that.
 *
 * @module LocalAutosaveMonitor
 */
/* harmony default export */ const local_autosave_monitor = ((0,external_wp_compose_namespaceObject.ifCondition)(hasSessionStorageSupport)(LocalAutosaveMonitor));

;// ./packages/editor/build-module/components/page-attributes/check.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Wrapper component that renders its children only if the post type supports page attributes.
 *
 * @param {Object}          props          - The component props.
 * @param {React.ReactNode} props.children - The child components to render.
 *
 * @return {React.ReactNode} The rendered child components or null if page attributes are not supported.
 */
function PageAttributesCheck({
  children
}) {
  const supportsPageAttributes = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    const postType = getPostType(getEditedPostAttribute('type'));
    return !!postType?.supports?.['page-attributes'];
  }, []);

  // Only render fields if post type supports page attributes or available templates exist.
  if (!supportsPageAttributes) {
    return null;
  }
  return children;
}
/* harmony default export */ const page_attributes_check = (PageAttributesCheck);

;// ./packages/editor/build-module/components/post-type-support-check/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * A component which renders its own children only if the current editor post
 * type supports one of the given `supportKeys` prop.
 *
 * @param {Object}            props             Props.
 * @param {React.ReactNode}   props.children    Children to be rendered if post
 *                                              type supports.
 * @param {(string|string[])} props.supportKeys String or string array of keys
 *                                              to test.
 *
 * @return {React.ReactNode} The component to be rendered.
 */
function PostTypeSupportCheck({
  children,
  supportKeys
}) {
  const postType = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    return getPostType(getEditedPostAttribute('type'));
  }, []);
  let isSupported = !!postType;
  if (postType) {
    isSupported = (Array.isArray(supportKeys) ? supportKeys : [supportKeys]).some(key => !!postType.supports[key]);
  }
  if (!isSupported) {
    return null;
  }
  return children;
}
/* harmony default export */ const post_type_support_check = (PostTypeSupportCheck);

;// ./packages/editor/build-module/components/page-attributes/order.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function PageAttributesOrder() {
  const order = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getEditedPost;
    return (_select$getEditedPost = select(store_store).getEditedPostAttribute('menu_order')) !== null && _select$getEditedPost !== void 0 ? _select$getEditedPost : 0;
  }, []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const [orderInput, setOrderInput] = (0,external_wp_element_namespaceObject.useState)(null);
  const setUpdatedOrder = value => {
    setOrderInput(value);
    const newOrder = Number(value);
    if (Number.isInteger(newOrder) && value.trim?.() !== '') {
      editPost({
        menu_order: newOrder
      });
    }
  };
  const value = orderInput !== null && orderInput !== void 0 ? orderInput : order;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexBlock, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
        __next40pxDefaultSize: true,
        label: (0,external_wp_i18n_namespaceObject.__)('Order'),
        help: (0,external_wp_i18n_namespaceObject.__)('Set the page order.'),
        value: value,
        onChange: setUpdatedOrder,
        hideLabelFromVision: true,
        onBlur: () => {
          setOrderInput(null);
        }
      })
    })
  });
}

/**
 * Renders the Page Attributes Order component. A number input in an editor interface
 * for setting the order of a given page.
 * The component is now not used in core but was kept for backward compatibility.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PageAttributesOrderWithChecks() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: "page-attributes",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PageAttributesOrder, {})
  });
}

;// ./packages/editor/build-module/components/post-panel-row/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



const PostPanelRow = (0,external_wp_element_namespaceObject.forwardRef)(({
  className,
  label,
  children
}, ref) => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
    className: dist_clsx('editor-post-panel__row', className),
    ref: ref,
    children: [label && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "editor-post-panel__row-label",
      children: label
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "editor-post-panel__row-control",
      children: children
    })]
  });
});
/* harmony default export */ const post_panel_row = (PostPanelRow);

;// ./packages/editor/build-module/utils/terms.js
/**
 * WordPress dependencies
 */


/**
 * Returns terms in a tree form.
 *
 * @param {Array} flatTerms Array of terms in flat format.
 *
 * @return {Array} Array of terms in tree format.
 */
function terms_buildTermsTree(flatTerms) {
  const flatTermsWithParentAndChildren = flatTerms.map(term => {
    return {
      children: [],
      parent: undefined,
      ...term
    };
  });

  // All terms should have a `parent` because we're about to index them by it.
  if (flatTermsWithParentAndChildren.some(({
    parent
  }) => parent === undefined)) {
    return flatTermsWithParentAndChildren;
  }
  const termsByParent = flatTermsWithParentAndChildren.reduce((acc, term) => {
    const {
      parent
    } = term;
    if (!acc[parent]) {
      acc[parent] = [];
    }
    acc[parent].push(term);
    return acc;
  }, {});
  const fillWithChildren = terms => {
    return terms.map(term => {
      const children = termsByParent[term.id];
      return {
        ...term,
        children: children && children.length ? fillWithChildren(children) : []
      };
    });
  };
  return fillWithChildren(termsByParent['0'] || []);
}
const unescapeString = arg => {
  return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(arg);
};

/**
 * Returns a term object with name unescaped.
 *
 * @param {Object} term The term object to unescape.
 *
 * @return {Object} Term object with name property unescaped.
 */
const unescapeTerm = term => {
  return {
    ...term,
    name: unescapeString(term.name)
  };
};

/**
 * Returns an array of term objects with names unescaped.
 * The unescape of each term is performed using the unescapeTerm function.
 *
 * @param {Object[]} terms Array of term objects to unescape.
 *
 * @return {Object[]} Array of term objects unescaped.
 */
const unescapeTerms = terms => {
  return (terms !== null && terms !== void 0 ? terms : []).map(unescapeTerm);
};

;// ./packages/editor/build-module/components/page-attributes/parent.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */




function getTitle(post) {
  return post?.title?.rendered ? (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(post.title.rendered) : `#${post.id} (${(0,external_wp_i18n_namespaceObject.__)('no title')})`;
}
const parent_getItemPriority = (name, searchValue) => {
  const normalizedName = remove_accents_default()(name || '').toLowerCase();
  const normalizedSearch = remove_accents_default()(searchValue || '').toLowerCase();
  if (normalizedName === normalizedSearch) {
    return 0;
  }
  if (normalizedName.startsWith(normalizedSearch)) {
    return normalizedName.length;
  }
  return Infinity;
};

/**
 * Renders the Page Attributes Parent component. A dropdown menu in an editor interface
 * for selecting the parent page of a given page.
 *
 * @return {React.ReactNode} The component to be rendered. Return null if post type is not hierarchical.
 */
function parent_PageAttributesParent() {
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const [fieldValue, setFieldValue] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    isHierarchical,
    parentPostId,
    parentPostTitle,
    pageItems,
    isLoading
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _pType$hierarchical;
    const {
      getPostType,
      getEntityRecords,
      getEntityRecord,
      isResolving
    } = select(external_wp_coreData_namespaceObject.store);
    const {
      getCurrentPostId,
      getEditedPostAttribute
    } = select(store_store);
    const postTypeSlug = getEditedPostAttribute('type');
    const pageId = getEditedPostAttribute('parent');
    const pType = getPostType(postTypeSlug);
    const postId = getCurrentPostId();
    const postIsHierarchical = (_pType$hierarchical = pType?.hierarchical) !== null && _pType$hierarchical !== void 0 ? _pType$hierarchical : false;
    const query = {
      per_page: 100,
      exclude: postId,
      parent_exclude: postId,
      orderby: 'menu_order',
      order: 'asc',
      _fields: 'id,title,parent'
    };

    // Perform a search when the field is changed.
    if (!!fieldValue) {
      query.search = fieldValue;
    }
    const parentPost = pageId ? getEntityRecord('postType', postTypeSlug, pageId) : null;
    return {
      isHierarchical: postIsHierarchical,
      parentPostId: pageId,
      parentPostTitle: parentPost ? getTitle(parentPost) : '',
      pageItems: postIsHierarchical ? getEntityRecords('postType', postTypeSlug, query) : null,
      isLoading: postIsHierarchical ? isResolving('getEntityRecords', ['postType', postTypeSlug, query]) : false
    };
  }, [fieldValue]);
  const parentOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const getOptionsFromTree = (tree, level = 0) => {
      const mappedNodes = tree.map(treeNode => [{
        value: treeNode.id,
        label: '— '.repeat(level) + (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(treeNode.name),
        rawName: treeNode.name
      }, ...getOptionsFromTree(treeNode.children || [], level + 1)]);
      const sortedNodes = mappedNodes.sort(([a], [b]) => {
        const priorityA = parent_getItemPriority(a.rawName, fieldValue);
        const priorityB = parent_getItemPriority(b.rawName, fieldValue);
        return priorityA >= priorityB ? 1 : -1;
      });
      return sortedNodes.flat();
    };
    if (!pageItems) {
      return [];
    }
    let tree = pageItems.map(item => ({
      id: item.id,
      parent: item.parent,
      name: getTitle(item)
    }));

    // Only build a hierarchical tree when not searching.
    if (!fieldValue) {
      tree = terms_buildTermsTree(tree);
    }
    const opts = getOptionsFromTree(tree);

    // Ensure the current parent is in the options list.
    const optsHasParent = opts.find(item => item.value === parentPostId);
    if (parentPostTitle && !optsHasParent) {
      opts.unshift({
        value: parentPostId,
        label: parentPostTitle
      });
    }
    return opts;
  }, [pageItems, fieldValue, parentPostTitle, parentPostId]);
  if (!isHierarchical) {
    return null;
  }
  /**
   * Handle user input.
   *
   * @param {string} inputValue The current value of the input field.
   */
  const handleKeydown = inputValue => {
    setFieldValue(inputValue);
  };

  /**
   * Handle author selection.
   *
   * @param {Object} selectedPostId The selected Author.
   */
  const handleChange = selectedPostId => {
    editPost({
      parent: selectedPostId
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ComboboxControl, {
    __nextHasNoMarginBottom: true,
    __next40pxDefaultSize: true,
    className: "editor-page-attributes__parent",
    label: (0,external_wp_i18n_namespaceObject.__)('Parent'),
    help: (0,external_wp_i18n_namespaceObject.__)('Choose a parent page.'),
    value: parentPostId,
    options: parentOptions,
    onFilterValueChange: (0,external_wp_compose_namespaceObject.debounce)(handleKeydown, 300),
    onChange: handleChange,
    hideLabelFromVision: true,
    isLoading: isLoading
  });
}
function PostParentToggle({
  isOpen,
  onClick
}) {
  const parentPost = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute
    } = select(store_store);
    const parentPostId = getEditedPostAttribute('parent');
    if (!parentPostId) {
      return null;
    }
    const {
      getEntityRecord
    } = select(external_wp_coreData_namespaceObject.store);
    const postTypeSlug = getEditedPostAttribute('type');
    return getEntityRecord('postType', postTypeSlug, parentPostId);
  }, []);
  const parentTitle = (0,external_wp_element_namespaceObject.useMemo)(() => !parentPost ? (0,external_wp_i18n_namespaceObject.__)('None') : getTitle(parentPost), [parentPost]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    size: "compact",
    className: "editor-post-parent__panel-toggle",
    variant: "tertiary",
    "aria-expanded": isOpen,
    "aria-label":
    // translators: %s: Current post parent.
    (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Change parent: %s'), parentTitle),
    onClick: onClick,
    children: parentTitle
  });
}
function ParentRow() {
  const homeUrl = (0,external_wp_data_namespaceObject.useSelect)(select => {
    // Site index.
    return select(external_wp_coreData_namespaceObject.store).getEntityRecord('root', '__unstableBase')?.home;
  }, []);
  // Use internal state instead of a ref to make sure that the component
  // re-renders when the popover's anchor updates.
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
    label: (0,external_wp_i18n_namespaceObject.__)('Parent'),
    ref: setPopoverAnchor,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
      popoverProps: popoverProps,
      className: "editor-post-parent__panel-dropdown",
      contentClassName: "editor-post-parent__panel-dialog",
      focusOnMount: true,
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostParentToggle, {
        isOpen: isOpen,
        onClick: onToggle
      }),
      renderContent: ({
        onClose
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        className: "editor-post-parent",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
          title: (0,external_wp_i18n_namespaceObject.__)('Parent'),
          onClose: onClose
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
          children: [(0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: The home URL of the WordPress installation without the scheme. */
          (0,external_wp_i18n_namespaceObject.__)('Child pages inherit characteristics from their parent, such as URL structure. For instance, if "Pricing" is a child of "Services", its URL would be %s<wbr />/services<wbr />/pricing.'), (0,external_wp_url_namespaceObject.filterURLForDisplay)(homeUrl).replace(/([/.])/g, '<wbr />$1')), {
            wbr: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("wbr", {})
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
            children: (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.__)('They also show up as sub-items in the default navigation menu. <a>Learn more.</a>'), {
              a: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
                href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/page-post-settings-sidebar/#page-attributes')
              })
            })
          })]
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(parent_PageAttributesParent, {})]
      })
    })
  });
}
/* harmony default export */ const page_attributes_parent = (parent_PageAttributesParent);

;// ./packages/editor/build-module/components/page-attributes/panel.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const PANEL_NAME = 'page-attributes';
function AttributesPanel() {
  const {
    isEnabled,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute,
      isEditorPanelEnabled
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      isEnabled: isEditorPanelEnabled(PANEL_NAME),
      postType: getPostType(getEditedPostAttribute('type'))
    };
  }, []);
  if (!isEnabled || !postType) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ParentRow, {});
}

/**
 * Renders the Page Attributes Panel component.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PageAttributesPanel() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(page_attributes_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(AttributesPanel, {})
  });
}

;// ./packages/icons/build-module/library/add-template.js
/**
 * WordPress dependencies
 */


const addTemplate = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M18.5 5.5V8H20V5.5H22.5V4H20V1.5H18.5V4H16V5.5H18.5ZM13.9624 4H6C4.89543 4 4 4.89543 4 6V18C4 19.1046 4.89543 20 6 20H18C19.1046 20 20 19.1046 20 18V10.0391H18.5V18C18.5 18.2761 18.2761 18.5 18 18.5H10L10 10.4917L16.4589 10.5139L16.4641 9.01389L5.5 8.97618V6C5.5 5.72386 5.72386 5.5 6 5.5H13.9624V4ZM5.5 10.4762V18C5.5 18.2761 5.72386 18.5 6 18.5H8.5L8.5 10.4865L5.5 10.4762Z"
  })
});
/* harmony default export */ const add_template = (addTemplate);

;// ./packages/editor/build-module/components/post-template/create-new-template-modal.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



const DEFAULT_TITLE = (0,external_wp_i18n_namespaceObject.__)('Custom Template');
function CreateNewTemplateModal({
  onClose
}) {
  const {
    defaultBlockTemplate,
    onNavigateToEntityRecord
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditorSettings,
      getCurrentTemplateId
    } = select(store_store);
    return {
      defaultBlockTemplate: getEditorSettings().defaultBlockTemplate,
      onNavigateToEntityRecord: getEditorSettings().onNavigateToEntityRecord,
      getTemplateId: getCurrentTemplateId
    };
  });
  const {
    createTemplate
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store_store));
  const [title, setTitle] = (0,external_wp_element_namespaceObject.useState)('');
  const [isBusy, setIsBusy] = (0,external_wp_element_namespaceObject.useState)(false);
  const cancel = () => {
    setTitle('');
    onClose();
  };
  const submit = async event => {
    event.preventDefault();
    if (isBusy) {
      return;
    }
    setIsBusy(true);
    const newTemplateContent = defaultBlockTemplate !== null && defaultBlockTemplate !== void 0 ? defaultBlockTemplate : (0,external_wp_blocks_namespaceObject.serialize)([(0,external_wp_blocks_namespaceObject.createBlock)('core/group', {
      tagName: 'header',
      layout: {
        inherit: true
      }
    }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/site-title'), (0,external_wp_blocks_namespaceObject.createBlock)('core/site-tagline')]), (0,external_wp_blocks_namespaceObject.createBlock)('core/separator'), (0,external_wp_blocks_namespaceObject.createBlock)('core/group', {
      tagName: 'main'
    }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/group', {
      layout: {
        inherit: true
      }
    }, [(0,external_wp_blocks_namespaceObject.createBlock)('core/post-title')]), (0,external_wp_blocks_namespaceObject.createBlock)('core/post-content', {
      layout: {
        inherit: true
      }
    })])]);
    const newTemplate = await createTemplate({
      slug: paramCase(title || DEFAULT_TITLE) || 'wp-custom-template',
      content: newTemplateContent,
      title: title || DEFAULT_TITLE
    });
    setIsBusy(false);
    onNavigateToEntityRecord({
      postId: newTemplate.id,
      postType: 'wp_template'
    });
    cancel();
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Modal, {
    title: (0,external_wp_i18n_namespaceObject.__)('Create custom template'),
    onRequestClose: cancel,
    focusOnMount: "firstContentElement",
    size: "small",
    overlayClassName: "editor-post-template__create-template-modal",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
      className: "editor-post-template__create-form",
      onSubmit: submit,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
        spacing: "3",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          label: (0,external_wp_i18n_namespaceObject.__)('Name'),
          value: title,
          onChange: setTitle,
          placeholder: DEFAULT_TITLE,
          disabled: isBusy,
          help: (0,external_wp_i18n_namespaceObject.__)(
          // eslint-disable-next-line no-restricted-syntax -- 'sidebar' is a common web design term for layouts
          'Describe the template, e.g. "Post with sidebar". A custom template can be manually applied to any post or page.')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
          justify: "right",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "tertiary",
            onClick: cancel,
            children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "primary",
            type: "submit",
            isBusy: isBusy,
            "aria-disabled": isBusy,
            children: (0,external_wp_i18n_namespaceObject.__)('Create')
          })]
        })]
      })
    })
  });
}

;// ./packages/editor/build-module/components/post-template/hooks.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

function useEditedPostContext() {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostId,
      getCurrentPostType
    } = select(store_store);
    return {
      postId: getCurrentPostId(),
      postType: getCurrentPostType()
    };
  }, []);
}
function useAllowSwitchingTemplates() {
  const {
    postType,
    postId
  } = useEditedPostContext();
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canUser,
      getEntityRecord,
      getEntityRecords
    } = select(external_wp_coreData_namespaceObject.store);
    const siteSettings = canUser('read', {
      kind: 'root',
      name: 'site'
    }) ? getEntityRecord('root', 'site') : undefined;
    const isPostsPage = +postId === siteSettings?.page_for_posts;
    const isFrontPage = postType === 'page' && +postId === siteSettings?.page_on_front;
    // If current page is set front page or posts page, we also need
    // to check if the current theme has a template for it. If not
    const templates = isFrontPage ? getEntityRecords('postType', 'wp_template', {
      per_page: -1
    }) : [];
    const hasFrontPage = isFrontPage && !!templates?.some(({
      slug
    }) => slug === 'front-page');
    return !isPostsPage && !hasFrontPage;
  }, [postId, postType]);
}
function useTemplates(postType) {
  return (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getEntityRecords('postType', 'wp_template', {
    per_page: -1,
    post_type: postType
  }), [postType]);
}
function useAvailableTemplates(postType) {
  const currentTemplateSlug = useCurrentTemplateSlug();
  const allowSwitchingTemplate = useAllowSwitchingTemplates();
  const templates = useTemplates(postType);
  return (0,external_wp_element_namespaceObject.useMemo)(() => allowSwitchingTemplate && templates?.filter(template => template.is_custom && template.slug !== currentTemplateSlug && !!template.content.raw // Skip empty templates.
  ), [templates, currentTemplateSlug, allowSwitchingTemplate]);
}
function useCurrentTemplateSlug() {
  const {
    postType,
    postId
  } = useEditedPostContext();
  const templates = useTemplates(postType);
  const entityTemplate = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const post = select(external_wp_coreData_namespaceObject.store).getEditedEntityRecord('postType', postType, postId);
    return post?.template;
  }, [postType, postId]);
  if (!entityTemplate) {
    return;
  }
  // If a page has a `template` set and is not included in the list
  // of the theme's templates, do not return it, in order to resolve
  // to the current theme's default template.
  return templates?.find(template => template.slug === entityTemplate)?.slug;
}

;// ./packages/editor/build-module/components/post-template/classic-theme.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */





function PostTemplateToggle({
  isOpen,
  onClick
}) {
  const templateTitle = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const templateSlug = select(store_store).getEditedPostAttribute('template');
    const {
      supportsTemplateMode,
      availableTemplates
    } = select(store_store).getEditorSettings();
    if (!supportsTemplateMode && availableTemplates[templateSlug]) {
      return availableTemplates[templateSlug];
    }
    const template = select(external_wp_coreData_namespaceObject.store).canUser('create', {
      kind: 'postType',
      name: 'wp_template'
    }) && select(store_store).getCurrentTemplateId();
    return template?.title || template?.slug || availableTemplates?.[templateSlug];
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    __next40pxDefaultSize: true,
    variant: "tertiary",
    "aria-expanded": isOpen,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Template options'),
    onClick: onClick,
    children: templateTitle !== null && templateTitle !== void 0 ? templateTitle : (0,external_wp_i18n_namespaceObject.__)('Default template')
  });
}

/**
 * Renders the dropdown content for selecting a post template.
 *
 * @param {Object}   props         The component props.
 * @param {Function} props.onClose The function to close the dropdown.
 *
 * @return {React.ReactNode} The rendered dropdown content.
 */
function PostTemplateDropdownContent({
  onClose
}) {
  var _options$find, _selectedOption$value;
  const allowSwitchingTemplate = useAllowSwitchingTemplates();
  const {
    availableTemplates,
    fetchedTemplates,
    selectedTemplateSlug,
    canCreate,
    canEdit,
    currentTemplateId,
    onNavigateToEntityRecord,
    getEditorSettings
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canUser,
      getEntityRecords
    } = select(external_wp_coreData_namespaceObject.store);
    const editorSettings = select(store_store).getEditorSettings();
    const canCreateTemplates = canUser('create', {
      kind: 'postType',
      name: 'wp_template'
    });
    const _currentTemplateId = select(store_store).getCurrentTemplateId();
    return {
      availableTemplates: editorSettings.availableTemplates,
      fetchedTemplates: canCreateTemplates ? getEntityRecords('postType', 'wp_template', {
        post_type: select(store_store).getCurrentPostType(),
        per_page: -1
      }) : undefined,
      selectedTemplateSlug: select(store_store).getEditedPostAttribute('template'),
      canCreate: allowSwitchingTemplate && canCreateTemplates && editorSettings.supportsTemplateMode,
      canEdit: allowSwitchingTemplate && canCreateTemplates && editorSettings.supportsTemplateMode && !!_currentTemplateId,
      currentTemplateId: _currentTemplateId,
      onNavigateToEntityRecord: editorSettings.onNavigateToEntityRecord,
      getEditorSettings: select(store_store).getEditorSettings
    };
  }, [allowSwitchingTemplate]);
  const options = (0,external_wp_element_namespaceObject.useMemo)(() => Object.entries({
    ...availableTemplates,
    ...Object.fromEntries((fetchedTemplates !== null && fetchedTemplates !== void 0 ? fetchedTemplates : []).map(({
      slug,
      title
    }) => [slug, title.rendered]))
  }).map(([slug, title]) => ({
    value: slug,
    label: title
  })), [availableTemplates, fetchedTemplates]);
  const selectedOption = (_options$find = options.find(option => option.value === selectedTemplateSlug)) !== null && _options$find !== void 0 ? _options$find : options.find(option => !option.value); // The default option has '' value.

  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const [isCreateModalOpen, setIsCreateModalOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-post-template__classic-theme-dropdown",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
      title: (0,external_wp_i18n_namespaceObject.__)('Template'),
      help: (0,external_wp_i18n_namespaceObject.__)('Templates define the way content is displayed when viewing your site.'),
      actions: canCreate ? [{
        icon: add_template,
        label: (0,external_wp_i18n_namespaceObject.__)('Add template'),
        onClick: () => setIsCreateModalOpen(true)
      }] : [],
      onClose: onClose
    }), !allowSwitchingTemplate ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Notice, {
      status: "warning",
      isDismissible: false,
      children: (0,external_wp_i18n_namespaceObject.__)('The posts page template cannot be changed.')
    }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SelectControl, {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      hideLabelFromVision: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Template'),
      value: (_selectedOption$value = selectedOption?.value) !== null && _selectedOption$value !== void 0 ? _selectedOption$value : '',
      options: options,
      onChange: slug => editPost({
        template: slug || ''
      })
    }), canEdit && onNavigateToEntityRecord && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        __next40pxDefaultSize: true,
        variant: "link",
        onClick: () => {
          onNavigateToEntityRecord({
            postId: currentTemplateId,
            postType: 'wp_template'
          });
          onClose();
          createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Editing template. Changes made here affect all posts and pages that use the template.'), {
            type: 'snackbar',
            actions: [{
              label: (0,external_wp_i18n_namespaceObject.__)('Go back'),
              onClick: () => getEditorSettings().onNavigateToPreviousEntityRecord()
            }]
          });
        },
        children: (0,external_wp_i18n_namespaceObject.__)('Edit template')
      })
    }), isCreateModalOpen && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateNewTemplateModal, {
      onClose: () => setIsCreateModalOpen(false)
    })]
  });
}
function ClassicThemeControl() {
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    className: 'editor-post-template__dropdown',
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
    label: (0,external_wp_i18n_namespaceObject.__)('Template'),
    ref: setPopoverAnchor,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
      popoverProps: popoverProps,
      focusOnMount: true,
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostTemplateToggle, {
        isOpen: isOpen,
        onClick: onToggle
      }),
      renderContent: ({
        onClose
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostTemplateDropdownContent, {
        onClose: onClose
      })
    })
  });
}

/**
 * Provides a dropdown menu for selecting and managing post templates.
 *
 * The dropdown menu includes a button for toggling the menu, a list of available templates, and options for creating and editing templates.
 *
 * @return {React.ReactNode} The rendered ClassicThemeControl component.
 */
/* harmony default export */ const classic_theme = (ClassicThemeControl);

;// external ["wp","warning"]
const external_wp_warning_namespaceObject = window["wp"]["warning"];
;// ./packages/editor/build-module/components/preferences-modal/enable-panel.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const {
  PreferenceBaseOption
} = unlock(external_wp_preferences_namespaceObject.privateApis);
function EnablePanelOption(props) {
  const {
    toggleEditorPanelEnabled
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    isChecked,
    isRemoved
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isEditorPanelEnabled,
      isEditorPanelRemoved
    } = select(store_store);
    return {
      isChecked: isEditorPanelEnabled(props.panelName),
      isRemoved: isEditorPanelRemoved(props.panelName)
    };
  }, [props.panelName]);
  if (isRemoved) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PreferenceBaseOption, {
    isChecked: isChecked,
    onChange: () => toggleEditorPanelEnabled(props.panelName),
    ...props
  });
}

;// ./packages/editor/build-module/components/preferences-modal/enable-plugin-document-setting-panel.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const {
  Fill,
  Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('EnablePluginDocumentSettingPanelOption');
const EnablePluginDocumentSettingPanelOption = ({
  label,
  panelName
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Fill, {
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(EnablePanelOption, {
    label: label,
    panelName: panelName
  })
});
EnablePluginDocumentSettingPanelOption.Slot = Slot;
/* harmony default export */ const enable_plugin_document_setting_panel = (EnablePluginDocumentSettingPanelOption);

;// ./packages/editor/build-module/components/plugin-document-setting-panel/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const {
  Fill: plugin_document_setting_panel_Fill,
  Slot: plugin_document_setting_panel_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('PluginDocumentSettingPanel');

/**
 * Renders items below the Status & Availability panel in the Document Sidebar.
 *
 * @param {Object}                props                                 Component properties.
 * @param {string}                props.name                            Required. A machine-friendly name for the panel.
 * @param {string}                [props.className]                     An optional class name added to the row.
 * @param {string}                [props.title]                         The title of the panel
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element, to be rendered when the sidebar is pinned to toolbar.
 * @param {React.ReactNode}       props.children                        Children to be rendered
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var el = React.createElement;
 * var __ = wp.i18n.__;
 * var registerPlugin = wp.plugins.registerPlugin;
 * var PluginDocumentSettingPanel = wp.editor.PluginDocumentSettingPanel;
 *
 * function MyDocumentSettingPlugin() {
 * 	return el(
 * 		PluginDocumentSettingPanel,
 * 		{
 * 			className: 'my-document-setting-plugin',
 * 			title: 'My Panel',
 * 			name: 'my-panel',
 * 		},
 * 		__( 'My Document Setting Panel' )
 * 	);
 * }
 *
 * registerPlugin( 'my-document-setting-plugin', {
 * 		render: MyDocumentSettingPlugin
 * } );
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { registerPlugin } from '@wordpress/plugins';
 * import { PluginDocumentSettingPanel } from '@wordpress/editor';
 *
 * const MyDocumentSettingTest = () => (
 * 		<PluginDocumentSettingPanel className="my-document-setting-plugin" title="My Panel" name="my-panel">
 *			<p>My Document Setting Panel</p>
 *		</PluginDocumentSettingPanel>
 *	);
 *
 *  registerPlugin( 'document-setting-test', { render: MyDocumentSettingTest } );
 * ```
 *
 * @return {React.ReactNode} The component to be rendered.
 */
const PluginDocumentSettingPanel = ({
  name,
  className,
  title,
  icon,
  children
}) => {
  const {
    name: pluginName
  } = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  const panelName = `${pluginName}/${name}`;
  const {
    opened,
    isEnabled
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isEditorPanelOpened,
      isEditorPanelEnabled
    } = select(store_store);
    return {
      opened: isEditorPanelOpened(panelName),
      isEnabled: isEditorPanelEnabled(panelName)
    };
  }, [panelName]);
  const {
    toggleEditorPanelOpened
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  if (undefined === name) {
     false ? 0 : void 0;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(enable_plugin_document_setting_panel, {
      label: title,
      panelName: panelName
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(plugin_document_setting_panel_Fill, {
      children: isEnabled && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
        className: className,
        title: title,
        icon: icon,
        opened: opened,
        onToggle: () => toggleEditorPanelOpened(panelName),
        children: children
      })
    })]
  });
};
PluginDocumentSettingPanel.Slot = plugin_document_setting_panel_Slot;
/* harmony default export */ const plugin_document_setting_panel = (PluginDocumentSettingPanel);

;// ./packages/editor/build-module/components/block-settings-menu/plugin-block-settings-menu-item.js
/**
 * WordPress dependencies
 */




const isEverySelectedBlockAllowed = (selected, allowed) => selected.filter(id => !allowed.includes(id)).length === 0;

/**
 * Plugins may want to add an item to the menu either for every block
 * or only for the specific ones provided in the `allowedBlocks` component property.
 *
 * If there are multiple blocks selected the item will be rendered if every block
 * is of one allowed type (not necessarily the same).
 *
 * @param {string[]} selectedBlocks Array containing the names of the blocks selected
 * @param {string[]} allowedBlocks  Array containing the names of the blocks allowed
 * @return {boolean} Whether the item will be rendered or not.
 */
const shouldRenderItem = (selectedBlocks, allowedBlocks) => !Array.isArray(allowedBlocks) || isEverySelectedBlockAllowed(selectedBlocks, allowedBlocks);

/**
 * Renders a new item in the block settings menu.
 *
 * @param {Object}                props                 Component props.
 * @param {Array}                 [props.allowedBlocks] An array containing a list of block names for which the item should be shown. If not present, it'll be rendered for any block. If multiple blocks are selected, it'll be shown if and only if all of them are in the allowed list.
 * @param {WPBlockTypeIconRender} [props.icon]          The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element.
 * @param {string}                props.label           The menu item text.
 * @param {Function}              props.onClick         Callback function to be executed when the user click the menu item.
 * @param {boolean}               [props.small]         Whether to render the label or not.
 * @param {string}                [props.role]          The ARIA role for the menu item.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var PluginBlockSettingsMenuItem = wp.editor.PluginBlockSettingsMenuItem;
 *
 * function doOnClick(){
 * 	// To be called when the user clicks the menu item.
 * }
 *
 * function MyPluginBlockSettingsMenuItem() {
 * 	return React.createElement(
 * 		PluginBlockSettingsMenuItem,
 * 		{
 * 			allowedBlocks: [ 'core/paragraph' ],
 * 			icon: 'dashicon-name',
 * 			label: __( 'Menu item text' ),
 * 			onClick: doOnClick,
 * 		}
 * 	);
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginBlockSettingsMenuItem } from '@wordpress/editor';
 *
 * const doOnClick = ( ) => {
 *     // To be called when the user clicks the menu item.
 * };
 *
 * const MyPluginBlockSettingsMenuItem = () => (
 *     <PluginBlockSettingsMenuItem
 * 		allowedBlocks={ [ 'core/paragraph' ] }
 * 		icon='dashicon-name'
 * 		label={ __( 'Menu item text' ) }
 * 		onClick={ doOnClick } />
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */
const PluginBlockSettingsMenuItem = ({
  allowedBlocks,
  icon,
  label,
  onClick,
  small,
  role
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockSettingsMenuControls, {
  children: ({
    selectedBlocks,
    onClose
  }) => {
    if (!shouldRenderItem(selectedBlocks, allowedBlocks)) {
      return null;
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
      onClick: (0,external_wp_compose_namespaceObject.compose)(onClick, onClose),
      icon: icon,
      label: small ? label : undefined,
      role: role,
      children: !small && label
    });
  }
});
/* harmony default export */ const plugin_block_settings_menu_item = (PluginBlockSettingsMenuItem);

;// ./packages/editor/build-module/components/plugin-more-menu-item/index.js
/**
 * WordPress dependencies
 */




/**
 * Renders a menu item in `Plugins` group in `More Menu` drop down, and can be used to as a button or link depending on the props provided.
 * The text within the component appears as the menu item label.
 *
 * @param {Object}                props                                 Component properties.
 * @param {React.ReactNode}       [props.children]                      Children to be rendered.
 * @param {string}                [props.href]                          When `href` is provided then the menu item is represented as an anchor rather than button. It corresponds to the `href` attribute of the anchor.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element, to be rendered to the left of the menu item label.
 * @param {Function}              [props.onClick=noop]                  The callback function to be executed when the user clicks the menu item.
 * @param {...*}                  [props.other]                         Any additional props are passed through to the underlying [Button](/packages/components/src/button/README.md) component.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var PluginMoreMenuItem = wp.editor.PluginMoreMenuItem;
 * var moreIcon = wp.element.createElement( 'svg' ); //... svg element.
 *
 * function onButtonClick() {
 * 	alert( 'Button clicked.' );
 * }
 *
 * function MyButtonMoreMenuItem() {
 * 	return wp.element.createElement(
 * 		PluginMoreMenuItem,
 * 		{
 * 			icon: moreIcon,
 * 			onClick: onButtonClick,
 * 		},
 * 		__( 'My button title' )
 * 	);
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginMoreMenuItem } from '@wordpress/editor';
 * import { more } from '@wordpress/icons';
 *
 * function onButtonClick() {
 * 	alert( 'Button clicked.' );
 * }
 *
 * const MyButtonMoreMenuItem = () => (
 * 	<PluginMoreMenuItem
 * 		icon={ more }
 * 		onClick={ onButtonClick }
 * 	>
 * 		{ __( 'My button title' ) }
 * 	</PluginMoreMenuItem>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */

function PluginMoreMenuItem(props) {
  var _props$as;
  const context = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(action_item, {
    name: "core/plugin-more-menu",
    as: (_props$as = props.as) !== null && _props$as !== void 0 ? _props$as : external_wp_components_namespaceObject.MenuItem,
    icon: props.icon || context.icon,
    ...props
  });
}

;// ./packages/editor/build-module/components/plugin-post-publish-panel/index.js
/**
 * WordPress dependencies
 */



const {
  Fill: plugin_post_publish_panel_Fill,
  Slot: plugin_post_publish_panel_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('PluginPostPublishPanel');

/**
 * Renders provided content to the post-publish panel in the publish flow
 * (side panel that opens after a user publishes the post).
 *
 * @param {Object}                props                                 Component properties.
 * @param {string}                [props.className]                     An optional class name added to the panel.
 * @param {string}                [props.title]                         Title displayed at the top of the panel.
 * @param {boolean}               [props.initialOpen=false]             Whether to have the panel initially opened. When no title is provided it is always opened.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element, to be rendered when the sidebar is pinned to toolbar.
 * @param {React.ReactNode}       props.children                        Children to be rendered
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginPostPublishPanel } from '@wordpress/editor';
 *
 * const MyPluginPostPublishPanel = () => (
 * 	<PluginPostPublishPanel
 * 		className="my-plugin-post-publish-panel"
 * 		title={ __( 'My panel title' ) }
 * 		initialOpen={ true }
 * 	>
 *         { __( 'My panel content' ) }
 * 	</PluginPostPublishPanel>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */
const PluginPostPublishPanel = ({
  children,
  className,
  title,
  initialOpen = false,
  icon
}) => {
  const {
    icon: pluginIcon
  } = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(plugin_post_publish_panel_Fill, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
      className: className,
      initialOpen: initialOpen || !title,
      title: title,
      icon: icon !== null && icon !== void 0 ? icon : pluginIcon,
      children: children
    })
  });
};
PluginPostPublishPanel.Slot = plugin_post_publish_panel_Slot;
/* harmony default export */ const plugin_post_publish_panel = (PluginPostPublishPanel);

;// ./packages/editor/build-module/components/plugin-post-status-info/index.js
/**
 * Defines as extensibility slot for the Summary panel.
 */

/**
 * WordPress dependencies
 */


const {
  Fill: plugin_post_status_info_Fill,
  Slot: plugin_post_status_info_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('PluginPostStatusInfo');

/**
 * Renders a row in the Summary panel of the Document sidebar.
 * It should be noted that this is named and implemented around the function it serves
 * and not its location, which may change in future iterations.
 *
 * @param {Object}          props             Component properties.
 * @param {string}          [props.className] An optional class name added to the row.
 * @param {React.ReactNode} props.children    Children to be rendered.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var PluginPostStatusInfo = wp.editor.PluginPostStatusInfo;
 *
 * function MyPluginPostStatusInfo() {
 * 	return React.createElement(
 * 		PluginPostStatusInfo,
 * 		{
 * 			className: 'my-plugin-post-status-info',
 * 		},
 * 		__( 'My post status info' )
 * 	)
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginPostStatusInfo } from '@wordpress/editor';
 *
 * const MyPluginPostStatusInfo = () => (
 * 	<PluginPostStatusInfo
 * 		className="my-plugin-post-status-info"
 * 	>
 * 		{ __( 'My post status info' ) }
 * 	</PluginPostStatusInfo>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */
const PluginPostStatusInfo = ({
  children,
  className
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(plugin_post_status_info_Fill, {
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelRow, {
    className: className,
    children: children
  })
});
PluginPostStatusInfo.Slot = plugin_post_status_info_Slot;
/* harmony default export */ const plugin_post_status_info = (PluginPostStatusInfo);

;// ./packages/editor/build-module/components/plugin-pre-publish-panel/index.js
/**
 * WordPress dependencies
 */



const {
  Fill: plugin_pre_publish_panel_Fill,
  Slot: plugin_pre_publish_panel_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('PluginPrePublishPanel');

/**
 * Renders provided content to the pre-publish side panel in the publish flow
 * (side panel that opens when a user first pushes "Publish" from the main editor).
 *
 * @param {Object}                props                                 Component props.
 * @param {string}                [props.className]                     An optional class name added to the panel.
 * @param {string}                [props.title]                         Title displayed at the top of the panel.
 * @param {boolean}               [props.initialOpen=false]             Whether to have the panel initially opened.
 *                                                                      When no title is provided it is always opened.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/)
 *                                                                      icon slug string, or an SVG WP element, to be rendered when
 *                                                                      the sidebar is pinned to toolbar. If `false` is passed, no icon will be rendered.
 * @param {React.ReactNode}       props.children                        Children to be rendered
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginPrePublishPanel } from '@wordpress/editor';
 *
 * const MyPluginPrePublishPanel = () => (
 * 	<PluginPrePublishPanel
 * 		className="my-plugin-pre-publish-panel"
 * 		title={ __( 'My panel title' ) }
 * 		initialOpen={ true }
 * 	>
 * 	    { __( 'My panel content' ) }
 * 	</PluginPrePublishPanel>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */
const PluginPrePublishPanel = ({
  children,
  className,
  title,
  initialOpen = false,
  icon
}) => {
  const {
    icon: pluginIcon
  } = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(plugin_pre_publish_panel_Fill, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
      className: className,
      initialOpen: initialOpen || !title,
      title: title,
      icon: icon !== null && icon !== void 0 ? icon : pluginIcon,
      children: children
    })
  });
};
PluginPrePublishPanel.Slot = plugin_pre_publish_panel_Slot;
/* harmony default export */ const plugin_pre_publish_panel = (PluginPrePublishPanel);

;// ./packages/editor/build-module/components/plugin-preview-menu-item/index.js
/**
 * WordPress dependencies
 */




/**
 * Renders a menu item in the Preview dropdown, which can be used as a button or link depending on the props provided.
 * The text within the component appears as the menu item label.
 *
 * @param {Object}                props                                 Component properties.
 * @param {React.ReactNode}       [props.children]                      Children to be rendered.
 * @param {string}                [props.href]                          When `href` is provided, the menu item is rendered as an anchor instead of a button. It corresponds to the `href` attribute of the anchor.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The icon to be rendered to the left of the menu item label. Can be a Dashicon slug or an SVG WP element.
 * @param {Function}              [props.onClick]                       The callback function to be executed when the user clicks the menu item.
 * @param {...*}                  [props.other]                         Any additional props are passed through to the underlying MenuItem component.
 *
 * @example
 * ```jsx
 * import { __ } from '@wordpress/i18n';
 * import { PluginPreviewMenuItem } from '@wordpress/editor';
 * import { external } from '@wordpress/icons';
 *
 * function onPreviewClick() {
 *   // Handle preview action
 * }
 *
 * const ExternalPreviewMenuItem = () => (
 *   <PluginPreviewMenuItem
 *     icon={ external }
 *     onClick={ onPreviewClick }
 *   >
 *     { __( 'Preview in new tab' ) }
 *   </PluginPreviewMenuItem>
 * );
 * registerPlugin( 'external-preview-menu-item', {
 *     render: ExternalPreviewMenuItem,
 * } );
 * ```
 *
 * @return {React.ReactNode} The rendered menu item component.
 */

function PluginPreviewMenuItem(props) {
  var _props$as;
  const context = (0,external_wp_plugins_namespaceObject.usePluginContext)();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(action_item, {
    name: "core/plugin-preview-menu",
    as: (_props$as = props.as) !== null && _props$as !== void 0 ? _props$as : external_wp_components_namespaceObject.MenuItem,
    icon: props.icon || context.icon,
    ...props
  });
}

;// ./packages/editor/build-module/components/plugin-sidebar/index.js
/**
 * WordPress dependencies
 */


/**
 * Renders a sidebar when activated. The contents within the `PluginSidebar` will appear as content within the sidebar.
 * It also automatically renders a corresponding `PluginSidebarMenuItem` component when `isPinnable` flag is set to `true`.
 * If you wish to display the sidebar, you can with use the `PluginSidebarMoreMenuItem` component or the `wp.data.dispatch` API:
 *
 * ```js
 * wp.data.dispatch( 'core/edit-post' ).openGeneralSidebar( 'plugin-name/sidebar-name' );
 * ```
 *
 * @see PluginSidebarMoreMenuItem
 *
 * @param {Object}                props                                 Element props.
 * @param {string}                props.name                            A string identifying the sidebar. Must be unique for every sidebar registered within the scope of your plugin.
 * @param {React.ReactNode}       [props.children]                      Children to be rendered.
 * @param {string}                [props.className]                     An optional class name added to the sidebar body.
 * @param {string}                props.title                           Title displayed at the top of the sidebar.
 * @param {boolean}               [props.isPinnable=true]               Whether to allow to pin sidebar to the toolbar. When set to `true` it also automatically renders a corresponding menu item.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element, to be rendered when the sidebar is pinned to toolbar.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var el = React.createElement;
 * var PanelBody = wp.components.PanelBody;
 * var PluginSidebar = wp.editor.PluginSidebar;
 * var moreIcon = React.createElement( 'svg' ); //... svg element.
 *
 * function MyPluginSidebar() {
 * 	return el(
 * 			PluginSidebar,
 * 			{
 * 				name: 'my-sidebar',
 * 				title: 'My sidebar title',
 * 				icon: moreIcon,
 * 			},
 * 			el(
 * 				PanelBody,
 * 				{},
 * 				__( 'My sidebar content' )
 * 			)
 * 	);
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PanelBody } from '@wordpress/components';
 * import { PluginSidebar } from '@wordpress/editor';
 * import { more } from '@wordpress/icons';
 *
 * const MyPluginSidebar = () => (
 * 	<PluginSidebar
 * 		name="my-sidebar"
 * 		title="My sidebar title"
 * 		icon={ more }
 * 	>
 * 		<PanelBody>
 * 			{ __( 'My sidebar content' ) }
 * 		</PanelBody>
 * 	</PluginSidebar>
 * );
 * ```
 */

function PluginSidebar({
  className,
  ...props
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(complementary_area, {
    panelClassName: className,
    className: "editor-sidebar",
    scope: "core",
    ...props
  });
}

;// ./packages/editor/build-module/components/plugin-sidebar-more-menu-item/index.js
/**
 * WordPress dependencies
 */


/**
 * Renders a menu item in `Plugins` group in `More Menu` drop down,
 * and can be used to activate the corresponding `PluginSidebar` component.
 * The text within the component appears as the menu item label.
 *
 * @param {Object}                props                                 Component props.
 * @param {string}                props.target                          A string identifying the target sidebar you wish to be activated by this menu item. Must be the same as the `name` prop you have given to that sidebar.
 * @param {React.ReactNode}       [props.children]                      Children to be rendered.
 * @param {WPBlockTypeIconRender} [props.icon=inherits from the plugin] The [Dashicon](https://developer.wordpress.org/resource/dashicons/) icon slug string, or an SVG WP element, to be rendered to the left of the menu item label.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var PluginSidebarMoreMenuItem = wp.editor.PluginSidebarMoreMenuItem;
 * var moreIcon = React.createElement( 'svg' ); //... svg element.
 *
 * function MySidebarMoreMenuItem() {
 * 	return React.createElement(
 * 		PluginSidebarMoreMenuItem,
 * 		{
 * 			target: 'my-sidebar',
 * 			icon: moreIcon,
 * 		},
 * 		__( 'My sidebar title' )
 * 	)
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { PluginSidebarMoreMenuItem } from '@wordpress/editor';
 * import { more } from '@wordpress/icons';
 *
 * const MySidebarMoreMenuItem = () => (
 * 	<PluginSidebarMoreMenuItem
 * 		target="my-sidebar"
 * 		icon={ more }
 * 	>
 * 		{ __( 'My sidebar title' ) }
 * 	</PluginSidebarMoreMenuItem>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */

function PluginSidebarMoreMenuItem(props) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ComplementaryAreaMoreMenuItem
  // Menu item is marked with unstable prop for backward compatibility.
  // @see https://github.com/WordPress/gutenberg/issues/14457
  , {
    __unstableExplicitMenuItem: true,
    scope: "core",
    ...props
  });
}

;// ./packages/editor/build-module/utils/search-templates.js
/**
 * External dependencies
 */


/**
 * Sanitizes the search input string.
 *
 * @param {string} input The search input to normalize.
 *
 * @return {string} The normalized search input.
 */
function normalizeSearchInput(input = '') {
  // Disregard diacritics.
  input = remove_accents_default()(input);

  // Trim & Lowercase.
  input = input.trim().toLowerCase();
  return input;
}

/**
 * Get the search rank for a given template and a specific search term.
 *
 * @param {Object} template    Template to rank
 * @param {string} searchValue Search term
 *
 * @return {number} A template search rank
 */
function getTemplateSearchRank(template, searchValue) {
  const normalizedSearchValue = normalizeSearchInput(searchValue);
  const normalizedTitle = normalizeSearchInput(template.title);
  let rank = 0;
  if (normalizedSearchValue === normalizedTitle) {
    rank += 30;
  } else if (normalizedTitle.startsWith(normalizedSearchValue)) {
    rank += 20;
  } else {
    const searchTerms = normalizedSearchValue.split(' ');
    const hasMatchedTerms = searchTerms.every(searchTerm => normalizedTitle.includes(searchTerm));

    // Prefer template with every search word in the title.
    if (hasMatchedTerms) {
      rank += 10;
    }
  }
  return rank;
}

/**
 * Filters a template list given a search term.
 *
 * @param {Array}  templates   Item list
 * @param {string} searchValue Search input.
 *
 * @return {Array} Filtered template list.
 */
function searchTemplates(templates = [], searchValue = '') {
  if (!searchValue) {
    return templates;
  }
  const rankedTemplates = templates.map(template => {
    return [template, getTemplateSearchRank(template, searchValue)];
  }).filter(([, rank]) => rank > 0);
  rankedTemplates.sort(([, rank1], [, rank2]) => rank2 - rank1);
  return rankedTemplates.map(([template]) => template);
}

;// ./packages/editor/build-module/components/post-template/swap-template-button.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */



function SwapTemplateButton({
  onClick
}) {
  const [showModal, setShowModal] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    postType,
    postId
  } = useEditedPostContext();
  const availableTemplates = useAvailableTemplates(postType);
  const {
    editEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const onTemplateSelect = async template => {
    editEntityRecord('postType', postType, postId, {
      template: template.name
    }, {
      undoIgnore: true
    });
    setShowModal(false); // Close the template suggestions modal first.
    onClick();
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
      disabled: !availableTemplates?.length,
      accessibleWhenDisabled: true,
      onClick: () => setShowModal(true),
      children: (0,external_wp_i18n_namespaceObject.__)('Change template')
    }), showModal && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Modal, {
      title: (0,external_wp_i18n_namespaceObject.__)('Choose a template'),
      onRequestClose: () => setShowModal(false),
      overlayClassName: "editor-post-template__swap-template-modal",
      isFullScreen: true,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "editor-post-template__swap-template-modal-content",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TemplatesList, {
          postType: postType,
          onSelect: onTemplateSelect
        })
      })
    })]
  });
}
function TemplatesList({
  postType,
  onSelect
}) {
  const [searchValue, setSearchValue] = (0,external_wp_element_namespaceObject.useState)('');
  const availableTemplates = useAvailableTemplates(postType);
  const templatesAsPatterns = (0,external_wp_element_namespaceObject.useMemo)(() => availableTemplates.map(template => ({
    name: template.slug,
    blocks: (0,external_wp_blocks_namespaceObject.parse)(template.content.raw),
    title: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title.rendered),
    id: template.id
  })), [availableTemplates]);
  const filteredBlockTemplates = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return searchTemplates(templatesAsPatterns, searchValue);
  }, [templatesAsPatterns, searchValue]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SearchControl, {
      __nextHasNoMarginBottom: true,
      onChange: setSearchValue,
      value: searchValue,
      label: (0,external_wp_i18n_namespaceObject.__)('Search'),
      placeholder: (0,external_wp_i18n_namespaceObject.__)('Search'),
      className: "editor-post-template__swap-template-search"
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalBlockPatternsList, {
      label: (0,external_wp_i18n_namespaceObject.__)('Templates'),
      blockPatterns: filteredBlockTemplates,
      onClickPattern: onSelect
    })]
  });
}

;// ./packages/editor/build-module/components/post-template/reset-default-template.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function ResetDefaultTemplate({
  onClick
}) {
  const currentTemplateSlug = useCurrentTemplateSlug();
  const allowSwitchingTemplate = useAllowSwitchingTemplates();
  const {
    postType,
    postId
  } = useEditedPostContext();
  const {
    editEntityRecord
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  // The default template in a post is indicated by an empty string.
  if (!currentTemplateSlug || !allowSwitchingTemplate) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
    onClick: () => {
      editEntityRecord('postType', postType, postId, {
        template: ''
      }, {
        undoIgnore: true
      });
      onClick();
    },
    children: (0,external_wp_i18n_namespaceObject.__)('Use default template')
  });
}

;// ./packages/editor/build-module/components/post-template/create-new-template.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function CreateNewTemplate() {
  const {
    canCreateTemplates
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      canUser
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      canCreateTemplates: canUser('create', {
        kind: 'postType',
        name: 'wp_template'
      })
    };
  }, []);
  const [isCreateModalOpen, setIsCreateModalOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const allowSwitchingTemplate = useAllowSwitchingTemplates();

  // The default template in a post is indicated by an empty string.
  if (!canCreateTemplates || !allowSwitchingTemplate) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
      onClick: () => {
        setIsCreateModalOpen(true);
      },
      children: (0,external_wp_i18n_namespaceObject.__)('Create new template')
    }), isCreateModalOpen && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateNewTemplateModal, {
      onClose: () => {
        setIsCreateModalOpen(false);
      }
    })]
  });
}

;// ./packages/editor/build-module/components/post-template/block-theme.js
/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */


/**
 * Internal dependencies
 */






function BlockThemeControl({
  id
}) {
  const {
    isTemplateHidden,
    onNavigateToEntityRecord,
    getEditorSettings,
    hasGoBack
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getRenderingMode,
      getEditorSettings: _getEditorSettings
    } = unlock(select(store_store));
    const editorSettings = _getEditorSettings();
    return {
      isTemplateHidden: getRenderingMode() === 'post-only',
      onNavigateToEntityRecord: editorSettings.onNavigateToEntityRecord,
      getEditorSettings: _getEditorSettings,
      hasGoBack: editorSettings.hasOwnProperty('onNavigateToPreviousEntityRecord')
    };
  }, []);
  const {
    get: getPreference
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_preferences_namespaceObject.store);
  const {
    editedRecord: template,
    hasResolved
  } = (0,external_wp_coreData_namespaceObject.useEntityRecord)('postType', 'wp_template', id);
  const {
    createSuccessNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const {
    setRenderingMode,
    setDefaultRenderingMode
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store_store));
  const canCreateTemplate = (0,external_wp_data_namespaceObject.useSelect)(select => !!select(external_wp_coreData_namespaceObject.store).canUser('create', {
    kind: 'postType',
    name: 'wp_template'
  }), []);
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    className: 'editor-post-template__dropdown',
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  if (!hasResolved) {
    return null;
  }

  // The site editor does not have a `onNavigateToPreviousEntityRecord` setting as it uses its own routing
  // and assigns its own backlink to focusMode pages.
  const notificationAction = hasGoBack ? [{
    label: (0,external_wp_i18n_namespaceObject.__)('Go back'),
    onClick: () => getEditorSettings().onNavigateToPreviousEntityRecord()
  }] : undefined;
  const mayShowTemplateEditNotice = () => {
    if (!getPreference('core/edit-site', 'welcomeGuideTemplate')) {
      createSuccessNotice((0,external_wp_i18n_namespaceObject.__)('Editing template. Changes made here affect all posts and pages that use the template.'), {
        type: 'snackbar',
        actions: notificationAction
      });
    }
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
    label: (0,external_wp_i18n_namespaceObject.__)('Template'),
    ref: setPopoverAnchor,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.DropdownMenu, {
      popoverProps: popoverProps,
      focusOnMount: true,
      toggleProps: {
        size: 'compact',
        variant: 'tertiary',
        tooltipPosition: 'middle left'
      },
      label: (0,external_wp_i18n_namespaceObject.__)('Template options'),
      text: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(template.title),
      icon: null,
      children: ({
        onClose
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.MenuGroup, {
          children: [canCreateTemplate && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
            onClick: () => {
              onNavigateToEntityRecord({
                postId: template.id,
                postType: 'wp_template'
              });
              onClose();
              mayShowTemplateEditNotice();
            },
            children: (0,external_wp_i18n_namespaceObject.__)('Edit template')
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SwapTemplateButton, {
            onClick: onClose
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ResetDefaultTemplate, {
            onClick: onClose
          }), canCreateTemplate && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CreateNewTemplate, {})]
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, {
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
            icon: !isTemplateHidden ? library_check : undefined,
            isSelected: !isTemplateHidden,
            role: "menuitemcheckbox",
            onClick: () => {
              const newRenderingMode = isTemplateHidden ? 'template-locked' : 'post-only';
              setRenderingMode(newRenderingMode);
              setDefaultRenderingMode(newRenderingMode);
            },
            children: (0,external_wp_i18n_namespaceObject.__)('Show template')
          })
        })]
      })
    })
  });
}

;// ./packages/editor/build-module/components/post-template/panel.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




/**
 * Displays the template controls based on the current editor settings and user permissions.
 *
 * @return {React.ReactNode} The rendered PostTemplatePanel component.
 */

function PostTemplatePanel() {
  const {
    templateId,
    isBlockTheme
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentTemplateId,
      getEditorSettings
    } = select(store_store);
    return {
      templateId: getCurrentTemplateId(),
      isBlockTheme: getEditorSettings().__unstableIsBlockBasedTheme
    };
  }, []);
  const isVisible = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$canUser;
    const postTypeSlug = select(store_store).getCurrentPostType();
    const postType = select(external_wp_coreData_namespaceObject.store).getPostType(postTypeSlug);
    if (!postType?.viewable) {
      return false;
    }
    const settings = select(store_store).getEditorSettings();
    const hasTemplates = !!settings.availableTemplates && Object.keys(settings.availableTemplates).length > 0;
    if (hasTemplates) {
      return true;
    }
    if (!settings.supportsTemplateMode) {
      return false;
    }
    const canCreateTemplates = (_select$canUser = select(external_wp_coreData_namespaceObject.store).canUser('create', {
      kind: 'postType',
      name: 'wp_template'
    })) !== null && _select$canUser !== void 0 ? _select$canUser : false;
    return canCreateTemplates;
  }, []);
  const canViewTemplates = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$canUser2;
    return (_select$canUser2 = select(external_wp_coreData_namespaceObject.store).canUser('read', {
      kind: 'postType',
      name: 'wp_template'
    })) !== null && _select$canUser2 !== void 0 ? _select$canUser2 : false;
  }, []);
  if ((!isBlockTheme || !canViewTemplates) && isVisible) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(classic_theme, {});
  }
  if (isBlockTheme && !!templateId) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockThemeControl, {
      id: templateId
    });
  }
  return null;
}

;// ./packages/editor/build-module/components/post-author/constants.js
const BASE_QUERY = {
  _fields: 'id,name',
  context: 'view' // Allows non-admins to perform requests.
};
const AUTHORS_QUERY = {
  who: 'authors',
  per_page: 100,
  ...BASE_QUERY
};

;// ./packages/editor/build-module/components/post-author/hook.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


function useAuthorsQuery(search) {
  const {
    authorId,
    authors,
    postAuthor,
    isLoading
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getUser,
      getUsers,
      isResolving
    } = select(external_wp_coreData_namespaceObject.store);
    const {
      getEditedPostAttribute
    } = select(store_store);
    const _authorId = getEditedPostAttribute('author');
    const query = {
      ...AUTHORS_QUERY
    };
    if (search) {
      query.search = search;
      query.search_columns = ['name'];
    }
    return {
      authorId: _authorId,
      authors: getUsers(query),
      postAuthor: getUser(_authorId, BASE_QUERY),
      isLoading: isResolving('getUsers', [query])
    };
  }, [search]);
  const authorOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const fetchedAuthors = (authors !== null && authors !== void 0 ? authors : []).map(author => {
      return {
        value: author.id,
        label: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(author.name)
      };
    });

    // Ensure the current author is included in the dropdown list.
    const foundAuthor = fetchedAuthors.findIndex(({
      value
    }) => postAuthor?.id === value);
    let currentAuthor = [];
    if (foundAuthor < 0 && postAuthor) {
      currentAuthor = [{
        value: postAuthor.id,
        label: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(postAuthor.name)
      }];
    } else if (foundAuthor < 0 && !postAuthor) {
      currentAuthor = [{
        value: 0,
        label: (0,external_wp_i18n_namespaceObject.__)('(No author)')
      }];
    }
    return [...currentAuthor, ...fetchedAuthors];
  }, [authors, postAuthor]);
  return {
    authorId,
    authorOptions,
    postAuthor,
    isLoading
  };
}

;// ./packages/editor/build-module/components/post-author/combobox.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function PostAuthorCombobox() {
  const [fieldValue, setFieldValue] = (0,external_wp_element_namespaceObject.useState)();
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    authorId,
    authorOptions,
    isLoading
  } = useAuthorsQuery(fieldValue);

  /**
   * Handle author selection.
   *
   * @param {number} postAuthorId The selected Author.
   */
  const handleSelect = postAuthorId => {
    if (!postAuthorId) {
      return;
    }
    editPost({
      author: postAuthorId
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ComboboxControl, {
    __nextHasNoMarginBottom: true,
    __next40pxDefaultSize: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Author'),
    options: authorOptions,
    value: authorId,
    onFilterValueChange: (0,external_wp_compose_namespaceObject.debounce)(setFieldValue, 300),
    onChange: handleSelect,
    allowReset: false,
    hideLabelFromVision: true,
    isLoading: isLoading
  });
}

;// ./packages/editor/build-module/components/post-author/select.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function PostAuthorSelect() {
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    authorId,
    authorOptions
  } = useAuthorsQuery();
  const setAuthorId = value => {
    const author = Number(value);
    editPost({
      author
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SelectControl, {
    __next40pxDefaultSize: true,
    __nextHasNoMarginBottom: true,
    className: "post-author-selector",
    label: (0,external_wp_i18n_namespaceObject.__)('Author'),
    options: authorOptions,
    onChange: setAuthorId,
    value: authorId,
    hideLabelFromVision: true
  });
}

;// ./packages/editor/build-module/components/post-author/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const minimumUsersForCombobox = 25;

/**
 * Renders the component for selecting the post author.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PostAuthor() {
  const showCombobox = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const authors = select(external_wp_coreData_namespaceObject.store).getUsers(AUTHORS_QUERY);
    return authors?.length >= minimumUsersForCombobox;
  }, []);
  if (showCombobox) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostAuthorCombobox, {});
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostAuthorSelect, {});
}
/* harmony default export */ const post_author = (PostAuthor);

;// ./packages/editor/build-module/components/post-author/check.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Wrapper component that renders its children only if the post type supports the author.
 *
 * @param {Object}          props          The component props.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} The component to be rendered. Return `null` if the post type doesn't
 * supports the author or if there are no authors available.
 */

function PostAuthorCheck({
  children
}) {
  const {
    hasAssignAuthorAction
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const post = select(store_store).getCurrentPost();
    const canAssignAuthor = post?._links?.['wp:action-assign-author'] ? true : false;
    return {
      hasAssignAuthorAction: canAssignAuthor
    };
  }, []);
  if (!hasAssignAuthorAction) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: "author",
    children: children
  });
}

;// ./packages/editor/build-module/components/post-author/panel.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */






function PostAuthorToggle({
  isOpen,
  onClick
}) {
  const {
    postAuthor
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const id = select(store_store).getEditedPostAttribute('author');
    return {
      postAuthor: select(external_wp_coreData_namespaceObject.store).getUser(id, BASE_QUERY)
    };
  }, []);
  const authorName = (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(postAuthor?.name) || (0,external_wp_i18n_namespaceObject.__)('(No author)');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    size: "compact",
    className: "editor-post-author__panel-toggle",
    variant: "tertiary",
    "aria-expanded": isOpen,
    "aria-label":
    // translators: %s: Author name.
    (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Change author: %s'), authorName),
    onClick: onClick,
    children: authorName
  });
}

/**
 * Renders the Post Author Panel component.
 *
 * @return {React.ReactNode} The rendered component.
 */
function panel_PostAuthor() {
  // Use internal state instead of a ref to make sure that the component
  // re-renders when the popover's anchor updates.
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostAuthorCheck, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
      label: (0,external_wp_i18n_namespaceObject.__)('Author'),
      ref: setPopoverAnchor,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
        popoverProps: popoverProps,
        contentClassName: "editor-post-author__panel-dialog",
        focusOnMount: true,
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostAuthorToggle, {
          isOpen: isOpen,
          onClick: onToggle
        }),
        renderContent: ({
          onClose
        }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
          className: "editor-post-author",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
            title: (0,external_wp_i18n_namespaceObject.__)('Author'),
            onClose: onClose
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_author, {
            onClose: onClose
          })]
        })
      })
    })
  });
}
/* harmony default export */ const panel = (panel_PostAuthor);

;// ./packages/editor/build-module/components/post-comments/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const COMMENT_OPTIONS = [{
  label: (0,external_wp_i18n_namespaceObject._x)('Open', 'Adjective: e.g. "Comments are open"'),
  value: 'open',
  description: (0,external_wp_i18n_namespaceObject.__)('Visitors can add new comments and replies.')
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Closed'),
  value: 'closed',
  description: [(0,external_wp_i18n_namespaceObject.__)('Visitors cannot add new comments or replies.'), (0,external_wp_i18n_namespaceObject.__)('Existing comments remain visible.')].join(' ')
}];
function PostComments() {
  const commentStatus = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getEditedPost;
    return (_select$getEditedPost = select(store_store).getEditedPostAttribute('comment_status')) !== null && _select$getEditedPost !== void 0 ? _select$getEditedPost : 'open';
  }, []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const handleStatus = newCommentStatus => editPost({
    comment_status: newCommentStatus
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("form", {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RadioControl, {
        className: "editor-change-status__options",
        hideLabelFromVision: true,
        label: (0,external_wp_i18n_namespaceObject.__)('Comment status'),
        options: COMMENT_OPTIONS,
        onChange: handleStatus,
        selected: commentStatus
      })
    })
  });
}

/**
 * A form for managing comment status.
 *
 * @return {React.ReactNode} The rendered PostComments component.
 */
/* harmony default export */ const post_comments = (PostComments);

;// ./packages/editor/build-module/components/post-pingbacks/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function PostPingbacks() {
  const pingStatus = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _select$getEditedPost;
    return (_select$getEditedPost = select(store_store).getEditedPostAttribute('ping_status')) !== null && _select$getEditedPost !== void 0 ? _select$getEditedPost : 'open';
  }, []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const onTogglePingback = () => editPost({
    ping_status: pingStatus === 'open' ? 'closed' : 'open'
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Enable pingbacks & trackbacks'),
    checked: pingStatus === 'open',
    onChange: onTogglePingback,
    help: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
      href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/trackbacks-and-pingbacks/'),
      children: (0,external_wp_i18n_namespaceObject.__)('Learn more about pingbacks & trackbacks')
    })
  });
}

/**
 * Renders a control for enabling or disabling pingbacks and trackbacks
 * in a WordPress post.
 *
 * @module PostPingbacks
 */
/* harmony default export */ const post_pingbacks = (PostPingbacks);

;// ./packages/editor/build-module/components/post-discussion/panel.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */






const panel_PANEL_NAME = 'discussion-panel';
function ModalContents({
  onClose
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-post-discussion",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
      title: (0,external_wp_i18n_namespaceObject.__)('Discussion'),
      onClose: onClose
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
        supportKeys: "comments",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_comments, {})
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
        supportKeys: "trackbacks",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_pingbacks, {})
      })]
    })]
  });
}
function PostDiscussionToggle({
  isOpen,
  onClick
}) {
  const {
    commentStatus,
    pingStatus,
    commentsSupported,
    trackbacksSupported
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getEditedPostAttribu, _getEditedPostAttribu2;
    const {
      getEditedPostAttribute
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    const postType = getPostType(getEditedPostAttribute('type'));
    return {
      commentStatus: (_getEditedPostAttribu = getEditedPostAttribute('comment_status')) !== null && _getEditedPostAttribu !== void 0 ? _getEditedPostAttribu : 'open',
      pingStatus: (_getEditedPostAttribu2 = getEditedPostAttribute('ping_status')) !== null && _getEditedPostAttribu2 !== void 0 ? _getEditedPostAttribu2 : 'open',
      commentsSupported: !!postType.supports.comments,
      trackbacksSupported: !!postType.supports.trackbacks
    };
  }, []);
  let label;
  if (commentStatus === 'open') {
    if (pingStatus === 'open') {
      label = (0,external_wp_i18n_namespaceObject._x)('Open', 'Adjective: e.g. "Comments are open"');
    } else {
      label = trackbacksSupported ? (0,external_wp_i18n_namespaceObject.__)('Comments only') : (0,external_wp_i18n_namespaceObject._x)('Open', 'Adjective: e.g. "Comments are open"');
    }
  } else if (pingStatus === 'open') {
    label = commentsSupported ? (0,external_wp_i18n_namespaceObject.__)('Pings only') : (0,external_wp_i18n_namespaceObject.__)('Pings enabled');
  } else {
    label = (0,external_wp_i18n_namespaceObject.__)('Closed');
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    size: "compact",
    className: "editor-post-discussion__panel-toggle",
    variant: "tertiary",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Change discussion options'),
    "aria-expanded": isOpen,
    onClick: onClick,
    children: label
  });
}

/**
 * This component allows to update comment and pingback
 * settings for the current post. Internally there are
 * checks whether the current post has support for the
 * above and if the `discussion-panel` panel is enabled.
 *
 * @return {React.ReactNode} The rendered PostDiscussionPanel component.
 */
function PostDiscussionPanel() {
  const {
    isEnabled
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isEditorPanelEnabled
    } = select(store_store);
    return {
      isEnabled: isEditorPanelEnabled(panel_PANEL_NAME)
    };
  }, []);

  // Use internal state instead of a ref to make sure that the component
  // re-renders when the popover's anchor updates.
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor]);
  if (!isEnabled) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: ['comments', 'trackbacks'],
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
      label: (0,external_wp_i18n_namespaceObject.__)('Discussion'),
      ref: setPopoverAnchor,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
        popoverProps: popoverProps,
        className: "editor-post-discussion__panel-dropdown",
        contentClassName: "editor-post-discussion__panel-dialog",
        focusOnMount: true,
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostDiscussionToggle, {
          isOpen: isOpen,
          onClick: onToggle
        }),
        renderContent: ({
          onClose
        }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ModalContents, {
          onClose: onClose
        })
      })
    })
  });
}

;// ./packages/editor/build-module/components/post-excerpt/index.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * Renders an editable textarea for the post excerpt.
 * Templates, template parts and patterns use the `excerpt` field as a description semantically.
 * Additionally templates and template parts override the `excerpt` field as `description` in
 * REST API. So this component handles proper labeling and updating the edited entity.
 *
 * @param {Object}  props                             - Component props.
 * @param {boolean} [props.hideLabelFromVision=false] - Whether to visually hide the textarea's label.
 * @param {boolean} [props.updateOnBlur=false]        - Whether to update the post on change or use local state and update on blur.
 */

function PostExcerpt({
  hideLabelFromVision = false,
  updateOnBlur = false
}) {
  const {
    excerpt,
    shouldUseDescriptionLabel,
    usedAttribute
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getEditedPostAttribute
    } = select(store_store);
    const postType = getCurrentPostType();
    // This special case is unfortunate, but the REST API of wp_template and wp_template_part
    // support the excerpt field through the "description" field rather than "excerpt".
    const _usedAttribute = ['wp_template', 'wp_template_part'].includes(postType) ? 'description' : 'excerpt';
    return {
      excerpt: getEditedPostAttribute(_usedAttribute),
      // There are special cases where we want to label the excerpt as a description.
      shouldUseDescriptionLabel: ['wp_template', 'wp_template_part', 'wp_block'].includes(postType),
      usedAttribute: _usedAttribute
    };
  }, []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const [localExcerpt, setLocalExcerpt] = (0,external_wp_element_namespaceObject.useState)((0,external_wp_htmlEntities_namespaceObject.decodeEntities)(excerpt));
  const updatePost = value => {
    editPost({
      [usedAttribute]: value
    });
  };
  const label = shouldUseDescriptionLabel ? (0,external_wp_i18n_namespaceObject.__)('Write a description (optional)') : (0,external_wp_i18n_namespaceObject.__)('Write an excerpt (optional)');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "editor-post-excerpt",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextareaControl, {
      __nextHasNoMarginBottom: true,
      label: label,
      hideLabelFromVision: hideLabelFromVision,
      className: "editor-post-excerpt__textarea",
      onChange: updateOnBlur ? setLocalExcerpt : updatePost,
      onBlur: updateOnBlur ? () => updatePost(localExcerpt) : undefined,
      value: updateOnBlur ? localExcerpt : excerpt,
      help: !shouldUseDescriptionLabel ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
        href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/page-post-settings-sidebar/#excerpt'),
        children: (0,external_wp_i18n_namespaceObject.__)('Learn more about manual excerpts')
      }) : (0,external_wp_i18n_namespaceObject.__)('Write a description')
    })
  });
}

;// ./packages/editor/build-module/components/post-excerpt/check.js
/**
 * Internal dependencies
 */


/**
 * Component for checking if the post type supports the excerpt field.
 *
 * @param {Object}          props          Props.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} The rendered component.
 */

function PostExcerptCheck({
  children
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: "excerpt",
    children: children
  });
}
/* harmony default export */ const post_excerpt_check = (PostExcerptCheck);

;// ./packages/editor/build-module/components/post-excerpt/plugin.js
/**
 * Defines as extensibility slot for the Excerpt panel.
 */

/**
 * WordPress dependencies
 */


const {
  Fill: plugin_Fill,
  Slot: plugin_Slot
} = (0,external_wp_components_namespaceObject.createSlotFill)('PluginPostExcerpt');

/**
 * Renders a post excerpt panel in the post sidebar.
 *
 * @param {Object}          props             Component properties.
 * @param {string}          [props.className] An optional class name added to the row.
 * @param {React.ReactNode} props.children    Children to be rendered.
 *
 * @example
 * ```js
 * // Using ES5 syntax
 * var __ = wp.i18n.__;
 * var PluginPostExcerpt = wp.editPost.__experimentalPluginPostExcerpt;
 *
 * function MyPluginPostExcerpt() {
 * 	return React.createElement(
 * 		PluginPostExcerpt,
 * 		{
 * 			className: 'my-plugin-post-excerpt',
 * 		},
 * 		__( 'Post excerpt custom content' )
 * 	)
 * }
 * ```
 *
 * @example
 * ```jsx
 * // Using ESNext syntax
 * import { __ } from '@wordpress/i18n';
 * import { __experimentalPluginPostExcerpt as PluginPostExcerpt } from '@wordpress/edit-post';
 *
 * const MyPluginPostExcerpt = () => (
 * 	<PluginPostExcerpt className="my-plugin-post-excerpt">
 * 		{ __( 'Post excerpt custom content' ) }
 * 	</PluginPostExcerpt>
 * );
 * ```
 *
 * @return {React.ReactNode} The rendered component.
 */
const PluginPostExcerpt = ({
  children,
  className
}) => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(plugin_Fill, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelRow, {
      className: className,
      children: children
    })
  });
};
PluginPostExcerpt.Slot = plugin_Slot;
/* harmony default export */ const post_excerpt_plugin = (PluginPostExcerpt);

;// ./packages/editor/build-module/components/post-excerpt/panel.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */






/**
 * Module Constants
 */

const post_excerpt_panel_PANEL_NAME = 'post-excerpt';
function ExcerptPanel() {
  const {
    isOpened,
    isEnabled,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isEditorPanelOpened,
      isEditorPanelEnabled,
      getCurrentPostType
    } = select(store_store);
    return {
      isOpened: isEditorPanelOpened(post_excerpt_panel_PANEL_NAME),
      isEnabled: isEditorPanelEnabled(post_excerpt_panel_PANEL_NAME),
      postType: getCurrentPostType()
    };
  }, []);
  const {
    toggleEditorPanelOpened
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const toggleExcerptPanel = () => toggleEditorPanelOpened(post_excerpt_panel_PANEL_NAME);
  if (!isEnabled) {
    return null;
  }

  // There are special cases where we want to label the excerpt as a description.
  const shouldUseDescriptionLabel = ['wp_template', 'wp_template_part', 'wp_block'].includes(postType);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
    title: shouldUseDescriptionLabel ? (0,external_wp_i18n_namespaceObject.__)('Description') : (0,external_wp_i18n_namespaceObject.__)('Excerpt'),
    opened: isOpened,
    onToggle: toggleExcerptPanel,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_excerpt_plugin.Slot, {
      children: fills => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostExcerpt, {}), fills]
      })
    })
  });
}

/**
 * Is rendered if the post type supports excerpts and allows editing the excerpt.
 *
 * @return {React.ReactNode} The rendered PostExcerptPanel component.
 */
function PostExcerptPanel() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_excerpt_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ExcerptPanel, {})
  });
}
function PrivatePostExcerptPanel() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_excerpt_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivateExcerpt, {})
  });
}
function PrivateExcerpt() {
  const {
    shouldRender,
    excerpt,
    shouldBeUsedAsDescription,
    allowEditing
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostType,
      getCurrentPostId,
      getEditedPostAttribute,
      isEditorPanelEnabled
    } = select(store_store);
    const postType = getCurrentPostType();
    const isTemplateOrTemplatePart = ['wp_template', 'wp_template_part'].includes(postType);
    const isPattern = postType === 'wp_block';
    // These post types use the `excerpt` field as a description semantically, so we need to
    // handle proper labeling and some flows where we should always render them as text.
    const _shouldBeUsedAsDescription = isTemplateOrTemplatePart || isPattern;
    const _usedAttribute = isTemplateOrTemplatePart ? 'description' : 'excerpt';
    // We need to fetch the entity in this case to check if we'll allow editing.
    const template = isTemplateOrTemplatePart && select(external_wp_coreData_namespaceObject.store).getEntityRecord('postType', postType, getCurrentPostId());
    // For post types that use excerpt as description, we do not abide
    // by the `isEnabled` panel flag in order to render them as text.
    const _shouldRender = isEditorPanelEnabled(post_excerpt_panel_PANEL_NAME) || _shouldBeUsedAsDescription;
    return {
      excerpt: getEditedPostAttribute(_usedAttribute),
      shouldRender: _shouldRender,
      shouldBeUsedAsDescription: _shouldBeUsedAsDescription,
      // If we should render, allow editing for all post types that are not used as description.
      // For the rest allow editing only for user generated entities.
      allowEditing: _shouldRender && (!_shouldBeUsedAsDescription || isPattern || template && template.source === TEMPLATE_ORIGINS.custom && !template.has_theme_file && template.is_custom)
    };
  }, []);
  const [popoverAnchor, setPopoverAnchor] = (0,external_wp_element_namespaceObject.useState)(null);
  const label = shouldBeUsedAsDescription ? (0,external_wp_i18n_namespaceObject.__)('Description') : (0,external_wp_i18n_namespaceObject.__)('Excerpt');
  // Memoize popoverProps to avoid returning a new object every time.
  const popoverProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    // Anchor the popover to the middle of the entire row so that it doesn't
    // move around when the label changes.
    anchor: popoverAnchor,
    'aria-label': label,
    headerTitle: label,
    placement: 'left-start',
    offset: 36,
    shift: true
  }), [popoverAnchor, label]);
  if (!shouldRender) {
    return false;
  }
  const excerptText = !!excerpt && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, {
    align: "left",
    numberOfLines: 4,
    truncate: allowEditing,
    children: (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(excerpt)
  });
  if (!allowEditing) {
    return excerptText;
  }
  const excerptPlaceholder = shouldBeUsedAsDescription ? (0,external_wp_i18n_namespaceObject.__)('Add a description…') : (0,external_wp_i18n_namespaceObject.__)('Add an excerpt…');
  const triggerEditLabel = shouldBeUsedAsDescription ? (0,external_wp_i18n_namespaceObject.__)('Edit description') : (0,external_wp_i18n_namespaceObject.__)('Edit excerpt');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
    children: [excerptText, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
      className: "editor-post-excerpt__dropdown",
      contentClassName: "editor-post-excerpt__dropdown__content",
      popoverProps: popoverProps,
      focusOnMount: true,
      ref: setPopoverAnchor,
      renderToggle: ({
        onToggle
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        __next40pxDefaultSize: true,
        onClick: onToggle,
        variant: "link",
        children: excerptText ? triggerEditLabel : excerptPlaceholder
      }),
      renderContent: ({
        onClose
      }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
          title: label,
          onClose: onClose
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
          spacing: 4,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_excerpt_plugin.Slot, {
            children: fills => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
              children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostExcerpt, {
                hideLabelFromVision: true,
                updateOnBlur: true
              }), fills]
            })
          })
        })]
      })
    })]
  });
}

;// ./packages/editor/build-module/components/theme-support-check/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Checks if the current theme supports specific features and renders the children if supported.
 *
 * @param {Object}          props             The component props.
 * @param {React.ReactNode} props.children    The children to render if the theme supports the specified features.
 * @param {string|string[]} props.supportKeys The key(s) of the theme support(s) to check.
 *
 * @return {React.ReactNode} The rendered children if the theme supports the specified features, otherwise null.
 */
function ThemeSupportCheck({
  children,
  supportKeys
}) {
  const {
    postType,
    themeSupports
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return {
      postType: select(store_store).getEditedPostAttribute('type'),
      themeSupports: select(external_wp_coreData_namespaceObject.store).getThemeSupports()
    };
  }, []);
  const isSupported = (Array.isArray(supportKeys) ? supportKeys : [supportKeys]).some(key => {
    var _themeSupports$key;
    const supported = (_themeSupports$key = themeSupports?.[key]) !== null && _themeSupports$key !== void 0 ? _themeSupports$key : false;
    // 'post-thumbnails' can be boolean or an array of post types.
    // In the latter case, we need to verify `postType` exists
    // within `supported`. If `postType` isn't passed, then the check
    // should fail.
    if ('post-thumbnails' === key && Array.isArray(supported)) {
      return supported.includes(postType);
    }
    return supported;
  });
  if (!isSupported) {
    return null;
  }
  return children;
}

;// ./packages/editor/build-module/components/post-featured-image/check.js
/**
 * Internal dependencies
 */



/**
 * Wrapper component that renders its children only if the post type supports a featured image
 * and the theme supports post thumbnails.
 *
 * @param {Object}          props          Props.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} The rendered component.
 */

function PostFeaturedImageCheck({
  children
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ThemeSupportCheck, {
    supportKeys: "post-thumbnails",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
      supportKeys: "thumbnail",
      children: children
    })
  });
}
/* harmony default export */ const post_featured_image_check = (PostFeaturedImageCheck);

;// ./packages/editor/build-module/components/post-featured-image/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */



const ALLOWED_MEDIA_TYPES = ['image'];

// Used when labels from post type were not yet loaded or when they are not present.
const DEFAULT_FEATURE_IMAGE_LABEL = (0,external_wp_i18n_namespaceObject.__)('Featured image');
const DEFAULT_SET_FEATURE_IMAGE_LABEL = (0,external_wp_i18n_namespaceObject.__)('Add a featured image');
const instructions = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
  children: (0,external_wp_i18n_namespaceObject.__)('To edit the featured image, you need permission to upload media.')
});
function getMediaDetails(media, postId) {
  var _media$media_details$, _media$media_details$2;
  if (!media) {
    return {};
  }
  const defaultSize = (0,external_wp_hooks_namespaceObject.applyFilters)('editor.PostFeaturedImage.imageSize', 'large', media.id, postId);
  if (defaultSize in ((_media$media_details$ = media?.media_details?.sizes) !== null && _media$media_details$ !== void 0 ? _media$media_details$ : {})) {
    return {
      mediaWidth: media.media_details.sizes[defaultSize].width,
      mediaHeight: media.media_details.sizes[defaultSize].height,
      mediaSourceUrl: media.media_details.sizes[defaultSize].source_url
    };
  }

  // Use fallbackSize when defaultSize is not available.
  const fallbackSize = (0,external_wp_hooks_namespaceObject.applyFilters)('editor.PostFeaturedImage.imageSize', 'thumbnail', media.id, postId);
  if (fallbackSize in ((_media$media_details$2 = media?.media_details?.sizes) !== null && _media$media_details$2 !== void 0 ? _media$media_details$2 : {})) {
    return {
      mediaWidth: media.media_details.sizes[fallbackSize].width,
      mediaHeight: media.media_details.sizes[fallbackSize].height,
      mediaSourceUrl: media.media_details.sizes[fallbackSize].source_url
    };
  }

  // Use full image size when fallbackSize and defaultSize are not available.
  return {
    mediaWidth: media.media_details.width,
    mediaHeight: media.media_details.height,
    mediaSourceUrl: media.source_url
  };
}
function PostFeaturedImage({
  currentPostId,
  featuredImageId,
  onUpdateImage,
  onRemoveImage,
  media,
  postType,
  noticeUI,
  noticeOperations,
  isRequestingFeaturedImageMedia
}) {
  const returnsFocusRef = (0,external_wp_element_namespaceObject.useRef)(false);
  const [isLoading, setIsLoading] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    getSettings
  } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const {
    mediaSourceUrl
  } = getMediaDetails(media, currentPostId);
  function onDropFiles(filesList) {
    getSettings().mediaUpload({
      allowedTypes: ALLOWED_MEDIA_TYPES,
      filesList,
      onFileChange([image]) {
        if ((0,external_wp_blob_namespaceObject.isBlobURL)(image?.url)) {
          setIsLoading(true);
          return;
        }
        if (image) {
          onUpdateImage(image);
        }
        setIsLoading(false);
      },
      onError(message) {
        noticeOperations.removeAllNotices();
        noticeOperations.createErrorNotice(message);
      },
      multiple: false
    });
  }

  /**
   * Generates the featured image alt text for this editing context.
   *
   * @param {Object} imageMedia                               The image media object.
   * @param {string} imageMedia.alt_text                      The alternative text of the image.
   * @param {Object} imageMedia.media_details                 The media details of the image.
   * @param {Object} imageMedia.media_details.sizes           The sizes of the image.
   * @param {Object} imageMedia.media_details.sizes.full      The full size details of the image.
   * @param {string} imageMedia.media_details.sizes.full.file The file name of the full size image.
   * @param {string} imageMedia.slug                          The slug of the image.
   * @return {string} The featured image alt text.
   */
  function getImageDescription(imageMedia) {
    if (imageMedia.alt_text) {
      return (0,external_wp_i18n_namespaceObject.sprintf)(
      // Translators: %s: The selected image alt text.
      (0,external_wp_i18n_namespaceObject.__)('Current image: %s'), imageMedia.alt_text);
    }
    return (0,external_wp_i18n_namespaceObject.sprintf)(
    // Translators: %s: The selected image filename.
    (0,external_wp_i18n_namespaceObject.__)('The current image has no alternative text. The file name is: %s'), imageMedia.media_details.sizes?.full?.file || imageMedia.slug);
  }
  function returnFocus(node) {
    if (returnsFocusRef.current && node) {
      node.focus();
      returnsFocusRef.current = false;
    }
  }
  const isMissingMedia = !isRequestingFeaturedImageMedia && !!featuredImageId && !media;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(post_featured_image_check, {
    children: [noticeUI, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "editor-post-featured-image",
      children: [media && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        id: `editor-post-featured-image-${featuredImageId}-describedby`,
        className: "hidden",
        children: getImageDescription(media)
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.MediaUploadCheck, {
        fallback: instructions,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.MediaUpload, {
          title: postType?.labels?.featured_image || DEFAULT_FEATURE_IMAGE_LABEL,
          onSelect: onUpdateImage,
          unstableFeaturedImageFlow: true,
          allowedTypes: ALLOWED_MEDIA_TYPES,
          modalClass: "editor-post-featured-image__media-modal",
          render: ({
            open
          }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
            className: "editor-post-featured-image__container",
            children: [isMissingMedia ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Notice, {
              status: "warning",
              isDismissible: false,
              children: (0,external_wp_i18n_namespaceObject.__)('Could not retrieve the featured image data.')
            }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Button, {
              __next40pxDefaultSize: true,
              ref: returnFocus,
              className: !featuredImageId ? 'editor-post-featured-image__toggle' : 'editor-post-featured-image__preview',
              onClick: open,
              "aria-label": !featuredImageId ? null : (0,external_wp_i18n_namespaceObject.__)('Edit or replace the featured image'),
              "aria-describedby": !featuredImageId ? null : `editor-post-featured-image-${featuredImageId}-describedby`,
              "aria-haspopup": "dialog",
              disabled: isLoading,
              accessibleWhenDisabled: true,
              children: [!!featuredImageId && media && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
                className: "editor-post-featured-image__preview-image",
                src: mediaSourceUrl,
                alt: getImageDescription(media)
              }), (isLoading || isRequestingFeaturedImageMedia) && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}), !featuredImageId && !isLoading && (postType?.labels?.set_featured_image || DEFAULT_SET_FEATURE_IMAGE_LABEL)]
            }), !!featuredImageId && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
              className: dist_clsx('editor-post-featured-image__actions', {
                'editor-post-featured-image__actions-missing-image': isMissingMedia,
                'editor-post-featured-image__actions-is-requesting-image': isRequestingFeaturedImageMedia
              }),
              children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
                __next40pxDefaultSize: true,
                className: "editor-post-featured-image__action",
                onClick: open,
                "aria-haspopup": "dialog",
                variant: isMissingMedia ? 'secondary' : undefined,
                children: (0,external_wp_i18n_namespaceObject.__)('Replace')
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
                __next40pxDefaultSize: true,
                className: "editor-post-featured-image__action",
                onClick: () => {
                  onRemoveImage();
                  // Signal that the toggle button should be focused,
                  // when it is rendered. Can't focus it directly here
                  // because it's rendered conditionally.
                  returnsFocusRef.current = true;
                },
                variant: isMissingMedia ? 'secondary' : undefined,
                isDestructive: isMissingMedia,
                children: (0,external_wp_i18n_namespaceObject.__)('Remove')
              })]
            }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.DropZone, {
              onFilesDrop: onDropFiles
            })]
          }),
          value: featuredImageId
        })
      })]
    })]
  });
}
const applyWithSelect = (0,external_wp_data_namespaceObject.withSelect)(select => {
  const {
    getEntityRecord,
    getPostType,
    hasFinishedResolution
  } = select(external_wp_coreData_namespaceObject.store);
  const {
    getCurrentPostId,
    getEditedPostAttribute
  } = select(store_store);
  const featuredImageId = getEditedPostAttribute('featured_media');
  return {
    media: featuredImageId ? getEntityRecord('postType', 'attachment', featuredImageId, {
      context: 'view'
    }) : null,
    currentPostId: getCurrentPostId(),
    postType: getPostType(getEditedPostAttribute('type')),
    featuredImageId,
    isRequestingFeaturedImageMedia: !!featuredImageId && !hasFinishedResolution('getEntityRecord', ['postType', 'attachment', featuredImageId, {
      context: 'view'
    }])
  };
});
const applyWithDispatch = (0,external_wp_data_namespaceObject.withDispatch)((dispatch, {
  noticeOperations
}, {
  select
}) => {
  const {
    editPost
  } = dispatch(store_store);
  return {
    onUpdateImage(image) {
      editPost({
        featured_media: image.id
      });
    },
    onDropImage(filesList) {
      select(external_wp_blockEditor_namespaceObject.store).getSettings().mediaUpload({
        allowedTypes: ['image'],
        filesList,
        onFileChange([image]) {
          editPost({
            featured_media: image.id
          });
        },
        onError(message) {
          noticeOperations.removeAllNotices();
          noticeOperations.createErrorNotice(message);
        },
        multiple: false
      });
    },
    onRemoveImage() {
      editPost({
        featured_media: 0
      });
    }
  };
});

/**
 * Renders the component for managing the featured image of a post.
 *
 * @param {Object}   props                  Props.
 * @param {number}   props.currentPostId    ID of the current post.
 * @param {number}   props.featuredImageId  ID of the featured image.
 * @param {Function} props.onUpdateImage    Function to call when the image is updated.
 * @param {Function} props.onRemoveImage    Function to call when the image is removed.
 * @param {Object}   props.media            The media object representing the featured image.
 * @param {string}   props.postType         Post type.
 * @param {Element}  props.noticeUI         UI for displaying notices.
 * @param {Object}   props.noticeOperations Operations for managing notices.
 *
 * @return {Element} Component to be rendered .
 */
/* harmony default export */ const post_featured_image = ((0,external_wp_compose_namespaceObject.compose)(external_wp_components_namespaceObject.withNotices, applyWithSelect, applyWithDispatch, (0,external_wp_components_namespaceObject.withFilters)('editor.PostFeaturedImage'))(PostFeaturedImage));

;// ./packages/editor/build-module/components/post-featured-image/panel.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const post_featured_image_panel_PANEL_NAME = 'featured-image';

/**
 * Renders the panel for the post featured image.
 *
 * @param {Object}  props               Props.
 * @param {boolean} props.withPanelBody Whether to include the panel body. Default true.
 *
 * @return {React.ReactNode} The component to be rendered.
 * Return Null if the editor panel is disabled for featured image.
 */
function PostFeaturedImagePanel({
  withPanelBody = true
}) {
  var _postType$labels$feat;
  const {
    postType,
    isEnabled,
    isOpened
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute,
      isEditorPanelEnabled,
      isEditorPanelOpened
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      postType: getPostType(getEditedPostAttribute('type')),
      isEnabled: isEditorPanelEnabled(post_featured_image_panel_PANEL_NAME),
      isOpened: isEditorPanelOpened(post_featured_image_panel_PANEL_NAME)
    };
  }, []);
  const {
    toggleEditorPanelOpened
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  if (!isEnabled) {
    return null;
  }
  if (!withPanelBody) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_featured_image_check, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_featured_image, {})
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_featured_image_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
      title: (_postType$labels$feat = postType?.labels?.featured_image) !== null && _postType$labels$feat !== void 0 ? _postType$labels$feat : (0,external_wp_i18n_namespaceObject.__)('Featured image'),
      opened: isOpened,
      onToggle: () => toggleEditorPanelOpened(post_featured_image_panel_PANEL_NAME),
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_featured_image, {})
    })
  });
}

;// ./packages/editor/build-module/components/post-format/check.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Component check if there are any post formats.
 *
 * @param {Object}          props          The component props.
 * @param {React.ReactNode} props.children The child elements to render.
 *
 * @return {React.ReactNode} The rendered component or null if post formats are disabled.
 */

function PostFormatCheck({
  children
}) {
  const disablePostFormats = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getEditorSettings().disablePostFormats, []);
  if (disablePostFormats) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: "post-formats",
    children: children
  });
}

;// ./packages/editor/build-module/components/post-format/index.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



// All WP post formats, sorted alphabetically by translated name.

const POST_FORMATS = [{
  id: 'aside',
  caption: (0,external_wp_i18n_namespaceObject.__)('Aside')
}, {
  id: 'audio',
  caption: (0,external_wp_i18n_namespaceObject.__)('Audio')
}, {
  id: 'chat',
  caption: (0,external_wp_i18n_namespaceObject.__)('Chat')
}, {
  id: 'gallery',
  caption: (0,external_wp_i18n_namespaceObject.__)('Gallery')
}, {
  id: 'image',
  caption: (0,external_wp_i18n_namespaceObject.__)('Image')
}, {
  id: 'link',
  caption: (0,external_wp_i18n_namespaceObject.__)('Link')
}, {
  id: 'quote',
  caption: (0,external_wp_i18n_namespaceObject.__)('Quote')
}, {
  id: 'standard',
  caption: (0,external_wp_i18n_namespaceObject.__)('Standard')
}, {
  id: 'status',
  caption: (0,external_wp_i18n_namespaceObject.__)('Status')
}, {
  id: 'video',
  caption: (0,external_wp_i18n_namespaceObject.__)('Video')
}].sort((a, b) => {
  const normalizedA = a.caption.toUpperCase();
  const normalizedB = b.caption.toUpperCase();
  if (normalizedA < normalizedB) {
    return -1;
  }
  if (normalizedA > normalizedB) {
    return 1;
  }
  return 0;
});

/**
 * `PostFormat` a component that allows changing the post format while also providing a suggestion for the current post.
 *
 * @example
 * ```jsx
 * <PostFormat />
 * ```
 *
 * @return {React.ReactNode} The rendered PostFormat component.
 */
function PostFormat() {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(PostFormat);
  const postFormatSelectorId = `post-format-selector-${instanceId}`;
  const {
    postFormat,
    suggestedFormat,
    supportedFormats
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getEditedPostAttribute,
      getSuggestedPostFormat
    } = select(store_store);
    const _postFormat = getEditedPostAttribute('format');
    const themeSupports = select(external_wp_coreData_namespaceObject.store).getThemeSupports();
    return {
      postFormat: _postFormat !== null && _postFormat !== void 0 ? _postFormat : 'standard',
      suggestedFormat: getSuggestedPostFormat(),
      supportedFormats: themeSupports.formats
    };
  }, []);
  const formats = POST_FORMATS.filter(format => {
    // Ensure current format is always in the set.
    // The current format may not be a format supported by the theme.
    return supportedFormats?.includes(format.id) || postFormat === format.id;
  });
  const suggestion = formats.find(format => format.id === suggestedFormat);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const onUpdatePostFormat = format => editPost({
    format
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PostFormatCheck, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "editor-post-format",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RadioControl, {
        className: "editor-post-format__options",
        label: (0,external_wp_i18n_namespaceObject.__)('Post Format'),
        selected: postFormat,
        onChange: format => onUpdatePostFormat(format),
        id: postFormatSelectorId,
        options: formats.map(format => ({
          label: format.caption,
          value: format.id
        })),
        hideLabelFromVision: true
      }), suggestion && suggestion.id !== postFormat && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
        className: "editor-post-format__suggestion",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "link",
          onClick: () => onUpdatePostFormat(suggestion.id),
          children: (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: post format */
          (0,external_wp_i18n_namespaceObject.__)('Apply suggested format: %s'), suggestion.caption)
        })
      })]
    })
  });
}

;// ./packages/editor/build-module/components/post-last-revision/check.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Wrapper component that renders its children if the post has more than one revision.
 *
 * @param {Object}          props          Props.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} Rendered child components if post has more than one revision, otherwise null.
 */

function PostLastRevisionCheck({
  children
}) {
  const {
    lastRevisionId,
    revisionsCount
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostLastRevisionId,
      getCurrentPostRevisionsCount
    } = select(store_store);
    return {
      lastRevisionId: getCurrentPostLastRevisionId(),
      revisionsCount: getCurrentPostRevisionsCount()
    };
  }, []);
  if (!lastRevisionId || revisionsCount < 2) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_type_support_check, {
    supportKeys: "revisions",
    children: children
  });
}
/* harmony default export */ const post_last_revision_check = (PostLastRevisionCheck);

;// ./packages/editor/build-module/components/post-last-revision/index.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function usePostLastRevisionInfo() {
  return (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getCurrentPostLastRevisionId,
      getCurrentPostRevisionsCount
    } = select(store_store);
    return {
      lastRevisionId: getCurrentPostLastRevisionId(),
      revisionsCount: getCurrentPostRevisionsCount()
    };
  }, []);
}

/**
 * Renders the component for displaying the last revision of a post.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PostLastRevision() {
  const {
    lastRevisionId,
    revisionsCount
  } = usePostLastRevisionInfo();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_last_revision_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      __next40pxDefaultSize: true,
      href: (0,external_wp_url_namespaceObject.addQueryArgs)('revision.php', {
        revision: lastRevisionId
      }),
      className: "editor-post-last-revision__title",
      icon: library_backup,
      iconPosition: "right",
      text: (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: number of revisions. */
      (0,external_wp_i18n_namespaceObject.__)('Revisions (%s)'), revisionsCount)
    })
  });
}
function PrivatePostLastRevision() {
  const {
    lastRevisionId,
    revisionsCount
  } = usePostLastRevisionInfo();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_last_revision_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_panel_row, {
      label: (0,external_wp_i18n_namespaceObject.__)('Revisions'),
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        href: (0,external_wp_url_namespaceObject.addQueryArgs)('revision.php', {
          revision: lastRevisionId
        }),
        className: "editor-private-post-last-revision__button",
        text: revisionsCount,
        variant: "tertiary",
        size: "compact"
      })
    })
  });
}
/* harmony default export */ const post_last_revision = (PostLastRevision);

;// ./packages/editor/build-module/components/post-last-revision/panel.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Renders the panel for displaying the last revision of a post.
 *
 * @return {React.ReactNode} The rendered component.
 */

function PostLastRevisionPanel() {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_last_revision_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, {
      className: "editor-post-last-revision__panel",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_last_revision, {})
    })
  });
}
/* harmony default export */ const post_last_revision_panel = (PostLastRevisionPanel);

;// ./packages/editor/build-module/components/post-locked-modal/index.js
/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */


function PostLockedModal() {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(PostLockedModal);
  const hookName = 'core/editor/post-locked-modal-' + instanceId;
  const {
    autosave,
    updatePostLock
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const {
    isLocked,
    isTakeover,
    user,
    postId,
    postLockUtils,
    activePostLock,
    postType,
    previewLink
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      isPostLocked,
      isPostLockTakeover,
      getPostLockUser,
      getCurrentPostId,
      getActivePostLock,
      getEditedPostAttribute,
      getEditedPostPreviewLink,
      getEditorSettings
    } = select(store_store);
    const {
      getPostType
    } = select(external_wp_coreData_namespaceObject.store);
    return {
      isLocked: isPostLocked(),
      isTakeover: isPostLockTakeover(),
      user: getPostLockUser(),
      postId: getCurrentPostId(),
      postLockUtils: getEditorSettings().postLockUtils,
      activePostLock: getActivePostLock(),
      postType: getPostType(getEditedPostAttribute('type')),
      previewLink: getEditedPostPreviewLink()
    };
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    /**
     * Keep the lock refreshed.
     *
     * When the user does not send a heartbeat in a heartbeat-tick
     * the user is no longer editing and another user can start editing.
     *
     * @param {Object} data Data to send in the heartbeat request.
     */
    function sendPostLock(data) {
      if (isLocked) {
        return;
      }
      data['wp-refresh-post-lock'] = {
        lock: activePostLock,
        post_id: postId
      };
    }

    /**
     * Refresh post locks: update the lock string or show the dialog if somebody has taken over editing.
     *
     * @param {Object} data Data received in the heartbeat request
     */
    function receivePostLock(data) {
      if (!data['wp-refresh-post-lock']) {
        return;
      }
      const received = data['wp-refresh-post-lock'];
      if (received.lock_error) {
        // Auto save and display the takeover modal.
        autosave();
        updatePostLock({
          isLocked: true,
          isTakeover: true,
          user: {
            name: received.lock_error.name,
            avatar: received.lock_error.avatar_src_2x
          }
        });
      } else if (received.new_lock) {
        updatePostLock({
          isLocked: false,
          activePostLock: received.new_lock
        });
      }
    }

    /**
     * Unlock the post before the window is exited.
     */
    function releasePostLock() {
      if (isLocked || !activePostLock) {
        return;
      }
      const data = new window.FormData();
      data.append('action', 'wp-remove-post-lock');
      data.append('_wpnonce', postLockUtils.unlockNonce);
      data.append('post_ID', postId);
      data.append('active_post_lock', activePostLock);
      if (window.navigator.sendBeacon) {
        window.navigator.sendBeacon(postLockUtils.ajaxUrl, data);
      } else {
        const xhr = new window.XMLHttpRequest();
        xhr.open('POST', postLockUtils.ajaxUrl, false);
        xhr.send(data);
      }
    }

    // Details on these events on the Heartbeat API docs
    // https://developer.wordpress.org/plugins/javascript/heartbeat-api/
    (0,external_wp_hooks_namespaceObject.addAction)('heartbeat.send', hookName, sendPostLock);
    (0,external_wp_hooks_namespaceObject.addAction)('heartbeat.tick', hookName, receivePostLock);
    window.addEventListener('beforeunload', releasePostLock);
    return () => {
      (0,external_wp_hooks_namespaceObject.removeAction)('heartbeat.send', hookName);
      (0,external_wp_hooks_namespaceObject.removeAction)('heartbeat.tick', hookName);
      window.removeEventListener('beforeunload', releasePostLock);
    };
  }, []);
  if (!isLocked) {
    return null;
  }
  const userDisplayName = user.name;
  const userAvatar = user.avatar;
  const unlockUrl = (0,external_wp_url_namespaceObject.addQueryArgs)('post.php', {
    'get-post-lock': '1',
    lockKey: true,
    post: postId,
    action: 'edit',
    _wpnonce: postLockUtils.nonce
  });
  const allPostsUrl = (0,external_wp_url_namespaceObject.addQueryArgs)('edit.php', {
    post_type: postType?.slug
  });
  const allPostsLabel = (0,external_wp_i18n_namespaceObject.__)('Exit editor');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Modal, {
    title: isTakeover ? (0,external_wp_i18n_namespaceObject.__)('Someone else has taken over this post') : (0,external_wp_i18n_namespaceObject.__)('This post is already being edited'),
    focusOnMount: true,
    shouldCloseOnClickOutside: false,
    shouldCloseOnEsc: false,
    isDismissible: false
    // Do not remove this class, as this class is used by third party plugins.
    ,
    className: "editor-post-locked-modal",
    size: "medium",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      alignment: "top",
      spacing: 6,
      children: [!!userAvatar && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
        src: userAvatar,
        alt: (0,external_wp_i18n_namespaceObject.__)('Avatar'),
        className: "editor-post-locked-modal__avatar",
        width: 64,
        height: 64
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        children: [!!isTakeover && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
          children: (0,external_wp_element_namespaceObject.createInterpolateElement)(userDisplayName ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: user's display name */
          (0,external_wp_i18n_namespaceObject.__)('<strong>%s</strong> now has editing control of this post (<PreviewLink />). Don’t worry, your changes up to this moment have been saved.'), userDisplayName) : (0,external_wp_i18n_namespaceObject.__)('Another user now has editing control of this post (<PreviewLink />). Don’t worry, your changes up to this moment have been saved.'), {
            strong: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("strong", {}),
            PreviewLink: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
              href: previewLink,
              children: (0,external_wp_i18n_namespaceObject.__)('preview')
            })
          })
        }), !isTakeover && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
            children: (0,external_wp_element_namespaceObject.createInterpolateElement)(userDisplayName ? (0,external_wp_i18n_namespaceObject.sprintf)(/* translators: %s: user's display name */
            (0,external_wp_i18n_namespaceObject.__)('<strong>%s</strong> is currently working on this post (<PreviewLink />), which means you cannot make changes, unless you take over.'), userDisplayName) : (0,external_wp_i18n_namespaceObject.__)('Another user is currently working on this post (<PreviewLink />), which means you cannot make changes, unless you take over.'), {
              strong: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("strong", {}),
              PreviewLink: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
                href: previewLink,
                children: (0,external_wp_i18n_namespaceObject.__)('preview')
              })
            })
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
            children: (0,external_wp_i18n_namespaceObject.__)('If you take over, the other user will lose editing control to the post, but their changes will be saved.')
          })]
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
          className: "editor-post-locked-modal__buttons",
          justify: "flex-end",
          children: [!isTakeover && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "tertiary",
            href: unlockUrl,
            children: (0,external_wp_i18n_namespaceObject.__)('Take over')
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            __next40pxDefaultSize: true,
            variant: "primary",
            href: allPostsUrl,
            children: allPostsLabel
          })]
        })]
      })]
    })
  });
}

/**
 * A modal component that is displayed when a post is locked for editing by another user.
 * The modal provides information about the lock status and options to take over or exit the editor.
 *
 * @return {React.ReactNode} The rendered PostLockedModal component.
 */
/* harmony default export */ const post_locked_modal = ( true ? (0,external_wp_components_namespaceObject.withFilters)('editor.PostLockedModal')(PostLockedModal) : 0);

;// ./packages/editor/build-module/components/post-pending-status/check.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * This component checks the publishing status of the current post.
 * If the post is already published or the user doesn't have the
 * capability to publish, it returns null.
 *
 * @param {Object}          props          Component properties.
 * @param {React.ReactNode} props.children Children to be rendered.
 *
 * @return {React.ReactNode} The rendered child elements or null if the post is already published or the user doesn't have the capability to publish.
 */
function PostPendingStatusCheck({
  children
}) {
  const {
    hasPublishAction,
    isPublished
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getCurrentPost$_link;
    const {
      isCurrentPostPublished,
      getCurrentPost
    } = select(store_store);
    return {
      hasPublishAction: (_getCurrentPost$_link = getCurrentPost()._links?.['wp:action-publish']) !== null && _getCurrentPost$_link !== void 0 ? _getCurrentPost$_link : false,
      isPublished: isCurrentPostPublished()
    };
  }, []);
  if (isPublished || !hasPublishAction) {
    return null;
  }
  return children;
}
/* harmony default export */ const post_pending_status_check = (PostPendingStatusCheck);

;// ./packages/editor/build-module/components/post-pending-status/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



/**
 * A component for displaying and toggling the pending status of a post.
 *
 * @return {React.ReactNode} The rendered component.
 */

function PostPendingStatus() {
  const status = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getEditedPostAttribute('status'), []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const togglePendingStatus = () => {
    const updatedStatus = status === 'pending' ? 'draft' : 'pending';
    editPost({
      status: updatedStatus
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(post_pending_status_check, {
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Pending review'),
      checked: status === 'pending',
      onChange: togglePendingStatus
    })
  });
}
/* harmony default export */ const post_pending_status = (PostPendingStatus);

;// ./packages/editor/build-module/components/post-preview-button/index.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */


function writeInterstitialMessage(targetDocument) {
  let markup = (0,external_wp_element_namespaceObject.renderToString)(/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-post-preview-button__interstitial-message",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.SVG, {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 96 96",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
        className: "outer",
        d: "M48 12c19.9 0 36 16.1 36 36S67.9 84 48 84 12 67.9 12 48s16.1-36 36-36",
        fill: "none"
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
        className: "inner",
        d: "M69.5 46.4c0-3.9-1.4-6.7-2.6-8.8-1.6-2.6-3.1-4.9-3.1-7.5 0-2.9 2.2-5.7 5.4-5.7h.4C63.9 19.2 56.4 16 48 16c-11.2 0-21 5.7-26.7 14.4h2.1c3.3 0 8.5-.4 8.5-.4 1.7-.1 1.9 2.4.2 2.6 0 0-1.7.2-3.7.3L40 67.5l7-20.9L42 33c-1.7-.1-3.3-.3-3.3-.3-1.7-.1-1.5-2.7.2-2.6 0 0 5.3.4 8.4.4 3.3 0 8.5-.4 8.5-.4 1.7-.1 1.9 2.4.2 2.6 0 0-1.7.2-3.7.3l11.5 34.3 3.3-10.4c1.6-4.5 2.4-7.8 2.4-10.5zM16.1 48c0 12.6 7.3 23.5 18 28.7L18.8 35c-1.7 4-2.7 8.4-2.7 13zm32.5 2.8L39 78.6c2.9.8 5.9 1.3 9 1.3 3.7 0 7.3-.6 10.6-1.8-.1-.1-.2-.3-.2-.4l-9.8-26.9zM76.2 36c0 3.2-.6 6.9-2.4 11.4L64 75.6c9.5-5.5 15.9-15.8 15.9-27.6 0-5.5-1.4-10.8-3.9-15.3.1 1 .2 2.1.2 3.3z",
        fill: "none"
      })]
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
      children: (0,external_wp_i18n_namespaceObject.__)('Generating preview…')
    })]
  }));
  markup += `
		<style>
			body {
				margin: 0;
			}
			.editor-post-preview-button__interstitial-message {
				display: flex;
				flex-direction: column;
				align-items: center;
				justify-content: center;
				height: 100vh;
				width: 100vw;
			}
			@-webkit-keyframes paint {
				0% {
					stroke-dashoffset: 0;
				}
			}
			@-moz-keyframes paint {
				0% {
					stroke-dashoffset: 0;
				}
			}
			@-o-keyframes paint {
				0% {
					stroke-dashoffset: 0;
				}
			}
			@keyframes paint {
				0% {
					stroke-dashoffset: 0;
				}
			}
			.editor-post-preview-button__interstitial-message svg {
				width: 192px;
				height: 192px;
				stroke: #555d66;
				stroke-width: 0.75;
			}
			.editor-post-preview-button__interstitial-message svg .outer,
			.editor-post-preview-button__interstitial-message svg .inner {
				stroke-dasharray: 280;
				stroke-dashoffset: 280;
				-webkit-animation: paint 1.5s ease infinite alternate;
				-moz-animation: paint 1.5s ease infinite alternate;
				-o-animation: paint 1.5s ease infinite alternate;
				animation: paint 1.5s ease infinite alternate;
			}
			p {
				text-align: center;
				font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
			}
		</style>
	`;

  /**
   * Filters the interstitial message shown when generating previews.
   *
   * @param {string} markup The preview interstitial markup.
   */
  markup = (0,external_wp_hooks_namespaceObject.applyFilters)('editor.PostPreview.interstitialMarkup', markup);
  targetDocument.write(markup);
  targetDocument.title = (0,external_wp_i18n_namespaceObject.__)('Generating preview…');
  targetDocument.close();
}

/**
 * Renders a button that opens a new window or tab for the preview,
 * writes the interstitial message to this window, and then navigates
 * to the actual preview link. The button is not rendered if the post
 * is not viewable and disabled if the post is not saveable.
 *
 * @param {Object}   props                     The component props.
 * @param {string}   props.className           The class name for the button.
 * @param {string}   props.textContent         The text content for the button.
 * @param {boolean}  props.forceIsAutosaveable Whether to force autosave.
 * @param {string}   props.role                The role attribute for the button.
 * @param {Function} props.onPreview           The callback function for preview event.
 *
 * @return {React.ReactNode} The rendered button component.
 */
function PostPreviewButton({
  className,
  textContent,
  forceIsAutosaveable,
  role,
  onPreview
}) {
  const {
    postId,
    currentPostLink,
    previewLink,
    isSaveable,
    isViewable
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _postType$viewable;
    const editor = select(store_store);
    const core = select(external_wp_coreData_namespaceObject.store);
    const postType = core.getPostType(editor.getCurrentPostType('type'));
    const canView = (_postType$viewable = postType?.viewable) !== null && _postType$viewable !== void 0 ? _postType$viewable : false;
    if (!canView) {
      return {
        isViewable: canView
      };
    }
    return {
      postId: editor.getCurrentPostId(),
      currentPostLink: editor.getCurrentPostAttribute('link'),
      previewLink: editor.getEditedPostPreviewLink(),
      isSaveable: editor.isEditedPostSaveable(),
      isViewable: canView
    };
  }, []);
  const {
    __unstableSaveForPreview
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  if (!isViewable) {
    return null;
  }
  const targetId = `wp-preview-${postId}`;
  const openPreviewWindow = async event => {
    // Our Preview button has its 'href' and 'target' set correctly for a11y
    // purposes. Unfortunately, though, we can't rely on the default 'click'
    // handler since sometimes it incorrectly opens a new tab instead of reusing
    // the existing one.
    // https://github.com/WordPress/gutenberg/pull/8330
    event.preventDefault();

    // Open up a Preview tab if needed. This is where we'll show the preview.
    const previewWindow = window.open('', targetId);

    // Focus the Preview tab. This might not do anything, depending on the browser's
    // and user's preferences.
    // https://html.spec.whatwg.org/multipage/interaction.html#dom-window-focus
    previewWindow.focus();
    writeInterstitialMessage(previewWindow.document);
    const link = await __unstableSaveForPreview({
      forceIsAutosaveable
    });
    previewWindow.location = link;
    onPreview?.();
  };

  // Link to the `?preview=true` URL if we have it, since this lets us see
  // changes that were autosaved since the post was last published. Otherwise,
  // just link to the post's URL.
  const href = previewLink || currentPostLink;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
    variant: !className ? 'tertiary' : undefined,
    className: className || 'editor-post-preview',
    href: href,
    target: targetId,
    accessibleWhenDisabled: true,
    disabled: !isSaveable,
    onClick: openPreviewWindow,
    role: role,
    size: "compact",
    children: textContent || /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [(0,external_wp_i18n_namespaceObject._x)('Preview', 'imperative verb'), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, {
        as: "span",
        children: /* translators: accessibility text */
        (0,external_wp_i18n_namespaceObject.__)('(opens in a new tab)')
      })]
    })
  });
}

;// ./packages/editor/build-module/components/post-publish-button/label.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Renders the label for the publish button.
 *
 * @return {string} The label for the publish button.
 */
function PublishButtonLabel() {
  const isSmallerThanMediumViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)('medium', '<');
  const {
    isPublished,
    isBeingScheduled,
    isSaving,
    isPublishing,
    hasPublishAction,
    isAutosaving,
    hasNonPostEntityChanges,
    postStatusHasChanged,
    postStatus
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _getCurrentPost$_link;
    const {
      isCurrentPostPublished,
      isEditedPostBeingScheduled,
      isSavingPost,
      isPublishingPost,
      getCurrentPost,
      getCurrentPostType,
      isAutosavingPost,
      getPostEdits,
      getEditedPostAttribute
    } = select(store_store);
    return {
      isPublished: isCurrentPostPublished(),
      isBeingScheduled: isEditedPostBeingScheduled(),
      isSaving: isSavingPost(),
      isPublishing: isPublishingPost(),
      hasPublishAction: (_getCurrentPost$_link = getCurrentPost()._links?.['wp:action-publish']) !== null && _getCurrentPost$_link !== void 0 ? _getCurrentPost$_link : false,
      postType: getCurrentPostType(),
      isAutosaving: isAutosavingPost(),
      hasNonPostEntityChanges: select(store_store).hasNonPostEntityChanges(),
      postStatusHasChanged: !!getPostEdits()?.status,
      postStatus: getEditedPostAttribute('status')
    };
  }, []);
  if (isPublishing) {
    /* translators: button label text should, if possible, be under 16 characters. */
    return (0,external_wp_i18n_namespaceObject.__)('Publishing…');
  } else if ((isPublished || isBeingScheduled) && isSaving && !isAutosaving) {
    /* translators: button label text should, if possible, be under 16 characters. */
    return (0,external_wp_i18n_namespaceObject.__)('Saving…');
  }
  if (!hasPublishAction) {
    // TODO: this is because "Submit for review" string is too long in some languages.
    // @see https://github.com/WordPress/gutenberg/issues/10475
    return isSmallerThanMediumViewport ? (0,external_wp_i18n_namespaceObject.__)('Publish') : (0,external_wp_i18n_namespaceObject.__)('Submit for Review');
  }
  if (hasNonPostEntityChanges || isPublished || postStatusHasChanged && !['future', 'publish'].includes(postStatus) || !postStatusHasChanged && postStatus === 'future') {
    return (0,external_wp_i18n_namespaceObject.__)('Save');
  }
  if (isBeingScheduled) {
    return (0,external_wp_i18n_namespaceObject.__)('Schedule');
  }
  return (0,external_wp_i18n_namespaceObject.__)('Publish');
}

;// ./packages/editor/build-module/components/post-publish-button/index.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const post_publish_button_noop = () => {};
class PostPublishButton extends external_wp_element_namespaceObject.Component {
  constructor(props) {
    super(props);
    this.createOnClick = this.createOnClick.bind(this);
    this.closeEntitiesSavedStates = this.closeEntitiesSavedStates.bind(this);
    this.state = {
      entitiesSavedStatesCallback: false
    };
  }
  createOnClick(callback) {
    return (...args) => {
      const {
        hasNonPostEntityChanges,
        setEntitiesSavedStatesCallback
      } = this.props;
      // If a post with non-post entities is published, but the user
      // elects to not save changes to the non-post entities, those
      // entities will still be dirty when the Publish button is clicked.
      // We also need to check that the `setEntitiesSavedStatesCallback`
      // prop was passed. See https://github.com/WordPress/gutenberg/pull/37383
      if (hasNonPostEntityChanges && setEntitiesSavedStatesCallback) {
        // The modal for multiple entity saving will open,
        // hold the callback for saving/publishing the post
        // so that we can call it if the post entity is checked.
        this.setState({
          entitiesSavedStatesCallback: () => callback(...args)
        });

        // Open the save panel by setting its callback.
        // To set a function on the useState hook, we must set it
        // with another function (() => myFunction). Passing the
        // function on its own will cause an error when called.
        setEntitiesSavedStatesCallback(() => this.closeEntitiesSavedStates);
        return post_publish_button_noop;
      }
      return callback(...args);
    };
  }
  closeEntitiesSavedStates(savedEntities) {
    const {
      postType,
      postId
    } = this.props;
    const {
      entitiesSavedStatesCallback
    } = this.state;
    this.setState({
      entitiesSavedStatesCallback: false
    }, () => {
      if (savedEntities && savedEntities.some(elt => elt.kind === 'postType' && elt.name === postType && elt.key === postId)) {
        // The post entity was checked, call the held callback from `createOnClick`.
        entitiesSavedStatesCallback();
      }
    });
  }
  render() {
    const {
      forceIsDirty,
      hasPublishAction,
      isBeingScheduled,
      isOpen,
      isPostSavingLocked,
      isPublishable,
      isPublished,
      isSaveable,
      isSaving,
      isAutoSaving,
      isToggle,
      savePostStatus,
      onSubmit = post_publish_button_noop,
      onToggle,
      visibility,
      hasNonPostEntityChanges,
      isSavingNonPostEntityChanges,
      postStatus,
      postStatusHasChanged
    } = this.props;
    const isButtonDisabled = (isSaving || !isSaveable || isPostSavingLocked || !isPublishable && !forceIsDirty) && (!hasNonPostEntityChanges || isSavingNonPostEntityChanges);
    const isToggleDisabled = (isPublished || isSaving || !isSaveable || !isPublishable && !forceIsDirty) && (!hasNonPostEntityChanges || isSavingNonPostEntityChanges);

    // If the new status has not changed explicitly, we derive it from
    // other factors, like having a publish action, etc.. We need to preserve
    // this because it affects when to show the pre and post publish panels.
    // If it has changed though explicitly, we need to respect that.
    let publishStatus = 'publish';
    if (postStatusHasChanged) {
      publishStatus = postStatus;
    } else if (!hasPublishAction) {
      publishStatus = 'pending';
    } else if (visibility === 'private') {
      publishStatus = 'private';
    } else if (isBeingScheduled) {
      publishStatus = 'future';
    }
    const onClickButton = () => {
      if (isButtonDisabled) {
        return;
      }
      onSubmit();
      savePostStatus(publishStatus);
    };

    // Callback to open the publish panel.
    const onClickToggle = () => {
      if (isToggleDisabled) {
        return;
      }
      onToggle();
    };
    const buttonProps = {
      'aria-disabled': isButtonDisabled,
      className: 'editor-post-publish-button',
      isBusy: !isAutoSaving && isSaving,
      variant: 'primary',
      onClick: this.createOnClick(onClickButton),
      'aria-haspopup': hasNonPostEntityChanges ? 'dialog' : undefined
    };
    const toggleProps = {
      'aria-disabled': isToggleDisabled,
      'aria-expanded': isOpen,
      className: 'editor-post-publish-panel__toggle',
      isBusy: isSaving && isPublished,
      variant: 'primary',
      size: 'compact',
      onClick: this.createOnClick(onClickToggle),
      'aria-haspopup': hasNonPostEntityChanges ? 'dialog' : undefined
    };
    const componentProps = isToggle ? toggleProps : buttonProps;
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        ...componentProps,
        className: `${componentProps.className} editor-post-publish-button__button`,
        size: "compact",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PublishButtonLabel, {})
      })
    });
  }
}

/**
 * Renders the publish button.
 */
/* harmony default export */ const post_publish_button = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withSelect)(select => {
  var _getCurrentPost$_link;
  const {
    isSavingPost,
    isAutosavingPost,
    isEditedPostBeingScheduled,
    getEditedPostVisibility,
    isCurrentPostPublished,
    isEditedPostSaveable,
    isEditedPostPublishable,
    isPostSavingLocked,
    getCurrentPost,
    getCurrentPostType,
    getCurrentPostId,
    hasNonPostEntityChanges,
    isSavingNonPostEntityChanges,
    getEditedPostAttribute,
    getPostEdits
  } = select(store_store);
  return {
    isSaving: isSavingPost(),
    isAutoSaving: isAutosavingPost(),
    isBeingScheduled: isEditedPostBeingScheduled(),
    visibility: getEditedPostVisibility(),
    isSaveable: isEditedPostSaveable(),
    isPostSavingLocked: isPostSavingLocked(),
    isPublishable: isEditedPostPublishable(),
    isPublished: isCurrentPostPublished(),
    hasPublishAction: (_getCurrentPost$_link = getCurrentPost()._links?.['wp:action-publish']) !== null && _getCurrentPost$_link !== void 0 ? _getCurrentPost$_link : false,
    postType: getCurrentPostType(),
    postId: getCurrentPostId(),
    postStatus: getEditedPostAttribute('status'),
    postStatusHasChanged: getPostEdits()?.status,
    hasNonPostEntityChanges: hasNonPostEntityChanges(),
    isSavingNonPostEntityChanges: isSavingNonPostEntityChanges()
  };
}), (0,external_wp_data_namespaceObject.withDispatch)(dispatch => {
  const {
    editPost,
    savePost
  } = dispatch(store_store);
  return {
    savePostStatus: status => {
      editPost({
        status
      }, {
        undoIgnore: true
      });
      savePost();
    }
  };
})])(PostPublishButton));

;// ./packages/icons/build-module/library/wordpress.js
/**
 * WordPress dependencies
 */


const wordpress = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "-2 -2 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M20 10c0-5.51-4.49-10-10-10C4.48 0 0 4.49 0 10c0 5.52 4.48 10 10 10 5.51 0 10-4.48 10-10zM7.78 15.37L4.37 6.22c.55-.02 1.17-.08 1.17-.08.5-.06.44-1.13-.06-1.11 0 0-1.45.11-2.37.11-.18 0-.37 0-.58-.01C4.12 2.69 6.87 1.11 10 1.11c2.33 0 4.45.87 6.05 2.34-.68-.11-1.65.39-1.65 1.58 0 .74.45 1.36.9 2.1.35.61.55 1.36.55 2.46 0 1.49-1.4 5-1.4 5l-3.03-8.37c.54-.02.82-.17.82-.17.5-.05.44-1.25-.06-1.22 0 0-1.44.12-2.38.12-.87 0-2.33-.12-2.33-.12-.5-.03-.56 1.2-.06 1.22l.92.08 1.26 3.41zM17.41 10c.24-.64.74-1.87.43-4.25.7 1.29 1.05 2.71 1.05 4.25 0 3.29-1.73 6.24-4.4 7.78.97-2.59 1.94-5.2 2.92-7.78zM6.1 18.09C3.12 16.65 1.11 13.53 1.11 10c0-1.3.23-2.48.72-3.59C3.25 10.3 4.67 14.2 6.1 18.09zm4.03-6.63l2.58 6.98c-.86.29-1.76.45-2.71.45-.79 0-1.57-.11-2.29-.33.81-2.38 1.62-4.74 2.42-7.1z"
  })
});
/* harmony default export */ const library_wordpress = (wordpress);

;// ./packages/editor/build-module/components/post-visibility/utils.js
/**
 * WordPress dependencies
 */

const VISIBILITY_OPTIONS = [{
  label: (0,external_wp_i18n_namespaceObject.__)('Public'),
  value: 'public',
  description: (0,external_wp_i18n_namespaceObject.__)('Visible to everyone.')
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Private'),
  value: 'private',
  description: (0,external_wp_i18n_namespaceObject.__)('Only visible to site admins and editors.')
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Password protected'),
  value: 'password',
  description: (0,external_wp_i18n_namespaceObject.__)('Only visible to those who know the password.')
}];

;// ./packages/editor/build-module/components/post-visibility/index.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



/**
 * Allows users to set the visibility of a post.
 *
 * @param {Object}   props         The component props.
 * @param {Function} props.onClose Function to call when the popover is closed.
 * @return {React.ReactNode} The rendered component.
 */

function PostVisibility({
  onClose
}) {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(PostVisibility);
  const {
    status,
    visibility,
    password
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    status: select(store_store).getEditedPostAttribute('status'),
    visibility: select(store_store).getEditedPostVisibility(),
    password: select(store_store).getEditedPostAttribute('password')
  }));
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const [hasPassword, setHasPassword] = (0,external_wp_element_namespaceObject.useState)(!!password);
  function updateVisibility(value) {
    const nextValues = {
      public: {
        status: visibility === 'private' ? 'draft' : status,
        password: ''
      },
      private: {
        status: 'private',
        password: ''
      },
      password: {
        status: visibility === 'private' ? 'draft' : status,
        password: password || ''
      }
    };
    editPost(nextValues[value]);
    setHasPassword(value === 'password');
  }
  const updatePassword = value => {
    editPost({
      password: value
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-post-visibility",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__experimentalInspectorPopoverHeader, {
      title: (0,external_wp_i18n_namespaceObject.__)('Visibility'),
      help: (0,external_wp_i18n_namespaceObject.__)('Control how this post is viewed.'),
      onClose: onClose
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RadioControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Visibility'),
        hideLabelFromVision: true,
        options: VISIBILITY_OPTIONS,
        selected: hasPassword ? 'password' : visibility,
        onChange: updateVisibility
      }), hasPassword && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Password'),
        onChange: updatePassword,
        value: password,
        placeholder: (0,external_wp_i18n_namespaceObject.__)('Use a secure password'),
        type: "text",
        id: `editor-post-visibility__password-input-${instanceId}`,
        __next40pxDefaultSize: true,
        __nextHasNoMarginBottom: true,
        maxLength: 255
      })]
    })]
  });
}

;// ./packages/editor/build-module/components/post-visibility/label.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns the label for the current post visibility setting.
 *
 * @return {string} Post visibility label.
 */
function PostVisibilityLabel() {
  return usePostVisibilityLabel();
}

/**
 * Get the label for the current post visibility setting.
 *
 * @return {string} Post visibility label.
 */
function usePostVisibilityLabel() {
  const visibility = (0,external_wp_data_namespaceObject.useSelect)(select => select(store_store).getEditedPostVisibility(), []);
  return VISIBILITY_OPTIONS.find(option => option.value === visibility)?.label;
}

;// ./node_modules/date-fns/toDate.mjs
/**
 * @name toDate
 * @category Common Helpers
 * @summary Convert the given argument to an instance of Date.
 *
 * @description
 * Convert the given argument to an instance of Date.
 *
 * If the argument is an instance of Date, the function returns its clone.
 *
 * If the argument is a number, it is treated as a timestamp.
 *
 * If the argument is none of the above, the function returns Invalid Date.
 *
 * **Note**: *all* Date arguments passed to any *date-fns* function is processed by `toDate`.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 *
 * @param argument - The value to convert
 *
 * @returns The parsed date in the local time zone
 *
 * @example
 * // Clone the date:
 * const result = toDate(new Date(2014, 1, 11, 11, 30, 30))
 * //=> Tue Feb 11 2014 11:30:30
 *
 * @example
 * // Convert the timestamp to date:
 * const result = toDate(1392098430000)
 * //=> Tue Feb 11 2014 11:30:30
 */
function toDate_toDate(argument) {
  const argStr = Object.prototype.toString.call(argument);

  // Clone the date
  if (
    argument instanceof Date ||
    (typeof argument === "object" && argStr === "[object Date]")
  ) {
    // Prevent the date to lose the milliseconds when passed to new Date() in IE10
    return new argument.constructor(+argument);
  } else if (
    typeof argument === "number" ||
    argStr === "[object Number]" ||
    typeof argument === "string" ||
    argStr === "[object String]"
  ) {
    // TODO: Can we get rid of as?
    return new Date(argument);
  } else {
    // TODO: Can we get rid of as?
    return new Date(NaN);
  }
}

// Fallback for modularized imports:
/* harmony default export */ const node_modules_date_fns_toDate = ((/* unused pure expression or super */ null && (toDate_toDate)));

;// ./node_modules/date-fns/startOfMonth.mjs


/**
 * @name startOfMonth
 * @category Month Helpers
 * @summary Return the start of a month for the given date.
 *
 * @description
 * Return the start of a month for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 *
 * @param date - The original date
 *
 * @returns The start of a month
 *
 * @example
 * // The start of a month for 2 September 2014 11:55:00:
 * const result = startOfMonth(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Mon Sep 01 2014 00:00:00
 */
function startOfMonth_startOfMonth(date) {
  const _date = toDate_toDate(date);
  _date.setDate(1);
  _date.setHours(0, 0, 0, 0);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const node_modules_date_fns_startOfMonth = ((/* unused pure expression or super */ null && (startOfMonth_startOfMonth)));

;// ./node_modules/date-fns/endOfMonth.mjs


/**
 * @name endOfMonth
 * @category Month Helpers
 * @summary Return the end of a month for the given date.
 *
 * @description
 * Return the end of a month for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 *
 * @param date - The original date
 *
 * @returns The end of a month
 *
 * @example
 * // The end of a month for 2 September 2014 11:55:00:
 * const result = endOfMonth(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Tue Sep 30 2014 23:59:59.999
 */
function endOfMonth(date) {
  const _date = toDate_toDate(date);
  const month = _date.getMonth();
  _date.setFullYear(_date.getFullYear(), month + 1, 0);
  _date.setHours(23, 59, 59, 999);
  return _date;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_endOfMonth = ((/* unused pure expression or super */ null && (endOfMonth)));

;// ./node_modules/date-fns/constants.mjs
/**
 * @module constants
 * @summary Useful constants
 * @description
 * Collection of useful date constants.
 *
 * The constants could be imported from `date-fns/constants`:
 *
 * ```ts
 * import { maxTime, minTime } from "./constants/date-fns/constants";
 *
 * function isAllowedTime(time) {
 *   return time <= maxTime && time >= minTime;
 * }
 * ```
 */

/**
 * @constant
 * @name daysInWeek
 * @summary Days in 1 week.
 */
const constants_daysInWeek = 7;

/**
 * @constant
 * @name daysInYear
 * @summary Days in 1 year.
 *
 * @description
 * How many days in a year.
 *
 * One years equals 365.2425 days according to the formula:
 *
 * > Leap year occures every 4 years, except for years that are divisable by 100 and not divisable by 400.
 * > 1 mean year = (365+1/4-1/100+1/400) days = 365.2425 days
 */
const constants_daysInYear = 365.2425;

/**
 * @constant
 * @name maxTime
 * @summary Maximum allowed time.
 *
 * @example
 * import { maxTime } from "./constants/date-fns/constants";
 *
 * const isValid = 8640000000000001 <= maxTime;
 * //=> false
 *
 * new Date(8640000000000001);
 * //=> Invalid Date
 */
const constants_maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1000;

/**
 * @constant
 * @name minTime
 * @summary Minimum allowed time.
 *
 * @example
 * import { minTime } from "./constants/date-fns/constants";
 *
 * const isValid = -8640000000000001 >= minTime;
 * //=> false
 *
 * new Date(-8640000000000001)
 * //=> Invalid Date
 */
const constants_minTime = -constants_maxTime;

/**
 * @constant
 * @name millisecondsInWeek
 * @summary Milliseconds in 1 week.
 */
const constants_millisecondsInWeek = 604800000;

/**
 * @constant
 * @name millisecondsInDay
 * @summary Milliseconds in 1 day.
 */
const constants_millisecondsInDay = 86400000;

/**
 * @constant
 * @name millisecondsInMinute
 * @summary Milliseconds in 1 minute
 */
const constants_millisecondsInMinute = 60000;

/**
 * @constant
 * @name millisecondsInHour
 * @summary Milliseconds in 1 hour
 */
const constants_millisecondsInHour = 3600000;

/**
 * @constant
 * @name millisecondsInSecond
 * @summary Milliseconds in 1 second
 */
const constants_millisecondsInSecond = 1000;

/**
 * @constant
 * @name minutesInYear
 * @summary Minutes in 1 year.
 */
const constants_minutesInYear = 525600;

/**
 * @constant
 * @name minutesInMonth
 * @summary Minutes in 1 month.
 */
const constants_minutesInMonth = 43200;

/**
 * @constant
 * @name minutesInDay
 * @summary Minutes in 1 day.
 */
const constants_minutesInDay = 1440;

/**
 * @constant
 * @name minutesInHour
 * @summary Minutes in 1 hour.
 */
const constants_minutesInHour = 60;

/**
 * @constant
 * @name monthsInQuarter
 * @summary Months in 1 quarter.
 */
const constants_monthsInQuarter = 3;

/**
 * @constant
 * @name monthsInYear
 * @summary Months in 1 year.
 */
const constants_monthsInYear = 12;

/**
 * @constant
 * @name quartersInYear
 * @summary Quarters in 1 year
 */
const constants_quartersInYear = 4;

/**
 * @constant
 * @name secondsInHour
 * @summary Seconds in 1 hour.
 */
const constants_secondsInHour = 3600;

/**
 * @constant
 * @name secondsInMinute
 * @summary Seconds in 1 minute.
 */
const constants_secondsInMinute = 60;

/**
 * @constant
 * @name secondsInDay
 * @summary Seconds in 1 day.
 */
const constants_secondsInDay = constants_secondsInHour * 24;

/**
 * @constant
 * @name secondsInWeek
 * @summary Seconds in 1 week.
 */
const constants_secondsInWeek = constants_secondsInDay * 7;

/**
 * @constant
 * @name secondsInYear
 * @summary Seconds in 1 year.
 */
const constants_secondsInYear = constants_secondsInDay * constants_daysInYear;

/**
 * @constant
 * @name secondsInMonth
 * @summary Seconds in 1 month
 */
const constants_secondsInMonth = constants_secondsInYear / 12;

/**
 * @constant
 * @name secondsInQuarter
 * @summary Seconds in 1 quarter.
 */
const constants_secondsInQuarter = constants_secondsInMonth * 3;

;// ./node_modules/date-fns/parseISO.mjs


/**
 * The {@link parseISO} function options.
 */

/**
 * @name parseISO
 * @category Common Helpers
 * @summary Parse ISO string
 *
 * @description
 * Parse the given string in ISO 8601 format and return an instance of Date.
 *
 * Function accepts complete ISO 8601 formats as well as partial implementations.
 * ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
 *
 * If the argument isn't a string, the function cannot parse the string or
 * the values are invalid, it returns Invalid Date.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 *
 * @param argument - The value to convert
 * @param options - An object with options
 *
 * @returns The parsed date in the local time zone
 *
 * @example
 * // Convert string '2014-02-11T11:30:30' to date:
 * const result = parseISO('2014-02-11T11:30:30')
 * //=> Tue Feb 11 2014 11:30:30
 *
 * @example
 * // Convert string '+02014101' to date,
 * // if the additional number of digits in the extended year format is 1:
 * const result = parseISO('+02014101', { additionalDigits: 1 })
 * //=> Fri Apr 11 2014 00:00:00
 */
function parseISO(argument, options) {
  const additionalDigits = options?.additionalDigits ?? 2;
  const dateStrings = splitDateString(argument);

  let date;
  if (dateStrings.date) {
    const parseYearResult = parseYear(dateStrings.date, additionalDigits);
    date = parseISO_parseDate(parseYearResult.restDateString, parseYearResult.year);
  }

  if (!date || isNaN(date.getTime())) {
    return new Date(NaN);
  }

  const timestamp = date.getTime();
  let time = 0;
  let offset;

  if (dateStrings.time) {
    time = parseTime(dateStrings.time);
    if (isNaN(time)) {
      return new Date(NaN);
    }
  }

  if (dateStrings.timezone) {
    offset = parseTimezone(dateStrings.timezone);
    if (isNaN(offset)) {
      return new Date(NaN);
    }
  } else {
    const dirtyDate = new Date(timestamp + time);
    // JS parsed string assuming it's in UTC timezone
    // but we need it to be parsed in our timezone
    // so we use utc values to build date in our timezone.
    // Year values from 0 to 99 map to the years 1900 to 1999
    // so set year explicitly with setFullYear.
    const result = new Date(0);
    result.setFullYear(
      dirtyDate.getUTCFullYear(),
      dirtyDate.getUTCMonth(),
      dirtyDate.getUTCDate(),
    );
    result.setHours(
      dirtyDate.getUTCHours(),
      dirtyDate.getUTCMinutes(),
      dirtyDate.getUTCSeconds(),
      dirtyDate.getUTCMilliseconds(),
    );
    return result;
  }

  return new Date(timestamp + time + offset);
}

const patterns = {
  dateTimeDelimiter: /[T ]/,
  timeZoneDelimiter: /[Z ]/i,
  timezone: /([Z+-].*)$/,
};

const dateRegex =
  /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
const timeRegex =
  /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
const timezoneRegex = /^([+-])(\d{2})(?::?(\d{2}))?$/;

function splitDateString(dateString) {
  const dateStrings = {};
  const array = dateString.split(patterns.dateTimeDelimiter);
  let timeString;

  // The regex match should only return at maximum two array elements.
  // [date], [time], or [date, time].
  if (array.length > 2) {
    return dateStrings;
  }

  if (/:/.test(array[0])) {
    timeString = array[0];
  } else {
    dateStrings.date = array[0];
    timeString = array[1];
    if (patterns.timeZoneDelimiter.test(dateStrings.date)) {
      dateStrings.date = dateString.split(patterns.timeZoneDelimiter)[0];
      timeString = dateString.substr(
        dateStrings.date.length,
        dateString.length,
      );
    }
  }

  if (timeString) {
    const token = patterns.timezone.exec(timeString);
    if (token) {
      dateStrings.time = timeString.replace(token[1], "");
      dateStrings.timezone = token[1];
    } else {
      dateStrings.time = timeString;
    }
  }

  return dateStrings;
}

function parseYear(dateString, additionalDigits) {
  const regex = new RegExp(
    "^(?:(\\d{4}|[+-]\\d{" +
      (4 + additionalDigits) +
      "})|(\\d{2}|[+-]\\d{" +
      (2 + additionalDigits) +
      "})$)",
  );

  const captures = dateString.match(regex);
  // Invalid ISO-formatted year
  if (!captures) return { year: NaN, restDateString: "" };

  const year = captures[1] ? parseInt(captures[1]) : null;
  const century = captures[2] ? parseInt(captures[2]) : null;

  // either year or century is null, not both
  return {
    year: century === null ? year : century * 100,
    restDateString: dateString.slice((captures[1] || captures[2]).length),
  };
}

function parseISO_parseDate(dateString, year) {
  // Invalid ISO-formatted year
  if (year === null) return new Date(NaN);

  const captures = dateString.match(dateRegex);
  // Invalid ISO-formatted string
  if (!captures) return new Date(NaN);

  const isWeekDate = !!captures[4];
  const dayOfYear = parseDateUnit(captures[1]);
  const month = parseDateUnit(captures[2]) - 1;
  const day = parseDateUnit(captures[3]);
  const week = parseDateUnit(captures[4]);
  const dayOfWeek = parseDateUnit(captures[5]) - 1;

  if (isWeekDate) {
    if (!validateWeekDate(year, week, dayOfWeek)) {
      return new Date(NaN);
    }
    return dayOfISOWeekYear(year, week, dayOfWeek);
  } else {
    const date = new Date(0);
    if (
      !validateDate(year, month, day) ||
      !validateDayOfYearDate(year, dayOfYear)
    ) {
      return new Date(NaN);
    }
    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
    return date;
  }
}

function parseDateUnit(value) {
  return value ? parseInt(value) : 1;
}

function parseTime(timeString) {
  const captures = timeString.match(timeRegex);
  if (!captures) return NaN; // Invalid ISO-formatted time

  const hours = parseTimeUnit(captures[1]);
  const minutes = parseTimeUnit(captures[2]);
  const seconds = parseTimeUnit(captures[3]);

  if (!validateTime(hours, minutes, seconds)) {
    return NaN;
  }

  return (
    hours * constants_millisecondsInHour + minutes * constants_millisecondsInMinute + seconds * 1000
  );
}

function parseTimeUnit(value) {
  return (value && parseFloat(value.replace(",", "."))) || 0;
}

function parseTimezone(timezoneString) {
  if (timezoneString === "Z") return 0;

  const captures = timezoneString.match(timezoneRegex);
  if (!captures) return 0;

  const sign = captures[1] === "+" ? -1 : 1;
  const hours = parseInt(captures[2]);
  const minutes = (captures[3] && parseInt(captures[3])) || 0;

  if (!validateTimezone(hours, minutes)) {
    return NaN;
  }

  return sign * (hours * constants_millisecondsInHour + minutes * constants_millisecondsInMinute);
}

function dayOfISOWeekYear(isoWeekYear, week, day) {
  const date = new Date(0);
  date.setUTCFullYear(isoWeekYear, 0, 4);
  const fourthOfJanuaryDay = date.getUTCDay() || 7;
  const diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}

// Validation functions

// February is null to handle the leap year (using ||)
const daysInMonths = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

function isLeapYearIndex(year) {
  return year % 400 === 0 || (year % 4 === 0 && year % 100 !== 0);
}

function validateDate(year, month, date) {
  return (
    month >= 0 &&
    month <= 11 &&
    date >= 1 &&
    date <= (daysInMonths[month] || (isLeapYearIndex(year) ? 29 : 28))
  );
}

function validateDayOfYearDate(year, dayOfYear) {
  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex(year) ? 366 : 365);
}

function validateWeekDate(_year, week, day) {
  return week >= 1 && week <= 53 && day >= 0 && day <= 6;
}

function validateTime(hours, minutes, seconds) {
  if (hours === 24) {
    return minutes === 0 && seconds === 0;
  }

  return (
    seconds >= 0 &&
    seconds < 60 &&
    minutes >= 0 &&
    minutes < 60 &&
    hours >= 0 &&
    hours < 25
  );
}

function validateTimezone(_hours, minutes) {
  return minutes >= 0 && minutes <= 59;
}

// Fallback for modularized imports:
/* harmony default export */ const date_fns_parseISO = ((/* unused pure expression or super */ null && (parseISO)));

;// ./packages/editor/build-module/components/post-schedule/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



const {
  PrivatePublishDateTimePicker
} = unlock(external_wp_blockEditor_namespaceObject.privateApis);

/**
 * Renders the PostSchedule component. It allows the user to schedule a post.
 *
 * @param {Object}   props         Props.
 * @param {Function} props.onClose Function to close the component.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PostSchedule(props) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivatePostSchedule, {
    ...props,
    showPopoverHeaderActions: true,
    isCompact: false
  });
}
function PrivatePostSchedule({
  onClose,
  showPopoverHeaderActions,
  isCompact
}) {
  const {
    postDate,
    postType
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    postDate: select(store_store).getEditedPostAttribute('date'),
    postType: select(store_store).getCurrentPostType()
  }), []);
  const {
    editPost
  } = (0,external_wp_data_namespaceObject.useDispatch)(store_store);
  const onUpdateDate = date => editPost({
    date
  });
  const [previewedMonth, setPreviewedMonth] = (0,external_wp_element_namespaceObject.useState)(startOfMonth_startOfMonth(new Date(postDate)));

  // Pick up published and scheduled site posts.
  const eventsByPostType = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_coreData_namespaceObject.store).getEntityRecords('postType', postType, {
    status: 'publish,future',
    after: startOfMonth_startOfMonth(previewedMonth).toISOString(),
    before: endOfMonth(previewedMonth).toISOString(),
    exclude: [select(store_store).getCurrentPostId()],
    per_page: 100,
    _fields: 'id,date'
  }), [previewedMonth, postType]);
  const events = (0,external_wp_element_namespaceObject.useMemo)(() => (eventsByPostType || []).map(({
    date: eventDate
  }) => ({
    date: new Date(eventDate)
  })), [eventsByPostType]);
  const settings = (0,external_wp_date_namespaceObject.getSettings)();

  // To know if the current timezone is a 12 hour time with look for "a" in the time format
  // We also make sure this a is not escaped by a "/"
  const is12HourTime = /a(?!\\)/i.test(settings.formats.time.toLowerCase() // Test only the lower case a.
  .replace(/\\\\/g, '') // Replace "//" with empty strings.
  .split('').reverse().join('') // Reverse the string and test for "a" not followed by a slash.
  );
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivatePublishDateTimePicker, {
    currentDate: postDate,
    onChange: onUpdateDate,
    is12Hour: is12HourTime,
    dateOrder: /* translators: Order of day, month, and year. Available formats are 'dmy', 'mdy', and 'ymd'. */
    (0,external_wp_i18n_namespaceObject._x)('dmy', 'date order'),
    events: events,
    onMonthPreviewed: date => setPreviewedMonth(parseISO(date)),
    onClose: onClose,
    isCompact: isCompact,
    showPopoverHeaderActions: showPopoverHeaderActions
  });
}

;// ./packages/editor/build-module/components/post-schedule/label.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Renders the PostScheduleLabel component.
 *
 * @param {Object} props Props.
 *
 * @return {React.ReactNode} The rendered component.
 */
function PostScheduleLabel(props) {
  return usePostScheduleLabel(props);
}

/**
 * Custom hook to get the label for post schedule.
 *
 * @param {Object}  options      Options for the hook.
 * @param {boolean} options.full Whether to get the full label or not. Default is false.
 *
 * @return {string} The label for post schedule.
 */
function usePostScheduleLabel({
  full = false
} = {}) {
  const {
    date,
    isFloating
  } = (0,external_wp_data_namespaceObject.useSelect)(select => ({
    date: select(store_store).getEditedPostAttribute('date'),
    isFloating: select(store_store).isEditedPostDateFloating()
  }), []);
  return full ? getFullPostScheduleLabel(date) : getPostScheduleLabel(date, {
    isFloating
  });
}
function getFullPostScheduleLabel(dateAttribute) {
  const date = (0,external_wp_date_namespaceObject.getDate)(dateAttribute);
  const timezoneAbbreviation = getTimezoneAbbreviation();
  const formattedDate = (0,external_wp_date_namespaceObject.dateI18n)(
  // translators: Use a non-breaking space between 'g:i' and 'a' if appropriate.
  (0,external_wp_i18n_namespaceObject._x)('F j, Y g:i\xa0a', 'post schedule full date format'), date);
  return (0,external_wp_i18n_namespaceObject.isRTL)() ? `${timezoneAbbreviation} ${formattedDate}` : `${formattedDate} ${timezoneAbbreviation}`;
}
function getPostScheduleLabel(dateAttribute, {
  isFloating = false,
  now = new Date()
} = {}) {
  if (!dateAttribute || isFloating) {
    return (0,external_wp_i18n_namespaceObject.__)('Immediately');
  }

  // If the user timezone does not equal the site timezone then using words
  // like 'tomorrow' is confusing, so show the full date.
  if (!isTimezoneSameAsSiteTimezone(now)) {
    return getFullPostScheduleLabel(dateAttribute);
  }
  const date = (0,external_wp_date_namespaceObject.getDate)(dateAttribute);
  if (isSameDay(date, now)) {
    return (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %s: Time of day the post is scheduled for.
    (0,external_wp_i18n_namespaceObject.__)('Today at %s'),
    // translators: If using a space between 'g:i' and 'a', use a non-breaking space.
    (0,external_wp_date_namespaceObject.dateI18n)((0,external_wp_i18n_namespaceObject._x)('g:i\xa0a', 'post schedule time format'), date));
  }
  const tomorrow = new Date(now);
  tomorrow.setDate(tomorrow.getDate() + 1);
  if (isSameDay(date, tomorrow)) {
    return (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %s: Time of day the post is scheduled for.
    (0,external_wp_i18n_namespaceObject.__)('Tomorrow at %s'),
    // translators: If using a space between 'g:i' and 'a', use a non-breaking space.
    (0,external_wp_date_namespaceObject.dateI18n)((0,external_wp_i18n_namespaceObject._x)('g:i\xa0a', 'post schedule time format'), date));
  }
  if (date.getFullYear() === now.getFullYear()) {
    return (0,external_wp_date_namespaceObject.dateI18n)(
    // translators: If using a space between 'g:i' and 'a', use a non-breaking space.
    (0,external_wp_i18n_namespaceObject._x)('F j g:i\xa0a', 'post schedule date format without year'), date);
  }
  return (0,external_wp_date_namespaceObject.dateI18n)(
  // translators: Use a non-breaking space between 'g:i' and 'a' if appropriate.
  (0,external_wp_i18n_namespaceObject._x)('F j, Y g:i\xa0a', 'post schedule full date format'), date);
}
function getTimezoneAbbreviation() {
  const {
    timezone
  } = (0,external_wp_date_namespaceObject.getSettings)();
  if (timezone.abbr && isNaN(Number(timezone.abbr))) {
    return timezone.abbr;
  }
  const symbol = timezone.offset < 0 ? '' : '+';
  return `UTC${symbol}${timezone.offsetFormatted}`;
}
function isTimezoneSameAsSiteTimezone(date) {
  const {
    timezone
  } = (0,external_wp_date_namespaceObject.getSettings)();
  const siteOffset = Number(timezone.offset);
  const dateOffset = -1 * (date.getTimezoneOffset() / 60);
  return siteOffset === dateOffset;
}
function isSameDay(left, right) {
  return left.getDate() === right.getDate() && left.getMonth() === right.getMonth() && left.getFullYear() === right.getFullYear();
}

;// ./packages/editor/build-module/components/post-taxonomies/most-used-terms.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const MIN_MOST_USED_TERMS = 3;
const DEFAULT_QUERY = {
  per_page: 10,
  orderby: 'count',
  order: 'desc',
  hide_empty: true,
  _fields: 'id,name,count',
  context: 'view'
};
function MostUsedTerms({
  onSelect,
  taxonomy
}) {
  const {
    _terms,
    showTerms
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const mostUsedTerms = select(external_wp_coreData_namespaceObject.store).getEntityRecords('taxonomy', taxonomy.slug, DEFAULT_QUERY);
    return {
      _terms: mostUsedTerms,
      showTerms: mostUsedTerms?.length >= MIN_MOST_USED_TERMS
    };
  }, [taxonomy.slug]);
  if (!showTerms) {
    return null;
  }
  const terms = unescapeTerms(_terms);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "editor-post-taxonomies__flat-term-most-used",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
      as: "h3",
      className: "editor-post-taxonomies__flat-term-most-used-label",
      children: taxonomy.labels.most_used
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", {
      role: "list",
      className: "editor-post-taxonomies__flat-term-most-used-list",
      children: terms.map(term => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("li", {
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          __next40pxDefaultSize: true,
          variant: "link",
          onClick: () => onSelect(term),
          children: term.name
        })
      }, term.id))
    })]
  });
}

;// ./packages/editor/build-module/components/post-taxonomies/flat-term-selector.js
/**
 * WordPress dependencies
 */










/**
 * Int